/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.components.tree.devicetree;

import com.huawei.dc.common.asndatacenter.AsnDCDeviceSubmapNtfnInfo;
import com.huawei.dc.common.asndatacenter.AsnDCSubMapInfo;
import com.huawei.dc.common.asndatacenter.AsnDCSubMapInfoLst;
import com.huawei.dc.common.components.tree.devicetree.DeviceTree;
import com.huawei.dc.common.components.tree.devicetree.DeviceTreeUtil;
import com.huawei.dc.common.components.tree.devicetree.SubmapTreeUtil;
import com.huawei.dc.common.components.tree.devicetree.descriptor.DeviceTreeBaseDescriptor;
import com.huawei.dc.common.components.tree.devicetree.model.DeviceTreeNode;
import com.huawei.dc.common.components.tree.devicetree.model.SubmapTreeModelManager;
import com.huawei.dc.common.components.tree.devicetree.renderer.DeviceTreeRenderer;
import com.huawei.dc.common.controller.AbstractDeviceInfoManager;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.tree.SubMapNodeInfo;
import com.huawei.dc.common.tree.TreeNodeInfo;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.devicemanagement.deviceoperation.controller.BusyDeviceObjectStore;
import com.huawei.dc.devicemanagement.model.deviceinfo.SubMapInfo;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class MainSubmapTree
extends DeviceTree {
    private static final long serialVersionUID = 1L;

    public MainSubmapTree(DeviceTreeBaseDescriptor oDescriptor, IDeviceInfoManager oDeviceInfoMgr, String rootName) {
        super(oDescriptor, oDeviceInfoMgr, rootName);
    }

    @Override
    protected void initializeCellRenderer() {
        this.setCellRenderer(new DeviceTreeRenderer());
    }

    @Override
    protected void initializeTreeModelManager(IDeviceInfoManager oDeviceInfoMgr) {
        this.m_oTreeModelManager = SubmapTreeModelManager.getInstance(oDeviceInfoMgr);
    }

    @Override
    public void processEvent(int iEventType, Object oEventSource) {
        if (!(oEventSource instanceof AsnDCDeviceSubmapNtfnInfo)) {
            return;
        }
        AsnDCDeviceSubmapNtfnInfo oAsnDeviceInfo = (AsnDCDeviceSubmapNtfnInfo)oEventSource;
        switch (iEventType) {
            case 0: {
                this.addDeviceToTree(oAsnDeviceInfo);
                break;
            }
            case 1: {
                this.removeDeviceFromTree(oAsnDeviceInfo);
                break;
            }
            case 3: {
                this.addSubmapNodeToTree(oAsnDeviceInfo);
                break;
            }
            case 4: {
                this.removeSubmapNodeFromTree(oAsnDeviceInfo);
                break;
            }
            case 5: {
                this.modifySubmapInTree(oAsnDeviceInfo);
                break;
            }
        }
    }

    private void addDeviceToTree(AsnDCDeviceSubmapNtfnInfo oAsnDeviceInfo) {
        AsnDCSubMapInfo oAsnDCSubMapInfo = oAsnDeviceInfo.oAsnDCSubMapInfo;
        if (null != oAsnDCSubMapInfo) {
            SubMapInfo subMapInfo = new SubMapInfo();
            subMapInfo.m_strSubMapID = new String(oAsnDCSubMapInfo.strSubMapID);
            subMapInfo.m_strSubMapName = new String(oAsnDCSubMapInfo.strSubMapName);
            AsnDCSubMapInfoLst oAsnDCSubMapInfoLst = oAsnDCSubMapInfo.oAsnDCSubMapInfoLst;
            SubmapTreeUtil oUtil = new SubmapTreeUtil(this, false);
            oUtil.getSubMapNodeForAsnSubmap(oAsnDeviceInfo.oDeviceInfo, oAsnDCSubMapInfoLst, subMapInfo);
        }
    }

    private void removeDeviceFromTree(AsnDCDeviceSubmapNtfnInfo oAsnDeviceInfo) {
        int iDeviceCountForVersion = 1;
        DeviceInfo oDeviceInfo = this.m_oDeviceInfoManager.getDevice(oAsnDeviceInfo.oDeviceInfo.iDevId.intValue());
        if (null == oDeviceInfo) {
            oDeviceInfo = this.m_oDeviceInfoManager.getDeviceFromAsn(oAsnDeviceInfo.oDeviceInfo);
            iDeviceCountForVersion = 0;
        }
        if (null == oDeviceInfo) {
            return;
        }
        if (null == oDeviceInfo.getDeviceTypeInfo() || null == oDeviceInfo.getDevVersion()) {
            return;
        }
        BusyDeviceObjectStore.getInstance().removeDeviceProgress(oDeviceInfo.getDevId());
        DefaultMutableTreeNode oVersionNode = DeviceTreeUtil.findNodeForDeviceVersion(this, oDeviceInfo.getDeviceTypeInfo(), oDeviceInfo.getDevVersion().getDevVersion());
        DeviceInfo[] arrRemainingDevices = this.m_oDeviceInfoManager.getDevicesForVersion(oDeviceInfo.getDevVersion().getDevVersion(), oDeviceInfo.getDeviceTypeInfo());
        if (null != oVersionNode && null != arrRemainingDevices && iDeviceCountForVersion == arrRemainingDevices.length) {
            oVersionNode.removeFromParent();
        }
    }

    private void removeSubmapNodeFromTree(AsnDCDeviceSubmapNtfnInfo oAsnDeviceInfo) {
        DefaultMutableTreeNode oSubmapNode = DeviceTreeUtil.findNodeForSubmap(this, new String(oAsnDeviceInfo.oAsnDCSubMapInfo.strSubMapID));
        AbstractDeviceInfoManager oDeviceInfoMgr = (AbstractDeviceInfoManager)DeviceInfoManagerImpl.getInstance();
        SubMapInfo oSubmapToBeDeleted = oDeviceInfoMgr.getSubmapForID(new String(oAsnDeviceInfo.oAsnDCSubMapInfo.strSubMapID));
        if (null != oSubmapToBeDeleted && null != oSubmapToBeDeleted.m_SubMapList) {
            int childSubmapSize = oSubmapToBeDeleted.m_SubMapList.size();
            for (int j = 0; j < childSubmapSize; ++j) {
                SubMapInfo oSubMapInfo = oSubmapToBeDeleted.m_SubMapList.get(j);
                if (oSubMapInfo == null) continue;
                this.addSubmapNodeToTreeBySubMapInfo(oSubMapInfo);
            }
        }
        if (null != oSubmapNode) {
            TreePath oPath = this.getSelectionPath();
            if (null != oPath && oSubmapNode.equals(oPath.getLastPathComponent())) {
                this.setSelectionRow(0);
            }
            oSubmapNode.removeFromParent();
        }
    }

    private void addSubmapNodeToTreeBySubMapInfo(SubMapInfo subMapInfo) {
        DefaultMutableTreeNode oCurParentNode;
        DefaultMutableTreeNode oCurDelNode = DeviceTreeUtil.findNodeForSubmap(this, subMapInfo.m_strParentSubMapID);
        if (null == oCurDelNode) {
            return;
        }
        TreeNodeInfo oTreeNodeInfo = (TreeNodeInfo)oCurDelNode.getUserObject();
        boolean bRootNode = oTreeNodeInfo.toString().equals(ResourceManager.getInstance().getResString("PHYSICAL_ROOT"));
        if (!bRootNode) {
            oTreeNodeInfo = this.getParentTreeNodeInfo(oCurDelNode);
        }
        String subMapID = "";
        if (null != oTreeNodeInfo.m_oSubMapNodeInfo) {
            subMapID = oTreeNodeInfo.m_oSubMapNodeInfo.m_submapId;
        }
        if (null != (oCurParentNode = DeviceTreeUtil.findNodeForSubmap(this, subMapID))) {
            DefaultMutableTreeNode oCurNode = DeviceTreeUtil.findNodeForSubmap(this, subMapInfo.m_strSubMapID);
            oCurParentNode.add(oCurNode);
        }
    }

    private TreeNodeInfo getParentTreeNodeInfo(DefaultMutableTreeNode oCurDelNode) {
        TreeNodeInfo oTreeNodeInfo = null;
        if (oCurDelNode.getParent() instanceof DeviceTreeNode) {
            DeviceTreeNode oDeviceNodeInfo = (DeviceTreeNode)oCurDelNode.getParent();
            oTreeNodeInfo = (TreeNodeInfo)oDeviceNodeInfo.getUserObject();
        } else if (oCurDelNode.getParent() instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode oDeviceNodeInfo = (DefaultMutableTreeNode)oCurDelNode.getParent();
            oTreeNodeInfo = (TreeNodeInfo)oDeviceNodeInfo.getUserObject();
        }
        return oTreeNodeInfo;
    }

    private void addSubmapNodeToTree(AsnDCDeviceSubmapNtfnInfo oAsnDeviceInfo) {
        DefaultMutableTreeNode oParentNode = DeviceTreeUtil.findNodeForSubmap(this, new String(oAsnDeviceInfo.oAsnDCSubMapInfo.strParentSubMapID));
        if (null != oParentNode) {
            SubMapNodeInfo submapNodeInfo = new SubMapNodeInfo();
            submapNodeInfo.m_submapId = new String(oAsnDeviceInfo.oAsnDCSubMapInfo.strSubMapID);
            submapNodeInfo.m_submapName = new String(oAsnDeviceInfo.oAsnDCSubMapInfo.strSubMapName);
            if (null != DeviceTreeUtil.findNodeForSubmap(this, submapNodeInfo.m_submapId)) {
                return;
            }
            DeviceTreeNode newSubmapNode = new DeviceTreeNode(new TreeNodeInfo(submapNodeInfo));
            oParentNode.add(newSubmapNode);
        }
    }

    private void modifySubmapInTree(AsnDCDeviceSubmapNtfnInfo oAsnNotificationInfo) {
        String newSParentSubMapID;
        String curSubMapID;
        AsnDCSubMapInfo oAsnDCSubMapInfo = oAsnNotificationInfo.oAsnDCSubMapInfo;
        String strSubmapId = new String(oAsnDCSubMapInfo.strSubMapID);
        DefaultMutableTreeNode oModifiedSubmap = DeviceTreeUtil.findNodeForSubmap(this, strSubmapId);
        if (null == oModifiedSubmap) {
            return;
        }
        TreeNodeInfo oTreeNodeInfo = this.getParentTreeNodeInfo(oModifiedSubmap);
        if (null != oTreeNodeInfo.m_oSubMapNodeInfo && (curSubMapID = oTreeNodeInfo.m_oSubMapNodeInfo.m_submapId).equals(newSParentSubMapID = new String(oAsnDCSubMapInfo.strParentSubMapID))) {
            return;
        }
        TreeNodeInfo oSubmapNodeInfo = (TreeNodeInfo)oModifiedSubmap.getUserObject();
        if (null != oAsnDCSubMapInfo.strSubMapName && 0 < oAsnDCSubMapInfo.strSubMapName.length) {
            oSubmapNodeInfo.m_oSubMapNodeInfo.m_submapName = new String(oAsnDCSubMapInfo.strSubMapName);
            oSubmapNodeInfo.m_nodeName = new String(oAsnDCSubMapInfo.strSubMapName);
        }
        if (null != oAsnDCSubMapInfo.strParentSubMapID) {
            TreePath oPath = this.getSelectionPath();
            if (oModifiedSubmap.equals(oPath.getLastPathComponent())) {
                this.setSelectionRow(0);
            }
            oModifiedSubmap.removeFromParent();
            DefaultMutableTreeNode oNewParentSubMap = DeviceTreeUtil.findNodeForSubmap(this, new String(oAsnDCSubMapInfo.strParentSubMapID));
            if (null != oNewParentSubMap) {
                oNewParentSubMap.add(oModifiedSubmap);
            }
        }
    }
}

