/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.components.tree.devicetree;

import com.huawei.dc.common.asndatacenter.AsnDCDeviceSubmapNtfnInfo;
import com.huawei.dc.common.components.tree.devicetree.DeviceTree;
import com.huawei.dc.common.components.tree.devicetree.DeviceTreeUtil;
import com.huawei.dc.common.components.tree.devicetree.descriptor.DeviceTreeBaseDescriptor;
import com.huawei.dc.common.components.tree.devicetree.model.DeviceTreeModelManager;
import com.huawei.dc.common.components.tree.devicetree.model.DeviceTreeNode;
import com.huawei.dc.common.components.tree.devicetree.renderer.DeviceTreeRenderer;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.tree.TreeNodeInfo;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.controller.DeviceConfigModelCtrller;
import java.text.Collator;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class MainDeviceTree
extends DeviceTree {
    private static final long serialVersionUID = 1L;
    private String m_sRootName = "";

    public MainDeviceTree(DeviceTreeBaseDescriptor oDescriptor, IDeviceInfoManager oDeviceInfoMgr, String rootName) {
        super(oDescriptor, oDeviceInfoMgr, rootName);
        this.m_sRootName = rootName;
    }

    @Override
    protected void initializeCellRenderer() {
        this.setCellRenderer(new DeviceTreeRenderer());
    }

    @Override
    protected void initializeTreeModelManager(IDeviceInfoManager oDeviceInfoMgr) {
        this.m_oTreeModelManager = DeviceTreeModelManager.getInstance(oDeviceInfoMgr);
    }

    @Override
    public void processEvent(int iEventType, Object oEventSource) {
        if (!(oEventSource instanceof AsnDCDeviceSubmapNtfnInfo)) {
            return;
        }
        AsnDCDeviceSubmapNtfnInfo oAsnDeviceInfo = (AsnDCDeviceSubmapNtfnInfo)oEventSource;
        int iDeviceId = oAsnDeviceInfo.oDeviceInfo.iDevId.intValue();
        switch (iEventType) {
            case 0: {
                if (Collator.getInstance().equals(this.m_sRootName, ResourceManager.getInstance().getResString("SAM_ROOT"))) {
                    return;
                }
                this.addDeviceToTree(iDeviceId);
                break;
            }
            case 1: {
                this.removeDeviceFromTree(oAsnDeviceInfo);
                break;
            }
            case 2: {
                this.modifyDeviceInTree(iDeviceId);
                break;
            }
        }
        DCFrameWorkUtil.updateUI(this);
    }

    private void addNodeToTree(int iDeviceId) {
        if (null == this.m_oDeviceInfoManager) {
            DCDebugTracer.trace("DC::addDeviceToTree::m_oDeviceInfoManager NULL");
            return;
        }
        DeviceInfo oDeviceInfo = this.m_oDeviceInfoManager.getDevice(iDeviceId);
        DeviceTypeInfo oTypeInfo = oDeviceInfo.getDeviceTypeInfo();
        if (null == oTypeInfo || null == oDeviceInfo.getDevVersion()) {
            return;
        }
        String strDeviceVersion = oDeviceInfo.getDevVersion().getDevVersion();
        if (null == strDeviceVersion || "".equals(strDeviceVersion)) {
            strDeviceVersion = ResourceManager.getInstance().getResString("UNKNOWN_VERSION");
        }
        this.deleteDevTypeNode();
        DefaultMutableTreeNode oTypeNode = DeviceTreeUtil.findNodeForDeviceType(this, oTypeInfo);
        if (null == oTypeNode) {
            TreeNodeInfo oDeviceTypeNode = new TreeNodeInfo(oTypeInfo);
            oTypeNode = new DeviceTreeNode(oDeviceTypeNode);
            this.m_oRoot.add(oTypeNode);
            this.m_oRoot.sortNode();
        }
        this.deleteVersionNode(oTypeInfo, oTypeNode);
        DefaultMutableTreeNode oVersionNode = DeviceTreeUtil.findNodeForDeviceVersion(this, oTypeInfo, strDeviceVersion);
        if (null != oVersionNode) {
            return;
        }
        TreeNodeInfo oNodeInfo = new TreeNodeInfo(strDeviceVersion, oTypeInfo);
        oVersionNode = new DeviceTreeNode(oNodeInfo);
        oTypeNode.add(oVersionNode);
        DCDebugTracer.trace("DC::NO exception till getSelectionRows");
    }

    private void addDeviceToTree(int iDeviceId) {
        DeviceConfigModelCtrller.getInstance().setAddingDeviceID(iDeviceId);
        this.addNodeToTree(iDeviceId);
    }

    private void modifyDeviceInTree(int iDeviceId) {
        this.addNodeToTree(iDeviceId);
    }

    private void deleteDevTypeNode() {
        if (null != this.m_oRoot) {
            int iCount = this.m_oRoot.getChildCount();
            Vector<DefaultMutableTreeNode> oWillDeletedDevTypeNodeVec = new Vector<DefaultMutableTreeNode>();
            for (int i = 0; i < iCount; ++i) {
                int iDevTypeVerId;
                DefaultMutableTreeNode oDevTypeNode = (DefaultMutableTreeNode)this.m_oRoot.getChildAt(i);
                TreeNodeInfo oNodeInfo = (TreeNodeInfo)oDevTypeNode.getUserObject();
                int iDevTypeId = oNodeInfo.getDeviceTypeInfo().getDevTypeID();
                DeviceInfo[] oDevices = this.m_oDeviceInfoManager.getDevicesByTypeAndVersion(iDevTypeId, iDevTypeVerId = oNodeInfo.getDeviceTypeInfo().getDevTypeVersionId());
                if (null != oDevices && 0 != oDevices.length) continue;
                oWillDeletedDevTypeNodeVec.add(oDevTypeNode);
            }
            for (DefaultMutableTreeNode oDevTypeNode : oWillDeletedDevTypeNodeVec) {
                oDevTypeNode.removeFromParent();
                oDevTypeNode = null;
            }
            if (0 < oWillDeletedDevTypeNodeVec.size()) {
                this.updateUI();
            }
            oWillDeletedDevTypeNodeVec.clear();
        }
    }

    private void deleteVersionNode(DeviceTypeInfo oDevTypeInfo, DefaultMutableTreeNode oTypeNode) {
        if (null != oTypeNode) {
            int iCount = oTypeNode.getChildCount();
            Vector<DefaultMutableTreeNode> oWillDeletedVerNodeVec = new Vector<DefaultMutableTreeNode>();
            boolean isDevPresent = false;
            for (int i = 0; i < iCount; ++i) {
                isDevPresent = false;
                DefaultMutableTreeNode oVerNode = (DefaultMutableTreeNode)oTypeNode.getChildAt(i);
                TreeNodeInfo oNodeInfo = (TreeNodeInfo)oVerNode.getUserObject();
                isDevPresent = this.m_oDeviceInfoManager.isDevicePresentForVersion(oNodeInfo.getVersion(), oDevTypeInfo);
                if (isDevPresent) continue;
                oWillDeletedVerNodeVec.add(oVerNode);
            }
            for (DefaultMutableTreeNode oVerNode : oWillDeletedVerNodeVec) {
                oVerNode.removeFromParent();
                oVerNode = null;
            }
            if (0 < oWillDeletedVerNodeVec.size()) {
                DCFrameWorkUtil.updateUI(this);
            }
            oWillDeletedVerNodeVec.clear();
        }
    }

    private void removeDeviceFromTree(AsnDCDeviceSubmapNtfnInfo oAsnDeviceInfo) {
        DeviceTypeInfo oTypeInfo;
        int iDeviceCountForVersion = 1;
        DeviceInfo oDeviceInfo = this.m_oDeviceInfoManager.getDevice(oAsnDeviceInfo.oDeviceInfo.iDevId.intValue());
        if (null == oDeviceInfo) {
            oDeviceInfo = this.m_oDeviceInfoManager.getDeviceFromAsn(oAsnDeviceInfo.oDeviceInfo);
            iDeviceCountForVersion = 0;
        }
        if (null == (oTypeInfo = oDeviceInfo.getDeviceTypeInfo()) || null == oDeviceInfo.getDevVersion()) {
            return;
        }
        String strDeviceVersion = oDeviceInfo.getDevVersion().getDevVersion();
        if (null == strDeviceVersion || strDeviceVersion.length() == 0) {
            strDeviceVersion = ResourceManager.getInstance().getResString("UNKNOWN_VERSION");
        }
        DefaultMutableTreeNode oVersionNode = DeviceTreeUtil.findNodeForDeviceVersion(this, oTypeInfo, strDeviceVersion);
        DeviceInfo[] arrRemainingDevices = this.m_oDeviceInfoManager.getDevicesForVersion(strDeviceVersion, oTypeInfo);
        boolean bLastSelectVerNode = null != this.m_oLastSelectNode && this.m_oLastSelectNode.equals(oVersionNode);
        boolean bLastSelectTypeNode = false;
        if (null != oVersionNode && null != arrRemainingDevices && iDeviceCountForVersion == arrRemainingDevices.length) {
            oVersionNode.removeFromParent();
            oVersionNode = null;
            DefaultMutableTreeNode oTypeNode = DeviceTreeUtil.findNodeForDeviceType(this, oTypeInfo);
            boolean bl = bLastSelectTypeNode = null != this.m_oLastSelectNode && this.m_oLastSelectNode.equals(oTypeNode);
            if (null != oTypeNode) {
                if (0 == oTypeNode.getChildCount()) {
                    oTypeNode.removeFromParent();
                    oTypeNode = null;
                    if (bLastSelectVerNode || bLastSelectTypeNode) {
                        this.setSelectionPath(new TreePath(this.m_oRoot.getPath()));
                    }
                } else if (bLastSelectVerNode) {
                    this.setSelectionPath(new TreePath(oTypeNode.getPath()));
                }
            }
        }
    }
}

