/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.components.tree.devicetree;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.components.tree.devicetree.BoardTree;
import com.huawei.dc.common.components.tree.devicetree.BoardTreeUtil;
import com.huawei.dc.common.components.tree.devicetree.DeviceTree;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.tree.DeviceNodeInfo;
import com.huawei.dc.common.tree.SubMapNodeInfo;
import com.huawei.dc.common.tree.TreeNodeInfo;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.model.deviceinfo.OLTDevVerInfo;
import com.huawei.dc.devicemanagement.model.deviceinfo.SubMapInfo;
import com.huawei.dc.taskmgmt.model.Resource;
import gnu.trove.THashSet;
import gnu.trove.TIntIntHashMap;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DeviceTreeUtil {
    static HashMap<Integer, TreeNodeInfo> nodeMap = new HashMap();

    public static void setTreeNodeSelectionStateForDevices(DeviceTree oTree, List<Integer> oDeviceIdLst, int iSelectionState) {
        DefaultMutableTreeNode oTreeNode = null;
        int iDeviceCount = oDeviceIdLst.size();
        for (int i = 0; i < iDeviceCount; ++i) {
            oTreeNode = DeviceTreeUtil.findNodeForDevice(oTree, oDeviceIdLst.get(i));
            if (null == oTreeNode) continue;
            ((TreeNodeInfo)oTreeNode.getUserObject()).setSelected(iSelectionState);
        }
    }

    public static void setTreeNodeSelectionStateForResources(DeviceTree oTree, THashSet<Resource> oResourceList, int iSelectionState, boolean isCheckVisible) {
        DefaultMutableTreeNode oTreeRootNode = oTree.getRoot();
        if (oTree instanceof BoardTree) {
            BoardTreeUtil.setTreeNodeSelectionStateForResources((BoardTree)oTree, oResourceList, iSelectionState);
            return;
        }
        DefaultMutableTreeNode oTreeNode = null;
        if (oTree.m_oTreeDescriptor.getViewType() == 5) {
            OLTDevVerInfo oLTDevVerInfo = null;
            OLTDevVerInfo[] oLTVerInfoLst = DeviceTreeUtil.getOLTVerInfoLst(oResourceList);
            if (null == oLTVerInfoLst) {
                return;
            }
            SubMapInfo oMxuSubMapInfo = DeviceInfoManagerImpl.getInstance().getMxuSubMapInfo();
            for (int i = 0; i < oLTVerInfoLst.length; ++i) {
                oLTDevVerInfo = oLTVerInfoLst[i];
                ArrayList neIDList = oLTDevVerInfo.getDevIDLst();
                for (int j = 0; j < neIDList.size(); ++j) {
                    int neId = (Integer)neIDList.get(j);
                    SubMapInfo oSubMapInfo = DeviceInfoManagerImpl.getInstance().getSubMapInfoByDevID(oMxuSubMapInfo, neId);
                    oTreeNode = DeviceTreeUtil.findNodeForOLTDevVer(oTree, oSubMapInfo, oLTDevVerInfo.getStrDevVer());
                    if (null == oTreeNode) continue;
                    ((TreeNodeInfo)oTreeNode.getUserObject()).setSelected(iSelectionState);
                }
            }
            DeviceTreeUtil.updateSelecForParentRecursively(oTreeRootNode);
            return;
        }
        DeviceTreeUtil.findNodeForDevice(oTree, oResourceList, iSelectionState);
        DeviceTreeUtil.updateSelecForParentRecursively(oTreeRootNode);
    }

    public static void updateSelectionForParent(DeviceTree oTree) {
        DefaultMutableTreeNode oTreeRootNode = oTree.getRoot();
        TreeNodeInfo oUserObj = (TreeNodeInfo)oTreeRootNode.getUserObject();
        if (2 == oUserObj.m_iNodeType) {
            DeviceTreeUtil.updateSelectionForParent(oTreeRootNode);
        } else {
            int iNosVerNodes = oTreeRootNode.getChildCount();
            for (int i = 0; i < iNosVerNodes; ++i) {
                DefaultMutableTreeNode oChildNode = (DefaultMutableTreeNode)oTreeRootNode.getChildAt(i);
                DeviceTreeUtil.updateSelectionForParent(oChildNode);
            }
            DeviceTreeUtil.updateSelectionForParent(oTreeRootNode);
        }
    }

    public static void setTreeNodeSelectionStateForOLT(DeviceTree oTree, List oResourceLst, int iSelectionState) {
        DefaultMutableTreeNode oTreeNode = null;
        int iResourceCount = oResourceLst.size();
        OLTDevVerInfo oLTDevVerInfo = null;
        SubMapInfo oMxuSubMapInfo = DeviceInfoManagerImpl.getInstance().getMxuSubMapInfo();
        for (int i = 0; i < iResourceCount; ++i) {
            oLTDevVerInfo = (OLTDevVerInfo)oResourceLst.get(i);
            ArrayList neIDList = oLTDevVerInfo.getDevIDLst();
            for (int j = 0; j < neIDList.size(); ++j) {
                int neID = (Integer)neIDList.get(j);
                SubMapInfo oParentSubMapInfo = DeviceInfoManagerImpl.getInstance().getSubMapInfoByDevID(oMxuSubMapInfo, neID);
                oTreeNode = DeviceTreeUtil.findNodeForOLTDevVer(oTree, oParentSubMapInfo, oLTDevVerInfo.getStrDevVer());
                if (null == oTreeNode) continue;
                ((TreeNodeInfo)oTreeNode.getUserObject()).setSelected(iSelectionState);
                DeviceTreeUtil.propogateSelectionToParentNode(oTreeNode, iSelectionState);
            }
        }
    }

    public static DefaultMutableTreeNode findNodeForOLTDevVer(DeviceTree oTree, SubMapInfo oSubMapInfo, String strVersion) {
        if (null == oTree) {
            return null;
        }
        Enumeration<TreeNode> oChildren = oTree.getRoot().breadthFirstEnumeration();
        while (oChildren.hasMoreElements()) {
            Object oUserObject;
            DefaultMutableTreeNode oNode = (DefaultMutableTreeNode)oChildren.nextElement();
            if (null == oNode || null == (oUserObject = oNode.getUserObject()) || !(oUserObject instanceof TreeNodeInfo)) continue;
            TreeNodeInfo oTreeNode = (TreeNodeInfo)oUserObject;
            if (oTreeNode.getVersion().equalsIgnoreCase(ResourceManager.getInstance().getResString("UNKNOWN_VERSION"))) {
                oTreeNode.setVersion("");
            }
            if (10 != oTreeNode.m_iNodeType || !oTreeNode.getStrOLTParentSubMapID().equals(oSubMapInfo.m_strSubMapID) || !oTreeNode.getVersion().equals(strVersion)) continue;
            return oNode;
        }
        return null;
    }

    public static DefaultMutableTreeNode findNodeForDevice(DeviceTree oTree, int iDeviceID) {
        if (null == oTree) {
            return null;
        }
        Enumeration<TreeNode> oChildren = oTree.getRoot().breadthFirstEnumeration();
        while (oChildren.hasMoreElements()) {
            Object oUserObject;
            DefaultMutableTreeNode oNode = (DefaultMutableTreeNode)oChildren.nextElement();
            if (null == oNode || null == (oUserObject = oNode.getUserObject()) || !(oUserObject instanceof TreeNodeInfo)) continue;
            TreeNodeInfo oTreeNode = (TreeNodeInfo)oUserObject;
            if (!(4 == oTreeNode.m_iNodeType ? oTreeNode.m_oDevInfo.m_iDeviceID == iDeviceID : 8 == oTreeNode.m_iNodeType && oTreeNode.m_oDeviceInfo.getDeviceId() == iDeviceID)) continue;
            return oNode;
        }
        return null;
    }

    private static boolean resetNodeMap(DeviceTree oTree) {
        if (null == oTree) {
            return false;
        }
        nodeMap.clear();
        Enumeration<TreeNode> oChildren = oTree.getRoot().breadthFirstEnumeration();
        while (oChildren.hasMoreElements()) {
            Object oUserObject;
            DefaultMutableTreeNode oNode = (DefaultMutableTreeNode)oChildren.nextElement();
            if (null == oNode || null == (oUserObject = oNode.getUserObject()) || !(oUserObject instanceof TreeNodeInfo)) continue;
            TreeNodeInfo oTreeNode = (TreeNodeInfo)oUserObject;
            if (4 != oTreeNode.m_iNodeType) continue;
            nodeMap.put(oTreeNode.m_oDevInfo.m_iDeviceID, oTreeNode);
        }
        return true;
    }

    public static boolean findNodeForDevice(DeviceTree oTree, THashSet<Resource> oResourceList, int iSelectionState) {
        if (null == oTree || !DeviceTreeUtil.resetNodeMap(oTree)) {
            return false;
        }
        Iterator oResItor = oResourceList.iterator();
        Resource oResource = null;
        while (oResItor.hasNext()) {
            oResource = (Resource)oResItor.next();
            TreeNodeInfo oTreeNode = nodeMap.get(oResource.getDeviceID());
            if (null == oTreeNode) continue;
            oTreeNode.setSelected(iSelectionState);
        }
        nodeMap.clear();
        return true;
    }

    public static DefaultMutableTreeNode findNodeForResource(DeviceTree oTree, Resource oResource) {
        Enumeration<TreeNode> oChildren = oTree.getRoot().breadthFirstEnumeration();
        while (oChildren.hasMoreElements()) {
            Object oUserObject;
            DefaultMutableTreeNode oNode = (DefaultMutableTreeNode)oChildren.nextElement();
            if (null == oNode || null == (oUserObject = oNode.getUserObject()) || !(oUserObject instanceof TreeNodeInfo)) continue;
            TreeNodeInfo oTreeNode = (TreeNodeInfo)oUserObject;
            switch (oTreeNode.m_iNodeType) {
                case 8: {
                    if (!oTreeNode.m_oDeviceInfo.getResource().equals(oResource)) break;
                    return oNode;
                }
                case 5: {
                    if (!oTreeNode.m_oFrameNodeInfo.getResource().equals(oResource)) break;
                    return oNode;
                }
                case 6: {
                    if (!oTreeNode.m_oSlotInfo.getResource().equals(oResource)) break;
                    return oNode;
                }
                case 7: {
                    if (!oTreeNode.m_oSubslotInfo.getResource().equals(oResource)) break;
                    return oNode;
                }
            }
        }
        return null;
    }

    public static DefaultMutableTreeNode findNodeForDeviceType(DeviceTree oTree, DeviceTypeInfo oDeviceTypeInfo) {
        if (null == oDeviceTypeInfo || null == oTree || null == oTree.getRoot()) {
            return null;
        }
        int iDeviceTypeID = oDeviceTypeInfo.getDevTypeID();
        int iDeviceTypeVersionID = oDeviceTypeInfo.getDevTypeVersionId();
        Enumeration<TreeNode> oChildren = oTree.getRoot().breadthFirstEnumeration();
        while (oChildren.hasMoreElements()) {
            TreeNodeInfo oDevTypeNodeInfo;
            DeviceTypeInfo oCurrDevTypeInfo;
            DefaultMutableTreeNode oTreeNode = (DefaultMutableTreeNode)oChildren.nextElement();
            TreeNodeInfo oNodeInfo = (TreeNodeInfo)oTreeNode.getUserObject();
            if (1 != oNodeInfo.m_iNodeType || iDeviceTypeID != (oCurrDevTypeInfo = (oDevTypeNodeInfo = (TreeNodeInfo)oTreeNode.getUserObject()).getDeviceTypeInfo()).getDevTypeID() || iDeviceTypeVersionID != oCurrDevTypeInfo.getDevTypeVersionId()) continue;
            return oTreeNode;
        }
        return null;
    }

    public static DefaultMutableTreeNode findNodeForDeviceVersion(DeviceTree oTree, DeviceTypeInfo oDeviceTypeInfo, String strDeviceVersion) {
        if (null == oDeviceTypeInfo || null == strDeviceVersion || null == oTree.getRoot()) {
            return null;
        }
        Enumeration<TreeNode> oChildren = oTree.getRoot().breadthFirstEnumeration();
        while (oChildren.hasMoreElements()) {
            TreeNodeInfo oDevTypeNodeInfo;
            DeviceTypeInfo oCurrDevTypeInfo;
            DefaultMutableTreeNode oTreeNode = (DefaultMutableTreeNode)oChildren.nextElement();
            TreeNodeInfo oNodeInfo = (TreeNodeInfo)oTreeNode.getUserObject();
            if (2 != oNodeInfo.m_iNodeType && 10 != oNodeInfo.m_iNodeType || null == oTreeNode.getParent() || !oDeviceTypeInfo.equals(oCurrDevTypeInfo = (oDevTypeNodeInfo = (TreeNodeInfo)oTreeNode.getUserObject()).getDeviceTypeInfo()) || !strDeviceVersion.trim().equals(oNodeInfo.getVersion())) continue;
            return oTreeNode;
        }
        return null;
    }

    public static DefaultMutableTreeNode findNodeForSubmap(DeviceTree oTree, String strSubmapID) {
        if (null == strSubmapID || "".equals(strSubmapID)) {
            return null;
        }
        if (strSubmapID.equals("HWMAP_PHY_SUBMAP")) {
            if (oTree.isRootVisible()) {
                return oTree.getRoot();
            }
            return (DefaultMutableTreeNode)oTree.getRoot().getChildAt(0);
        }
        Enumeration<TreeNode> oChildren = oTree.getRoot().breadthFirstEnumeration();
        while (oChildren.hasMoreElements()) {
            Object oUserObject;
            DefaultMutableTreeNode oNode = (DefaultMutableTreeNode)oChildren.nextElement();
            if (null == oNode || null == (oUserObject = oNode.getUserObject()) || !(oUserObject instanceof TreeNodeInfo)) continue;
            TreeNodeInfo oTreeNode = (TreeNodeInfo)oUserObject;
            if (0 != oTreeNode.m_iNodeType || !strSubmapID.equals(oTreeNode.m_oSubMapNodeInfo.m_submapId)) continue;
            return oNode;
        }
        return null;
    }

    public static void propogateSelectionToParentNode(DefaultMutableTreeNode childNode, int typeOfSelection) {
        if (!((TreeNodeInfo)childNode.getUserObject()).isNodeSelectable()) {
            return;
        }
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)childNode.getParent();
        TreeNodeInfo child = null;
        if (null == parentNode) {
            child = (TreeNodeInfo)childNode.getUserObject();
            child.setSelected(typeOfSelection);
            return;
        }
        DeviceTreeUtil.updateSelectionForParent(parentNode);
    }

    public static void propogateSelectionToChildNodes(DefaultMutableTreeNode oNode, int iTypeOfSelection) {
        if (null == oNode || 0 == oNode.getChildCount()) {
            return;
        }
        int iChildCount = oNode.getChildCount();
        for (int i = 0; i < iChildCount; ++i) {
            DefaultMutableTreeNode oChildNode = (DefaultMutableTreeNode)oNode.getChildAt(i);
            if (null != oChildNode && oChildNode.getUserObject() instanceof TreeNodeInfo) {
                TreeNodeInfo oNodeInfo = (TreeNodeInfo)oChildNode.getUserObject();
                oNodeInfo.setSelected(iTypeOfSelection);
            }
            DeviceTreeUtil.propogateSelectionToChildNodes(oChildNode, iTypeOfSelection);
        }
    }

    public static void updateSelecForParentRecursively(DefaultMutableTreeNode oParentNode) {
        if (null == oParentNode) {
            return;
        }
        DefaultMutableTreeNode oChildNode = null;
        TreeNodeInfo oChildNodeInfo = null;
        int iChildCount = oParentNode.getChildCount();
        boolean bIsAlreadyParentSet = false;
        for (int i = 0; i < iChildCount; ++i) {
            oChildNode = (DefaultMutableTreeNode)oParentNode.getChildAt(i);
            oChildNodeInfo = (TreeNodeInfo)oChildNode.getUserObject();
            int iNodeType = oChildNodeInfo.m_iNodeType;
            if (4 == iNodeType || 5 == iNodeType || 6 == iNodeType || 7 == iNodeType || 10 == iNodeType) {
                if (bIsAlreadyParentSet) continue;
                bIsAlreadyParentSet = true;
                DeviceTreeUtil.updateSelectionForParent(oParentNode);
                continue;
            }
            DeviceTreeUtil.updateSelecForParentRecursively(oChildNode);
        }
    }

    private static void updateSelectionForParent(DefaultMutableTreeNode parentNode) {
        if (null == parentNode) {
            return;
        }
        DefaultMutableTreeNode oChildNode = null;
        TreeNodeInfo oChildNodeInfo = null;
        boolean isAnyChildSelected = false;
        boolean isPartiallySelected = false;
        boolean isAnyChildDeselected = false;
        int iChildCount = parentNode.getChildCount();
        for (int i = 0; i < iChildCount; ++i) {
            oChildNode = (DefaultMutableTreeNode)parentNode.getChildAt(i);
            oChildNodeInfo = (TreeNodeInfo)oChildNode.getUserObject();
            if (oChildNodeInfo.getSelectedState() == 1) {
                isPartiallySelected = true;
                ((TreeNodeInfo)parentNode.getUserObject()).setSelected(1);
                DeviceTreeUtil.propogateSelectionToParentNode(parentNode, 1);
                break;
            }
            if (oChildNodeInfo.getSelectedState() == 0) {
                isAnyChildSelected = true;
                if (!isAnyChildDeselected) continue;
                break;
            }
            if (oChildNodeInfo.getSelectedState() != 2) continue;
            isAnyChildDeselected = true;
            if (isAnyChildSelected) break;
        }
        DeviceTreeUtil.populateNodeForChildSelection(parentNode, isAnyChildSelected, isPartiallySelected, isAnyChildDeselected);
    }

    private static void populateNodeForChildSelection(DefaultMutableTreeNode oParentNode, boolean isAnyChildSelected, boolean isPartiallySelected, boolean isAnyChildDeselected) {
        if (null == oParentNode) {
            return;
        }
        if (!isPartiallySelected) {
            TreeNodeInfo oNodeInfo = (TreeNodeInfo)oParentNode.getUserObject();
            if (isAnyChildSelected && isAnyChildDeselected) {
                oNodeInfo.setSelected(1);
                DeviceTreeUtil.propogateSelectionToParentNode(oParentNode, 1);
            } else if (isAnyChildSelected && !isAnyChildDeselected) {
                oNodeInfo.setSelected(0);
                DeviceTreeUtil.propogateSelectionToParentNode(oParentNode, 0);
            } else if (!isAnyChildSelected && isAnyChildDeselected) {
                oNodeInfo.setSelected(2);
                DeviceTreeUtil.propogateSelectionToParentNode(oParentNode, 2);
            }
        }
    }

    public static DeviceInfo[] getDeviceListForTreeNode(TreeNodeInfo oTreeNodeInfo) {
        if (null == oTreeNodeInfo) {
            return new DeviceInfo[0];
        }
        IDeviceInfoManager oDeviceInfoManager = DCFrameWorkUtil.getDeviceInfoManager();
        DeviceInfo[] oDeviceList = null;
        if (4 == oTreeNodeInfo.m_iNodeType) {
            oDeviceList = new DeviceInfo[1];
            DeviceNodeInfo oDeviceInfo = oTreeNodeInfo.m_oDevInfo;
            oDeviceList[0] = oDeviceInfoManager.getDevice(oDeviceInfo.m_iDeviceID);
        } else if (3 == oTreeNodeInfo.m_iNodeType) {
            oDeviceList = oDeviceInfoManager.getDevices();
        } else if (1 == oTreeNodeInfo.m_iNodeType) {
            int iDeviceTypeID = oTreeNodeInfo.m_oDevType.getDevTypeID();
            int iDeviceTypeVerID = oTreeNodeInfo.m_oDevType.getDevTypeVersionId();
            oDeviceList = oDeviceInfoManager.getDevicesByTypeAndVersion(iDeviceTypeID, iDeviceTypeVerID);
        } else if (9 == oTreeNodeInfo.m_iNodeType) {
            Vector<DeviceInfo> resourceList = new Vector<DeviceInfo>();
            Vector devTypeList = oDeviceInfoManager.getDevTypeListByDiffusionTask();
            int devTypeCount = devTypeList.size();
            for (int i = 0; i < devTypeCount; ++i) {
                DeviceTypeInfo deviceType = (DeviceTypeInfo)devTypeList.get(i);
                int iDeviceTypeID = deviceType.getDevTypeID();
                DeviceInfo[] deviceList = oDeviceInfoManager.getDevicesByType(iDeviceTypeID);
                for (int j = 0; j < deviceList.length; ++j) {
                    resourceList.add(deviceList[j]);
                }
            }
            oDeviceList = resourceList.toArray(new DeviceInfo[0]);
        } else if (2 == oTreeNodeInfo.m_iNodeType) {
            String strVersionID = oTreeNodeInfo.m_strDeviceVersion;
            DeviceTypeInfo oDeviceTypeInfo = oTreeNodeInfo.m_oDevType;
            oDeviceList = oDeviceInfoManager.getDevicesForVersion(strVersionID, oDeviceTypeInfo);
        } else if (10 == oTreeNodeInfo.m_iNodeType) {
            String strVersionID = oTreeNodeInfo.m_strDeviceVersion;
            DeviceTypeInfo oDeviceTypeInfo = oTreeNodeInfo.m_oDevType;
            SubMapInfo oSubMapInfo = oDeviceInfoManager.getSubmapForID(oTreeNodeInfo.getStrOLTParentSubMapID(), oDeviceInfoManager.getMxuSubMapInfo());
            DeviceInfo[] arrDeviceList = oDeviceInfoManager.getDevicesSubMapCurLev(oSubMapInfo);
            oDeviceList = oDeviceInfoManager.filterDevicesByVersion(arrDeviceList, strVersionID, oDeviceTypeInfo);
        } else if (0 == oTreeNodeInfo.m_iNodeType) {
            SubMapNodeInfo oSubMapNodeInfo = oTreeNodeInfo.m_oSubMapNodeInfo;
            oDeviceList = DeviceTreeUtil.filterDevicesForNodeType(oSubMapNodeInfo);
        }
        Vector<DeviceInfo> devices = new Vector<DeviceInfo>();
        if (null != oTreeNodeInfo.getBoardType() && null != oDeviceList) {
            for (DeviceInfo devInfo : oDeviceList) {
                if (!devInfo.getDevBoardType().equals(oTreeNodeInfo.getBoardType())) continue;
                devices.add(devInfo);
            }
            return devices.toArray(new DeviceInfo[0]);
        }
        return oDeviceList;
    }

    public static DeviceInfo[] filterDevicesForNodeType(SubMapNodeInfo oSubMapNodeInfo) {
        if (null == oSubMapNodeInfo) {
            return new DeviceInfo[0];
        }
        IDeviceInfoManager oDeviceInfoManager = DCFrameWorkUtil.getDeviceInfoManager();
        SubMapInfo oSubMapInfo = oDeviceInfoManager.getSubmapForID(oSubMapNodeInfo.m_submapId);
        DeviceInfo[] arrDeviceList = oDeviceInfoManager.getDevicesRecursivelyInSubMap(oSubMapInfo);
        if (3 == oSubMapNodeInfo.m_iSubmapNodeType) {
            return arrDeviceList;
        }
        if (1 == oSubMapNodeInfo.m_iSubmapNodeType) {
            DeviceInfo[] arrFilteredDeviceList;
            if (oSubMapNodeInfo.m_iDeviceType == -1 && oSubMapNodeInfo.m_iDeviceTypeVersionID == -1) {
                Vector devTypeList = oDeviceInfoManager.getDevTypeListByDiffusionTask();
                Vector<DeviceInfo> devices = new Vector<DeviceInfo>();
                int devTypeCount = devTypeList.size();
                for (int i = 0; i < devTypeCount; ++i) {
                    DeviceTypeInfo devTypeInfo = (DeviceTypeInfo)devTypeList.get(i);
                    if (devTypeInfo.getDevTypeID() == -1 && devTypeInfo.getDevTypeVersionId() == -1) continue;
                    DeviceInfo[] devList = oDeviceInfoManager.filterDevicesByType(arrDeviceList, devTypeInfo.getDevTypeID(), devTypeInfo.getDevTypeVersionId());
                    int count = devList.length;
                    for (int j = 0; j < count; ++j) {
                        devices.add(devList[j]);
                    }
                }
                arrFilteredDeviceList = devices.toArray(new DeviceInfo[0]);
            } else {
                arrFilteredDeviceList = oDeviceInfoManager.filterDevicesByType(arrDeviceList, oSubMapNodeInfo.m_iDeviceType, oSubMapNodeInfo.m_iDeviceTypeVersionID);
            }
            return arrFilteredDeviceList;
        }
        if (2 == oSubMapNodeInfo.m_iSubmapNodeType) {
            DeviceTypeInfo oDeviceTypeInfo = oDeviceInfoManager.getDeviceTypeInfo(oSubMapNodeInfo.m_iDeviceType, oSubMapNodeInfo.m_iDeviceTypeVersionID);
            DeviceInfo[] arrFilteredDeviceList = oDeviceInfoManager.filterDevicesByVersion(arrDeviceList, oSubMapNodeInfo.m_strDeviceVersion, oDeviceTypeInfo);
            return arrFilteredDeviceList;
        }
        return new DeviceInfo[0];
    }

    public static TreeNodeInfo getSelectedTreeNodeInfo(DeviceTree oDeviceTree) {
        if (null != oDeviceTree) {
            TreePath oPath = oDeviceTree.getSelectionPath();
            if (null == oPath) {
                return null;
            }
            DefaultMutableTreeNode oNode = (DefaultMutableTreeNode)oPath.getLastPathComponent();
            if (null != oNode && oNode.getUserObject() instanceof TreeNodeInfo) {
                return (TreeNodeInfo)oNode.getUserObject();
            }
        }
        return null;
    }

    public static DefaultMutableTreeNode findNodeForTreeNodeInfo(DeviceTree oDeviceTree, TreeNodeInfo oNodeInfo) {
        if (null == oNodeInfo) {
            return null;
        }
        switch (oNodeInfo.m_iNodeType) {
            case 3: {
                return oDeviceTree.getRoot();
            }
            case 1: {
                return DeviceTreeUtil.findNodeForDeviceType(oDeviceTree, oNodeInfo.m_oDevType);
            }
            case 2: {
                return DeviceTreeUtil.findNodeForDeviceVersion(oDeviceTree, oNodeInfo.m_oDevType, oNodeInfo.m_strDeviceVersion);
            }
            case 0: {
                return DeviceTreeUtil.findNodeForSubmap(oDeviceTree, oNodeInfo.m_oSubMapNodeInfo.m_submapId);
            }
        }
        return null;
    }

    public static OLTDevVerInfo[] getOLTVerInfoLst(TreeNodeInfo oTreeNodeInfo) {
        DeviceInfo[] devInfoLst = DeviceTreeUtil.getDeviceListForTreeNode(oTreeNodeInfo);
        Vector<DeviceInfo> mxuDeviceVec = new Vector<DeviceInfo>();
        for (DeviceInfo deviceInfo : devInfoLst) {
            if (!deviceInfo.getDeviceTypeInfo().isBMSDomain() || deviceInfo.getRoleType() != 2) continue;
            mxuDeviceVec.add(deviceInfo);
        }
        if (mxuDeviceVec.size() == 0) {
            return new OLTDevVerInfo[0];
        }
        devInfoLst = mxuDeviceVec.toArray(new DeviceInfo[0]);
        OLTDevVerInfo[] oLTDevVerInfoLst = DeviceTreeUtil.getOLTVerInfoLst(devInfoLst);
        return oLTDevVerInfoLst;
    }

    public static OLTDevVerInfo[] getOLTVerInfoLst(DeviceInfo[] devInfoLst) {
        IDeviceInfoManager oDeviceInfoManager = DCFrameWorkUtil.getDeviceInfoManager();
        int devLstSize = devInfoLst.length;
        DeviceInfo devInfo = null;
        DeviceInfo oltDevInfo = null;
        int devTypeID = -1;
        int devTypeVerID = -1;
        OLTDevVerInfo oLTVerInfo = null;
        Vector oLTDevVerInfoVt = new Vector();
        int oltDevID = -1;
        int devID = -1;
        TIntIntHashMap oTIntIntHashMap = new TIntIntHashMap();
        try {
            oTIntIntHashMap = oDeviceInfoManager.getOLTIDWithMXUIDMap(devInfoLst);
        }
        catch (DCException ex) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ex.getMessage(), DCFrameWorkUtil.getLocalizedString("ERROR"), 0);
        }
        for (int i = 0; i < devLstSize; ++i) {
            oLTVerInfo = new OLTDevVerInfo();
            devInfo = devInfoLst[i];
            devID = devInfo.getDevId();
            oltDevID = oTIntIntHashMap.get(devID);
            oltDevInfo = oDeviceInfoManager.getDevice(oltDevID);
            devTypeID = devInfo.getDeviceTypeInfo().getDevTypeID();
            devTypeVerID = devInfo.getDeviceTypeInfo().getDevTypeVersionId();
            oLTVerInfo.setIDevTypeID(devTypeID);
            oLTVerInfo.setIDevVerID(devTypeVerID);
            oLTVerInfo.setOltDevID(oltDevID);
            oLTVerInfo.setOltDevName(oltDevInfo.getDevName());
            oLTVerInfo.setOltDevIP(oltDevInfo.getDevIPAddress());
            oLTVerInfo.setStrDevVer(devInfo.getDevVersion().getDevVersion());
            DeviceTreeUtil.refreshDevVerInfoLst(oLTDevVerInfoVt, oLTVerInfo, devID);
        }
        OLTDevVerInfo[] oLTDevVerInfoLst = new OLTDevVerInfo[oLTDevVerInfoVt.size()];
        oLTDevVerInfoLst = oLTDevVerInfoVt.toArray(oLTDevVerInfoLst);
        return oLTDevVerInfoLst;
    }

    public static OLTDevVerInfo[] getOLTVerInfoLst(THashSet<Resource> resourceList) {
        if (null == resourceList) {
            return null;
        }
        IDeviceInfoManager oDeviceInfoManager = DCFrameWorkUtil.getDeviceInfoManager();
        int devID = -1;
        int oltDevID = -1;
        int devTypeID = -1;
        int devTypeVerID = -1;
        Resource resource2 = null;
        DeviceInfo oltDevInfo = null;
        OLTDevVerInfo oLTVerInfo = null;
        DeviceInfo devInfo = null;
        Vector oLTDevVerInfoVt = new Vector();
        TIntIntHashMap oTIntIntHashMap = new TIntIntHashMap();
        try {
            oTIntIntHashMap = oDeviceInfoManager.getOLTIDWithMXUIDMap(resourceList);
        }
        catch (DCException ex) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ex.getMessage(), DCFrameWorkUtil.getLocalizedString("ERROR"), 0);
        }
        for (Resource resource2 : resourceList) {
            devID = resource2.getDeviceID();
            oLTVerInfo = new OLTDevVerInfo();
            devInfo = oDeviceInfoManager.getDevice(devID);
            oltDevID = oTIntIntHashMap.get(devID);
            oltDevInfo = oDeviceInfoManager.getDevice(oltDevID);
            devTypeID = devInfo.getDeviceTypeInfo().getDevTypeID();
            devTypeVerID = devInfo.getDeviceTypeInfo().getDevTypeVersionId();
            oLTVerInfo.setIDevTypeID(devTypeID);
            oLTVerInfo.setIDevVerID(devTypeVerID);
            oLTVerInfo.setOltDevID(oltDevID);
            oLTVerInfo.setOltDevName(oltDevInfo.getDevName());
            oLTVerInfo.setOltDevIP(oltDevInfo.getDevIPAddress());
            oLTVerInfo.setStrDevVer(resource2.getDeviceVersion());
            DeviceTreeUtil.refreshDevVerInfoLst(oLTDevVerInfoVt, oLTVerInfo, devID);
        }
        OLTDevVerInfo[] oLTDevVerInfoLst = new OLTDevVerInfo[oLTDevVerInfoVt.size()];
        oLTDevVerInfoLst = oLTDevVerInfoVt.toArray(oLTDevVerInfoLst);
        return oLTDevVerInfoLst;
    }

    private static void refreshDevVerInfoLst(Vector oLTDevVerInfoVt, OLTDevVerInfo oLTDevVerInfo, int devID) {
        boolean isExist = false;
        int size = oLTDevVerInfoVt.size();
        OLTDevVerInfo existOLTDevVerInfo = null;
        for (int i = 0; i < size; ++i) {
            existOLTDevVerInfo = (OLTDevVerInfo)oLTDevVerInfoVt.get(i);
            if (!oLTDevVerInfo.getStrDevVer().equals(existOLTDevVerInfo.getStrDevVer()) || oLTDevVerInfo.getOltDevID() != existOLTDevVerInfo.getOltDevID()) continue;
            isExist = true;
            existOLTDevVerInfo.addMxuMount();
            ArrayList<Integer> tmpLst = new ArrayList<Integer>();
            tmpLst.add(devID);
            existOLTDevVerInfo.addDevIDLst(tmpLst);
            break;
        }
        if (!isExist) {
            ArrayList<Integer> tmpLst = new ArrayList<Integer>();
            tmpLst.add(devID);
            oLTDevVerInfo.addDevIDLst(tmpLst);
            oLTDevVerInfoVt.add(oLTDevVerInfo);
        }
    }
}

