/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.components.tree.devicetree;

import com.huawei.dc.common.components.tree.devicetree.descriptor.DeviceTreeBaseDescriptor;
import com.huawei.dc.common.components.tree.devicetree.listener.DeviceTreeKeyListener;
import com.huawei.dc.common.components.tree.devicetree.listener.DeviceTreeListener;
import com.huawei.dc.common.components.tree.devicetree.model.DeviceTreeModel;
import com.huawei.dc.common.components.tree.devicetree.model.DeviceTreeModelManager;
import com.huawei.dc.common.components.tree.devicetree.model.DeviceTreeNode;
import com.huawei.dc.common.components.tree.devicetree.model.IDeviceTreeModelManager;
import com.huawei.dc.common.components.tree.devicetree.renderer.DeviceSelectionTreeRenderer;
import com.huawei.dc.common.components.tree.renderer.DCDefaultTreeCellRenderer;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.interfaces.DCTreeEventListener;
import com.huawei.dc.common.tree.TreeNodeInfo;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.taskmgmt.model.Resource;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public abstract class DeviceTree
extends JTree {
    private static final long serialVersionUID = 1L;
    protected DeviceTreeBaseDescriptor m_oTreeDescriptor;
    protected IDeviceTreeModelManager m_oTreeModelManager;
    protected DeviceTreeNode m_oRoot;
    protected DeviceTreeListener m_oTreeListener;
    protected IDeviceInfoManager m_oDeviceInfoManager;
    protected int m_iLastSelectRow = -1;
    protected DefaultMutableTreeNode m_oLastSelectNode = null;

    public DeviceTree(DeviceTreeBaseDescriptor oTreeDescriptor, IDeviceInfoManager oDeviceInfoManager, String rootName) {
        this.initializeTree(oTreeDescriptor, oDeviceInfoManager, rootName);
    }

    public DeviceTree(DeviceTreeBaseDescriptor oTreeDescriptor, DeviceInfo[] deviceInfoList, String rootName) {
        this.initializeTreeByFilter(oTreeDescriptor, deviceInfoList, rootName);
    }

    private void initializeTree(DeviceTreeBaseDescriptor oTreeDescriptor, IDeviceInfoManager oDeviceInfoMgr, String rootName) {
        this.m_oTreeDescriptor = oTreeDescriptor;
        if (null == this.m_oTreeDescriptor) {
            return;
        }
        this.m_oDeviceInfoManager = oDeviceInfoMgr;
        this.initializeModel();
        this.initializeTreeSelectionModel();
        this.initializeTreeModelManager(oDeviceInfoMgr);
        this.populateTreeModel(rootName);
        this.initializeCellRenderer();
        this.initializeTreeListener();
        this.addKeyListenerToComponent();
        this.setShowsRootHandles(true);
    }

    private void initializeTreeByFilter(DeviceTreeBaseDescriptor oTreeDescriptor, DeviceInfo[] deviceInfoList, String rootName) {
        this.m_oTreeDescriptor = oTreeDescriptor;
        if (null == this.m_oTreeDescriptor) {
            return;
        }
        this.initializeModel();
        this.initializeTreeSelectionModel();
        this.initializeTreeModelManager(DeviceInfoManagerImpl.getInstance());
        this.populateTreeModelByFilter(rootName, deviceInfoList);
        this.initializeCellRenderer();
        this.initializeTreeListener();
        this.addKeyListenerToComponent();
        this.setShowsRootHandles(true);
    }

    public void clearRoot() {
        this.m_oRoot.removeAllChildren();
    }

    public DefaultMutableTreeNode getRoot() {
        return this.m_oRoot;
    }

    private void initializeModel() {
        this.setLargeModel(true);
        this.setRowHeight(19);
        this.m_oRoot = new DeviceTreeNode();
        DeviceTreeModel oTreeModel = new DeviceTreeModel(this.m_oRoot);
        this.setModel(oTreeModel);
        this.setSelectionRow(0);
        this.m_iLastSelectRow = 0;
    }

    protected void initializeTreeListener() {
        this.m_oTreeListener = new DeviceTreeListener(this);
        this.addMouseListener(this.m_oTreeListener);
    }

    protected void initializeCellRenderer() {
        if (this.m_oTreeDescriptor.isTreeSelectable()) {
            this.setCellRenderer(new DeviceSelectionTreeRenderer());
        } else {
            this.setCellRenderer(new DCDefaultTreeCellRenderer());
        }
    }

    protected void initializeTreeModelManager(IDeviceInfoManager oDeviceInfoMgr) {
        this.m_oTreeModelManager = DeviceTreeModelManager.getInstance(oDeviceInfoMgr);
    }

    private void populateTreeModel(String title) {
        int iTreeType = this.m_oTreeDescriptor.getTreeType();
        if (2 == iTreeType || 3 == iTreeType) {
            this.setRootVisible(true);
        } else {
            this.setRootVisible(false);
        }
        this.m_oTreeModelManager.populateTreeModel(this.m_oRoot, this.m_oTreeDescriptor, title);
    }

    private void populateTreeModelByFilter(String title, DeviceInfo[] deviceInfoList) {
        int iTreeType = this.m_oTreeDescriptor.getTreeType();
        if (2 == iTreeType || 3 == iTreeType) {
            this.setRootVisible(true);
        } else {
            this.setRootVisible(false);
        }
        this.m_oTreeModelManager.populateTreeModelByFilter(this.m_oRoot, this.m_oTreeDescriptor, title, deviceInfoList);
    }

    protected void initializeTreeSelectionModel() {
        this.getSelectionModel().setSelectionMode(1);
        if (!this.m_oTreeDescriptor.isTreeSelectable()) {
            this.setSelectionListenerToTree();
        }
    }

    private void setSelectionListenerToTree() {
        this.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent oEvent) {
                DefaultMutableTreeNode oSelectedNode = (DefaultMutableTreeNode)DeviceTree.this.getLastSelectedPathComponent();
                if (null != oSelectedNode) {
                    DeviceTree.this.m_oTreeListener.sendNotificationToTreeListeners(oSelectedNode);
                }
                DeviceTree.this.m_oLastSelectNode = oSelectedNode;
                if (null != oSelectedNode && oSelectedNode.equals(DeviceTree.this.m_oRoot)) {
                    DeviceTree.this.m_iLastSelectRow = 0;
                }
            }
        });
    }

    public void updateTreeModel(String title) {
        this.m_oTreeModelManager.populateTreeModel(this.m_oRoot, this.m_oTreeDescriptor, title);
    }

    public void registerForTreeSelectionEvent(DCTreeEventListener oEventListener) {
        if (null != this.m_oTreeListener) {
            this.m_oTreeListener.addDCEventListener(oEventListener);
        }
    }

    public void unregisterForTreeSelectionEvent(DCTreeEventListener oEventListener) {
        this.m_oTreeListener.removeDCEventListener(oEventListener);
    }

    public void setSelectable(boolean bFlag) {
        this.m_oTreeDescriptor.setTreeSelectable(bFlag);
        if (bFlag) {
            this.setCellRenderer(new DeviceSelectionTreeRenderer());
        }
    }

    public DeviceTreeBaseDescriptor getTreeDescriptor() {
        return this.m_oTreeDescriptor;
    }

    public void notifyNodeSelection(DefaultMutableTreeNode oNode) {
        this.m_oTreeListener.notifyTreeNodeSelection(oNode);
        this.m_oLastSelectNode = oNode;
        if (null != oNode && oNode.equals(this.m_oRoot)) {
            this.m_iLastSelectRow = 0;
        }
    }

    public void notifyTreeInit() {
        this.m_oTreeListener.notifyTreeInit();
    }

    public List getSelectedResources() {
        ArrayList<Resource> oSelectedResourceList = new ArrayList<Resource>(0);
        if (0 == this.m_oRoot.getChildCount()) {
            return oSelectedResourceList;
        }
        IDeviceInfoManager deviceInfoManager = DeviceInfoManagerImpl.getInstance();
        DeviceInfo deviceInfo = null;
        Resource oResource = null;
        Enumeration<TreeNode> oChildEnum = this.m_oRoot.depthFirstEnumeration();
        while (oChildEnum.hasMoreElements()) {
            DefaultMutableTreeNode oTreeNode = (DefaultMutableTreeNode)oChildEnum.nextElement();
            TreeNodeInfo oNodeInfo = (TreeNodeInfo)oTreeNode.getUserObject();
            if (4 != oNodeInfo.m_iNodeType || 2 == oNodeInfo.getSelectedState()) continue;
            oResource = new Resource();
            deviceInfo = deviceInfoManager.getDevice(oNodeInfo.m_oDevInfo.m_iDeviceID);
            if (null != deviceInfo) {
                oResource.setMMLProtocolPhysicalID(deviceInfo.getNEDevId());
                if (null != deviceInfo.getDeviceTypeInfo()) {
                    oResource.setDevTypeId(deviceInfo.getDeviceTypeInfo().getDevTypeID());
                    oResource.setDevVersionID(deviceInfo.getDeviceTypeInfo().getDevTypeVersionId());
                }
            }
            oResource.setDeviceID(oNodeInfo.m_oDevInfo.m_iDeviceID);
            oResource.setDeviceIP(oNodeInfo.m_oDevInfo.m_strDeviceIP);
            oResource.setDeviceName(oNodeInfo.m_oDevInfo.m_strDeviceName);
            oResource.setRoleType(oNodeInfo.m_oDevInfo.m_iRoleType);
            oSelectedResourceList.add(oResource);
        }
        return oSelectedResourceList;
    }

    public DeviceInfo[] getSelectedDevInfoArr() {
        Vector<DeviceInfo> deviceVec = new Vector<DeviceInfo>(0);
        if (0 == this.m_oRoot.getChildCount()) {
            return deviceVec.toArray(new DeviceInfo[0]);
        }
        IDeviceInfoManager deviceInfoManager = DeviceInfoManagerImpl.getInstance();
        DeviceInfo deviceInfo = null;
        Enumeration<TreeNode> oChildEnum = this.m_oRoot.depthFirstEnumeration();
        while (oChildEnum.hasMoreElements()) {
            DefaultMutableTreeNode oTreeNode = (DefaultMutableTreeNode)oChildEnum.nextElement();
            TreeNodeInfo oNodeInfo = (TreeNodeInfo)oTreeNode.getUserObject();
            if (4 != oNodeInfo.m_iNodeType || 2 == oNodeInfo.getSelectedState() || null == (deviceInfo = deviceInfoManager.getDevice(oNodeInfo.m_oDevInfo.m_iDeviceID))) continue;
            deviceVec.add(deviceInfo);
        }
        return deviceVec.toArray(new DeviceInfo[0]);
    }

    public DeviceInfo[] getDeSelectedDevInfoArr() {
        Vector<DeviceInfo> deviceVec = new Vector<DeviceInfo>(0);
        if (0 == this.m_oRoot.getChildCount()) {
            return deviceVec.toArray(new DeviceInfo[0]);
        }
        IDeviceInfoManager deviceInfoManager = DeviceInfoManagerImpl.getInstance();
        DeviceInfo deviceInfo = null;
        Enumeration<TreeNode> oChildEnum = this.m_oRoot.depthFirstEnumeration();
        while (oChildEnum.hasMoreElements()) {
            DefaultMutableTreeNode oTreeNode = (DefaultMutableTreeNode)oChildEnum.nextElement();
            TreeNodeInfo oNodeInfo = (TreeNodeInfo)oTreeNode.getUserObject();
            if (4 != oNodeInfo.m_iNodeType || 2 != oNodeInfo.getSelectedState() || null == (deviceInfo = deviceInfoManager.getDevice(oNodeInfo.m_oDevInfo.m_iDeviceID))) continue;
            deviceVec.add(deviceInfo);
        }
        return deviceVec.toArray(new DeviceInfo[0]);
    }

    public DefaultMutableTreeNode getLastSelectNode() {
        return this.m_oLastSelectNode;
    }

    public DeviceTreeListener getTreeListener() {
        return this.m_oTreeListener;
    }

    public void processEvent(int iEventType, Object oEventSource) {
    }

    public void disposeTree() {
        if (null != this.m_oDeviceInfoManager) {
            this.m_oDeviceInfoManager = null;
        }
        if (null != this.m_oRoot) {
            this.m_oRoot.removeAllChildren();
            this.m_oRoot = null;
        }
        if (null != this.m_oTreeDescriptor) {
            this.m_oTreeDescriptor = null;
        }
        if (null != this.m_oTreeListener) {
            this.m_oTreeListener.setToNULL();
            this.m_oTreeListener = null;
        }
        if (null != this.m_oTreeModelManager) {
            this.m_oTreeModelManager = null;
        }
        if (null != this.getCellRenderer()) {
            this.m_oTreeModelManager = null;
        }
        try {
            this.setCellRenderer(null);
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
    }

    protected void addKeyListenerToComponent() {
        this.addKeyListener(new DeviceTreeKeyListener(this));
    }
}

