/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.components.tree.devicetree;

import com.huawei.dc.common.asndatacenter.AsnDCDeviceSubmapNtfnInfo;
import com.huawei.dc.common.components.tree.devicetree.BoardTree;
import com.huawei.dc.common.components.tree.devicetree.DeviceTreeUtil;
import com.huawei.dc.common.components.tree.devicetree.descriptor.DeviceTreeBaseDescriptor;
import com.huawei.dc.common.components.tree.devicetree.model.DeviceTreeModelManager;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.tree.DeviceNodeInfo;
import com.huawei.dc.common.tree.TreeNodeInfo;
import com.huawei.dc.deviceinfo.DeviceInfo;
import javax.swing.tree.DefaultMutableTreeNode;

public class DeviceBoardTree
extends BoardTree {
    private static final long serialVersionUID = 1L;

    public DeviceBoardTree(DeviceTreeBaseDescriptor oDescriptor, IDeviceInfoManager oDeviceInfoMgr, String rootName) {
        super(oDescriptor, oDeviceInfoMgr, rootName);
    }

    @Override
    protected void initializeTreeModelManager(IDeviceInfoManager oDeviceInfoMgr) {
        this.m_oTreeModelManager = DeviceTreeModelManager.getInstance(oDeviceInfoMgr);
    }

    @Override
    public void processEvent(int iEventType, Object oEventSource) {
        if (!(oEventSource instanceof AsnDCDeviceSubmapNtfnInfo)) {
            return;
        }
        AsnDCDeviceSubmapNtfnInfo oAsnDeviceInfo = (AsnDCDeviceSubmapNtfnInfo)oEventSource;
        switch (iEventType) {
            case 0: {
                this.addDeviceToTree(oAsnDeviceInfo);
                break;
            }
            case 1: {
                this.removeDeviceFromTree(oAsnDeviceInfo);
                break;
            }
            case 2: {
                this.modifyDeviceInTree(oAsnDeviceInfo);
                break;
            }
        }
    }

    private void addDeviceToTree(AsnDCDeviceSubmapNtfnInfo oAsnDeviceInfo) {
        DeviceInfo oDeviceInfo = this.m_oDeviceInfoManager.getDeviceFromAsn(oAsnDeviceInfo.oDeviceInfo);
        DefaultMutableTreeNode oDeviceNode = DeviceTreeUtil.findNodeForDevice(this, oDeviceInfo.getDevId());
        if (null != oDeviceNode) {
            return;
        }
        DefaultMutableTreeNode oVersionNode = DeviceTreeUtil.findNodeForDeviceVersion(this, oDeviceInfo.getDeviceTypeInfo(), oDeviceInfo.getDevVersion().getDevVersion());
        if (null == oVersionNode) {
            if (3 == this.m_oTreeDescriptor.getTreeType()) {
                return;
            }
            oVersionNode = new DefaultMutableTreeNode();
            TreeNodeInfo oNodeInfo = new TreeNodeInfo(oDeviceInfo.getDevVersion().getDevVersion(), oDeviceInfo.getDeviceTypeInfo());
            oVersionNode.setUserObject(oNodeInfo);
            DefaultMutableTreeNode oTypeNode = DeviceTreeUtil.findNodeForDeviceType(this, oDeviceInfo.getDeviceTypeInfo());
            if (null == oTypeNode) {
                return;
            }
            oTypeNode.add(oVersionNode);
        }
        DeviceNodeInfo devNodeInfo = new DeviceNodeInfo();
        devNodeInfo.m_iDeviceID = oDeviceInfo.getDevId();
        devNodeInfo.m_strDeviceIP = oDeviceInfo.getDevIPAddress();
        devNodeInfo.m_strDeviceName = oDeviceInfo.getDevName();
        devNodeInfo.m_iRoleType = oDeviceInfo.getRoleType();
        TreeNodeInfo oDeviceNodeInfo = new TreeNodeInfo(devNodeInfo);
        oDeviceNode = new DefaultMutableTreeNode(oDeviceNodeInfo);
        oVersionNode.add(oDeviceNode);
    }

    private void removeDeviceFromTree(AsnDCDeviceSubmapNtfnInfo oAsnDeviceInfo) {
        DefaultMutableTreeNode oDeviceNode;
        DeviceInfo oDeviceInfo = this.m_oDeviceInfoManager.getDevice(oAsnDeviceInfo.oDeviceInfo.iDevId.intValue());
        if (null == oDeviceInfo) {
            oDeviceInfo = this.m_oDeviceInfoManager.getDeviceFromAsn(oAsnDeviceInfo.oDeviceInfo);
        }
        if (null == (oDeviceNode = DeviceTreeUtil.findNodeForDevice(this, oDeviceInfo.getDevId()))) {
            return;
        }
        DefaultMutableTreeNode oVersionNode = (DefaultMutableTreeNode)oDeviceNode.getParent();
        oDeviceNode.removeFromParent();
        TreeNodeInfo oDeviceNodeInfo = (TreeNodeInfo)oDeviceNode.getUserObject();
        if (2 != oDeviceNodeInfo.getSelectedState()) {
            oDeviceNodeInfo.setSelected(2);
            this.m_oTreeListener.sendNotificationToTreeListeners(oDeviceNode);
        }
        if (3 != this.m_oTreeDescriptor.getTreeType() && 0 == oVersionNode.getChildCount()) {
            oVersionNode.removeFromParent();
        }
    }

    private void modifyDeviceInTree(AsnDCDeviceSubmapNtfnInfo oAsnDeviceInfo) {
        DeviceInfo oDeviceInfo = this.m_oDeviceInfoManager.getDeviceFromAsn(oAsnDeviceInfo.oDeviceInfo);
        DefaultMutableTreeNode oDeviceNode = DeviceTreeUtil.findNodeForDevice(this, oDeviceInfo.getDevId());
        if (null == oDeviceNode) {
            return;
        }
        DeviceNodeInfo devNodeInfo = new DeviceNodeInfo();
        devNodeInfo.m_iDeviceID = oDeviceInfo.getDevId();
        devNodeInfo.m_strDeviceIP = oDeviceInfo.getDevIPAddress();
        devNodeInfo.m_strDeviceName = oDeviceInfo.getDevName();
        devNodeInfo.m_iRoleType = oDeviceInfo.getRoleType();
        TreeNodeInfo oDeviceNodeInfo = new TreeNodeInfo(devNodeInfo);
        oDeviceNode.setUserObject(oDeviceNodeInfo);
    }
}

