/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.components.tree.devicetree;

import com.huawei.dc.common.components.tree.devicetree.BoardTree;
import com.huawei.dc.common.components.tree.devicetree.DeviceTreeUtil;
import com.huawei.dc.common.tree.TreeNodeInfo;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.devicemanagement.model.DeviceModelAdapter;
import com.huawei.dc.devicemanagement.model.deviceinfo.DeviceInformation;
import com.huawei.dc.devicemanagement.model.deviceinfo.FrameInformation;
import com.huawei.dc.devicemanagement.model.deviceinfo.SlotInformation;
import com.huawei.dc.devicemanagement.model.deviceinfo.SubslotInformation;
import com.huawei.dc.taskmgmt.model.Resource;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;

public class BoardTreeUtil {
    public static THashSet<Resource> getResourcesFromNodeInfo(TreeNodeInfo oTreeNode, BoardTree oBoardTree) {
        if (null == oTreeNode || null == oBoardTree) {
            return new THashSet();
        }
        switch (oTreeNode.m_iNodeType) {
            case 8: {
                return BoardTreeUtil.getAllResourcesFromDevice(oTreeNode.m_oDeviceInfo);
            }
            case 5: {
                return BoardTreeUtil.getAllResourcesFromFrame(oTreeNode.m_oFrameNodeInfo);
            }
            case 6: {
                return BoardTreeUtil.getAllResourcesFromSlot(oTreeNode.m_oSlotInfo);
            }
            case 7: {
                THashSet oResourceList = new THashSet();
                oResourceList.add((Object)oTreeNode.m_oSubslotInfo.getResource());
                return oResourceList;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                DeviceInfo[] arrDevices = DeviceTreeUtil.getDeviceListForTreeNode(oTreeNode);
                return BoardTreeUtil.getResourcesFromDeviceList(arrDevices, oBoardTree);
            }
        }
        return new THashSet();
    }

    public static THashSet<Resource> getAllResourcesFromDevice(DeviceInformation oDeviceInfo) {
        THashSet oResourceList = new THashSet();
        if (null == oDeviceInfo) {
            return oResourceList;
        }
        List oFrameList = oDeviceInfo.getFrameList();
        if (null == oFrameList || 0 == oFrameList.size()) {
            oResourceList.add((Object)oDeviceInfo.getResource());
            return oResourceList;
        }
        int iBoardCount = oFrameList.size();
        for (int i = 0; i < iBoardCount; ++i) {
            FrameInformation oFrame = (FrameInformation)oFrameList.get(i);
            oResourceList.addAll(BoardTreeUtil.getAllResourcesFromFrame(oFrame));
        }
        return oResourceList;
    }

    public static THashSet<Resource> getAllResourcesFromFrame(FrameInformation oFrameNodeInfo) {
        THashSet oResourceList = new THashSet();
        if (null == oFrameNodeInfo) {
            return oResourceList;
        }
        List oBoardList = oFrameNodeInfo.getBoardInformationList();
        if (null == oBoardList || 0 == oBoardList.size()) {
            oResourceList.add((Object)oFrameNodeInfo.getResource());
            return oResourceList;
        }
        int iBoardCount = oBoardList.size();
        for (int i = 0; i < iBoardCount; ++i) {
            SlotInformation oSlot = (SlotInformation)oBoardList.get(i);
            oResourceList.addAll(BoardTreeUtil.getAllResourcesFromSlot(oSlot));
        }
        return oResourceList;
    }

    public static THashSet<Resource> getAllResourcesFromSlot(SlotInformation oSlotInfo) {
        THashSet oResourceList = new THashSet();
        if (null == oSlotInfo) {
            return oResourceList;
        }
        List oSubslotList = oSlotInfo.getSubslotList();
        if (null == oSubslotList || 0 == oSubslotList.size()) {
            oResourceList.add((Object)oSlotInfo.getResource());
            return oResourceList;
        }
        int iSubslotCount = oSubslotList.size();
        for (int i = 0; i < iSubslotCount; ++i) {
            SubslotInformation oSubslot = (SubslotInformation)oSubslotList.get(i);
            oResourceList.add((Object)oSubslot.getResource());
        }
        return oResourceList;
    }

    public static THashSet<Resource> getResourcesFromDeviceList(DeviceInfo[] arrDevices, BoardTree oBoardTree) {
        THashSet oResourceList = new THashSet();
        if (null == arrDevices || 0 == arrDevices.length) {
            return oResourceList;
        }
        for (int i = 0; i < arrDevices.length; ++i) {
            Resource oResource = DeviceModelAdapter.populateResourceFromDeviceID(arrDevices[i].getDevId());
            DefaultMutableTreeNode oDeviceNode = DeviceTreeUtil.findNodeForResource(oBoardTree, oResource);
            if (null == oDeviceNode || null == oDeviceNode.getUserObject()) continue;
            TreeNodeInfo oNodeInfo = (TreeNodeInfo)oDeviceNode.getUserObject();
            if (8 != oNodeInfo.m_iNodeType) continue;
            oResourceList.addAll(BoardTreeUtil.getAllResourcesFromDevice(oNodeInfo.m_oDeviceInfo));
        }
        return oResourceList;
    }

    public static List getSelectedResourcesFromDevice(DefaultMutableTreeNode oDeviceInfoNode) {
        ArrayList<Resource> oSelectedResourceList = new ArrayList<Resource>(0);
        if (null == oDeviceInfoNode) {
            return oSelectedResourceList;
        }
        int iFrameCount = oDeviceInfoNode.getChildCount();
        for (int i = 0; i < iFrameCount; ++i) {
            DefaultMutableTreeNode oFrameNode = (DefaultMutableTreeNode)oDeviceInfoNode.getChildAt(i);
            TreeNodeInfo oFrameNodeInfo = (TreeNodeInfo)oFrameNode.getUserObject();
            if (5 != oFrameNodeInfo.m_iNodeType) continue;
            if (0 == oFrameNodeInfo.getSelectedState()) {
                oSelectedResourceList.addAll((Collection<Resource>)BoardTreeUtil.getAllResourcesFromFrame(oFrameNodeInfo.m_oFrameNodeInfo));
                continue;
            }
            if (1 != oFrameNodeInfo.getSelectedState()) continue;
            oSelectedResourceList.addAll(BoardTreeUtil.getSelectedResourcesFromFrame(oFrameNode));
        }
        return oSelectedResourceList;
    }

    public static List getSelectedResourcesFromFrame(DefaultMutableTreeNode oFrameNode) {
        ArrayList<Resource> oSelectedResourceList = new ArrayList<Resource>(0);
        if (null == oFrameNode) {
            return oSelectedResourceList;
        }
        int iSlotCount = oFrameNode.getChildCount();
        for (int i = 0; i < iSlotCount; ++i) {
            DefaultMutableTreeNode oSloteNode = (DefaultMutableTreeNode)oFrameNode.getChildAt(i);
            TreeNodeInfo oSlotNodeInfo = (TreeNodeInfo)oSloteNode.getUserObject();
            if (6 != oSlotNodeInfo.m_iNodeType) continue;
            if (0 == oSlotNodeInfo.getSelectedState()) {
                oSelectedResourceList.addAll((Collection<Resource>)BoardTreeUtil.getAllResourcesFromSlot(oSlotNodeInfo.m_oSlotInfo));
                continue;
            }
            if (1 != oSlotNodeInfo.getSelectedState()) continue;
            oSelectedResourceList.addAll(BoardTreeUtil.getSelectedResourcesFromSlot(oSloteNode));
        }
        return oSelectedResourceList;
    }

    public static List getSelectedResourcesFromSlot(DefaultMutableTreeNode oSlotNode) {
        ArrayList<Resource> oSelectedResourceList = new ArrayList<Resource>(0);
        if (null == oSlotNode) {
            return oSelectedResourceList;
        }
        int iSubslotCount = oSlotNode.getChildCount();
        for (int i = 0; i < iSubslotCount; ++i) {
            DefaultMutableTreeNode oSubsloteNode = (DefaultMutableTreeNode)oSlotNode.getChildAt(i);
            TreeNodeInfo oSubslotNodeInfo = (TreeNodeInfo)oSubsloteNode.getUserObject();
            if (7 != oSubslotNodeInfo.m_iNodeType || 0 != oSubslotNodeInfo.getSelectedState() && 1 != oSubslotNodeInfo.getSelectedState()) continue;
            oSelectedResourceList.add(oSubslotNodeInfo.m_oSubslotInfo.getResource());
        }
        return oSelectedResourceList;
    }

    public static void setTreeNodeSelectionStateForResources(BoardTree oTree, THashSet<Resource> oResourceList, int iSelectionState) {
        if (null == oResourceList || null == oTree) {
            return;
        }
        DefaultMutableTreeNode oTreeNode = null;
        HashSet<Integer> oMissingDeviceIds = new HashSet<Integer>(0);
        ArrayList<Resource> oMissingResources = new ArrayList<Resource>(0);
        Iterator oResItor = oResourceList.iterator();
        Resource oResource = null;
        while (oResItor.hasNext()) {
            oResource = (Resource)oResItor.next();
            oTreeNode = DeviceTreeUtil.findNodeForResource(oTree, oResource);
            if (null != oTreeNode) {
                ((TreeNodeInfo)oTreeNode.getUserObject()).setSelected(iSelectionState);
                DeviceTreeUtil.propogateSelectionToParentNode(oTreeNode, iSelectionState);
                continue;
            }
            oMissingDeviceIds.add(oResource.getDeviceID());
            oMissingResources.add(oResource);
        }
        if (0 < oMissingDeviceIds.size()) {
            oTree.populateBoardsForDevices(new ArrayList(oMissingDeviceIds), false);
            int iMissingResources = oMissingResources.size();
            for (int i = 0; i < iMissingResources; ++i) {
                Resource oTmpResource = (Resource)oMissingResources.get(i);
                oTreeNode = DeviceTreeUtil.findNodeForResource(oTree, oTmpResource);
                if (null == oTreeNode) continue;
                ((TreeNodeInfo)oTreeNode.getUserObject()).setSelected(iSelectionState);
                DeviceTreeUtil.propogateSelectionToParentNode(oTreeNode, iSelectionState);
            }
        }
    }
}

