/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.components.tree.devicetree;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.components.dialog.ProgressDlg;
import com.huawei.dc.common.components.tree.devicetree.BoardTreeUtil;
import com.huawei.dc.common.components.tree.devicetree.DeviceTree;
import com.huawei.dc.common.components.tree.devicetree.DeviceTreeUtil;
import com.huawei.dc.common.components.tree.devicetree.descriptor.DeviceTreeBaseDescriptor;
import com.huawei.dc.common.components.tree.devicetree.listener.BoardTreeListener;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.event.ProgressDetail;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.tree.TreeNodeInfo;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.devicemanagement.controller.DeviceInfoSyncCtrller;
import com.huawei.dc.devicemanagement.controller.IDeviceInfoSyncCtrller;
import com.huawei.dc.devicemanagement.event.DeviceInfoEvent;
import com.huawei.dc.devicemanagement.event.DeviceInfoNotifier;
import com.huawei.dc.devicemanagement.event.IDeviceInfoListener;
import com.huawei.dc.devicemanagement.model.deviceinfo.DeviceInformation;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.taskmgmt.model.Resource;
import java.awt.Component;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public abstract class BoardTree
extends DeviceTree
implements IDeviceInfoListener {
    private ProgressDlg m_oProgressDlg = new ProgressDlg();

    public BoardTree(DeviceTreeBaseDescriptor oTreeDescriptor, IDeviceInfoManager oDeviceInfoManager, String rootName) {
        super(oTreeDescriptor, oDeviceInfoManager, rootName);
        DefaultTreeModel oTreeModel = (DefaultTreeModel)this.getModel();
        oTreeModel.setAsksAllowsChildren(true);
    }

    @Override
    protected void initializeTreeListener() {
        this.m_oTreeListener = new BoardTreeListener(this);
        this.addMouseListener(this.m_oTreeListener);
    }

    @Override
    public List getSelectedResources() {
        ArrayList<Resource> oSelectedResourceList = new ArrayList<Resource>(0);
        if (0 == this.m_oRoot.getChildCount()) {
            return oSelectedResourceList;
        }
        Enumeration<TreeNode> oChildEnum = this.m_oRoot.depthFirstEnumeration();
        while (oChildEnum.hasMoreElements()) {
            DefaultMutableTreeNode oTreeNode = (DefaultMutableTreeNode)oChildEnum.nextElement();
            TreeNodeInfo oNodeInfo = (TreeNodeInfo)oTreeNode.getUserObject();
            if (8 != oNodeInfo.m_iNodeType) continue;
            if (0 == oNodeInfo.getSelectedState()) {
                oSelectedResourceList.addAll((Collection<Resource>)BoardTreeUtil.getAllResourcesFromDevice(oNodeInfo.m_oDeviceInfo));
                continue;
            }
            if (1 != oNodeInfo.getSelectedState()) continue;
            oSelectedResourceList.addAll(BoardTreeUtil.getSelectedResourcesFromDevice(oTreeNode));
        }
        return oSelectedResourceList;
    }

    public synchronized void populateBoardsForDevices(List oDeviceIdList, boolean bDisplayProgress) {
        if (null == oDeviceIdList || 0 == oDeviceIdList.size()) {
            return;
        }
        IDeviceInfoSyncCtrller oSyncController = DeviceInfoSyncCtrller.getInstance();
        try {
            DeviceInfoNotifier.getInstance().addDeviceNotificationListener(this);
            int iReqID = DCFrameWorkUtil.generateRequestId();
            if (bDisplayProgress) {
                this.initializeProgressDialog(oDeviceIdList, iReqID);
            }
            oSyncController.getMultiDevBoards(iReqID, oDeviceIdList);
            if (bDisplayProgress) {
                Thread oProgressDlgThread = new Thread(){

                    @Override
                    public void run() {
                        BoardTree.this.m_oProgressDlg.setVisible(true);
                    }
                };
                oProgressDlgThread.start();
            }
        }
        catch (DCException e) {
            if (null != this.m_oProgressDlg) {
                this.m_oProgressDlg.dispose();
            }
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), e.getErrorCode(), ResourceManager.getInstance().getResString("ERROR"), 0);
            DeviceInfoNotifier.getInstance().removeDeviceNotificationListener(this);
            return;
        }
    }

    private void initializeProgressDialog(List oDeviceIdList, int iReqID) {
        this.m_oProgressDlg.setTitle(ResourceManager.getInstance().getResString("MULTIPLE_BOARDS_PROGRESS"));
        this.m_oProgressDlg.setDefaultCloseOperation(2);
        this.m_oProgressDlg.setProgressDlgId(iReqID);
        this.m_oProgressDlg.setCommandCode(43851);
        this.m_oProgressDlg.setDeviceIds(oDeviceIdList);
    }

    @Override
    public synchronized void onDeviceNotification(DeviceInfoEvent oEvent) {
        if (null == oEvent) {
            return;
        }
        if (3 == oEvent.getEventType()) {
            DeviceInformation oDeviceInfo;
            DefaultMutableTreeNode oDeviceNode;
            ProgressDetail oProgressInfo = (ProgressDetail)oEvent.getSource();
            if (null == oProgressInfo) {
                return;
            }
            if (oProgressInfo.isFinal()) {
                DeviceInfoNotifier.getInstance().removeDeviceNotificationListener(this);
                this.notifyAll();
                return;
            }
            if (null == oProgressInfo || null == oProgressInfo.getProgressObject()) {
                return;
            }
            if (null != this.m_oProgressDlg) {
                this.updateProgessDialog(oProgressInfo);
            }
            if (null != (oDeviceNode = DeviceTreeUtil.findNodeForDevice(this, (oDeviceInfo = (DeviceInformation)oProgressInfo.getProgressObject()).getDeviceId()))) {
                this.m_oTreeModelManager.addDeviceInformation(oDeviceNode, oDeviceInfo);
                this.updateUI();
            }
        }
    }

    private void updateProgessDialog(ProgressDetail oProgressInfo) {
        if (!oProgressInfo.isFinal()) {
            Map oErrorCodeMap = oProgressInfo.getErrorCodeMap();
            DeviceInformation oDeviceInfo = (DeviceInformation)oProgressInfo.getProgressObject();
            int iDevId = oDeviceInfo.getDeviceId();
            BigInteger oErrorCode = (BigInteger)oErrorCodeMap.get(iDevId);
            String strError = null;
            if (null != oErrorCode) {
                strError = ErrorCodeReader.getInstance().getErrorDesc(oErrorCode);
            }
            DeviceInfo deviceInfo = DCFrameWorkUtil.getDeviceInfoManager().getDevice(iDevId);
            String strDisplayName = "";
            if (null != deviceInfo) {
                String devName = deviceInfo.getDevName();
                String devIPAdd = deviceInfo.getDevIPAddress();
                strDisplayName = devName + '(' + devIPAdd + ')';
            } else {
                strDisplayName = ResourceManager.getInstance().getResString("TABLE_DEVICEID") + " : " + iDevId;
                strError = ResourceManager.getInstance().getResString("DEVICE_DELETED");
            }
            if (this.m_oProgressDlg.getProgressDlgId() == oProgressInfo.getRequestId()) {
                this.m_oProgressDlg.setProgress(strDisplayName, strError, oProgressInfo.getProgress(), iDevId);
            }
        }
    }

    @Override
    public void disposeTree() {
        DeviceInfoNotifier.getInstance().removeDeviceNotificationListener(this);
        super.disposeTree();
    }
}

