/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.components.table.renderer;

import com.huawei.dc.common.components.deviceselection.table.DCDefaultTableRenderer;
import com.huawei.dc.common.util.DCCommonUtil;
import com.huawei.dc.devicemanagement.patchmanagement.model.PatchProgressInfo;
import com.huawei.dc.framework.ErrorCodeReader;
import java.awt.Color;
import java.awt.Component;
import java.math.BigInteger;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JTable;

public class ProgressInfoTableCellRenderer
extends DCDefaultTableRenderer {
    @Override
    public Component getTableCellRendererComponent(JTable table, Object oValue, boolean isSelected, boolean hasFocus, int row, int column) {
        if (!(oValue instanceof PatchProgressInfo)) {
            return super.getTableCellRendererComponent(table, oValue, isSelected, hasFocus, row, column);
        }
        return this.getRendererComponentForProgressInfo(table, (PatchProgressInfo)oValue, isSelected);
    }

    private Component getRendererComponentForProgressInfo(JTable oTable, PatchProgressInfo oProgressInfo, boolean isSelected) {
        String strValue;
        if (1 == oProgressInfo.getState()) {
            JProgressBar oProgressBar = this.generateProgressBar(oProgressInfo);
            oProgressBar.setBackground(oTable.getBackground());
            oProgressBar.setForeground(new Color(0, 0, 115));
            return oProgressBar;
        }
        JLabel oLabel = new JLabel();
        oLabel.setOpaque(true);
        String strLinkText = strValue = oProgressInfo.toString();
        if (999293081 == oProgressInfo.getResult()) {
            strValue = ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(oProgressInfo.getResult()));
        }
        if (0 < oProgressInfo.getResult()) {
            strLinkText = DCCommonUtil.getFailureStr("", oProgressInfo.getResult());
        }
        if (null != strValue && !"".equals(strValue.trim())) {
            oLabel.setText(strLinkText);
            oLabel.setToolTipText(strValue);
        }
        this.setColorForComponent(oTable, isSelected, oLabel);
        return oLabel;
    }

    private JProgressBar generateProgressBar(PatchProgressInfo oProgressInfo) {
        JProgressBar progressBar = new JProgressBar(0, 0, 100);
        progressBar.setOpaque(true);
        progressBar.setForeground(new Color(0, 0, 115));
        progressBar.setStringPainted(true);
        progressBar.setValue(oProgressInfo.getProgress());
        String strValue = oProgressInfo.toString();
        if (null != strValue && !"".equals(strValue.trim())) {
            progressBar.setToolTipText(strValue);
        }
        return progressBar;
    }
}

