/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.components.table.renderer;

import com.huawei.dc.common.components.table.DCTable;
import com.huawei.dc.common.components.table.IDCTableModelListener;
import com.huawei.dc.common.components.table.ITableNotifyMouseEvent;
import com.huawei.dc.common.components.table.model.DCTableModel;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellRenderer;

public class DCTableCheckBoxHeader
extends JButton
implements TableCellRenderer,
ITableNotifyMouseEvent,
IDCTableModelListener {
    private static final long serialVersionUID = 6444859778552477823L;
    private final ImageIcon PART_ICON = ResourceManager.getInstance().getImage("part.gif");
    private final ImageIcon ALL_ICON = ResourceManager.getInstance().getImage("all.gif");
    private final ImageIcon NON_SELECTED_ICON = ResourceManager.getInstance().getImage("noneselect.gif");
    private int m_iCurrentColumnIndex = -1;
    private DCTable m_oTable;
    private DCTableModel m_oTableModel;

    public DCTableCheckBoxHeader(DCTable table, int iColumn) {
        Color headerColor = UIManager.getColor("TableHeader.background");
        this.setBackground(new Color(headerColor.getRed(), headerColor.getGreen(), headerColor.getBlue() - 1));
        this.setForeground(UIManager.getColor("TableHeader.foreground"));
        this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        this.setFont(UIManager.getFont("TableHeader.font"));
        this.setHorizontalAlignment(0);
        this.setIcon(this.NON_SELECTED_ICON);
        this.m_oTable = table;
        this.m_oTableModel = (DCTableModel)this.m_oTable.getModel();
        this.m_iCurrentColumnIndex = iColumn;
    }

    public DCTableCheckBoxHeader(DCTable table, int iColumn, boolean isDisableEdit) {
        Color headerColor = UIManager.getColor("TableHeader.background");
        this.setBackground(new Color(headerColor.getRed(), headerColor.getGreen(), headerColor.getBlue() - 1));
        this.setForeground(UIManager.getColor("TableHeader.foreground"));
        this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        this.setFont(UIManager.getFont("TableHeader.font"));
        this.setHorizontalAlignment(0);
        this.setIcon(this.NON_SELECTED_ICON);
        this.setEnabled(!isDisableEdit);
        this.m_oTable = table;
        this.m_oTableModel = (DCTableModel)this.m_oTable.getModel();
        this.m_iCurrentColumnIndex = iColumn;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setText(String.valueOf(value));
        return this;
    }

    protected void updateSelectState(DCTableModel model, int column) {
        int iRowCount = model.getRowCount();
        boolean isHasSelected = false;
        boolean isHasNoSelected = false;
        boolean isHasEnable = false;
        boolean isHasDisable = false;
        for (int i = 0; i < iRowCount; ++i) {
            Object oValue = model.getValueAt(i, column);
            if (null == oValue || !(oValue instanceof Boolean)) continue;
            if (((Boolean)oValue).booleanValue()) {
                isHasSelected = true;
            } else {
                isHasNoSelected = true;
            }
            if (model.isCellEditable(i, column)) {
                isHasEnable = true;
                continue;
            }
            isHasDisable = true;
        }
        if (isHasSelected && isHasNoSelected) {
            this.setIcon(this.PART_ICON);
        } else if (isHasSelected) {
            this.setIcon(this.ALL_ICON);
        } else {
            this.setIcon(this.NON_SELECTED_ICON);
        }
        if (isHasDisable && !isHasEnable) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
        if (null != this.m_oTable) {
            DCFrameWorkUtil.updateUI(this.m_oTable.getTableHeader());
            this.m_oTable.repaint();
        }
    }

    @Override
    public void doClick(MouseEvent me, int column) {
        Object oValue;
        int i;
        if (this.m_iCurrentColumnIndex != column || !this.isEnabled()) {
            return;
        }
        int iRowCount = this.m_oTableModel.getRowCount();
        boolean isSelected = false;
        boolean isHasNotSelected = false;
        for (i = 0; i < iRowCount; ++i) {
            if (!this.m_oTableModel.isCellEditable(i, this.m_iCurrentColumnIndex)) continue;
            oValue = this.m_oTableModel.getValueAt(i, this.m_iCurrentColumnIndex);
            if (oValue instanceof Boolean) {
                isSelected = (Boolean)oValue;
            }
            if (isSelected) continue;
            isHasNotSelected = true;
            break;
        }
        for (i = 0; i < iRowCount; ++i) {
            if (!this.m_oTableModel.isCellEditable(i, this.m_iCurrentColumnIndex) || null == (oValue = this.m_oTableModel.getValueAt(i, this.m_iCurrentColumnIndex))) continue;
            this.m_oTableModel.setValueAt(isHasNotSelected, i, this.m_iCurrentColumnIndex);
        }
        this.updateSelectState(this.m_oTableModel, column);
    }

    @Override
    public void tableDataChanged(TableModelEvent e) {
        int iColumn = e.getColumn();
        if (this.m_iCurrentColumnIndex != iColumn) {
            return;
        }
        if (e.getSource() instanceof DCTableModel) {
            this.updateSelectState((DCTableModel)e.getSource(), iColumn);
        }
    }
}

