/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.components.table.renderer;

import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.UIResource;
import javax.swing.table.TableCellRenderer;

public class DCBooleanRenderer
extends JCheckBox
implements TableCellRenderer,
UIResource {
    private static final long serialVersionUID = 3694221639533994178L;
    private final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

    public DCBooleanRenderer() {
        this.setHorizontalAlignment(0);
        this.setBorderPainted(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (null == value) {
            JLabel label = new JLabel();
            label.setOpaque(true);
            if (isSelected) {
                label.setForeground(table.getSelectionForeground());
                label.setBackground(table.getSelectionBackground());
            } else {
                label.setForeground(table.getForeground());
                label.setBackground(table.getBackground());
            }
            label.setText("--");
            return label;
        }
        if (isSelected) {
            super.setBackground(table.getSelectionBackground());
        } else {
            this.setForeground(table.getForeground());
            this.setBackground(table.getBackground());
        }
        this.setSelected(value != null && (Boolean)value != false);
        if (hasFocus) {
            this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
        } else {
            this.setBorder(this.noFocusBorder);
        }
        this.setEnabled(table.isCellEditable(row, column));
        return this;
    }
}

