/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.components.table.model;

import com.huawei.dc.common.components.table.IDCTableModelListener;
import com.huawei.dc.common.components.table.model.DCList;
import com.huawei.dc.common.components.table.model.IDCTableRowData;
import com.huawei.dc.common.components.table.model.ITableInfo;
import com.huawei.dc.common.util.DCDebugTracer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public class DCTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -7182634722580828930L;
    private String[] m_strTableHeader;
    private String[] m_getterMethodNames;
    private String[] m_setterMethodNames;
    private Class[] m_cTypes;
    private Vector<IDCTableRowData> m_dataVector;
    private Vector<IDCTableModelListener> m_listenerVec;

    public DCTableModel(String[] columnNames, String[] getterMethodNames, String[] setterMethodNames, Class[] cTypes) {
        this.m_strTableHeader = columnNames;
        this.m_getterMethodNames = getterMethodNames;
        this.m_setterMethodNames = setterMethodNames;
        this.m_cTypes = cTypes;
        this.m_dataVector = new Vector();
        this.m_listenerVec = new Vector();
    }

    public DCTableModel(String[] columnNames, String[] getterMethodNames) {
        this.m_strTableHeader = columnNames;
        this.m_getterMethodNames = getterMethodNames;
        this.m_dataVector = new Vector();
        this.m_listenerVec = new Vector();
    }

    public DCTableModel(ITableInfo oTableInfo) {
        this.m_strTableHeader = oTableInfo.getHeader();
        this.m_getterMethodNames = oTableInfo.getGetterMethods();
        this.m_setterMethodNames = oTableInfo.getSetterMethods();
        this.m_cTypes = oTableInfo.getColumnTypes();
        this.m_dataVector = new Vector();
        this.m_listenerVec = new Vector();
    }

    @Override
    public String getColumnName(int column) {
        return this.m_strTableHeader[column];
    }

    @Override
    public int getColumnCount() {
        return this.m_strTableHeader.length;
    }

    @Override
    public int getRowCount() {
        return this.m_dataVector.size();
    }

    public Class getColumnClass(int column) {
        if (null == this.m_cTypes) {
            return super.getColumnClass(column);
        }
        return this.m_cTypes[column];
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        try {
            IDCTableRowData rowObject = this.m_dataVector.get(rowIndex);
            if (rowObject != null) {
                if (this.m_cTypes[columnIndex] == DCList.class) {
                    Method method = rowObject.getClass().getMethod(this.m_getterMethodNames[columnIndex], null);
                    if (method != null) {
                        DCList oData = (DCList)method.invoke((Object)rowObject, null);
                        oData.setCurrSelectedObj(aValue);
                    }
                } else {
                    Method method = rowObject.getClass().getMethod(this.m_setterMethodNames[columnIndex], this.m_cTypes[columnIndex]);
                    if (method != null) {
                        method.invoke((Object)rowObject, aValue);
                    }
                }
            }
        }
        catch (SecurityException e) {
            DCDebugTracer.trace(e);
        }
        catch (NoSuchMethodException e) {
            DCDebugTracer.trace(e);
        }
        catch (IllegalArgumentException e) {
            DCDebugTracer.trace(e);
        }
        catch (IllegalAccessException e) {
            DCDebugTracer.trace(e);
        }
        catch (InvocationTargetException e) {
            DCDebugTracer.trace(e);
        }
        this.fireDCTableDataChanged(rowIndex, columnIndex);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        IDCTableRowData rowObject = this.m_dataVector.get(rowIndex);
        if (rowObject != null) {
            try {
                Method method = rowObject.getClass().getMethod(this.m_getterMethodNames[columnIndex], null);
                if (method != null) {
                    return method.invoke((Object)rowObject, null);
                }
            }
            catch (SecurityException e) {
                DCDebugTracer.trace(e);
            }
            catch (NoSuchMethodException e) {
                DCDebugTracer.trace(e);
            }
            catch (IllegalArgumentException e) {
                DCDebugTracer.trace(e);
            }
            catch (IllegalAccessException e) {
                DCDebugTracer.trace(e);
            }
            catch (InvocationTargetException e) {
                DCDebugTracer.trace(e);
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return null != this.m_setterMethodNames && this.m_setterMethodNames.length > columnIndex && null != this.m_setterMethodNames[columnIndex];
    }

    public void setDataVector(Vector<IDCTableRowData> dataVector) {
        this.m_dataVector = dataVector != null ? dataVector : new Vector();
        this.fireTableStructureChanged();
    }

    public Vector<IDCTableRowData> getDataVector() {
        return this.m_dataVector;
    }

    public void addRow(IDCTableRowData rowData) {
        this.m_dataVector.add(rowData);
        int insertRow = this.m_dataVector.size();
        this.fireTableRowsInserted(insertRow, insertRow);
    }

    public void removeRow(IDCTableRowData rowData) {
        int index = 0;
        for (IDCTableRowData oRowData : this.m_dataVector) {
            if (oRowData.isSame(rowData)) {
                this.m_dataVector.remove(oRowData);
                this.fireTableRowsDeleted(index, index);
                break;
            }
            ++index;
        }
    }

    public void removeAllRow() {
        int iRowCount = this.getRowCount();
        if (0 < iRowCount) {
            this.m_dataVector.removeAllElements();
            this.fireTableRowsDeleted(0, iRowCount - 1);
        }
    }

    public IDCTableRowData getRowData(int rowIndex) {
        return this.m_dataVector.get(rowIndex);
    }

    public String[] getGetterMethodNames() {
        return this.m_getterMethodNames;
    }

    public String[] getSetterMethodNames() {
        return this.m_setterMethodNames;
    }

    public void addDCTableModelListener(IDCTableModelListener oListener) {
        this.m_listenerVec.add(oListener);
    }

    public void fireDCTableDataChanged(int rowIndex, int columnIndex) {
        TableModelEvent oEvent = new TableModelEvent(this, rowIndex, rowIndex, columnIndex);
        for (IDCTableModelListener listener : this.m_listenerVec) {
            listener.tableDataChanged(oEvent);
        }
    }

    public void fireDCTableDataChanged() {
        for (int i = 0; i < this.m_strTableHeader.length; ++i) {
            TableModelEvent oEvent = new TableModelEvent(this, 0, this.m_dataVector.size(), i);
            for (IDCTableModelListener listener : this.m_listenerVec) {
                listener.tableDataChanged(oEvent);
            }
        }
    }
}

