/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.components.table.editor;

import com.huawei.dc.common.components.dialog.IBrowseDlgInterafce;
import com.huawei.dc.common.framework.utility.ConfigurationInfo;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCFileChooser;
import com.huawei.dc.taskmgmt.report.tasklevel.bean.TaskReportFileInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;

public class FileBrowseButtonCellEditor
extends DefaultCellEditor
implements IBrowseDlgInterafce {
    private static final long serialVersionUID = 1L;
    private JTable m_devTable;
    private JButton m_oBrowseButton;
    private JPanel m_oButtonPanel;
    private JLabel m_oLabel;
    JPanel m_oPanelComp = null;

    public FileBrowseButtonCellEditor(int iColIndex, JCheckBox checkBox, JTable oTable) {
        super(checkBox);
        this.m_devTable = oTable;
    }

    private void browseDirectory() {
        String strPath = ConfigurationInfo.getInstance().getAbsoluteBaseDirectory() + File.separator + "report/";
        File defaultDir = new File(strPath);
        if (!defaultDir.exists()) {
            try {
                defaultDir.mkdir();
            }
            catch (Exception ex) {
                DCDebugTracer.trace(ex);
                return;
            }
        }
        DCFileChooser oSaveasFileChooser = new DCFileChooser(strPath, false);
        oSaveasFileChooser.setTitle(DCFrameWorkUtil.getLocalizedString("SELECT_DIR"));
        oSaveasFileChooser.setFileSelectionMode(1);
        oSaveasFileChooser.setControlButtonsAreShown(true);
        oSaveasFileChooser.setCurrentDirectory(defaultDir);
        oSaveasFileChooser.displayPathName();
        int returnValue = oSaveasFileChooser.showDialog(DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("OK"));
        if (0 != returnValue) {
            return;
        }
        this.setFileOrDirectory(oSaveasFileChooser.getSelectFilePath(), "", false);
    }

    @Override
    public Object getCellEditorValue() {
        int iSelectRow = this.m_devTable.getSelectedRow();
        return (String)this.m_devTable.getValueAt(iSelectRow, 4);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.m_oPanelComp = new JPanel();
        this.m_oPanelComp.setName("TaskReportPanel_m_oPanelComp");
        this.m_oPanelComp.setLayout(new BorderLayout());
        this.initBrowseButton();
        this.initButtonPanel();
        this.m_oLabel = new JLabel();
        this.m_oBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileBrowseButtonCellEditor.this.browseDirectory();
                FileBrowseButtonCellEditor.this.fireEditingStopped();
            }
        });
        String strFileName = null;
        strFileName = null == value || "".equals(value.toString()) ? TaskReportFileInfo.getDefaultFilePath() : (String)value;
        this.m_oLabel.setText(strFileName);
        this.m_oLabel.setToolTipText(strFileName);
        this.m_oButtonPanel.add((Component)this.m_oBrowseButton, "West");
        this.m_oPanelComp.add((Component)this.m_oButtonPanel, "East");
        this.m_oPanelComp.add((Component)this.m_oLabel, "West");
        this.m_oPanelComp.setToolTipText(this.m_oLabel.getText());
        return this.m_oPanelComp;
    }

    private void initBrowseButton() {
        this.m_oBrowseButton = new JButton();
        this.m_oBrowseButton.setName("TaskReportPanel_m_oBrowseButton");
        this.m_oBrowseButton.setOpaque(true);
        this.m_oBrowseButton.setText("...");
        this.m_oBrowseButton.setPreferredSize(new Dimension(20, 17));
        this.m_oBrowseButton.setMaximumSize(new Dimension(20, 17));
        this.m_oBrowseButton.setMinimumSize(new Dimension(20, 17));
        this.m_oBrowseButton.setToolTipText(ResourceManager.getInstance().getResString("BROWSE_TOOLTIP"));
    }

    private void initButtonPanel() {
        this.m_oButtonPanel = new JPanel();
        this.m_oButtonPanel.setLayout(new BorderLayout());
        this.m_oButtonPanel.setPreferredSize(new Dimension(21, 17));
        this.m_oButtonPanel.setMaximumSize(new Dimension(21, 17));
        this.m_oButtonPanel.setMinimumSize(new Dimension(21, 17));
    }

    @Override
    public void setFileOrDirectory(String strFilePath, String strVersion, boolean file) {
        int iSelectedColumn = 4;
        this.m_devTable.getModel().setValueAt(strFilePath, this.m_devTable.getSelectedRow(), iSelectedColumn);
        this.stopCellEditing();
    }
}

