/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.components.table.editor;

import com.huawei.dc.common.components.table.model.DCList;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.plaf.basic.BasicComboBoxRenderer;

public class DCTableComboBoxCellEditor
extends DefaultCellEditor {
    private static final long serialVersionUID = -2970576930866676679L;
    protected JComboBox m_comboBox;

    public DCTableComboBoxCellEditor(JComboBox comboBox) {
        super(comboBox);
        comboBox.setRenderer(new CustomComboBoxRenderer());
        this.m_comboBox = comboBox;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.initComboBox(value);
        return super.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    private void initComboBox(Object value) {
        this.m_comboBox.removeAllItems();
        if (value instanceof DCList) {
            DCList oData = (DCList)value;
            ArrayList oItemLst = oData.getAllDataLst();
            for (int i = 0; i < oItemLst.size(); ++i) {
                this.m_comboBox.addItem(oItemLst.get(i));
            }
            this.m_comboBox.setSelectedItem(oData.getCurrSelectedObj());
            this.m_comboBox.setToolTipText(this.getToolTipText(value));
        }
    }

    protected String getToolTipText(Object value) {
        if (null != value) {
            return value.toString();
        }
        return "";
    }

    class CustomComboBoxRenderer
    extends BasicComboBoxRenderer {
        private static final long serialVersionUID = -7285463945208780042L;

        CustomComboBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
                if (index > -1) {
                    list.setToolTipText(DCTableComboBoxCellEditor.this.getToolTipText(value));
                } else {
                    list.setToolTipText(null);
                }
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (null != value) {
                if ("".equals(value.toString().intern())) {
                    list.setToolTipText(null);
                } else {
                    list.setToolTipText(DCTableComboBoxCellEditor.this.getToolTipText(value));
                }
            }
            this.setFont(list.getFont());
            this.setText(value == null ? "" : value.toString());
            return this;
        }
    }
}

