/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.components.table;

import com.huawei.dc.common.components.table.ITableNotifyMouseEvent;
import com.huawei.dc.common.components.table.editor.DCTableComboBoxCellEditor;
import com.huawei.dc.common.components.table.model.DCList;
import com.huawei.dc.common.components.table.model.DCTableModel;
import com.huawei.dc.common.components.table.renderer.DCBooleanRenderer;
import com.huawei.dc.common.components.table.renderer.DCTableCheckBoxHeader;
import com.huawei.dc.common.components.table.renderer.DCTableComboBoxCellRenderer;
import com.huawei.dc.devicemanagement.deviceoperation.util.TableProgressCellRenderer;
import com.huawei.dc.deviceoperation.util.OperationStatus;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class DCTable
extends JTable {
    private static final long serialVersionUID = -9102187318268832751L;

    public DCTable(DCTableModel oTableModel) {
        super(oTableModel);
        this.initTableCellRenderer(oTableModel);
        this.initTableHeaderRenderer(oTableModel);
        this.getTableHeader().setReorderingAllowed(false);
        oTableModel.fireDCTableDataChanged();
    }

    private void initTableCellRenderer(DCTableModel oTableModel) {
        this.setDefaultRenderer(DCList.class, new DCTableComboBoxCellRenderer());
        this.setDefaultEditor(DCList.class, new DCTableComboBoxCellEditor(new JComboBox()));
        this.setDefaultRenderer(Boolean.class, new DCBooleanRenderer());
        this.setDefaultRenderer(OperationStatus.class, new TableProgressCellRenderer());
    }

    private void initTableHeaderRenderer(DCTableModel oTableModel) {
        for (int i = 0; i < oTableModel.getColumnCount(); ++i) {
            if (!this.getColumnClass(i).equals(Boolean.class)) continue;
            DCTableCheckBoxHeader headerRenderer = new DCTableCheckBoxHeader(this, i);
            oTableModel.addDCTableModelListener(headerRenderer);
            this.getColumn(this.getColumnName(i)).setHeaderRenderer(headerRenderer);
        }
        this.registHeaderEvent();
    }

    private void registHeaderEvent() {
        this.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ITableNotifyMouseEvent oNotifyObj;
                int iColumn = DCTable.this.getColumnModel().getColumnIndexAtX(e.getX());
                String strColumnName = DCTable.this.getColumnName(iColumn);
                TableCellRenderer headerRender = DCTable.this.getColumn(strColumnName).getHeaderRenderer();
                if (headerRender instanceof ITableNotifyMouseEvent && null != (oNotifyObj = (ITableNotifyMouseEvent)((Object)headerRender))) {
                    oNotifyObj.doClick(e, iColumn);
                }
            }
        });
    }
}

