/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.components.dialog.tableLinkDialog;

import com.huawei.dc.adapter.swimap.imap12.util.DCInmLengthLimitPasswordField;
import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.components.treetable.model.TreeTableNode;
import com.huawei.dc.common.components.treetable.view.DCSortableTreeTable;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.security.DCEncryptServiceUtil;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.standalone.model.AbstractDevInfoObj;
import com.huawei.dc.standalone.model.AccessDevInfoObj;
import com.huawei.dc.standalone.model.OptixDevInfoObj;
import com.huawei.dc.standalone.model.RouterDevInfoObj;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTree;

public class InputPwdDlg
extends DCModalDialog {
    private static final long serialVersionUID = 1L;
    DCInmLengthLimitPasswordField pwdTxt1 = null;
    DCInmLengthLimitPasswordField pwdTxt2 = null;
    private int PWD_CHECK_SUCCESS = 0;
    private int PWD_NOT_EQUAL = 1;
    private int PWD_LENGTH_NOT_ENOUGH = 2;
    private int minLen = 20;
    private int maxLen = 0;
    private char[] returnValue = "".toCharArray();
    private boolean bIsOK = true;
    private JTable jTable;

    public InputPwdDlg(JTable table) {
        this.jTable = table;
        this.initDlg();
    }

    private void initDlg() {
        this.setSize(270, 140);
        this.setLocationRelativeTo(DCFrameWorkUtil.getMainFrame());
        this.setTitle(ResourceManager.getInstance().getResString("CONFIGURATION"));
        JPanel mainPanel = new JPanel();
        mainPanel.setSize(245, 95);
        mainPanel.setLayout(null);
        this.m_oOKBtn = new JButton(ResourceManager.getInstance().getResString("SYSTEM_INFO_OK_BTN"));
        this.m_oCancelBtn = new JButton(ResourceManager.getInstance().getResString("SYSTEM_INFO_CANCEL_BTN"));
        this.pwdTxt1 = new DCInmLengthLimitPasswordField(50);
        this.pwdTxt2 = new DCInmLengthLimitPasswordField(50);
        JLabel pwdLable = new JLabel(ResourceManager.getInstance().getResString("PASSWORD"));
        JLabel confirmPwdLable = new JLabel(ResourceManager.getInstance().getResString("CONFIRM_PASSWORD"));
        pwdLable.setBounds(new Rectangle(10, 10, 110, 21));
        confirmPwdLable.setBounds(new Rectangle(10, 40, 110, 21));
        this.pwdTxt1.setBounds(new Rectangle(130, 10, 110, 21));
        this.pwdTxt2.setBounds(new Rectangle(130, 40, 110, 21));
        this.m_oOKBtn.setBounds(new Rectangle(30, 75, 80, 21));
        this.m_oCancelBtn.setBounds(new Rectangle(150, 75, 80, 21));
        mainPanel.add(pwdLable);
        mainPanel.add(confirmPwdLable);
        mainPanel.add((Component)this.pwdTxt1);
        mainPanel.add((Component)this.pwdTxt2);
        mainPanel.add(this.m_oOKBtn);
        mainPanel.add(this.m_oCancelBtn);
        this.add(mainPanel);
        this.initializeButtonActions();
        this.setIsOK(false);
        this.setVisible(true);
    }

    private void initializeButtonActions() {
        this.m_oCancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InputPwdDlg.this.cancelButton_ActionPerformed();
            }
        });
        this.m_oOKBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InputPwdDlg.this.oKButton_ActionPerformed();
            }
        });
    }

    private int checkPwd(char[] pwdStr1, char[] pwdStr2) {
        String pwd2;
        int result = this.PWD_CHECK_SUCCESS;
        String pwd1 = String.valueOf(pwdStr1);
        if (!pwd1.equals(pwd2 = String.valueOf(pwdStr2))) {
            DCOptionPane.showErrorDialog((Component)((Object)this), ResourceManager.getInstance().getResString("CONFIRM_PASSWORD_FAILED_ERROR"));
            return this.PWD_NOT_EQUAL;
        }
        if (this.maxLen != 0 && (pwd1.length() < this.maxLen || pwd2.length() < this.maxLen)) {
            DCOptionPane.showErrorDialog((Component)((Object)this), ResourceManager.getInstance().getResString("CONFIRM_PASSWORD_FAILED_ERROR"));
            return this.PWD_LENGTH_NOT_ENOUGH;
        }
        if (this.minLen != 0 && (pwd1.length() > this.minLen || pwd2.length() > this.minLen)) {
            DCOptionPane.showErrorDialog((Component)((Object)this), ResourceManager.getInstance().getResString("CONFIRM_PASSWORD_FAILED_ERROR"));
            return this.PWD_LENGTH_NOT_ENOUGH;
        }
        pwd1 = null;
        pwd2 = null;
        return result;
    }

    @Override
    protected String getCurrentContext() {
        return null;
    }

    @Override
    protected void oKButton_ActionPerformed() {
        int result = this.checkPwd(this.pwdTxt1.getPassword(), this.pwdTxt2.getPassword());
        if (result == this.PWD_CHECK_SUCCESS) {
            DCSortableTreeTable oDCSortableTreeTable = (DCSortableTreeTable)((Object)this.jTable);
            JTree tree = oDCSortableTreeTable.getTree();
            TreeTableNode tmpNode = (TreeTableNode)tree.getPathForRow(oDCSortableTreeTable.getSelectedRow()).getLastPathComponent();
            AbstractDevInfoObj devInfoObj = null;
            if (tmpNode.getUserObject() instanceof RouterDevInfoObj) {
                devInfoObj = (RouterDevInfoObj)tmpNode.getUserObject();
            } else if (tmpNode.getUserObject() instanceof AccessDevInfoObj) {
                devInfoObj = (AccessDevInfoObj)tmpNode.getUserObject();
            } else if (tmpNode.getUserObject() instanceof OptixDevInfoObj) {
                devInfoObj = (OptixDevInfoObj)tmpNode.getUserObject();
            }
            devInfoObj.setKeyMode(0);
            this.setCellEditorValue(DCEncryptServiceUtil.encrypt(this.pwdTxt1.getPassword()));
            this.setIsOK(true);
            this.closeDialog();
        }
    }

    @Override
    protected void cancelButton_ActionPerformed() {
        this.closeDialog();
    }

    private void setCellEditorValue(char[] value) {
        this.returnValue = value;
    }

    public char[] getCellEditorValue() {
        return this.returnValue;
    }

    public boolean getIsOK() {
        return this.bIsOK;
    }

    private void setIsOK(boolean isOK) {
        this.bIsOK = isOK;
    }

    @Override
    protected void closeDialog() {
        super.closeDialog();
    }
}

