/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.components.dialog.fileselection.model;

import com.huawei.dc.common.framework.utility.ResourceManager;
import java.io.File;
import javax.swing.filechooser.FileFilter;

public class DCFileFilter
extends FileFilter {
    public static final String ALL_FILE_POSTFIX = "*.*";
    private static final String ALL_REG_EXP = ".+";
    private String m_strDescription = "";
    private String m_strPostfix = "*.*";
    private String m_strRegexp = "*.*";
    private ResourceManager m_oResMgr = ResourceManager.getInstance();

    public DCFileFilter() {
        this.m_strPostfix = ALL_FILE_POSTFIX;
        this.m_strRegexp = ALL_REG_EXP;
        this.m_strDescription = this.m_oResMgr.getResString("ALL_FILE_FILTER_DESCRIPTION");
    }

    public String getM_strPostfix() {
        return this.m_strPostfix;
    }

    public DCFileFilter(String strPostfix) {
        this.m_strPostfix = strPostfix;
        this.m_strRegexp = this.constructRegexp(strPostfix);
        this.m_strDescription = this.m_oResMgr.getResString(strPostfix);
    }

    public DCFileFilter(String strPostfix, String strDescription) {
        this.m_strPostfix = strPostfix;
        this.m_strRegexp = this.constructRegexp(strPostfix);
        this.m_strDescription = strDescription;
    }

    private String constructRegexp(String strPostfix) {
        String strTmpPostfix = this.m_strPostfix.trim();
        if (ALL_FILE_POSTFIX.equals(strTmpPostfix)) {
            return ALL_REG_EXP;
        }
        strTmpPostfix = strTmpPostfix.replaceAll(" ", "");
        strTmpPostfix = strTmpPostfix.replaceAll(";", "|");
        strTmpPostfix = strTmpPostfix.replaceAll("\\*", ".+\\\\");
        return strTmpPostfix.toLowerCase();
    }

    public boolean accept(String strFileName) {
        if (null != strFileName) {
            return strFileName.toLowerCase().matches(this.m_strRegexp);
        }
        return false;
    }

    @Override
    public boolean accept(File f) {
        if (null != f) {
            if (f.isDirectory()) {
                return true;
            }
            return this.accept(f.getName());
        }
        return false;
    }

    @Override
    public String getDescription() {
        return this.m_strDescription;
    }

    public String toString() {
        if (!"".equals(this.m_strDescription)) {
            return this.m_strDescription + "(" + this.m_strPostfix + ")";
        }
        return this.m_strPostfix;
    }
}

