/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.components.dialog.fileselection;

import com.huawei.dc.common.asndatacenter.ASNDCFileInfoStruct;
import com.huawei.dc.common.asndatacenter.ASNDCFileInfoStructLst;
import com.huawei.dc.common.asndatacenter.AsnDCGetDirReq;
import com.huawei.dc.common.asndatacenter.AsnDCGetDirRsp;
import com.huawei.dc.common.asndatacenter.AsnDCTargetFileServerTypeEnum;
import com.huawei.dc.common.asndatacenter.DCStringList;
import com.huawei.dc.common.components.dialog.fileselection.ExternalFTPFileView;
import com.huawei.dc.common.components.dialog.fileselection.IFileView;
import com.huawei.dc.common.components.dialog.fileselection.model.DCFileInfo;
import com.huawei.dc.common.controller.BaseCommManager;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.framework.system.SystemManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ParamUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCTimeDateUtil;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.deviceoperation.IDeviceOperation;
import com.huawei.dc.devicemanagement.deviceoperation.IParaList;
import com.huawei.dc.devicemanagement.model.ContentType;
import com.huawei.dc.devicemanagement.model.xmlconfig.DeviceXMLConfigModel;
import com.huawei.dc.devicemanagement.model.xmlconfig.IDeviceTypeConfigModel;
import com.huawei.dc.devicemanagement.model.xmlconfig.IOperationConfig;
import com.huawei.dc.deviceoperation.util.DirListNode;
import com.huawei.dc.taskmgmt.controller.TaskSrcDstVersionCheck;
import java.util.Collections;
import java.util.List;
import net.commustru.fstru.FStruct;

public class ServerFileView
implements IFileView {
    private boolean m_isCAM = false;
    protected String m_strCurrentPath = "";
    private int m_iType = 3;
    private boolean m_isWindows = true;
    private String strRootPath = null;
    private boolean m_isBrowseFromThirdFTP = false;
    private static boolean isOpSysWindows = true;
    private static int noRecoverFilePath = 0;
    private static String systemPath = "";

    public ServerFileView() {
    }

    public ServerFileView(int iType, String strCurrentPath) {
        this(iType, false, false, null);
        this.strRootPath = this.m_strCurrentPath = strCurrentPath;
    }

    public ServerFileView(int iType, boolean isBrowseFromThirdFTP, String strInitPath) {
        this(iType, false, isBrowseFromThirdFTP, strInitPath);
    }

    public ServerFileView(int iType, boolean isCAM, boolean isBrowseFromThirdFTP, String strInitPath) {
        String SOLARIS_ROOT_DIR;
        this.m_iType = iType;
        this.m_isCAM = isCAM;
        this.m_isBrowseFromThirdFTP = isBrowseFromThirdFTP;
        SystemManager oSysMgr = new SystemManager();
        this.m_strCurrentPath = this.m_isBrowseFromThirdFTP ? oSysMgr.getBrowseFileDir(1, TaskSrcDstVersionCheck.getInstance().getThirdFTPServerName()) : oSysMgr.getBrowseFileDir(0, "");
        systemPath = this.m_strCurrentPath = this.m_strCurrentPath.replaceAll("\\\\", "/");
        this.strRootPath = this.m_strCurrentPath;
        if (DCFrameWorkUtil.getIsSingleClient() && null != strInitPath && strInitPath.length() > 0 && this.isSameStartPath(strInitPath, this.m_strCurrentPath)) {
            this.m_strCurrentPath = strInitPath;
        }
        if (this.strRootPath.startsWith(SOLARIS_ROOT_DIR = "/")) {
            this.m_isWindows = false;
            isOpSysWindows = false;
        }
    }

    public static String getSystemPath() {
        return systemPath;
    }

    public static boolean isOpSysWindows() {
        return isOpSysWindows;
    }

    protected String getContentTypeFrmModel(int iContentTypeId, int iDeviceType, int iDevTypeVerId) {
        Object[] oContenType;
        IParaList oPerationParaList = null;
        DeviceTypeInfo oDevTypeInfo = DeviceInfoManagerImpl.getInstance().getDeviceTypeInfo(iDeviceType, iDevTypeVerId);
        String strContentType = null;
        if (null == oDevTypeInfo) {
            return strContentType;
        }
        IDeviceTypeConfigModel oDevConfigModel = DeviceXMLConfigModel.getInstance().getDeviceTypeConfigModel(oDevTypeInfo, null);
        if (null == oDevConfigModel) {
            return strContentType;
        }
        IOperationConfig operationConfiguration = oDevConfigModel.getOperationConfiguration();
        IDeviceOperation deviceOperation = operationConfiguration.getDeviceOperation(2);
        if (null != deviceOperation) {
            oPerationParaList = deviceOperation.getoPerationParaList();
        }
        if (null != oPerationParaList && null != (oContenType = ParamUtil.getInstance().getContentTypeList(oPerationParaList))) {
            ContentType oContentType = ParamUtil.getInstance().getContentType(oContenType, iContentTypeId);
            if (null == oContentType) {
                return strContentType;
            }
            strContentType = oContentType.getStrContentType();
        }
        return strContentType;
    }

    protected AsnDCGetDirReq constructReq(String strPath) {
        AsnDCGetDirReq dirGetReq = new AsnDCGetDirReq();
        dirGetReq.strRootPath = strPath.getBytes();
        dirGetReq.oDeviceOperationType.value = this.m_isCAM ? 42 : 10;
        if (this.m_isBrowseFromThirdFTP) {
            if (StringUtils.isIPV4(strPath) || strPath.equals("")) {
                dirGetReq.strRootPath = "/".getBytes();
            }
            dirGetReq.oTargetFileServerType = new AsnDCTargetFileServerTypeEnum(1);
            dirGetReq.strTargetFileServerName = TaskSrcDstVersionCheck.getInstance().getThirdFTPServerName().getBytes();
        }
        return dirGetReq;
    }

    @Override
    public int getFileInfoInPath(String strPath, List<DCFileInfo> oFileInfoLst) {
        AsnDCGetDirRsp dirRsp;
        AsnDCGetDirReq dirGetReq;
        BaseCommManager commManager = DCFrameWorkUtil.getCommManager();
        int iErrorCode = commManager.sendSyncMsgWithSyncCommand(43842, (FStruct)(dirGetReq = this.constructReq(strPath)), (FStruct)(dirRsp = new AsnDCGetDirRsp()));
        if (0 == iErrorCode) {
            int i;
            noRecoverFilePath = 0;
            if (null != dirRsp && null != dirRsp.oErrorInfo && 0 != dirRsp.oErrorInfo.iErrorNo.intValue()) {
                if (dirRsp.oErrorInfo.iErrorNo.intValue() == 989859222 && null != strPath && strPath.equals(ExternalFTPFileView.browseFTPFilePath())) {
                    noRecoverFilePath = dirRsp.oErrorInfo.iErrorNo.intValue();
                    this.strRootPath = "/";
                    DCDebugTracer.trace("The device have not recoverdata on the thirdparty under the path" + ExternalFTPFileView.browseFTPFilePath());
                } else {
                    return dirRsp.oErrorInfo.iErrorNo.intValue();
                }
            }
            noRecoverFilePath = 0;
            if (null != dirRsp && null != dirRsp.oErrorInfo && dirRsp.oErrorInfo.iErrorNo.intValue() == 989859222 && null != strPath && strPath.equals(ExternalFTPFileView.browseFTPFilePath())) {
                noRecoverFilePath = dirRsp.oErrorInfo.iErrorNo.intValue();
                this.strRootPath = "/";
            }
            this.m_strCurrentPath = this.m_isBrowseFromThirdFTP && StringUtils.isIPV4(strPath) ? "/" : strPath;
            if (1 != this.m_iType) {
                DCStringList oAsnDirLst = dirRsp.oDirectories;
                int iDirCount = oAsnDirLst.size();
                for (i = 0; i < iDirCount; ++i) {
                    DirListNode oNameNode = new DirListNode(new String((byte[])oAsnDirLst.get(i)), true);
                    DCFileInfo oDirInfo = new DCFileInfo();
                    oDirInfo.setNameNode(oNameNode);
                    oFileInfoLst.add(oDirInfo);
                }
            }
            if (2 != this.m_iType && null != dirRsp && null != dirRsp.oFiles) {
                ASNDCFileInfoStructLst oAsnFileLst = dirRsp.oFiles;
                int iFileCount = oAsnFileLst.size();
                for (i = 0; i < iFileCount; ++i) {
                    ASNDCFileInfoStruct oAsnFileInfo = (ASNDCFileInfoStruct)oAsnFileLst.get(i);
                    DCFileInfo oFileInfo = new DCFileInfo();
                    DirListNode oNameNode = new DirListNode(new String(oAsnFileInfo.strFilename), false);
                    oFileInfo.setNameNode(oNameNode);
                    if (null != oAsnFileInfo.strVersion) {
                        oFileInfo.setVersion(new String(oAsnFileInfo.strVersion));
                    }
                    int iContentTypeId = -1;
                    int iDeviceType = -1;
                    int iDevTypeVerId = -1;
                    if (null != oAsnFileInfo.iContent) {
                        iContentTypeId = oAsnFileInfo.iContent.intValue();
                    }
                    if (null != oAsnFileInfo.iDevType) {
                        iDeviceType = oAsnFileInfo.iDevType.intValue();
                    }
                    if (null != oAsnFileInfo.iDevTypeVersion) {
                        iDevTypeVerId = oAsnFileInfo.iDevTypeVersion.intValue();
                    }
                    if (-1 != iContentTypeId && -1 != iDeviceType && -1 != iDevTypeVerId) {
                        String strContentType = null;
                        strContentType = this.getContentTypeFrmModel(iContentTypeId, iDeviceType, iDevTypeVerId);
                        if (null == strContentType) {
                            strContentType = Integer.toString(iContentTypeId);
                        }
                        oFileInfo.setContentType(strContentType);
                    }
                    if (null != oAsnFileInfo.iFileSize) {
                        oFileInfo.setSize(String.valueOf(oAsnFileInfo.iFileSize));
                    }
                    if (null != oAsnFileInfo.strTime) {
                        oFileInfo.setModifiedTime(DCTimeDateUtil.getLocaleDisplayTime(oAsnFileInfo.strTime));
                    }
                    oFileInfoLst.add(oFileInfo);
                }
            }
            Collections.sort(oFileInfoLst);
        }
        return iErrorCode;
    }

    @Override
    public int getType() {
        return this.m_iType;
    }

    public void setBrowseFromThirdFTP() {
        this.m_isBrowseFromThirdFTP = true;
    }

    @Override
    public String getCurrentPath() {
        return this.m_strCurrentPath;
    }

    public boolean isRecoverFromThirdParty() {
        return !this.strRootPath.equals(ServerFileView.getSystemPath());
    }

    @Override
    public boolean isWindows() {
        return this.m_isWindows;
    }

    public static int isExistenRecoverpath() {
        return noRecoverFilePath;
    }

    @Override
    public String getRootPath() {
        return this.strRootPath;
    }

    public boolean isSameStartPath(String srcPath, String dstPath) {
        String subPath;
        return dstPath.length() <= srcPath.length() && srcPath.contains(dstPath) && ((subPath = srcPath.substring(dstPath.length(), srcPath.length())).startsWith("/") || subPath.length() < 1);
    }
}

