/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.components.dialog.fileselection;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.components.dialog.SimpleProgressDlg;
import com.huawei.dc.common.components.dialog.fileselection.AbstractSelectFilePanel;
import com.huawei.dc.common.components.dialog.fileselection.ExternalFTPFileView;
import com.huawei.dc.common.components.dialog.fileselection.IFileView;
import com.huawei.dc.common.components.dialog.fileselection.ISelectFileListener;
import com.huawei.dc.common.components.dialog.fileselection.ServerFileView;
import com.huawei.dc.common.components.dialog.fileselection.model.DCFileFilter;
import com.huawei.dc.common.components.dialog.fileselection.model.DCFileInfo;
import com.huawei.dc.common.components.dialog.fileselection.model.DCFileTableInfo;
import com.huawei.dc.common.components.table.DCTable;
import com.huawei.dc.common.components.table.model.DCTableModel;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.ComboBoxWithToolTip;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.deviceoperation.util.DirFileCellRendrer;
import com.huawei.dc.deviceoperation.util.DirListNode;
import com.huawei.dc.taskmgmt.view.ValidationResult;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;

public class SelectServerFilePanel
extends AbstractSelectFilePanel {
    private static final long serialVersionUID = 5885727757923757660L;
    protected transient DCTable m_oTable;
    protected transient DCTableModel m_oTableModel;
    private ComboBoxWithToolTip m_oFileTypeFilterComboBox;
    private IFileView m_oFileView;
    private String m_oRootDir;
    private JPanel m_oFileTypeFilterPanel;
    private DCFileInfo[] m_oFileInfos = new DCFileInfo[0];
    private ISelectFileListener m_oSelectFileListener;
    private boolean m_isBrowseFromThirdFTP = false;
    private static boolean supportRecoverFromThirdParty = false;
    private SimpleProgressDlg m_oProgressDlg = null;

    public SelectServerFilePanel(boolean isShowBorder) throws DCException {
        this(3, isShowBorder, false, null);
    }

    public SelectServerFilePanel(int iType, boolean isShowBorder, boolean isBrowseFromThirdFTP, String strInitPath) throws DCException {
        this(new ServerFileView(iType, isBrowseFromThirdFTP, strInitPath), isShowBorder, isBrowseFromThirdFTP);
    }

    public SelectServerFilePanel(IFileView oFileView, boolean isShowBorder, boolean isBrowseFromThirdFTP) throws DCException {
        super(isShowBorder);
        this.m_oFileView = oFileView;
        this.m_isBrowseFromThirdFTP = isBrowseFromThirdFTP;
        this.m_oRootDir = oFileView.getCurrentPath();
        this.isDefaultSelect(this.m_oRootDir);
        this.jInit();
        try {
            this.updateTableData(this.m_oRootDir);
        }
        catch (DCException e) {
            DCOptionPane.showErrorDialog((Component)this, e.getErrorCode());
        }
    }

    public void isDefaultSelect(String RootDir) {
        supportRecoverFromThirdParty = !RootDir.equals(ServerFileView.getSystemPath());
    }

    private void jInit() {
        this.initFilePathPanel();
        this.initTable();
        this.initFileTypeFilter();
    }

    private void initFilePathPanel() {
        ImageIcon oUpIcon = this.m_oResMgr.getImage("upfolder.gif");
        this.m_oPathBtn.setIcon(oUpIcon);
    }

    private void initTable() {
        boolean isOnlyShowDir = 2 == this.m_oFileView.getType();
        this.m_oTableModel = new DCTableModel(new DCFileTableInfo(isOnlyShowDir));
        this.m_oTable = new DCTable(this.m_oTableModel){
            private static final long serialVersionUID = 6933629461692448686L;

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.m_oTable.setName("com.huawei.dc.common.components.dialog.fileselection.SelectServerFilePanel.m_oTable");
        this.m_oTable.setColumnSelectionAllowed(false);
        this.m_oTable.setRowSelectionAllowed(true);
        this.m_oTable.setIntercellSpacing(new Dimension(0, 0));
        this.m_oTable.setShowGrid(false);
        this.m_oTable.getBackground().darker();
        this.m_oTable.setRowHeight(21);
        this.m_oTable.setSelectionMode(0);
        this.m_oTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (2 == e.getClickCount()) {
                    SelectServerFilePanel.this.handleDoubleClickEvent(e);
                }
            }
        });
        this.m_oTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                char ch = e.getKeyChar();
                SelectServerFilePanel.this.handleKeyPressEvent(String.valueOf(ch));
            }
        });
        this.initTableRender();
        JScrollPane sp = new JScrollPane(this.m_oTable);
        if (this.m_isBrowseFromThirdFTP) {
            JLabel oFileTypeFilterLabel = new JLabel(this.m_oResMgr.getResString("NOT_SUPPORT_CHINESE_DIR"));
            JPanel mTableAndeNotePanel = new JPanel();
            mTableAndeNotePanel.setLayout(new BorderLayout(5, 0));
            mTableAndeNotePanel.add((Component)sp, "Center");
            mTableAndeNotePanel.add((Component)oFileTypeFilterLabel, "South");
            this.add((Component)mTableAndeNotePanel, "Center");
        } else {
            this.add((Component)sp, "Center");
        }
    }

    private void initTableRender() {
        TableColumn oDirFileColumn = this.m_oTable.getColumn(this.m_oResMgr.getResString("BROWSE_DLG_NAME"));
        oDirFileColumn.setWidth(150);
        this.m_oTable.getTableHeader().setPreferredSize(new Dimension(this.m_oTable.getSize().width, 21));
        oDirFileColumn.setCellRenderer(new DirFileCellRendrer());
    }

    private void initFileTypeFilter() {
        this.m_oFileTypeFilterPanel = new JPanel();
        this.m_oFileTypeFilterPanel.setLayout(new BorderLayout(5, 0));
        JLabel oFileTypeFilterLabel = new JLabel(this.m_oResMgr.getResString("SAM_IMPORT_PANEL_CONTENT_TYPE_LABEL"));
        this.m_oFileTypeFilterComboBox = new ComboBoxWithToolTip();
        this.m_oFileTypeFilterComboBox.setPreferredSize(new Dimension(200, 21));
        this.m_oFileTypeFilterComboBox.addItem(new DCFileFilter());
        this.m_oFileTypeFilterComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (1 == e.getStateChange()) {
                    SelectServerFilePanel.this.filterFile((DCFileFilter)e.getItem());
                }
            }
        });
        this.m_oFileTypeFilterPanel.add((Component)oFileTypeFilterLabel, "West");
        this.m_oFileTypeFilterPanel.add((Component)this.m_oFileTypeFilterComboBox, "Center");
        this.add((Component)this.m_oFileTypeFilterPanel, "South");
    }

    protected void updateTableData(String strPath) throws DCException {
        ArrayList<DCFileInfo> oFileInfoLst = new ArrayList<DCFileInfo>();
        int iErrorCode = this.updatetable(strPath, oFileInfoLst);
        if (0 != iErrorCode) {
            strPath = "/";
            DCOptionPane.showErrorDialog((Component)this, iErrorCode);
        }
        if (ServerFileView.isExistenRecoverpath() == 989859222 && strPath.equals(ExternalFTPFileView.browseFTPFilePath()) && 0 != (iErrorCode = this.updatetable(strPath = "/", oFileInfoLst))) {
            DCOptionPane.showErrorDialog((Component)this, iErrorCode);
        }
        this.m_oFileInfos = oFileInfoLst.toArray(new DCFileInfo[0]);
        DCFileFilter oFileFilter = (DCFileFilter)this.m_oFileTypeFilterComboBox.getSelectedItem();
        if (null == oFileFilter) {
            oFileFilter = new DCFileFilter();
        }
        this.m_oTableModel.removeAllRow();
        DCDebugTracer.trace("ThirdServer Directory and Files Size:" + oFileInfoLst.size());
        for (DCFileInfo oFileInfo : oFileInfoLst) {
            DirListNode oNameNode = oFileInfo.getNameNode();
            if (!oNameNode.m_bIsDirectory && !oFileFilter.accept(oNameNode.m_strName)) continue;
            this.m_oTableModel.addRow(oFileInfo);
        }
        int ColumnCount = this.m_oTableModel.getRowCount();
        TableColumn firsetColumn = this.m_oTable.getColumnModel().getColumn(0);
        firsetColumn.setPreferredWidth(110);
        boolean selectPathValue = strPath.equals(this.m_oRootDir);
        if (selectPathValue && supportRecoverFromThirdParty) {
            this.m_oTable.getSelectionModel().setSelectionInterval(0, ColumnCount - 1);
        }
        if (!strPath.startsWith("/") && this.m_oRootDir.equals("/")) {
            this.m_oSelectedPathText.setText("/" + strPath);
        } else if (!strPath.startsWith("/") && !strPath.startsWith(ServerFileView.getSystemPath())) {
            this.m_oSelectedPathText.setText("/" + strPath);
        } else {
            this.m_oSelectedPathText.setText(strPath);
        }
        String m_oRootDirVar = ServerFileView.getSystemPath();
        String cur_path = this.m_oSelectedPathText.getText();
        m_oRootDirVar = m_oRootDirVar.endsWith("\\") ? m_oRootDirVar.substring(0, m_oRootDirVar.lastIndexOf("\\")) : m_oRootDirVar;
        m_oRootDirVar = m_oRootDirVar.endsWith("/") ? m_oRootDirVar.substring(0, m_oRootDirVar.lastIndexOf("/")) : m_oRootDirVar;
        cur_path = cur_path.endsWith("\\") ? cur_path.substring(0, cur_path.lastIndexOf("\\")) : cur_path;
        String string = cur_path = cur_path.endsWith("/") ? cur_path.substring(0, cur_path.lastIndexOf("/")) : cur_path;
        if (strPath.equals("/") || m_oRootDirVar.equals(cur_path)) {
            this.m_oPathBtn.setEnabled(false);
            if (null == ExternalFTPFileView.hasDeviceInfo()) {
                this.m_oPathBtn.setEnabled(false);
            } else if (this.m_oSelectedPathText.getText().equals(ExternalFTPFileView.browseFTPFilePath())) {
                this.m_oPathBtn.setEnabled(true);
            }
        } else {
            this.m_oPathBtn.setEnabled(true);
        }
    }

    private void filterFile(DCFileFilter oFileFilter) {
        this.m_oTableModel.removeAllRow();
        for (DCFileInfo oFileInfo : this.m_oFileInfos) {
            DirListNode oNameNode = oFileInfo.getNameNode();
            if (!oNameNode.m_bIsDirectory && !oFileFilter.accept(oNameNode.m_strName)) continue;
            this.m_oTableModel.addRow(oFileInfo);
        }
    }

    private void handleKeyPressEvent(String oKey) {
        int iSelectedRow = this.m_oTable.getSelectedRow();
        int iRowCount = this.m_oTable.getRowCount();
        int iCurrentRow = iSelectedRow;
        for (int iFindCont = 0; iFindCont < iRowCount; ++iFindCont) {
            if (++iCurrentRow >= iRowCount) {
                iCurrentRow = 0;
            }
            DCFileInfo oFileInfo = (DCFileInfo)this.m_oTableModel.getRowData(iCurrentRow);
            DirListNode oNameNode = oFileInfo.getNameNode();
            if (!oNameNode.m_strName.toLowerCase().startsWith(oKey.toLowerCase())) continue;
            this.m_oTable.getSelectionModel().setSelectionInterval(iCurrentRow, iCurrentRow);
            Rectangle oRect = this.m_oTable.getCellRect(iCurrentRow, 0, true);
            this.m_oTable.scrollRectToVisible(oRect);
            break;
        }
    }

    private void handleDoubleClickEvent(MouseEvent e) {
        int iSelectedRow = this.m_oTable.getSelectedRow();
        DCFileInfo oSelectFileInfo = (DCFileInfo)this.m_oTableModel.getRowData(iSelectedRow);
        DirListNode oNameNode = oSelectFileInfo.getNameNode();
        if (oNameNode.m_bIsDirectory) {
            try {
                this.updateTableData(this.getNextPath(oNameNode.m_strName));
            }
            catch (DCException e1) {
                DCOptionPane.showErrorDialog((Component)this, e1.getErrorCode());
                DCDebugTracer.trace(e1);
            }
        } else if (null != this.m_oSelectFileListener) {
            this.m_oSelectFileListener.doubleClick();
        }
    }

    @Override
    protected void handlePathBtnEvent() {
        String strCurrentPath = this.m_oFileView.getCurrentPath();
        int index = strCurrentPath.lastIndexOf("/");
        String strUpPath = this.m_oFileView.getRootPath();
        if (0 < index) {
            strUpPath = strCurrentPath.substring(0, index);
        }
        if (0 == index) {
            strUpPath = "/";
        }
        if (-1 == index) {
            strUpPath = "/";
        }
        try {
            this.updateTableData(strUpPath);
        }
        catch (DCException e) {
            DCOptionPane.showErrorDialog((Component)this, e.getErrorCode());
            DCDebugTracer.trace(e);
        }
    }

    private String getNextPath(String strDirName) {
        StringBuffer sb = new StringBuffer();
        String strCurrentPath = this.m_oFileView.getCurrentPath();
        if (!"/".equals(strCurrentPath) || !this.m_oFileView.isWindows()) {
            sb.append(strCurrentPath);
            if (!sb.toString().endsWith("/")) {
                sb.append("/");
            }
        }
        if ("/".equals(strCurrentPath) && this.m_oFileView.isWindows()) {
            sb.append(strCurrentPath);
        }
        sb.append(strDirName);
        return sb.toString();
    }

    public void setFileTypeFilterVisible(boolean isVisible) {
        this.m_oFileTypeFilterPanel.setVisible(isVisible);
    }

    @Override
    public void addFileFilter(DCFileFilter oFileFileter) {
        if (null != oFileFileter) {
            this.m_oFileTypeFilterComboBox.insertItemAt(oFileFileter, 0);
        }
    }

    public void setSelectFileFilter(int index) {
        if (index < this.m_oFileTypeFilterComboBox.getItemCount()) {
            this.m_oFileTypeFilterComboBox.setSelectedIndex(index);
        }
    }

    @Override
    public DCFileInfo getSelectedFile() {
        String strPath = this.m_oSelectedPathText.getText();
        int iSelectedRow = this.m_oTable.getSelectedRow();
        if (0 <= iSelectedRow) {
            DCFileInfo oSelectFileInfo = (DCFileInfo)this.m_oTableModel.getRowData(iSelectedRow);
            DirListNode oNameNode = oSelectFileInfo.getNameNode();
            strPath = strPath != null && !strPath.equals("") && strPath.endsWith("/") ? strPath + oNameNode.m_strName : strPath + "/" + oNameNode.m_strName;
            oSelectFileInfo.setAbsolutePath(strPath);
            return oSelectFileInfo;
        }
        DCFileInfo oFileInfo = new DCFileInfo();
        int index = strPath.lastIndexOf("/");
        String strName = strPath;
        if (0 < index && index < strPath.length()) {
            strName = strPath.substring(index + 1);
        }
        DirListNode oNameNode = new DirListNode(strName, true);
        oFileInfo.setNameNode(oNameNode);
        oFileInfo.setAbsolutePath(strPath);
        return oFileInfo;
    }

    public void setRootDir(String strDir) {
        this.m_oRootDir = strDir;
        try {
            this.updateTableData(strDir);
        }
        catch (DCException e) {
            DCOptionPane.showErrorDialog((Component)this, e.getErrorCode());
            DCDebugTracer.trace(e);
        }
    }

    public void updateTableModel(DCTableModel oTableModel) {
        this.m_oTableModel = oTableModel;
        this.m_oTable.setModel(this.m_oTableModel);
        this.initTableRender();
        DCFrameWorkUtil.updateUI(this.m_oTable);
    }

    @Override
    public void setDefaultPath(String strPath) {
        if (this.m_oFileView.getRootPath().equals(this.m_oRootDir) || strPath.startsWith(this.m_oRootDir)) {
            try {
                this.updateTableData(strPath);
            }
            catch (DCException e) {
                DCOptionPane.showErrorDialog((Component)this, e.getErrorCode());
                DCDebugTracer.trace(e);
            }
        }
    }

    public void addSelectFileListener(ISelectFileListener oSelectFileListener) {
        this.m_oSelectFileListener = oSelectFileListener;
    }

    @Override
    public List<DCFileInfo> getAllFileInCurrentPath() {
        String strPath = this.m_oSelectedPathText.getPath().trim();
        if (!this.m_oFileView.getRootPath().equals(strPath)) {
            strPath = strPath + "/";
        }
        DCFileInfo oSelectedFileInfo = this.getSelectedFile();
        ArrayList<DCFileInfo> oFileInfoLst = new ArrayList<DCFileInfo>();
        for (DCFileInfo oTmpFileInfo : this.m_oFileInfos) {
            DirListNode oTmpNameNode = oTmpFileInfo.getNameNode();
            if (oTmpNameNode.m_bIsDirectory || oSelectedFileInfo.isSame(oTmpFileInfo)) continue;
            DCFileInfo oFileInfo = new DCFileInfo();
            DirListNode oNameNode = new DirListNode(oTmpNameNode.m_strName, false);
            oFileInfo.setNameNode(oNameNode);
            oFileInfo.setAbsolutePath(strPath + oTmpNameNode.m_strName);
            oFileInfoLst.add(oFileInfo);
        }
        return oFileInfoLst;
    }

    public IFileView getFileView() {
        return this.m_oFileView;
    }

    private void initProgressDlg() {
        this.closeProgressDlg();
        this.m_oProgressDlg = new SimpleProgressDlg(ResourceManager.getInstance().getResString("DIRECTORY_INFO"), true, ResourceManager.getInstance().getResString("DIRECTORY_PROGRESS_PROMPT")){
            private static final long serialVersionUID = 1L;

            @Override
            protected void cancelRollBtnActionPerformed() {
                if (null == SelectServerFilePanel.this.m_oProgressDlg) {
                    return;
                }
                SelectServerFilePanel.this.closeProgressDlg();
            }
        };
        this.m_oProgressDlg.getcancelRollBtn().setText(ResourceManager.getInstance().getResString("CANCEL"));
    }

    public synchronized void closeProgressDlg() {
        if (null != this.m_oProgressDlg) {
            DCDebugTracer.trace("Getting ThirdServer Directory End");
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SelectServerFilePanel.this.m_oProgressDlg.dispose();
                    SelectServerFilePanel.this.m_oProgressDlg = null;
                }
            });
        }
    }

    private int updatetable(String strPath, List<DCFileInfo> oFileInfoLst) {
        ValidationResult oValidResult = new ValidationResult();
        oValidResult.setErrorCode(0);
        if (supportRecoverFromThirdParty) {
            this.initProgressDlg();
            UpdateFileTable updateFileTableThread = new UpdateFileTable(strPath, oFileInfoLst);
            updateFileTableThread.start();
            this.m_oProgressDlg.setVisible(true);
            oValidResult = updateFileTableThread.getValidateResult();
        } else {
            oValidResult.setErrorCode(this.m_oFileView.getFileInfoInPath(strPath, oFileInfoLst));
        }
        if (null == oValidResult) {
            oValidResult = new ValidationResult();
        }
        return oValidResult.getErrorCode();
    }

    class UpdateFileTable
    extends Thread {
        private ValidationResult m_oResult = null;
        private String path;
        private List<DCFileInfo> fileLst;

        public UpdateFileTable(String strPath, List<DCFileInfo> oFileInfoLst) {
            this.path = strPath;
            this.fileLst = oFileInfoLst;
            this.setName("SelectServerFilePanel#UpdateFileTable-Thread");
        }

        @Override
        public void run() {
            try {
                UpdateFileTable.sleep(500L);
            }
            catch (InterruptedException ex) {
                DCDebugTracer.trace(ex);
            }
            this.m_oResult = new ValidationResult();
            this.m_oResult.setErrorCode(0);
            int iErrorCode = SelectServerFilePanel.this.m_oFileView.getFileInfoInPath(this.path, this.fileLst);
            this.m_oResult.setErrorCode(iErrorCode);
            SelectServerFilePanel.this.closeProgressDlg();
        }

        public ValidationResult getValidateResult() {
            return this.m_oResult;
        }
    }
}

