/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.components.dialog.fileselection;

import com.huawei.dc.common.components.dialog.fileselection.AbstractSelectFilePanel;
import com.huawei.dc.common.components.dialog.fileselection.model.DCFileFilter;
import com.huawei.dc.common.components.dialog.fileselection.model.DCFileInfo;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.util.DCFileChooser;
import com.huawei.dc.deviceoperation.util.DirListNode;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class SelectLocalFilePanel
extends AbstractSelectFilePanel {
    private static final long serialVersionUID = -7052051221913703727L;
    private List<DCFileFilter> m_oFileFilter = new ArrayList<DCFileFilter>();

    public SelectLocalFilePanel() {
        super(true);
        this.jInit();
    }

    private void jInit() {
        this.m_oPathBtn.setText("...");
    }

    @Override
    protected void handlePathBtnEvent() {
        DCFileChooser oBrowseDlg = new DCFileChooser();
        oBrowseDlg.setTitle(this.m_oResMgr.getResString("FILE_SELECTION_DLG_TITLE"));
        for (DCFileFilter oFileFilter : this.m_oFileFilter) {
            oBrowseDlg.setFileFilter(oFileFilter);
        }
        int iReturnVal = oBrowseDlg.showOpenDialog(DCFrameWorkUtil.getMainFrame());
        if (iReturnVal == 0) {
            this.m_oSelectedPathText.setText(oBrowseDlg.getSelectedFile().getAbsolutePath());
        }
    }

    @Override
    public List<DCFileInfo> getAllFileInCurrentPath() {
        File oFile = new File(this.m_oSelectedPathText.getPath().trim());
        ArrayList<DCFileInfo> oFileInfoLst = new ArrayList<DCFileInfo>();
        if (oFile.isFile()) {
            DCFileInfo oFileInfo = new DCFileInfo();
            DirListNode oNameNode = new DirListNode(oFile.getName(), false);
            oFileInfo.setNameNode(oNameNode);
            oFileInfo.setAbsolutePath(oFile.getAbsolutePath());
            oFileInfoLst.add(oFileInfo);
            return oFileInfoLst;
        }
        File[] oFiles = oFile.listFiles();
        if (null == oFiles) {
            return oFileInfoLst;
        }
        for (File oTmpFile : oFiles) {
            if (!oTmpFile.isFile()) continue;
            DCFileInfo oFileInfo = new DCFileInfo();
            DirListNode oNameNode = new DirListNode(oTmpFile.getName(), false);
            oFileInfo.setNameNode(oNameNode);
            oFileInfo.setAbsolutePath(oTmpFile.getAbsolutePath());
            oFileInfoLst.add(oFileInfo);
        }
        return oFileInfoLst;
    }

    @Override
    public void addFileFilter(DCFileFilter oFileFileter) {
        if (null != oFileFileter) {
            int count = this.m_oFileFilter.size();
            for (int i = 0; i < count; ++i) {
                String strPostfix = this.m_oFileFilter.get(i).getM_strPostfix().trim();
                String strDesc = this.m_oFileFilter.get(i).getDescription().trim();
                if (!strPostfix.equals(oFileFileter.getM_strPostfix().trim()) || !strPostfix.equals(strDesc)) continue;
                this.m_oFileFilter.set(i, oFileFileter);
                return;
            }
            this.m_oFileFilter.add(oFileFileter);
        }
    }
}

