/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.components.dialog.fileselection;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.components.dialog.fileselection.IUpdateDestinationListener;
import com.huawei.dc.common.framework.system.SystemManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.ComboBoxWithToolTip;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.configuration.system.externalftp.ExternalFTPInfo;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SelectDestinationPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private ComboBoxWithToolTip m_oDestinationCombox;
    private ComboBoxWithToolTip m_oThirdFTPServerCombox;
    private IUpdateDestinationListener m_oUpdateDestListener;
    private JLabel m_oDestLabel;
    private String m_oPreSelectDestination = IUpdateDestinationListener.DESTINATION_NMS_SERVER;
    private boolean m_isSupportClient = false;
    private boolean m_isSupportExternalFTP = false;

    public SelectDestinationPanel() {
        this("", false, false);
    }

    public SelectDestinationPanel(boolean isSupportClient, boolean isSupportExternalFTP) {
        this("", isSupportClient, isSupportExternalFTP);
    }

    public SelectDestinationPanel(String strLabelName, boolean isSupportClient, boolean isSupportExternalFTP) {
        this.m_isSupportClient = isSupportClient;
        this.m_isSupportExternalFTP = isSupportExternalFTP;
        this.jInit();
        this.setDestLabelText(strLabelName);
    }

    private void jInit() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConst = new GridBagConstraints();
        gridBagConst.weightx = 0.0;
        gridBagConst.gridx = 0;
        gridBagConst.gridy = 0;
        gridBagConst.gridwidth = 1;
        gridBagConst.anchor = 17;
        this.m_oDestLabel = new JLabel();
        this.add((Component)this.m_oDestLabel, gridBagConst);
        this.m_oDestinationCombox = new ComboBoxWithToolTip();
        this.m_oDestinationCombox.setName("com.huawei.dc.devicemanagement.deviceoperation.common.SelectFileServerPanel.m_oDestinationCombox");
        this.m_oDestinationCombox.addItem(IUpdateDestinationListener.DESTINATION_NMS_SERVER);
        if (this.m_isSupportClient) {
            this.m_oDestinationCombox.addItem(IUpdateDestinationListener.DESTINATION_NMS_CLIENT);
        }
        if (this.m_isSupportExternalFTP) {
            this.m_oDestinationCombox.addItem(IUpdateDestinationListener.DESTINATION_EXTERNAL_FTP_SERVER);
        }
        this.m_oDestinationCombox.addActionListener(new ActionListener(){
            private long m_iSelectTime = 0L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.m_iSelectTime != e.getWhen()) {
                    SelectDestinationPanel.this.updateDestination(SelectDestinationPanel.this.m_oDestinationCombox.getSelectedItem());
                    this.m_iSelectTime = e.getWhen();
                }
            }
        });
        this.m_oDestinationCombox.setPreferredSize(new Dimension(150, 21));
        gridBagConst.weightx = 0.001;
        gridBagConst.gridx = 1;
        gridBagConst.gridy = 0;
        gridBagConst.gridwidth = 2;
        gridBagConst.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.m_oDestinationCombox, gridBagConst);
        this.m_oThirdFTPServerCombox = new ComboBoxWithToolTip(){

            @Override
            public void setSelectedItem(Object anObject) {
                if (super.getSelectedItem().equals(anObject)) {
                    return;
                }
                super.setSelectedItem(anObject);
                String externalFTPServer = SelectDestinationPanel.this.getExternalFTPServerName();
                if (null != externalFTPServer && !"".equals(externalFTPServer)) {
                    SelectDestinationPanel.this.m_oUpdateDestListener.updateExternalFTPName(SelectDestinationPanel.this.getExternalFTPServerName());
                }
            }
        };
        this.m_oThirdFTPServerCombox.setName("com.huawei.dc.devicemanagement.deviceoperation.common.SelectFileServerPanel.m_oThirdFTPServerCombox");
        this.m_oThirdFTPServerCombox.setPreferredSize(new Dimension(100, 21));
        gridBagConst.weightx = 1.0;
        gridBagConst.gridx = 3;
        gridBagConst.gridy = 0;
        gridBagConst.gridwidth = 5;
        gridBagConst.fill = 2;
        gridBagConst.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.m_oThirdFTPServerCombox, gridBagConst);
        this.m_oThirdFTPServerCombox.setVisible(false);
    }

    private void updateDestination(Object oDestination) {
        DCDebugTracer.trace("SelectDestinationPanel#updateDestination:" + oDestination);
        if (IUpdateDestinationListener.DESTINATION_NMS_SERVER.equals(oDestination)) {
            this.m_oThirdFTPServerCombox.setVisible(false);
        } else if (IUpdateDestinationListener.DESTINATION_NMS_CLIENT.equals(oDestination)) {
            this.m_oThirdFTPServerCombox.setVisible(false);
        } else {
            SystemManager oSysMgr = new SystemManager();
            try {
                this.m_oThirdFTPServerCombox.removeAllItems();
                ExternalFTPInfo[] oExternalFTPInfos = oSysMgr.getExternalFTPInfos();
                if (0 == oExternalFTPInfos.length) {
                    DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("THIRD_PARTY_FTP_NOT_CONFIGURED_CONFIRM_MSG"));
                    this.m_oDestinationCombox.setSelectedItem(this.m_oPreSelectDestination);
                    return;
                }
                DCDebugTracer.trace("SelectDestinationPanel#oExternalFTPInfos size:" + oExternalFTPInfos.length);
                for (ExternalFTPInfo oExternalFTPInfo : oExternalFTPInfos) {
                    this.m_oThirdFTPServerCombox.addItem(oExternalFTPInfo);
                }
                this.m_oThirdFTPServerCombox.setSelectedIndex(0);
            }
            catch (DCException e) {
                DCDebugTracer.trace(e);
                DCOptionPane.showMessageDialog((Component)this, e.getErrorCode(), ResourceManager.getInstance().getResString("FAIL_TO_GET_EXTERNAL_FTP_SERVER_INFO"), 0);
                return;
            }
            this.m_oThirdFTPServerCombox.setVisible(true);
        }
        if (null != this.m_oUpdateDestListener) {
            try {
                this.m_oUpdateDestListener.updateDestination(String.valueOf(oDestination));
            }
            catch (DCException e) {
                DCOptionPane.showMessageDialog((Component)this, e.getMessage(), ResourceManager.getInstance().getResString("INFO"), 1);
                this.m_oDestinationCombox.setSelectedItem(this.m_oPreSelectDestination);
                if (null != this.m_oThirdFTPServerCombox && !IUpdateDestinationListener.DESTINATION_EXTERNAL_FTP_SERVER.equals(this.m_oPreSelectDestination)) {
                    this.m_oThirdFTPServerCombox.setVisible(false);
                }
                return;
            }
        }
        this.m_oPreSelectDestination = oDestination.toString();
    }

    public void setSelectedDestination(String strDestination) {
        this.m_oDestinationCombox.setSelectedItem(strDestination);
    }

    public void setDestLabelText(String strText) {
        this.m_oDestLabel.setText(strText);
    }

    public void addUpdateDestinationListener(IUpdateDestinationListener oListener) {
        this.m_oUpdateDestListener = oListener;
    }

    public String getDestination() {
        return this.m_oDestinationCombox.getSelectedItem().toString();
    }

    public String getExternalFTPServerName() {
        Object oSelectFTPInfo;
        if (IUpdateDestinationListener.DESTINATION_EXTERNAL_FTP_SERVER.equals(this.getDestination()) && (oSelectFTPInfo = this.m_oThirdFTPServerCombox.getSelectedItem()) instanceof ExternalFTPInfo) {
            ExternalFTPInfo oExternalFTPInfo = (ExternalFTPInfo)oSelectFTPInfo;
            return oExternalFTPInfo.getServerName();
        }
        return "";
    }
}

