/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.components.dialog.fileselection;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.components.dialog.IBrowseDlgInterafce;
import com.huawei.dc.common.components.dialog.fileselection.AbstractSelectFilePanel;
import com.huawei.dc.common.components.dialog.fileselection.ISelectFileListener;
import com.huawei.dc.common.components.dialog.fileselection.IUpdateDestinationListener;
import com.huawei.dc.common.components.dialog.fileselection.SelectDestinationPanel;
import com.huawei.dc.common.components.dialog.fileselection.SelectExternalFTPFilePanel;
import com.huawei.dc.common.components.dialog.fileselection.SelectLocalFilePanel;
import com.huawei.dc.common.components.dialog.fileselection.SelectServerFilePanel;
import com.huawei.dc.common.components.dialog.fileselection.model.DCFileFilter;
import com.huawei.dc.common.components.dialog.fileselection.model.DCFileInfo;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.deviceoperation.util.DirListNode;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JPanel;

public class FileSelectionBrowseDlg
extends DCModalDialog
implements IUpdateDestinationListener,
ISelectFileListener {
    private static final long serialVersionUID = -8326646397459067892L;
    protected SelectDestinationPanel m_oSelectDestPanel;
    private CardLayout m_oSelectFilePanelCardLayout;
    private JPanel m_oSelectFilePanel;
    protected AbstractSelectFilePanel m_oCurrentSelectFilePanel;
    protected SelectServerFilePanel m_oSelectServerFilePanel;
    protected SelectLocalFilePanel m_oSelectLocalFilePanel;
    protected SelectExternalFTPFilePanel m_oSelectExternalFTPFilePanel;
    private ResourceManager m_oResMgr = ResourceManager.getInstance();
    private int m_iBrowseType = 3;
    private boolean m_isSupportClient = false;
    private boolean m_isSupportExternalFTP = false;
    private boolean m_isBrowseFromThirdFTP = false;
    private JPanel m_oCenterMainPanel;
    protected IBrowseDlgInterafce m_oBrowseDlgInterface;
    protected boolean m_isShowDestination = false;
    protected int m_iDomain = 0;
    private boolean m_isOKOption = false;
    protected String str_operationID = "";
    private String strInitPath = "";
    private boolean m_recoverServerPrivilege = true;
    private boolean m_recoverClientPrivilege = true;
    private boolean m_recoverThirdPrivilege = true;

    public FileSelectionBrowseDlg(String operationID) throws DCException {
        this(2, 0, false, false, false, operationID, null);
    }

    public FileSelectionBrowseDlg(boolean isSupportClient, boolean isSupportExternalFTP, boolean isBrowseFromThirdFTP, String operationID) throws DCException {
        this(3, 0, isSupportClient, isSupportExternalFTP, isBrowseFromThirdFTP, operationID, null);
    }

    public FileSelectionBrowseDlg(int iDomain, boolean isSupportClient, boolean isSupportExternalFTP, String operationID, String strInitPatch) throws DCException {
        this(3, iDomain, isSupportClient, isSupportExternalFTP, false, operationID, strInitPatch);
    }

    public FileSelectionBrowseDlg(int iBrowseType, int iDomain, boolean isSupportClient, boolean isSupportExternalFTP, boolean isBrowseFromThirdFTP, String operationID, String sInitPath) throws DCException {
        this.m_iBrowseType = iBrowseType;
        this.m_iDomain = iDomain;
        this.m_isSupportClient = isSupportClient;
        this.m_isSupportExternalFTP = isSupportExternalFTP;
        this.m_isBrowseFromThirdFTP = isBrowseFromThirdFTP;
        this.str_operationID = operationID;
        this.strInitPath = sInitPath;
        if (2 == iBrowseType) {
            this.setTitle(this.m_oResMgr.getResString("SELECT_DIR"));
        } else {
            this.setTitle(this.m_oResMgr.getResString("RECOVER_DLG_SELECT_FILE_TITLE"));
        }
        this.jInit();
    }

    private void jInit() throws DCException {
        JPanel oMainPanel = new JPanel();
        oMainPanel.setLayout(new BorderLayout(5, 5));
        oMainPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        this.setContentPane(oMainPanel);
        this.setSize(500, 372);
        this.setResizable(true);
        if (2 != this.m_iBrowseType) {
            this.m_isShowDestination = true;
        }
        if (!this.m_isSupportClient && !this.m_isSupportExternalFTP) {
            this.m_isShowDestination = false;
        }
        this.m_oCenterMainPanel = new JPanel();
        this.m_oCenterMainPanel.setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.m_oCenterMainPanel, "Center");
        this.checkUserPrivilege();
        this.initDestSelectionPanel();
        this.initFileSelectiongPanel();
        this.setDestComboxDefaultSelectByPermisson();
        this.initBtnPanel();
        if (!IUpdateDestinationListener.DESTINATION_NMS_CLIENT.equals(this.m_oSelectDestPanel.getDestination())) {
            this.initSelectServerFilePanel();
            this.m_oCurrentSelectFilePanel = this.m_oSelectServerFilePanel;
        }
    }

    private void checkUserPrivilege() {
        if (DCFrameWorkUtil.getIsSingleClient()) {
            return;
        }
        this.m_recoverServerPrivilege = DCFrameWorkUtil.hasUserOperationPrivilege(43824);
        this.m_recoverClientPrivilege = DCFrameWorkUtil.hasUserOperationPrivilege(43868);
        this.m_recoverThirdPrivilege = DCFrameWorkUtil.hasUserOperationPrivilege(44096);
    }

    private void initDestSelectionPanel() {
        this.m_oSelectDestPanel = new SelectDestinationPanel(this.m_isSupportClient, this.m_isSupportExternalFTP);
        this.m_oSelectDestPanel.addUpdateDestinationListener(this);
        this.m_oSelectDestPanel.setDestLabelText(this.m_oResMgr.getResString("RECOVER_DESTINATION_LABEL"));
        if (this.m_isShowDestination) {
            this.m_oCenterMainPanel.add((Component)this.m_oSelectDestPanel, "North");
        }
    }

    private void initFileSelectiongPanel() {
        this.m_oSelectFilePanel = new JPanel();
        this.m_oSelectFilePanelCardLayout = new CardLayout();
        this.m_oSelectFilePanel.setLayout(this.m_oSelectFilePanelCardLayout);
        this.m_oCenterMainPanel.add((Component)this.m_oSelectFilePanel, "Center");
    }

    protected void initSelectServerFilePanel() throws DCException {
        if (null == this.m_oSelectServerFilePanel) {
            this.m_oSelectServerFilePanel = new SelectServerFilePanel(this.m_iBrowseType, this.m_isShowDestination, this.m_isBrowseFromThirdFTP, this.strInitPath);
            this.m_oSelectServerFilePanel.setFileTypeFilterVisible(false);
            this.m_oSelectServerFilePanel.addSelectFileListener(this);
            this.m_oSelectFilePanel.add((Component)this.m_oSelectServerFilePanel, this.m_oSelectServerFilePanel.getClass().getName());
        }
    }

    protected void initSelectLocalFilePanel() {
        if (null == this.m_oSelectLocalFilePanel) {
            this.m_oSelectLocalFilePanel = new SelectLocalFilePanel();
            String strFilter = this.generateSuffixByDomain(this.m_iDomain);
            DCFileFilter dcFilter = new DCFileFilter(strFilter);
            this.m_oSelectLocalFilePanel.addFileFilter(dcFilter);
            this.m_oSelectFilePanel.add((Component)this.m_oSelectLocalFilePanel, this.m_oSelectLocalFilePanel.getClass().getName());
        }
    }

    private void setDestComboxDefaultSelectByPermisson() {
        if (!DCFrameWorkUtil.getIsSingleClient() && "Recover".equals(this.str_operationID)) {
            if (this.m_recoverServerPrivilege) {
                this.m_oSelectDestPanel.setSelectedDestination(IUpdateDestinationListener.DESTINATION_NMS_SERVER);
            } else if (this.m_recoverClientPrivilege) {
                this.m_oSelectDestPanel.setSelectedDestination(IUpdateDestinationListener.DESTINATION_NMS_CLIENT);
            } else if (this.m_isSupportExternalFTP && this.m_recoverThirdPrivilege) {
                this.m_oSelectDestPanel.setSelectedDestination(IUpdateDestinationListener.DESTINATION_EXTERNAL_FTP_SERVER);
            } else {
                DCOptionPane.showMessageDialog(null, ResourceManager.getInstance().getResString("NO_PRIVILEGE_RECOVER"), ResourceManager.getInstance().getResString("SUGGESTION"), 1);
                this.closeDialog();
            }
        }
    }

    private String generateSuffixByDomain(int iDevDomain) {
        StringBuffer filterFileSuffex = new StringBuffer();
        if (4 == iDevDomain) {
            filterFileSuffex.append("*.pkg");
        } else if (2 == iDevDomain) {
            filterFileSuffex.append("*.cc");
        } else if (2 == iDevDomain) {
            filterFileSuffex.append("*.dat;*.cfg");
        } else {
            filterFileSuffex.append("*.dat;*.cfg;*.pkg");
        }
        return filterFileSuffex.toString();
    }

    protected void initSelectExternalFTPFilePanel() throws DCException {
        if (null == this.m_oSelectExternalFTPFilePanel) {
            this.m_oSelectExternalFTPFilePanel = new SelectExternalFTPFilePanel(this.m_iBrowseType, this.m_oSelectDestPanel.getExternalFTPServerName(), this.m_isShowDestination);
            this.m_oSelectExternalFTPFilePanel.setFileTypeFilterVisible(false);
            this.m_oSelectFilePanel.add((Component)this.m_oSelectExternalFTPFilePanel, this.m_oSelectExternalFTPFilePanel.getClass().getName());
        }
    }

    private void initBtnPanel() {
        this.m_oOKBtn.setText(this.m_oResMgr.getResString("OK_BUTTON"));
        this.m_oOKBtn.setName("com.huawei.dc.common.components.dialog.fileselection.FileSelectionBrowseDlg.m_oOKBtn");
        this.m_oOKBtn.setPreferredSize(new Dimension(80, 20));
        this.m_oCancelBtn.setText(this.m_oResMgr.getResString("CANCEL_BUTTON"));
        this.m_oCancelBtn.setName("com.huawei.dc.common.components.dialog.fileselection.FileSelectionBrowseDlg.m_oCancelBtn");
        this.m_oCancelBtn.setPreferredSize(new Dimension(80, 20));
        JPanel oBtnPanel = new JPanel();
        oBtnPanel.setLayout(new FlowLayout(2, 0, 5));
        oBtnPanel.add(this.m_oOKBtn);
        oBtnPanel.add(Box.createHorizontalStrut(5));
        oBtnPanel.add(this.m_oCancelBtn);
        this.getContentPane().add((Component)oBtnPanel, "South");
    }

    @Override
    protected String getCurrentContext() {
        return null;
    }

    @Override
    public void updateDestination(String strDestination) throws DCException {
        DCDebugTracer.trace("FileSelectionBrowseDlg#updateDestination:" + strDestination);
        if ("Recover".equals(this.str_operationID)) {
            this.updateDestinationWithRecover(strDestination);
        } else if (IUpdateDestinationListener.DESTINATION_NMS_CLIENT.equals(strDestination)) {
            this.initSelectLocalFilePanel();
            this.m_oCurrentSelectFilePanel = this.m_oSelectLocalFilePanel;
        } else if (IUpdateDestinationListener.DESTINATION_NMS_SERVER.equals(strDestination)) {
            this.initSelectServerFilePanel();
            this.m_oCurrentSelectFilePanel = this.m_oSelectServerFilePanel;
        } else {
            this.initSelectExternalFTPFilePanel();
            this.m_oCurrentSelectFilePanel = this.m_oSelectExternalFTPFilePanel;
        }
        this.m_oCurrentSelectFilePanel.setBorderTitle(this.getTitle());
        this.m_oSelectFilePanelCardLayout.show(this.m_oSelectFilePanel, this.m_oCurrentSelectFilePanel.getClass().getName());
    }

    public void updateDestinationWithRecover(String strDestination) throws DCException {
        if (IUpdateDestinationListener.DESTINATION_NMS_CLIENT.equals(strDestination)) {
            if (!this.m_recoverClientPrivilege) {
                throw new DCException(ResourceManager.getInstance().getResString("NO_PRIVILEGE_RECOVER_FROM_CLIENT"));
            }
            this.initSelectLocalFilePanel();
            this.m_oCurrentSelectFilePanel = this.m_oSelectLocalFilePanel;
        } else if (IUpdateDestinationListener.DESTINATION_NMS_SERVER.equals(strDestination)) {
            if (!this.m_recoverServerPrivilege) {
                throw new DCException(ResourceManager.getInstance().getResString("NO_PRIVILEGE_RECOVER_FROM_SERVER"));
            }
            this.initSelectServerFilePanel();
            this.m_oCurrentSelectFilePanel = this.m_oSelectServerFilePanel;
        } else {
            if (!this.m_recoverThirdPrivilege) {
                throw new DCException(ResourceManager.getInstance().getResString("NO_PRIVILEGE_RECOVER_FROM_THIRD"));
            }
            this.initSelectExternalFTPFilePanel();
            this.m_oCurrentSelectFilePanel = this.m_oSelectExternalFTPFilePanel;
        }
    }

    public String getDestination() {
        if (null != this.m_oSelectDestPanel) {
            return this.m_oSelectDestPanel.getDestination();
        }
        return IUpdateDestinationListener.DESTINATION_NMS_SERVER;
    }

    public String getExternalFTPServerName() {
        if (null != this.m_oSelectDestPanel) {
            return this.m_oSelectDestPanel.getExternalFTPServerName();
        }
        return "";
    }

    public void registBrowseDlgInterface(IBrowseDlgInterafce oBrowseDlgInterface) {
        this.m_oBrowseDlgInterface = oBrowseDlgInterface;
    }

    public void setTitle(String strTitle) {
        super.setTitle(strTitle);
        if (null != this.m_oCurrentSelectFilePanel) {
            this.m_oCurrentSelectFilePanel.setBorderTitle(strTitle);
        }
    }

    @Override
    protected void oKButton_ActionPerformed() {
        this.m_isOKOption = true;
        if (null != this.m_oBrowseDlgInterface) {
            String strDestination = this.getDestination();
            DCFileInfo oFileInfo = this.m_oCurrentSelectFilePanel.getSelectedFile();
            DirListNode oNameNode = oFileInfo.getNameNode();
            if (2 == this.m_iBrowseType) {
                if (!oNameNode.m_bIsDirectory) {
                    DCOptionPane.showErrorDialog((Component)((Object)this), this.m_oResMgr.getResString("BROWSEDLG_SELECT_DIRECTORY"));
                    return;
                }
            } else if (oNameNode.m_bIsDirectory) {
                DCOptionPane.showErrorDialog((Component)((Object)this), this.m_oResMgr.getResString("BROWSEDLG_SELECT_FILE"));
                return;
            }
            String strFilePath = oFileInfo.getAbsolutePath();
            String strVersion = "";
            if (IUpdateDestinationListener.DESTINATION_NMS_SERVER.equals(strDestination)) {
                strVersion = oFileInfo.getVersion();
            }
            this.m_oBrowseDlgInterface.setFileOrDirectory(strFilePath, strVersion, true);
        }
        super.closeDialog();
    }

    @Override
    protected void cancelButton_ActionPerformed() {
        this.m_isOKOption = false;
        if (null != this.m_oBrowseDlgInterface) {
            this.m_oBrowseDlgInterface.setFileOrDirectory("", "", true);
        }
        super.cancelButton_ActionPerformed();
    }

    public boolean isOKOption() {
        return this.m_isOKOption;
    }

    public void setRootDir(String strDir) {
        if (null != this.m_oSelectServerFilePanel) {
            this.m_oSelectServerFilePanel.setRootDir(strDir);
        }
    }

    public void setDefaultPath(String strPath) {
        this.m_oCurrentSelectFilePanel.setDefaultPath(strPath);
    }

    @Override
    public void doubleClick() {
        this.oKButton_ActionPerformed();
    }

    @Override
    public void updateExternalFTPName(String strExternalFTPName) {
        if (null != this.m_oSelectExternalFTPFilePanel) {
            this.m_oSelectExternalFTPFilePanel.setExternalFTPName(strExternalFTPName);
        }
    }
}

