/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.components.dialog.fileselection;

import com.huawei.dc.common.components.DCFilePathTextField;
import com.huawei.dc.common.components.dialog.fileselection.model.DCFileFilter;
import com.huawei.dc.common.components.dialog.fileselection.model.DCFileInfo;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.deviceoperation.util.DirListNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;

public abstract class AbstractSelectFilePanel
extends JPanel {
    private static final long serialVersionUID = -6371469377668365095L;
    protected ResourceManager m_oResMgr = ResourceManager.getInstance();
    private JLabel m_oFilePathLabel;
    protected DCFilePathTextField m_oSelectedPathText;
    JButton m_oPathBtn;
    private TitledBorder m_oTitleBorder;
    private boolean m_isShowBorder = false;

    public AbstractSelectFilePanel() {
        this(false);
    }

    public AbstractSelectFilePanel(boolean isShowBorder) {
        this.m_isShowBorder = isShowBorder;
        this.jInit();
    }

    private void jInit() {
        this.setLayout(new BorderLayout(0, 5));
        if (this.m_isShowBorder) {
            Border oEmptyBorder = BorderFactory.createEmptyBorder(0, 5, 5, 5);
            this.m_oTitleBorder = BorderFactory.createTitledBorder(this.m_oResMgr.getResString("SELECT_FILE"));
            CompoundBorder oBorder = BorderFactory.createCompoundBorder(this.m_oTitleBorder, oEmptyBorder);
            this.setBorder(oBorder);
        }
        this.initFilePathPanel();
    }

    private void initFilePathPanel() {
        JPanel oFilePathPanel = new JPanel();
        oFilePathPanel.setLayout(new BorderLayout(5, 0));
        this.m_oFilePathLabel = new JLabel(this.m_oResMgr.getResString("FILE_PATH"));
        this.m_oSelectedPathText = new DCFilePathTextField();
        this.m_oSelectedPathText.setName("com.huawei.dc.common.components.dialog.fileselection.AbstractSelectFilePanel.m_oSelectedPathText");
        this.m_oSelectedPathText.setEditable(false);
        this.m_oPathBtn = new JButton();
        this.m_oPathBtn.setName("com.huawei.dc.common.components.dialog.fileselection.AbstractSelectFilePanel.m_oSelectPathBtn");
        this.m_oPathBtn.setPreferredSize(new Dimension(30, 20));
        this.m_oPathBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractSelectFilePanel.this.handlePathBtnEvent();
            }
        });
        oFilePathPanel.add((Component)this.m_oFilePathLabel, "West");
        oFilePathPanel.add((Component)this.m_oSelectedPathText, "Center");
        oFilePathPanel.add((Component)this.m_oPathBtn, "East");
        this.add((Component)oFilePathPanel, "North");
    }

    protected DCFileInfo getSelectedFile() {
        DCFileInfo oFileInfo = new DCFileInfo();
        DirListNode oNameNode = new DirListNode(this.m_oSelectedPathText.getText(), false);
        oFileInfo.setNameNode(oNameNode);
        oFileInfo.setAbsolutePath(this.m_oSelectedPathText.getText());
        return oFileInfo;
    }

    public void setBorderTitle(String strTitle) {
        if (null != this.m_oTitleBorder) {
            this.m_oTitleBorder.setTitle(strTitle);
        }
    }

    public void setPathLabelText(String strText) {
        this.m_oFilePathLabel.setText(strText);
    }

    public void setDefaultPath(String strPath) {
        this.m_oSelectedPathText.setText(strPath);
    }

    protected abstract void handlePathBtnEvent();

    public abstract List<DCFileInfo> getAllFileInCurrentPath();

    public abstract void addFileFilter(DCFileFilter var1);
}

