/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.components.dialog;

import com.huawei.dc.adapter.swimap.iview.commstyle.resource.DCResourceMng;
import com.huawei.dc.adapter.swimap.iview.templates.extendedtable.DCExtendedTable;
import com.huawei.dc.adapter.swimap.iview.templates.extendedtable.DCSortableTableModel;
import com.huawei.dc.adapter.swimap.iview.templates.print.DCPrintSupportor;
import com.huawei.dc.adapter.swimap.iview.templates.print.DCTablePrintable;
import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.components.table.renderer.DCTableNumberCellRenderer;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.DCSaveFileChooser;
import com.huawei.dc.common.util.FileUtil;
import com.huawei.dc.common.util.StringUtils;
import com.swimap.iview.templates.extendedtable.SortableTableModel;
import com.swimap.iview.templates.print.tools.TablePrintable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;

public class ViewTableResultDlg
extends DCModalDialog {
    private static final long serialVersionUID = 1L;
    DCSortableTableModel dataModel = null;
    private String[] resultTableHeader = null;
    protected JScrollPane m_oScrollPane = null;
    private JPanel m_oCloseBtnPanel = null;
    private DCExtendedTable jTable = null;
    protected static final int MIN_PANEL_WIDTH = 633;
    protected static final int MAX_PANEL_HEIGHT = 490;
    protected static final String tipHtmlStrStart = "<html><body> <table width=98% align=center><tr><td>";
    protected static final String tipHtmlStrEnd = "</td></tr></table></body> </html>";
    protected final Color redColor = new Color(196, 48, 45);
    private static final Dimension BUTTON_DIMENSION = new Dimension(100, 21);
    private static final Dimension BUTTON_DIMENSION1 = new Dimension(150, 21);

    public ViewTableResultDlg(String[] tableHeader, List<String[]> rowList) {
        this.setTableHeader(tableHeader);
        this.initialize(rowList);
    }

    private void initialize(List<String[]> rowList) {
        this.setSize(new Dimension(633, 490));
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(633, 490));
        this.setMinimumSize(new Dimension(633, 490));
        this.dataModel = new DCSortableTableModel(this.resultTableHeader, 0){
            private static final long serialVersionUID = -4235149534501144674L;

            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        if (null != rowList) {
            for (int i = 0; i < rowList.size(); ++i) {
                this.dataModel.addRow((Object[])rowList.get(i));
            }
        }
        this.jTable = new DCExtendedTable((SortableTableModel)this.dataModel);
        this.jTable.setSortableClickCount(1);
        JTableHeader header = this.jTable.getTableHeader();
        header.setReorderingAllowed(false);
        this.jTable.setScrolls(false);
        this.jTable.setUpDateSelectedRow(true);
        this.jTable.setInvalidedForeground(Color.BLACK);
        this.jTable.setColAutoResizeMode(2);
        int colCount = this.jTable.getColumnCount();
        for (int i = 0; i < colCount; ++i) {
            TableColumn column = this.jTable.getColumnModel().getColumn(i);
            column.setCellRenderer(new DetailTableRenderer());
        }
        this.jTable.setRowHeight(25);
        TableColumn oLastColumn = this.jTable.getColumnModel().getColumn(this.dataModel.getColumnCount() - 1);
        oLastColumn.setMinWidth(40);
        oLastColumn.setPreferredWidth(250);
        oLastColumn.setMaxWidth(550);
        TableColumn oFirstColumn = this.jTable.getColumnModel().getColumn(0);
        oFirstColumn.setMinWidth(50);
        oFirstColumn.setPreferredWidth(50);
        oFirstColumn.setMaxWidth(100);
        oFirstColumn.setCellRenderer(new DCTableNumberCellRenderer());
        this.m_oScrollPane = new JScrollPane((Component)this.jTable);
        this.m_oScrollPane.setPreferredSize(new Dimension(576, 397));
        this.m_oScrollPane.setMinimumSize(new Dimension(576, 397));
        this.m_oScrollPane.setMaximumSize(new Dimension(576, 397));
        GridBagConstraints areaGrdBagConsts = new GridBagConstraints(0, 0, 6, 5, 1.0, 1.0, 10, 1, new Insets(2, 12, 12, 12), 0, 0);
        this.add(this.m_oScrollPane, areaGrdBagConsts);
        this.m_oCloseBtnPanel = new JPanel();
        this.m_oCloseBtnPanel.setPreferredSize(new Dimension(350, 40));
        this.m_oCloseBtnPanel.setMinimumSize(new Dimension(350, 40));
        this.m_oCloseBtnPanel.setName("ViewTableResultDlg_m_oCloseBtnPanel");
        GridBagLayout layout = new GridBagLayout();
        this.m_oCloseBtnPanel.setLayout(layout);
        this.m_oOKBtn.setName("ViewTableResultDlg_m_oOKBtn");
        this.m_oOKBtn.setText(ResourceManager.getInstance().getResString("GENERATE_REPORT_BTN"));
        this.m_oOKBtn.setVerticalTextPosition(3);
        this.m_oOKBtn.setPreferredSize(BUTTON_DIMENSION1);
        this.m_oOKBtn.setMinimumSize(BUTTON_DIMENSION1);
        this.m_oOKBtn.setMaximumSize(BUTTON_DIMENSION1);
        this.m_oCancelBtn.setName("ViewTableResultDlg_m_oCancelBtn");
        this.m_oCancelBtn.setText(ResourceManager.getInstance().getResString("OK"));
        this.m_oCancelBtn.setVerticalTextPosition(3);
        this.m_oCancelBtn.setPreferredSize(BUTTON_DIMENSION);
        this.m_oCancelBtn.setMinimumSize(BUTTON_DIMENSION);
        this.m_oCancelBtn.setMaximumSize(BUTTON_DIMENSION);
        this.m_oCloseBtnPanel.add((Component)this.m_oOKBtn, new GridBagConstraints(0, 0, 1, 7, 1.0, 1.0, 13, 0, new Insets(0, 12, 12, 12), 0, 0));
        this.m_oCloseBtnPanel.add((Component)this.m_oCancelBtn, new GridBagConstraints(1, 0, 1, 7, 1.0, 1.0, 17, 0, new Insets(0, 12, 12, 12), 0, 0));
        GridBagConstraints oBtnOKGrdBagConsts = null;
        oBtnOKGrdBagConsts = new GridBagConstraints(0, 6, 6, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 12), 0, 0);
        this.add(this.m_oCloseBtnPanel, oBtnOKGrdBagConsts);
        DCHelpManager.getInstance().enableF1HelpKey(this.getContentPane(), this.getCurrentContext());
        this.setResizable(true);
        this.setLocationRelativeTo(DCFrameWorkUtil.getMainFrame());
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    ViewTableResultDlg.this.dispose();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    ViewTableResultDlg.this.dispose();
                }
            }
        });
    }

    @Override
    protected void oKButton_ActionPerformed() {
        DCSaveFileChooser oFileChooserDlg = new DCSaveFileChooser();
        oFileChooserDlg.setFileFilter(7);
        oFileChooserDlg.setTitle(ResourceManager.getInstance().getResString("GENERATE_REPORT_BTN"));
        oFileChooserDlg.setAcceptAllFileFilterUsed(false);
        oFileChooserDlg.setEncodingEnabled(true);
        String fileName = FileUtil.getFileName(this.getTitle() + "_" + StringUtils.getStrNowTime("yyyyMMddHHmmss"));
        oFileChooserDlg.setDefaultFileName(fileName);
        int iReturnVal = -1;
        iReturnVal = oFileChooserDlg.showSaveDialog((Component)((Object)this));
        if (iReturnVal != 0) {
            return;
        }
        String strFileName = oFileChooserDlg.getFullFileName();
        if (strFileName.toLowerCase(DCResourceMng.getInstance().getLocale()).endsWith(".html") || strFileName.toLowerCase(DCResourceMng.getInstance().getLocale()).endsWith(".htm") || strFileName.toLowerCase(DCResourceMng.getInstance().getLocale()).endsWith(".txt") || strFileName.toLowerCase(DCResourceMng.getInstance().getLocale()).endsWith(".csv")) {
            this.saveRecords(strFileName, oFileChooserDlg.getUserEncoding());
        } else {
            DCOptionPane.showMessageDialog((Component)((Object)this), ResourceManager.getInstance().getResString("TASK_STATISTICS_TABLE_FILE_TYPE_NOT_SUPP"), ResourceManager.getInstance().getResString("ERROR_MESSAGE"), 0);
        }
    }

    private void saveRecords(final String strFileName, final String strEncoding) {
        final String title = this.getTitle();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String strUserName;
                DCTablePrintable printable = null;
                String strHeader = title;
                Vector tableData = new Vector();
                String fileHeader = null;
                fileHeader = strUserName = DCFrameWorkUtil.getUserName();
                int iRowCount = ViewTableResultDlg.this.jTable.getRowCount();
                int iColumnCount = ViewTableResultDlg.this.resultTableHeader.length;
                tableData = ViewTableResultDlg.this.tableDataVec(iRowCount, iColumnCount);
                try {
                    printable = new DCTablePrintable(strHeader, fileHeader, " ", ViewTableResultDlg.this.resultTableHeader, tableData, tableData.size(), true);
                }
                catch (Exception ex) {
                    DCDebugTracer.trace(ex);
                    return;
                }
                String strFileType = null;
                strFileType = strFileName.toLowerCase(DCResourceMng.getInstance().getLocale()).endsWith(".html") || strFileName.toLowerCase(DCResourceMng.getInstance().getLocale()).endsWith(".htm") || strFileName.endsWith(".HTML") || strFileName.endsWith(".HTM") ? "html" : (strFileName.toLowerCase(DCResourceMng.getInstance().getLocale()).endsWith(".csv") ? "csv" : "txt");
                boolean bSaveSuccess = false;
                try {
                    bSaveSuccess = DCPrintSupportor.saveToFileNoCheck((JFrame)DCFrameWorkUtil.getMainFrame(), (String)strFileName, (TablePrintable)printable, (String)strFileType, (String)strEncoding);
                }
                catch (Exception e) {
                    DCDebugTracer.trace(e);
                }
                if (bSaveSuccess) {
                    DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("SAVE_SUCCESS"), ResourceManager.getInstance().getResString("INFO"), 1);
                } else {
                    DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("SAVE_FAILURE"), ResourceManager.getInstance().getResString("ERROR_MESSAGE"), 0);
                }
            }
        });
    }

    private Vector tableDataVec(int iRowCount, int iColumnCount) {
        Vector tableData = new Vector();
        for (int i = 0; i < iRowCount; ++i) {
            Vector<String> rowData = new Vector<String>();
            for (int j = 0; j < iColumnCount; ++j) {
                if (null != this.jTable.getValueAt(i, j) && !this.jTable.getValueAt(i, j).equals("")) {
                    rowData.add(this.jTable.getValueAt(i, j).toString());
                    continue;
                }
                rowData.add(" ");
            }
            tableData.add(rowData);
        }
        return tableData;
    }

    public DefaultTableModel getDataModel() {
        return this.dataModel;
    }

    public JTable getTable() {
        return this.jTable;
    }

    public String[] getTableHeader() {
        return this.resultTableHeader;
    }

    private void setTableHeader(String[] resultTableHeaderParm) {
        this.resultTableHeader = resultTableHeaderParm;
        this.resultTableHeader[0] = "ID";
    }

    @Override
    protected String getCurrentContext() {
        return "HELP_TOPIC_TASK_VIEW_COMMAND_BACK_INFO";
    }

    class DetailTableRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        DetailTableRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int iRow, int iCol) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, iRow, iCol);
            label.setOpaque(true);
            Object oValue = ViewTableResultDlg.this.dataModel.getDataVector().elementAt(iRow);
            boolean bNeedToRed = false;
            label.setForeground(Color.BLACK);
            if (oValue instanceof Vector) {
                Vector row = (Vector)oValue;
                for (int i = 0; i < row.size(); ++i) {
                    String str = ((String)row.get(i)).trim().toUpperCase();
                    if (!"(YES)".equals(str)) continue;
                    bNeedToRed = true;
                }
                if (bNeedToRed) {
                    label.setForeground(ViewTableResultDlg.this.redColor);
                }
                if (isSelected) {
                    label.setForeground(Color.WHITE);
                }
            }
            label.setToolTipText(ViewTableResultDlg.tipHtmlStrStart + label.getText() + ViewTableResultDlg.tipHtmlStrEnd);
            return label;
        }
    }
}

