/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.components.dialog;

import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.components.dialog.ProgressDlg;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCOptionPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.KeyStroke;

public class SimpleProgressDlg
extends ProgressDlg {
    private static final long serialVersionUID = 3729050077792242787L;
    private Component m_window = DCFrameWorkUtil.getMainFrame();
    boolean m_bIsRoll = false;
    ImageIcon m_RollIcon = null;
    protected JButton m_cancelRollBtn = null;
    private ActionListener m_oEscKeyHandler;
    private KeyStroke m_oEscKeyStroke;
    private JLabel ProgressLabel = null;

    public SimpleProgressDlg() {
        this.setDefaultCloseOperation(2);
    }

    public SimpleProgressDlg(String strTitle, String strMessage, boolean bIsIndeterminate) {
        this.jInit(strTitle, strMessage, bIsIndeterminate);
    }

    public SimpleProgressDlg(String strTitle, String strMessage, boolean bIsIndeterminate, DCModalDialog dialog) {
        super(dialog);
        this.m_window = dialog;
        this.jInit(strTitle, strMessage, bIsIndeterminate);
    }

    public SimpleProgressDlg(String strTitle, boolean bIsRoll) {
        super(bIsRoll);
        this.jInit(strTitle, bIsRoll, ResourceManager.getInstance().getResString("WAIT_FOR_NEXT_ACTION"));
    }

    public SimpleProgressDlg(String strTitle, boolean bIsRoll, String sPrompt) {
        super(bIsRoll);
        this.jInit(strTitle, bIsRoll, sPrompt);
    }

    public SimpleProgressDlg(String strTitle, boolean bIsRoll, DCModalDialog dialog, String strProgressLabel, boolean bUseDefaultLabel) {
        super(dialog, bIsRoll);
        this.m_window = dialog;
        if (!bUseDefaultLabel || null == strProgressLabel) {
            strProgressLabel = ResourceManager.getInstance().getResString("WAIT_FOR_NEXT_ACTION");
        }
        this.jInit(strTitle, bIsRoll, strProgressLabel);
    }

    private void jInit(String strTitle, boolean bIsRoll, String sPrompt) {
        this.setSize(378, 90);
        this.setResizable(false);
        this.setLocationRelativeTo(DCFrameWorkUtil.getMainFrame());
        this.getContentPane().setLayout(new GridBagLayout());
        if (bIsRoll) {
            this.m_bIsRoll = bIsRoll;
            this.ProgressLabel = new JLabel(sPrompt);
            JLabel ProressLbl = new JLabel();
            this.m_RollIcon = ResourceManager.getInstance().getImage("wait_for_next.gif");
            ProressLbl.setIcon(this.m_RollIcon);
            ProressLbl.setPreferredSize(new Dimension(255, 21));
            ProressLbl.setMinimumSize(new Dimension(255, 21));
            this.getContentPane().add((Component)this.ProgressLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 12, 0, 12), 0, 0));
            this.getContentPane().add((Component)ProressLbl, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 12, 0, 12), 0, 0));
            this.initializeCancelRollBtn();
            this.registerCancelRollBtnListener();
            this.getContentPane().add((Component)this.m_cancelRollBtn, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 12, 0, 12), 0, 0));
            this.m_oEscKeyHandler = this.createActionListenerForEscape();
            this.m_oEscKeyStroke = KeyStroke.getKeyStroke(27, 0);
            this.registerKeyBoardActionFor(this.m_oEscKeyStroke, this.m_oEscKeyHandler);
        }
        if (null != strTitle) {
            this.setTitle(strTitle);
        }
    }

    private void registerKeyBoardActionFor(KeyStroke oKeyStroke, ActionListener oKeyHandler) {
        this.rootPane.registerKeyboardAction(oKeyHandler, oKeyStroke, 2);
    }

    @Override
    protected ActionListener createActionListenerForEscape() {
        ActionListener oEscKeyHandler = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int confirm = DCOptionPane.showConfirmDialog(SimpleProgressDlg.this.m_window, ResourceManager.getInstance().getResString("CONFIRM_VERSION_EXIT"), ResourceManager.getInstance().getResString("CONFIRM"), 0);
                if (confirm == 0) {
                    SimpleProgressDlg.this.cancelButtonActionPerformed();
                    SimpleProgressDlg.this.doCleanUp();
                }
            }
        };
        return oEscKeyHandler;
    }

    protected void initializeCancelRollBtn() {
        this.m_cancelRollBtn = new JButton(ResourceManager.getInstance().getResString("CANCEL_BUTTON"));
        this.m_cancelRollBtn.setName("Components_ProgressDlg_m_cancelBtn");
        this.m_cancelRollBtn.setPreferredSize(new Dimension(80, 21));
        this.m_cancelRollBtn.setMinimumSize(new Dimension(80, 21));
    }

    protected void registerCancelRollBtnListener() {
        this.m_cancelRollBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleProgressDlg.this.cancelRollBtnActionPerformed();
            }
        });
    }

    protected void cancelRollBtnActionPerformed() {
        int confirm = DCOptionPane.showConfirmDialog(this.m_window, ResourceManager.getInstance().getResString("CONFIRM_VERSION_EXIT"), ResourceManager.getInstance().getResString("CONFIRM"), 0);
        if (confirm == 0) {
            this.cancelButtonActionPerformed();
            this.doCleanUp();
        }
    }

    private void jInit(String strTitle, String strMessage, boolean bIsIndeterminate) {
        this.setDefaultCloseOperation(2);
        this.setSize(500, 105);
        this.setParentDefault(false);
        if (bIsIndeterminate) {
            this.m_progressBar.setStringPainted(false);
            this.m_progressBar.setIndeterminate(true);
        }
        this.m_cancelBtn.setBounds(382, 45, 100, 21);
        if (null != strTitle) {
            this.setTitle(strTitle);
        }
        if (null != strMessage) {
            this.setSize(500, 125);
            this.m_progressBar.setBounds(12, 32, 470, 21);
            this.m_cancelBtn.setBounds(382, 66, 100, 21);
            JLabel oLabel = new JLabel(strMessage);
            oLabel.setBounds(12, 6, 470, 24);
            this.getContentPane().add(oLabel);
        }
    }

    @Override
    protected void setTable() {
    }

    @Override
    protected void initializeBtns() {
        this.initializeCancelBtn();
    }

    @Override
    protected void addListeners() {
        this.registerCancelBtnListener();
    }

    @Override
    protected void addComponentsToContainer() {
        if (this.m_bIsRoll) {
            return;
        }
        this.getContentPane().add((Component)this.m_progressBar, null);
        this.getContentPane().add((Component)this.m_cancelBtn, null);
    }

    @Override
    protected void cancelButtonActionPerformed() {
    }

    @Override
    protected void showConfirmationDialog() {
        int confirm = DCOptionPane.showConfirmDialog(this.m_window, ResourceManager.getInstance().getResString("CONFIRM_VERSION_EXIT"), ResourceManager.getInstance().getResString("CONFIRM"), 0);
        if (confirm == 0) {
            this.cancelButtonActionPerformed();
            this.doCleanUp();
        } else {
            this.setDefaultCloseOperation(0);
        }
    }

    public JButton getcancelRollBtn() {
        return this.m_cancelRollBtn;
    }

    @Override
    public void doCleanUp() {
        this.dispose();
    }
}

