/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.components.dialog;

import com.huawei.dc.adapter.swimap.iview.commstyle.resource.DCResourceMng;
import com.huawei.dc.common.components.dialog.ReportSaveFileFilter;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCFileChooser;
import com.huawei.dc.common.util.DCOptionPane;
import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.util.GregorianCalendar;

public class SaveasFileChooser
extends DCFileChooser {
    private static final long serialVersionUID = 1231544224067373486L;
    private boolean isCloseDialog = false;

    public SaveasFileChooser(Frame oFrame, String strDefaultName, String strFilePath) {
        super(strFilePath);
        this.m_strBackupFileName = strFilePath;
        this.setTitle(strDefaultName);
    }

    public String getFileName() {
        if (null == this.getSelectedFile()) {
            return null;
        }
        String strFileName = this.getSelectedFile().getAbsolutePath();
        if (this.getReturnValue() == 1) {
            strFileName = null;
            return strFileName;
        }
        String strFullFileName = this.m_strBackupFileName.substring(this.m_strBackupFileName.lastIndexOf(File.separatorChar) + 1);
        int index = strFullFileName.lastIndexOf(".");
        String strBackupFileExtension = "";
        strBackupFileExtension = index == -1 ? "" : strFullFileName.substring(index + 1);
        if (strFileName.indexOf(strBackupFileExtension) == -1 && strBackupFileExtension.length() != 0) {
            strFileName = strFileName + "." + strBackupFileExtension;
        }
        return strFileName;
    }

    protected String getFileType(String strFileName) {
        String strFullFileName = this.m_strBackupFileName.substring(this.m_strBackupFileName.lastIndexOf(File.separatorChar) + 1);
        int index = strFullFileName.lastIndexOf(".");
        String strBackupFileExtension = "";
        strBackupFileExtension = index == -1 ? "" : strFullFileName.substring(index + 1);
        if (strFullFileName.lastIndexOf(".") == -1 && strBackupFileExtension.length() != 0) {
            strFullFileName = strFullFileName + "." + strBackupFileExtension;
        }
        this.isCloseDialog = SaveasFileChooser.isValidFileNameAndType((Component)((Object)this), strFileName, strBackupFileExtension);
        return strBackupFileExtension;
    }

    public static boolean isValidFileNameAndType(Component oWindow, String strFileName, String strFileType) {
        if (strFileName.lastIndexOf(".") == -1 && strFileType.length() != 0) {
            strFileName = strFileName + "." + strFileType;
        }
        if (!SaveasFileChooser.isFileNameValid(strFileName)) {
            DCOptionPane.showMessageDialog(oWindow, ResourceManager.getInstance().getResString("PRINT_FILENAME_ERROR"), ResourceManager.getInstance().getResString("ERROR_MESSAGE"), 0);
            return false;
        }
        File oFile = new File(strFileName);
        if (oFile.exists()) {
            if (oFile.canWrite()) {
                int iOption = DCOptionPane.showConfirmDialog(oWindow, ResourceManager.getInstance().getResString("PRINT_COVER_FILE"), ResourceManager.getInstance().getResString("PRINT_CONFIRM_TITLE"), 0);
                if (iOption != 0) {
                    return false;
                }
            } else {
                DCOptionPane.showMessageDialog(oWindow, ResourceManager.getInstance().getResString("PRINT_READ_ONLY"), ResourceManager.getInstance().getResString("DEVICE_VERSION_SAVE_BTN"), 0);
                return false;
            }
        }
        if (!oFile.getParentFile().canWrite()) {
            DCOptionPane.showMessageDialog(oWindow, ResourceManager.getInstance().getResString("PRINT_NO_WRITE_PERMISSION"), ResourceManager.getInstance().getResString("DEVICE_VERSION_SAVE_BTN"), 0);
            return false;
        }
        return true;
    }

    public static boolean isFileNameValid(String strFileName) {
        File oFile = new File(strFileName);
        strFileName = oFile.getName();
        String[] strIllegalCharArr = new String[]{":", "/", "\"", "<", ">", "|", "?", "*"};
        for (int i = 0; i < strIllegalCharArr.length; ++i) {
            if (strFileName.indexOf(strIllegalCharArr[i]) == -1) continue;
            return false;
        }
        return true;
    }

    public void setFileName(String strDefaultName, boolean isAddExtFilter) {
        if (!isAddExtFilter) {
            super.setCurrentDirectory(new File(strDefaultName));
            return;
        }
        if ("".equals(strDefaultName)) {
            return;
        }
        StringBuffer strDefultFileName = new StringBuffer();
        strDefultFileName.append(strDefaultName);
        strDefultFileName.append("_");
        GregorianCalendar oCurrDate = new GregorianCalendar();
        strDefultFileName.append(oCurrDate.get(1));
        String strCurrMonth = Integer.valueOf(oCurrDate.get(2) + 1).toString();
        if (strCurrMonth.length() < 2) {
            strCurrMonth = "0" + strCurrMonth;
            strDefultFileName.append(strCurrMonth);
        } else {
            strDefultFileName.append(strCurrMonth);
        }
        String strCurrDate = Integer.valueOf(oCurrDate.get(5)).toString();
        if (strCurrDate.length() < 2) {
            strCurrDate = "0" + strCurrDate;
            strDefultFileName.append(strCurrDate);
        } else {
            strDefultFileName.append(strCurrDate);
        }
        String strCurrHour = Integer.valueOf(oCurrDate.get(11)).toString();
        if (strCurrHour.length() < 2) {
            strCurrHour = "0" + strCurrHour;
            strDefultFileName.append(strCurrHour);
        } else {
            strDefultFileName.append(strCurrHour);
        }
        String strCurrMin = Integer.valueOf(oCurrDate.get(12)).toString();
        if (strCurrMin.length() < 2) {
            strCurrMin = "0" + strCurrMin;
            strDefultFileName.append(strCurrMin);
        } else {
            strDefultFileName.append(strCurrMin);
        }
        String strCurrSecond = Integer.valueOf(oCurrDate.get(13)).toString();
        if (strCurrSecond.length() < 2) {
            strCurrSecond = "0" + strCurrSecond;
            strDefultFileName.append(strCurrSecond);
        } else {
            strDefultFileName.append(strCurrSecond);
        }
        super.setCurrentDirectory(new File(strDefultFileName.toString()));
        String strFileName = this.m_strBackupFileName.substring(this.m_strBackupFileName.lastIndexOf(File.separatorChar) + 1);
        int index = strFileName.lastIndexOf(".");
        int iFileExtnIndex = this.m_strBackupFileName.lastIndexOf(".");
        String strBackupFileExtension = "";
        strBackupFileExtension = index == -1 ? "" : this.m_strBackupFileName.substring(iFileExtnIndex + 1);
        ReportSaveFileFilter oFileFilter = new ReportSaveFileFilter(new String[]{strBackupFileExtension}, strBackupFileExtension.toUpperCase(DCResourceMng.getInstance().getLocale()) + " " + ResourceManager.getInstance().getResString("HELP_FRAME_FILE"));
        this.setFileFilter(oFileFilter);
    }

    public void setFileName(String strDefaultName) {
        this.setFileName(strDefaultName, true);
    }
}

