/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.components.dialog;

import com.huawei.dc.common.components.dialog.ProgressDlg;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.taskmgmt.report.tasklevel.bean.TaskReportFileInfo;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.JButton;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ReportProgressDlg
extends ProgressDlg {
    private static final long serialVersionUID = -6146727476181458410L;

    public ReportProgressDlg(String reportName, String opeName) {
        super(reportName, opeName);
    }

    protected void initOpenFolderBtn() {
        String OPEN_FOLDER_ACTION = "openFolder";
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String strCmd = e.getActionCommand();
                if ("openFolder".equals(strCmd)) {
                    int index = ReportProgressDlg.this.m_oResultTable.getSelectedRow();
                    List taskRepFlLst = (List)ReportProgressDlg.this.getUserObject();
                    if (null == taskRepFlLst || index < 0) {
                        return;
                    }
                    TaskReportFileInfo fileInfo = (TaskReportFileInfo)taskRepFlLst.get(index);
                    String sFileName = ReportProgressDlg.this.generateFileName(fileInfo);
                    ReportProgressDlg.this.openPath(sFileName);
                }
            }
        };
        this.openFolderBtn = new JButton();
        String openText = ResourceManager.getInstance().getResString("GENERATE_TASK_REPORT_OPEN_BTN");
        this.openFolderBtn.setText(openText);
        if (StringUtils.isWinSystem()) {
            this.openFolderBtn.setToolTipText(ResourceManager.getInstance().getResString("GENERATE_TASK_REPORT_OPEN_FILE"));
        } else {
            this.openFolderBtn.setToolTipText(ResourceManager.getInstance().getResString("GENERATE_TASK_REPORT_OPEN_FOLDER"));
        }
        this.openFolderBtn.addActionListener(listener);
        this.openFolderBtn.setMnemonic('O');
        this.openFolderBtn.setName("Components_ProgressDlg_openFolderBtn");
        this.openFolderBtn.setBounds(268, 50, 100, 21);
        this.openFolderBtn.setActionCommand("openFolder");
        this.openFolderBtn.setEnabled(false);
    }

    @Override
    protected void addComponentsToContainer() {
        this.getContentPane().add((Component)this.m_progressBar, null);
        this.getContentPane().add((Component)this.m_closeBtn, null);
        this.initOpenFolderBtn();
        this.getContentPane().add((Component)this.openFolderBtn, null);
        this.m_oResultTable.getSelectionModel().addListSelectionListener(new TableSelectionListener());
        this.getContentPane().add((Component)this.m_oScrollPane, null);
    }

    private void changeButtonStatus() {
        if (null == this.openFolderBtn) {
            return;
        }
        int index = this.m_oResultTable.getSelectedRowCount();
        if (!StringUtils.isWinSystem() || 1 != index) {
            this.openFolderBtn.setEnabled(false);
        } else {
            this.openFolderBtn.setEnabled(true);
        }
    }

    private String generateFileName(TaskReportFileInfo fileInfo) {
        if (null == fileInfo) {
            return "";
        }
        String sFilePath = fileInfo.getFilePath();
        String sFielName = fileInfo.getFileName();
        if (StringUtils.isWinSystem()) {
            if (sFilePath.endsWith("\\")) {
                return sFilePath + sFielName + ".xls";
            }
            return sFilePath + File.separator + sFielName + ".xls";
        }
        return sFilePath + File.separator + sFielName;
    }

    protected void openPath(String strPath) {
        DCDebugTracer.trace("open task report file " + strPath);
        String[] execString = new String[2];
        String filePath = null;
        if (StringUtils.isWinSystem()) {
            execString[0] = "explorer";
            try {
                filePath = strPath.replace("/", "\\");
            }
            catch (Exception ex) {
                DCDebugTracer.traceError(ex.getMessage());
                filePath = strPath;
            }
        } else {
            execString[0] = "netscape";
            filePath = strPath;
        }
        execString[1] = filePath;
        try {
            Runtime.getRuntime().exec(execString);
        }
        catch (Exception ex) {
            DCDebugTracer.trace("failed to open task report file");
            DCDebugTracer.traceError(ex.getMessage());
            return;
        }
    }

    @Override
    public void updateProgress(int iProgress) {
        ListSelectionModel oSelectionModel = this.m_oResultTable.getSelectionModel();
        int iSelectedRow = this.m_oResultTable.getRowCount() - 1;
        oSelectionModel.setSelectionInterval(iSelectedRow, iSelectedRow);
        super.updateProgress(iProgress);
        if (100 == iProgress) {
            this.openFolderBtn.setEnabled(true);
        } else {
            this.openFolderBtn.setEnabled(false);
        }
        this.changeButtonStatus();
    }

    class TableSelectionListener
    implements ListSelectionListener {
        TableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent arg) {
            if (arg.getValueIsAdjusting()) {
                ReportProgressDlg.this.changeButtonStatus();
            }
        }
    }
}

