/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.components.dialog;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnDCSyncCancelReq;
import com.huawei.dc.common.asndatacenter.AsnDCSyncRsp;
import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.components.table.renderer.TooltipHeader;
import com.huawei.dc.common.controller.BaseCommManager;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCCommonUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCHelpForErrCodeUtil;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.ErrorInfo;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.taskmgmt.view.createtask.ViewCommandResultDialog;
import com.swimap.iview.util.SyncCommand;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import net.commustru.fstru.FStruct;

public class ProgressDlg
extends DCModalDialog {
    private static final long serialVersionUID = 1L;
    protected JTable m_oResultTable = null;
    protected DefaultTableModel m_oDetailsTableModel = null;
    protected JScrollPane m_oScrollPane = null;
    private boolean m_bShowDetail = false;
    protected JButton m_detailsBtn = null;
    protected JButton m_closeBtn = null;
    protected JButton m_cancelBtn = null;
    protected JButton openFolderBtn = null;
    protected JProgressBar m_progressBar = null;
    protected int m_iProgressdDlgId = -1;
    protected int m_iNeedAddHeight = 0;
    protected JLabel m_DesProgressLabel = null;
    protected int m_iCommandCode = -1;
    protected List m_oDeviceIds = null;
    protected boolean m_bCancelOpPerformed = false;
    private String[] strColumnNames = null;
    private Component m_window = DCFrameWorkUtil.getMainFrame();
    private HashMap<Integer, String> m_oBoardInfoMap;
    private Object userObject = null;

    public void setCommandCode(int iCommandCode) {
        this.m_iCommandCode = iCommandCode;
    }

    public void setDeviceIds(List oDeviceIds) {
        this.m_oDeviceIds = oDeviceIds;
    }

    public ProgressDlg() {
        super(DCFrameWorkUtil.getMainFrame(), true);
        this.setTable();
        this.jbInit();
    }

    public ProgressDlg(boolean IsRoll) {
        super(DCFrameWorkUtil.getMainFrame(), true);
        if (IsRoll) {
            this.jbInit(IsRoll);
        }
    }

    private void jbInit(boolean IsRoll) {
        if (IsRoll) {
            this.initializeDialog();
            this.setDefaultCloseOperation(0);
        }
    }

    public ProgressDlg(String strColumnName1, String strColumnName2) {
        super(DCFrameWorkUtil.getMainFrame(), true);
        String[] columnNames = new String[]{strColumnName1, strColumnName2};
        this.strColumnNames = columnNames;
        this.setTable();
        this.jbInit();
    }

    public ProgressDlg(String strColumnName1, String strColumnName2, JLabel ProgressLbl, int iNeedAddHeight) {
        super(DCFrameWorkUtil.getMainFrame(), true);
        if (null != ProgressLbl && iNeedAddHeight != 0) {
            this.m_iNeedAddHeight = iNeedAddHeight;
            this.m_DesProgressLabel = ProgressLbl;
        }
        String[] columnNames = new String[]{strColumnName1, strColumnName2};
        this.strColumnNames = columnNames;
        this.setTable();
        this.jbInit();
    }

    public ProgressDlg(int iCommandCode) {
        super(DCFrameWorkUtil.getMainFrame(), true);
        this.m_iCommandCode = iCommandCode;
        this.setTable();
        this.jbInit();
    }

    public ProgressDlg(int iCommandCode, JLabel ProgressLbl, int iNeedAddHeight) {
        super(DCFrameWorkUtil.getMainFrame(), true);
        if (null != ProgressLbl && iNeedAddHeight != 0) {
            this.m_iNeedAddHeight = iNeedAddHeight;
            this.m_DesProgressLabel = ProgressLbl;
        }
        this.m_iCommandCode = iCommandCode;
        this.setTable();
        this.jbInit();
    }

    public ProgressDlg(DCModalDialog parentDlg, int iCommandCode) {
        super(parentDlg, true);
        this.m_iCommandCode = iCommandCode;
        this.setTable();
        this.jbInit();
    }

    public ProgressDlg(int iCommandCode, int[] iArrDevIds) {
        super(DCFrameWorkUtil.getMainFrame(), true);
        this.m_iCommandCode = iCommandCode;
        int iSelecDevCount = iArrDevIds.length;
        this.m_oDeviceIds = new ArrayList(0);
        for (int i = 0; i < iSelecDevCount; ++i) {
            this.m_oDeviceIds.add(iArrDevIds[i]);
        }
        this.setTable();
        this.jbInit();
    }

    public ProgressDlg(int iCommandCode, int[] iArrDevIds, String[] strColumns) {
        super(DCFrameWorkUtil.getMainFrame(), true);
        this.m_iCommandCode = iCommandCode;
        int iSelecDevCount = iArrDevIds.length;
        this.m_oDeviceIds = new ArrayList(0);
        for (int i = 0; i < iSelecDevCount; ++i) {
            this.m_oDeviceIds.add(iArrDevIds[i]);
        }
        this.strColumnNames = strColumns;
        this.setTable();
        this.jbInit();
    }

    public ProgressDlg(int iCommandCode, List oDeviceIds, HashMap<Integer, String> oBoardInfoMap) {
        super(DCFrameWorkUtil.getMainFrame(), true);
        this.m_iCommandCode = iCommandCode;
        this.m_oDeviceIds = oDeviceIds;
        this.m_oBoardInfoMap = oBoardInfoMap;
        this.setTable();
        this.jbInit();
    }

    public ProgressDlg(DCModalDialog dialog) {
        super(dialog, true);
        this.m_window = dialog;
        this.setTable();
        this.jbInit();
    }

    public ProgressDlg(DCModalDialog dialog, boolean IsRoll) {
        super(dialog, IsRoll);
        this.m_window = dialog;
        this.jbInit(IsRoll);
    }

    public void setProgressDlgId(int iProgressDlgId) {
        this.m_iProgressdDlgId = iProgressDlgId;
    }

    public int getProgressDlgId() {
        return this.m_iProgressdDlgId;
    }

    protected void setTable() {
        this.initializeTableModel();
        this.initializeTable();
        this.initializeScrollPane();
        for (int i = 0; i < this.strColumnNames.length; ++i) {
            this.setColumnRenderer(i);
        }
        this.addKeyListenerToTable();
    }

    protected void initializeTableModel() {
        if (this.strColumnNames == null) {
            this.strColumnNames = this.getTableColumnNames();
        }
        this.m_oDetailsTableModel = new DefaultTableModel(this.strColumnNames, 0){

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
    }

    private void addKeyListenerToTable() {
        this.m_oResultTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                ProgressDlg.this.keypressActionEvent(e);
            }
        });
    }

    protected void keypressActionEvent(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            if (this.m_cancelBtn.isEnabled()) {
                int confirm = DCOptionPane.showConfirmDialog(this.m_window, ResourceManager.getInstance().getResString("CONFIRM_VERSION_EXIT"), ResourceManager.getInstance().getResString("CONFIRM"), 0);
                if (confirm == 0) {
                    this.cancelButtonActionPerformed();
                    this.doCleanUp();
                }
            } else {
                this.doCleanUp();
            }
        }
    }

    private void initializeScrollPane() {
        this.m_oScrollPane = new JScrollPane(this.m_oResultTable);
        Border border1 = BorderFactory.createEtchedBorder();
        this.m_oScrollPane.setBorder(border1);
        this.m_oScrollPane.setBounds(12, 83 + this.m_iNeedAddHeight, 470, 119);
    }

    private void initializeTable() {
        this.m_oResultTable = new JTable(this.m_oDetailsTableModel);
        this.m_oResultTable.setName("Components_ProgressDlg_m_oResultTable");
        this.m_oResultTable.getTableHeader().setPreferredSize(new Dimension(this.m_oResultTable.getSize().width, 21));
        this.m_oResultTable.setRowHeight(21);
        TooltipHeader tableHeader = new TooltipHeader(this.m_oResultTable.getColumnModel(), this.strColumnNames);
        tableHeader.setReorderingAllowed(false);
        this.m_oResultTable.setTableHeader(tableHeader);
    }

    protected String[] getTableColumnNames() {
        String[] columnNames = new String[]{ResourceManager.getInstance().getResString("DEVICE_NAME"), ResourceManager.getInstance().getResString("OPERATE_RESULT")};
        return columnNames;
    }

    private void jbInit() {
        this.setDefaultCloseOperation(2);
        this.initializeDialog();
        this.initializeComponents();
        if (43829 == this.m_iCommandCode) {
            ActionListener escKeyHandler = this.implementEscKeyEvent();
            KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
            this.rootPane.registerKeyboardAction(escKeyHandler, keyStroke, 2);
        }
        this.addListeners();
        this.addComponentsToContainer();
        this.setDefaultCloseOperation(0);
    }

    private ActionListener implementEscKeyEvent() {
        ActionListener escKeyHandler = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                this.checkCancelBtnStatus();
            }

            private void checkCancelBtnStatus() {
                if (ProgressDlg.this.m_cancelBtn.isEnabled()) {
                    this.showConfirmToExitMsg();
                } else {
                    ProgressDlg.this.doCleanUp();
                }
            }

            private void showConfirmToExitMsg() {
                int confirm = DCOptionPane.showConfirmDialog(ProgressDlg.this.m_window, ResourceManager.getInstance().getResString("CONFIRM_VERSION_EXIT"), ResourceManager.getInstance().getResString("CONFIRM"), 0);
                if (confirm == 0) {
                    ProgressDlg.this.cancelButtonActionPerformed();
                    ProgressDlg.this.doCleanUp();
                }
            }
        };
        return escKeyHandler;
    }

    protected void addListeners() {
        this.registerDetailBtnListener();
        this.registerCancelBtnListener();
        this.registerCloseBtnListener();
    }

    private void registerCloseBtnListener() {
        this.m_closeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProgressDlg.this.doCleanUp();
                ToolTipManager.sharedInstance().setEnabled(true);
                ProgressDlg.this.oKButton_ActionPerformed();
            }
        });
    }

    protected void registerCancelBtnListener() {
        this.m_cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int confirm = DCOptionPane.showConfirmDialog(ProgressDlg.this.m_window, ResourceManager.getInstance().getResString("CONFIRM_VERSION_EXIT"), ResourceManager.getInstance().getResString("CONFIRM"), 0);
                if (confirm == 0) {
                    ProgressDlg.this.cancelButtonActionPerformed();
                    ProgressDlg.this.doCleanUp();
                }
            }
        });
    }

    private void registerDetailBtnListener() {
        this.m_detailsBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolTipManager.sharedInstance().setEnabled(true);
                ProgressDlg.this.detailsButtonActionPerformed();
            }
        });
    }

    private void initializeComponents() {
        this.initializeLabel();
        this.initializeBtns();
        this.initializeProgressBar();
    }

    private void initializeProgressBar() {
        this.m_progressBar = new JProgressBar(0, 0, 100);
        this.m_progressBar.setName("Components_ProgressDlg_m_progressBar");
        this.m_progressBar.setBounds(12, 12 + this.m_iNeedAddHeight, 470, 21);
        this.m_progressBar.setBackground(this.getBackground());
        this.m_progressBar.setForeground(new Color(0, 0, 116));
        this.m_progressBar.setValue(0);
        this.m_progressBar.setStringPainted(true);
        this.m_progressBar.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, Color.gray));
    }

    protected void initializeLabel() {
        if (null == this.m_DesProgressLabel) {
            return;
        }
        this.m_DesProgressLabel.setBounds(12, 5, 450, this.m_iNeedAddHeight);
    }

    protected void initializeBtns() {
        this.initializeDetailBtn();
        this.initializeCancelBtn();
        this.initializeCloseBtn();
    }

    protected void initializeCloseBtn() {
        this.m_closeBtn = new JButton(ResourceManager.getInstance().getResString("CLOSE_BUTTON"));
        this.m_closeBtn.setName("Components_ProgressDlg_m_closeBtn");
        this.m_closeBtn.setBounds(382, 50 + this.m_iNeedAddHeight, 100, 21);
        this.m_closeBtn.setEnabled(false);
    }

    protected void initializeCancelBtn() {
        this.m_cancelBtn = new JButton(ResourceManager.getInstance().getResString("CANCEL_BUTTON"));
        this.m_cancelBtn.setName("Components_ProgressDlg_m_cancelBtn");
        this.m_cancelBtn.setBounds(278, 50 + this.m_iNeedAddHeight, 100, 21);
    }

    protected void initializeDetailBtn() {
        this.m_detailsBtn = new JButton(ResourceManager.getInstance().getResString("DETAILS_TEXT_CLOSED"));
        this.m_detailsBtn.setName("Components_ProgressDlg_m_detailsBtn");
        this.m_detailsBtn.setBounds(174, 50 + this.m_iNeedAddHeight, 100, 21);
        this.m_detailsBtn.setMnemonic('D');
    }

    protected void addComponentsToContainer() {
        if (null != this.m_DesProgressLabel) {
            this.getContentPane().add((Component)this.m_DesProgressLabel, null);
        }
        this.getContentPane().add((Component)this.m_closeBtn, null);
        this.getContentPane().add((Component)this.m_cancelBtn, null);
        this.getContentPane().add((Component)this.m_progressBar, null);
        this.getContentPane().add((Component)this.m_detailsBtn, null);
        this.getContentPane().add((Component)this.m_oScrollPane, null);
    }

    private void initializeDialog() {
        this.setSize(500, 108);
        this.setResizable(false);
        this.setLocationRelativeTo(DCFrameWorkUtil.getMainFrame());
        this.getContentPane().setLayout(null);
    }

    private void setColumnRenderer(int iColumn) {
        TableColumnModel oColumnModel = this.m_oResultTable.getColumnModel();
        oColumnModel.getColumn(iColumn).setCellRenderer(new DetailTableRenderer());
    }

    private void detailsButtonActionPerformed() {
        if (!this.isM_bShowDetail()) {
            this.setSize(500, 250 + this.m_iNeedAddHeight);
            this.setM_bShowDetail(true);
            this.m_detailsBtn.setText(ResourceManager.getInstance().getResString("DETAILS_TEXT_OPEN"));
        } else {
            this.setSize(500, 108 + this.m_iNeedAddHeight);
            this.setM_bShowDetail(false);
            this.m_detailsBtn.setText(ResourceManager.getInstance().getResString("DETAILS_TEXT_CLOSED"));
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.validate();
            this.repaint();
            this.getContentPane().repaint();
            this.m_oScrollPane.repaint();
            this.m_cancelBtn.repaint();
            this.m_closeBtn.repaint();
            this.m_detailsBtn.repaint();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProgressDlg.this.validate();
                    ProgressDlg.this.repaint();
                    ProgressDlg.this.getContentPane().repaint();
                    ProgressDlg.this.m_oScrollPane.repaint();
                    ProgressDlg.this.m_cancelBtn.repaint();
                    ProgressDlg.this.m_closeBtn.repaint();
                    ProgressDlg.this.m_detailsBtn.repaint();
                }
            });
        }
    }

    public void setProgress(String strDisplayName, String strOpResult, int iProgress) {
        Vector<String> oRowVector = new Vector<String>(0);
        oRowVector.add(strDisplayName);
        oRowVector.add(strOpResult);
        if (strDisplayName.length() > 0) {
            this.addRowInModel(strDisplayName, strOpResult, oRowVector);
        }
        this.updateProgress(iProgress);
    }

    public void addRowInModel(String strDisplayName, String strOpResult) {
        Vector<String> oRowVector = new Vector<String>(0);
        oRowVector.add(strDisplayName);
        oRowVector.add(strOpResult);
        if (strDisplayName.length() > 0) {
            this.addRowInModel(strDisplayName, strOpResult, oRowVector);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressDlg.this.getContentPane().repaint();
                if (null != ProgressDlg.this.m_oScrollPane) {
                    ProgressDlg.this.m_oScrollPane.repaint();
                }
                ProgressDlg.this.m_cancelBtn.repaint();
                ProgressDlg.this.m_closeBtn.repaint();
            }
        });
    }

    public void setProgress(String strDisplayName, String strOpResult, int iProgress, ErrorInfo oErrorInfo) {
        Vector<Object> oRowVector = new Vector<Object>(0);
        oRowVector.add(strDisplayName);
        oRowVector.add(strOpResult);
        oRowVector.add(oErrorInfo);
        if (strDisplayName.length() > 0) {
            this.addRowInModel(strDisplayName, strOpResult, oRowVector);
        }
        this.updateProgress(iProgress);
    }

    public void updateProgress(final int iProgress) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (100 != ProgressDlg.this.m_progressBar.getValue()) {
                    ProgressDlg.this.m_progressBar.setValue(iProgress);
                }
                if (100 == iProgress) {
                    ProgressDlg.this.m_closeBtn.setEnabled(true);
                    ProgressDlg.this.m_cancelBtn.setEnabled(false);
                }
                ProgressDlg.this.getContentPane().repaint();
                if (null != ProgressDlg.this.m_oScrollPane) {
                    ProgressDlg.this.m_oScrollPane.repaint();
                }
                ProgressDlg.this.m_cancelBtn.repaint();
                ProgressDlg.this.m_closeBtn.repaint();
            }
        });
    }

    public void setProgress(ArrayList rowList, int iProgress) {
        if (100 != this.m_progressBar.getValue()) {
            this.m_progressBar.setValue(iProgress);
        }
        if (rowList.size() > 0) {
            int rowCount = rowList.size();
            for (int i = 0; i < rowCount; ++i) {
                Vector rowRec = (Vector)rowList.get(i);
                this.m_oDetailsTableModel.addRow(rowRec);
            }
        }
        if (100 == iProgress) {
            this.m_closeBtn.setEnabled(true);
            this.m_cancelBtn.setEnabled(false);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressDlg.this.getContentPane().repaint();
                ProgressDlg.this.m_oScrollPane.repaint();
                ProgressDlg.this.m_cancelBtn.repaint();
                ProgressDlg.this.m_closeBtn.repaint();
            }
        });
    }

    public void setProgress(String strDisplayName, String strOpResult, int iProgress, int iDeviceId) {
        if (!this.m_bCancelOpPerformed || 43974 == this.m_iCommandCode) {
            if (this.m_oDeviceIds.contains(iDeviceId)) {
                this.m_oDeviceIds.remove((Object)iDeviceId);
            }
            this.setProgress(strDisplayName, strOpResult, iProgress);
        }
        if (0 >= this.m_oDeviceIds.size()) {
            this.m_cancelBtn.setEnabled(false);
        }
    }

    public void setProgress(String strDisplayName, String strOpResult, int iProgress, int iDeviceId, ErrorInfo oErrorInfo) {
        if (!this.m_bCancelOpPerformed) {
            if (this.m_oDeviceIds.contains(iDeviceId)) {
                this.m_oDeviceIds.remove((Object)iDeviceId);
            }
            this.setProgress(strDisplayName, strOpResult, iProgress, oErrorInfo);
        }
        if (0 >= this.m_oDeviceIds.size()) {
            this.m_cancelBtn.setEnabled(false);
        }
    }

    @Override
    public void doCleanUp() {
        if (this.m_closeBtn.isEnabled()) {
            this.m_oDetailsTableModel.getDataVector().removeAllElements();
            this.dispose();
        }
    }

    protected void cancelButtonActionPerformed() {
        this.m_bCancelOpPerformed = true;
        try {
            this.sendCancelRequest();
            ToolTipManager.sharedInstance().setEnabled(true);
            this.updateDetailsTable();
            this.enableDisableButtons();
        }
        catch (DCException e) {
            return;
        }
    }

    protected void enableDisableButtons() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressDlg.this.m_cancelBtn.setEnabled(false);
                if (43974 != ProgressDlg.this.m_iCommandCode && 43973 != ProgressDlg.this.m_iCommandCode) {
                    ProgressDlg.this.m_closeBtn.setEnabled(true);
                    ProgressDlg.this.m_progressBar.setValue(100);
                }
            }
        });
    }

    protected void updateDetailsTable() {
        if (null == this.m_oDeviceIds || 0 >= this.m_oDeviceIds.size()) {
            return;
        }
        String strOpResult = this.getCancelResult();
        for (int index = 0; index < this.m_oDeviceIds.size(); ++index) {
            int iDeviceId = Integer.parseInt(this.m_oDeviceIds.get(index).toString());
            String strDisplayName = "";
            if (null != this.m_oBoardInfoMap) {
                strDisplayName = this.m_oBoardInfoMap.get(iDeviceId);
            } else {
                IDeviceInfoManager oInfoMgr = this.getDeviceInfoManager();
                DeviceInfo oDeviceInfo = oInfoMgr.getDevice(iDeviceId);
                if (43974 == this.m_iCommandCode && null != this.getRowForDevice(oDeviceInfo)) {
                    return;
                }
                String strDevName = oDeviceInfo.getDevName();
                String strDevIPAdd = oDeviceInfo.getDevIPAddress();
                strDisplayName = strDevName + '(' + strDevIPAdd + ')';
            }
            Vector<String> oRowVector = new Vector<String>(0);
            oRowVector.add(strDisplayName);
            oRowVector.add(strOpResult);
            if (strDisplayName.length() <= 0) continue;
            this.addRowInModel(strOpResult, strDisplayName, oRowVector);
        }
        if (null != this.m_oBoardInfoMap) {
            this.m_oBoardInfoMap.clear();
            this.m_oBoardInfoMap = null;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressDlg.this.repaintPanel();
            }
        });
    }

    protected String getCancelResult() {
        if (43974 == this.m_iCommandCode || 43973 == this.m_iCommandCode) {
            return ResourceManager.getInstance().getResString("OPERATION_IS_BEING_CANCELLED");
        }
        return ResourceManager.getInstance().getResString("OPERATION_CANCELLED");
    }

    protected IDeviceInfoManager getDeviceInfoManager() {
        return DCFrameWorkUtil.getDeviceInfoManager();
    }

    protected void repaintPanel() {
        this.getContentPane().repaint();
        this.m_oScrollPane.repaint();
        this.m_cancelBtn.repaint();
        this.m_closeBtn.repaint();
    }

    private synchronized void addRowInModel(String strOpResult, String strDisplayName, Vector oRowVector) {
        DCDebugTracer.trace("result=" + strOpResult + " displayname=" + strDisplayName);
        oRowVector.add(strDisplayName);
        oRowVector.add(strOpResult);
        this.m_oDetailsTableModel.addRow(oRowVector);
    }

    @Override
    protected void closeDialog() {
        if (null != this.m_cancelBtn && this.m_cancelBtn.isEnabled()) {
            this.showConfirmationDialog();
        } else if (43974 == this.m_iCommandCode || 43973 == this.m_iCommandCode) {
            if (!this.m_closeBtn.isEnabled()) {
                DCOptionPane.showMessageDialog(this.m_window, ResourceManager.getInstance().getResString("OPERATION_IN_PROGRESS_MSG"), ResourceManager.getInstance().getResString("SYSTEM_INFO_ERROR"), 0);
                return;
            }
            this.doCleanUp();
        } else {
            this.doCleanUp();
        }
    }

    protected void showConfirmationDialog() {
        int confirm = DCOptionPane.showConfirmDialog(this.m_window, ResourceManager.getInstance().getResString("CONFIRM_VERSION_EXIT"), ResourceManager.getInstance().getResString("CONFIRM"), 0);
        if (confirm == 0) {
            this.cancelButtonActionPerformed();
            this.doCleanUp();
        } else {
            this.setDefaultCloseOperation(0);
        }
    }

    protected void sendCancelRequest() throws DCException {
        int iErrorCode;
        final BaseCommManager oCommManager = DCFrameWorkUtil.getCommManager();
        final AsnDCSyncCancelReq oAsnCancelReq = new AsnDCSyncCancelReq();
        oAsnCancelReq.oReqID = BigInteger.valueOf(this.m_iProgressdDlgId);
        final AsnDCSyncRsp oAsnDCOpertionRsp = this.getAsnDCOperationRspInstance();
        SyncCommand syncCommand = new SyncCommand(){

            public Object call() throws Exception {
                int iErrorCode = oCommManager.sendSyncMsg(BaseCommManager.getMSGHead(43852), (FStruct)oAsnCancelReq, (FStruct)oAsnDCOpertionRsp);
                return iErrorCode;
            }
        };
        syncCommand.startCall((Component)DCFrameWorkUtil.getMainFrame(), true);
        if (null != syncCommand.getResult() && 0 != (iErrorCode = ((Integer)syncCommand.getResult()).intValue())) {
            throw new DCException(iErrorCode, ResourceManager.getInstance().getResString("SEND_FAIL"));
        }
        if (0 != oAsnDCOpertionRsp.oErrorInfo.iErrorNo.intValue()) {
            throw new DCException(oAsnDCOpertionRsp.oErrorInfo.iErrorNo.intValue(), ResourceManager.getInstance().getResString("CANCEL_REQUEST_FAILED"));
        }
    }

    public AsnDCSyncRsp getAsnDCOperationRspInstance() {
        return new AsnDCSyncRsp();
    }

    boolean isM_bShowDetail() {
        return this.m_bShowDetail;
    }

    protected void setM_bShowDetail(boolean showDetail) {
        this.m_bShowDetail = showDetail;
    }

    public DefaultTableModel getM_oDetailsTableModel() {
        return this.m_oDetailsTableModel;
    }

    public boolean isM_bCancelOpPerformed() {
        return this.m_bCancelOpPerformed;
    }

    public void setM_bCancelOpPerformed(boolean cancelOpPerformed) {
        this.m_bCancelOpPerformed = cancelOpPerformed;
    }

    public void showDetailInfo() {
        this.detailsButtonActionPerformed();
    }

    public Vector<String> getRowForDevice(DeviceInfo oDeviceInfo) {
        Vector<Vector> oDataVector = this.m_oDetailsTableModel.getDataVector();
        int iRowCount = this.m_oDetailsTableModel.getRowCount();
        StringBuffer strDeviceDetail = new StringBuffer(0);
        strDeviceDetail.append(oDeviceInfo.getDevName());
        strDeviceDetail.append('(');
        strDeviceDetail.append(oDeviceInfo.getDevIPAddress());
        strDeviceDetail.append(')');
        for (int i = 0; i < iRowCount; ++i) {
            String strDevInfo;
            Vector oRow = oDataVector.get(i);
            if (null == oRow || null == (strDevInfo = (String)oRow.get(0)) || !strDevInfo.equalsIgnoreCase(strDeviceDetail.toString())) continue;
            return oRow;
        }
        return null;
    }

    private Component renderColumn(JTable table, Object value, boolean isSelected, JLabel label, ErrorInfo oErrorInfo) {
        if (isSelected) {
            this.setLabelWhenColumnIsSelected(table, label);
        } else {
            this.setLabelWhenColumnIsNotSelected(table, label);
        }
        if (null != value) {
            this.setLabelWhenColumnValueIsNull(value, label, oErrorInfo);
        }
        label.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, Color.gray));
        return label;
    }

    private void setLabelWhenColumnIsSelected(JTable table, JLabel label) {
        label.setBackground(table.getSelectionBackground());
        label.setForeground(Color.white);
    }

    private void setLabelWhenColumnIsNotSelected(JTable table, JLabel label) {
        label.setBackground(table.getBackground());
        label.setForeground(table.getForeground());
    }

    private void setLabelWhenColumnValueIsNull(Object value, JLabel label, ErrorInfo oErrorInfo) {
        String strLabelText = value.toString();
        if (null != oErrorInfo) {
            strLabelText = DCCommonUtil.getFailureStr("", oErrorInfo.getErrorCode());
        }
        label.setText(strLabelText);
        label.setToolTipText(value.toString());
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public void customizeTableForTelnetError() {
        int iColumnCount = this.m_oDetailsTableModel.getColumnCount();
        if (3 == iColumnCount) {
            this.m_oResultTable.removeColumn(this.m_oResultTable.getColumnModel().getColumn(iColumnCount - 1));
            this.m_oResultTable.addMouseMotionListener(this.generateMouseMotionAdapter());
            this.m_oResultTable.addMouseListener(this.generateMouseAdapterForTable());
        }
    }

    private MouseMotionAdapter generateMouseMotionAdapter() {
        return new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent oMouseEvent) {
                Cursor cur;
                ErrorInfo oErrorInfo;
                Object oValue;
                Point oPoint = oMouseEvent.getPoint();
                int iColumnCount = ProgressDlg.this.m_oDetailsTableModel.getColumnCount();
                int iCol = ProgressDlg.this.m_oResultTable.columnAtPoint(oPoint);
                int iRow = ProgressDlg.this.m_oResultTable.rowAtPoint(oPoint);
                boolean bHandCursor = false;
                if (3 == iColumnCount && 1 == iCol && (oValue = ProgressDlg.this.m_oDetailsTableModel.getValueAt(iRow, 2)) instanceof ErrorInfo && DCHelpForErrCodeUtil.isShowHyperlink((oErrorInfo = (ErrorInfo)oValue).getErrorCode())) {
                    bHandCursor = true;
                }
                if (bHandCursor) {
                    cur = new Cursor(12);
                    DCFrameWorkUtil.setCursor(ProgressDlg.this.m_oResultTable, cur);
                } else {
                    cur = new Cursor(0);
                    DCFrameWorkUtil.setCursor(ProgressDlg.this.m_oResultTable, cur);
                }
            }
        };
    }

    private MouseAdapter generateMouseAdapterForTable() {
        return new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                Cursor cur = new Cursor(0);
                DCFrameWorkUtil.setCursor(cur);
            }

            @Override
            public void mouseClicked(MouseEvent oMouseEvent) {
                ErrorInfo oErrorInfo;
                Object oValue;
                Point oPoint = oMouseEvent.getPoint();
                int iColumnCount = ProgressDlg.this.m_oDetailsTableModel.getColumnCount();
                int iCol = ProgressDlg.this.m_oResultTable.columnAtPoint(oPoint);
                int iRow = ProgressDlg.this.m_oResultTable.rowAtPoint(oPoint);
                ErrorInfo oErrInfo = null;
                if (3 == iColumnCount && 1 == iCol && (oValue = ProgressDlg.this.m_oDetailsTableModel.getValueAt(iRow, 2)) instanceof ErrorInfo && DCHelpForErrCodeUtil.isShowHyperlink((oErrorInfo = (ErrorInfo)oValue).getErrorCode())) {
                    oErrInfo = oErrorInfo;
                }
                if (null != oErrInfo) {
                    if (999293081 == oErrInfo.getErrorCode()) {
                        String strMessage = oErrInfo.getErrMsg();
                        ViewCommandResultDialog dialog = new ViewCommandResultDialog(strMessage);
                        dialog.setTitle(DCFrameWorkUtil.getLocalizedString("OPERATION_RESULT"));
                        dialog.getContentTextArea().setLineWrap(true);
                        dialog.setVisible(true);
                    } else {
                        DCHelpForErrCodeUtil.showHelp(ProgressDlg.this.m_oResultTable, oErrInfo.getErrorCode());
                    }
                }
            }
        };
    }

    @Override
    protected String getCurrentContext() {
        return null;
    }

    public int getCurProgress() {
        return this.m_progressBar.getValue();
    }

    class DetailTableRenderer
    implements TableCellRenderer {
        DetailTableRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int iRow, int iCol) {
            ErrorInfo oTmpErrorInfo;
            Object oValue;
            JLabel label = new JLabel();
            label.setOpaque(true);
            int iColumnCount = ProgressDlg.this.m_oDetailsTableModel.getColumnCount();
            ErrorInfo oErrorInfo = null;
            if (3 == iColumnCount && 1 == iCol && (oValue = ProgressDlg.this.m_oDetailsTableModel.getValueAt(iRow, 2)) instanceof ErrorInfo && DCHelpForErrCodeUtil.isShowHyperlink((oTmpErrorInfo = (ErrorInfo)oValue).getErrorCode())) {
                oErrorInfo = oTmpErrorInfo;
            }
            return ProgressDlg.this.renderColumn(table, value, isSelected, label, oErrorInfo);
        }
    }
}

