/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.components.dialog;

import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.util.DCCleanupUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.u2000.component.dialog.BaseInternalDialog;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public abstract class DCModalDialog
extends BaseInternalDialog {
    private static final long serialVersionUID = -8107093551368678122L;
    protected JButton m_oOKBtn;
    protected JButton m_oCancelBtn;
    protected JButton m_oSaveBtn;
    private ActionListener m_oEscKeyHandler;
    private KeyStroke m_oEscKeyStroke;
    private ActionListener m_oF1KeyHandler;
    private KeyStroke m_oF1KeyStroke;
    private boolean m_isClosed = false;

    public DCModalDialog() {
        super(true, true);
        this.setResizable(false);
        this.setSize(410, 310);
        this.jbInit();
    }

    public DCModalDialog(DCModalDialog dialog) {
        super(true, true);
        this.setResizable(false);
        this.setSize(410, 310);
        this.setLocationRelativeTo((Component)((Object)dialog));
        this.jbInit();
    }

    public DCModalDialog(JDialog dialog) {
        super(true, true);
        this.setResizable(false);
        this.setSize(410, 310);
        this.setLocationRelativeTo(dialog);
        this.jbInit();
    }

    public DCModalDialog(DCModalDialog parentDlg, boolean isModel) {
        super(true, isModel);
        this.setResizable(false);
        this.setSize(410, 310);
        this.setLocationRelativeTo((Component)((Object)parentDlg));
        this.jbInit();
    }

    public DCModalDialog(DCModalDialog parentDlg, String strTitle, boolean isModel) {
        super(true, isModel);
        this.setTitle(strTitle);
        this.setResizable(false);
        this.setSize(410, 310);
        this.setLocationRelativeTo((Component)((Object)parentDlg));
        this.jbInit();
    }

    public DCModalDialog(JFrame parentFrame) {
        super(true, true);
        this.setResizable(false);
        this.setSize(410, 310);
        this.setLocationRelativeTo(parentFrame);
        this.jbInit();
    }

    public DCModalDialog(JFrame parentFrame, boolean isModel) {
        super(true, isModel);
        this.setResizable(false);
        this.setSize(410, 310);
        this.setLocationRelativeTo(parentFrame);
        this.jbInit();
    }

    public DCModalDialog(Frame parentFrame, boolean isModel) {
        super(true, isModel);
        this.setResizable(false);
        this.setSize(410, 310);
        this.setLocationRelativeTo(parentFrame);
        this.jbInit();
    }

    public DCModalDialog(Frame parentFrame, String strTitle, boolean isModel) {
        super(true, isModel);
        this.setTitle(strTitle);
        this.setResizable(false);
        this.setSize(410, 310);
        this.setLocationRelativeTo(parentFrame);
        this.jbInit();
    }

    private void jbInit() {
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.m_oCancelBtn = new JButton();
        this.m_oOKBtn = new JButton();
        this.m_oCancelBtn.setName("DCModalDialog_m_oCancelBtn");
        this.m_oOKBtn.setName("DCModalDialog_m_oOKBtn");
        this.m_oOKBtn.setFocusable(false);
        this.m_oCancelBtn.setFocusable(false);
        this.initializeButtonActions();
        this.initializeKeyStrokeActions();
        this.addDialogWindowListener();
    }

    protected void addDialogWindowListener() {
        this.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosing(InternalFrameEvent e) {
                DCModalDialog.this.closeDialog();
            }
        });
    }

    private void initializeKeyStrokeActions() {
        ActionListener oEnterKeyHandler = this.createActionListenerForEnter();
        KeyStroke oEnterKeyStroke = KeyStroke.getKeyStroke(10, 0);
        this.registerKeyBoardActionFor(oEnterKeyStroke, oEnterKeyHandler);
        this.m_oEscKeyHandler = this.createActionListenerForEscape();
        this.m_oEscKeyStroke = KeyStroke.getKeyStroke(27, 0);
        this.registerKeyBoardActionFor(this.m_oEscKeyStroke, this.m_oEscKeyHandler);
    }

    private ActionListener createActionListenerForEnter() {
        ActionListener oEnterKeyHandler = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DCModalDialog.this.m_oOKBtn.doClick();
            }
        };
        return oEnterKeyHandler;
    }

    protected ActionListener createActionListenerForEscape() {
        ActionListener oEscKeyHandler = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DCModalDialog.this.closeDialog();
            }
        };
        return oEscKeyHandler;
    }

    protected void addKeyListenerToComponent(Component oComp) {
        oComp.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    DCModalDialog.this.closeDialog();
                } else if (e.getKeyCode() == 10) {
                    DCModalDialog.this.m_oOKBtn.doClick();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    DCModalDialog.this.closeDialog();
                } else if (e.getKeyCode() == 10) {
                    DCModalDialog.this.m_oOKBtn.doClick();
                }
            }
        });
    }

    private void registerKeyBoardActionFor(KeyStroke oKeyStroke, ActionListener oKeyHandler) {
        this.rootPane.registerKeyboardAction(oKeyHandler, oKeyStroke, 2);
    }

    protected void registerForHelp(JComponent component) {
        component.registerKeyboardAction(this.m_oF1KeyHandler, this.m_oF1KeyStroke, 0);
    }

    private void initializeButtonActions() {
        this.m_oCancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DCModalDialog.this.cancelButton_ActionPerformed();
            }
        });
        this.m_oOKBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DCModalDialog.this.oKButton_ActionPerformed();
            }
        });
    }

    protected void closeDialog() {
        this.doCleanUp();
        DCFrameWorkUtil.setCursor((Component)((Object)this), Cursor.getDefaultCursor());
        this.m_isClosed = true;
        this.dispose();
    }

    public boolean isCloseDialog() {
        return this.m_isClosed;
    }

    public void doCleanUp() {
        DCCleanupUtil.cleanupComponent((JComponent)((Object)this));
        DCCleanupUtil.cleanupComponent(this.m_oOKBtn);
        this.m_oOKBtn = null;
        DCCleanupUtil.cleanupComponent(this.m_oCancelBtn);
        this.m_oCancelBtn = null;
        this.m_oEscKeyHandler = null;
        this.m_oF1KeyHandler = null;
        if (null != this.m_oEscKeyStroke) {
            this.rootPane.unregisterKeyboardAction(this.m_oEscKeyStroke);
            this.m_oEscKeyStroke = null;
        }
        if (null != this.m_oF1KeyStroke) {
            this.rootPane.unregisterKeyboardAction(this.m_oF1KeyStroke);
            this.m_oF1KeyStroke = null;
        }
        this.rootPane.removeAll();
        this.getContentPane().removeAll();
        this.removeAll();
    }

    protected void cancelButton_ActionPerformed() {
        this.closeDialog();
    }

    protected void oKButton_ActionPerformed() {
    }

    protected void displayHelp() {
        String strContext = this.getCurrentContext();
        if (null == strContext || "".equals(strContext)) {
            return;
        }
        try {
            DCFrameWorkUtil.waitCursor();
            DCHelpManager.getInstance().enableF1HelpKey(this.getContentPane(), strContext);
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
        DCFrameWorkUtil.defaultCursor();
    }

    public void setVisible(boolean visible) {
        if (visible) {
            try {
                ((Object)((Object)this)).wait(500L);
            }
            catch (Exception e) {
                DCDebugTracer.trace("DCModalDialog#Wait 500ms");
            }
        }
        super.setVisible(visible);
    }

    protected abstract String getCurrentContext();

    public JButton getCancelBtn() {
        return this.m_oCancelBtn;
    }
}

