/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.components.dialog;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnDCLoadTaskDeviceInfo;
import com.huawei.dc.common.asndatacenter.AsnDCSyncCancelReq;
import com.huawei.dc.common.asndatacenter.AsnDCSyncRsp;
import com.huawei.dc.common.components.dialog.ProgressDlg;
import com.huawei.dc.common.controller.BaseCommManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.devicemanagement.connectivity.view.TableCellRender;
import com.huawei.dc.taskmgmt.view.common.QueryFailedBoardInfoDlg;
import com.swimap.iview.util.SyncCommand;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import net.commustru.fstru.FStruct;

public class CommonProgressDlg
extends ProgressDlg {
    private static final long serialVersionUID = 1L;
    private JProgressBar m_oCommonProgressBar = null;
    private JLabel m_oProgressLbl = null;
    private String m_oProgBarInfo = "";
    private String[] m_oColumnNames = null;
    private List<AsnDCLoadTaskDeviceInfo> deviceInfoList;
    private JButton oShowQueryReasonButton;
    private static final char SHOW_QUERY_BUTTON_MNEMONIC = 'Q';

    public CommonProgressDlg(String[] columnNames, List<String[]> neList) {
        this.m_oColumnNames = columnNames;
        this.initNeGUI(neList);
    }

    public CommonProgressDlg(int iCmdCode, List oDeviceIDLst, String[] columnNames) {
        this.setCommandCode(iCmdCode);
        this.setDeviceIds(oDeviceIDLst);
        this.m_oColumnNames = columnNames;
        this.initGUI();
    }

    public CommonProgressDlg(int iCmdCode, List oDeviceIDLst, String[] columnNames, HashMap<Integer, String> oBoardInfoMap) {
        super(iCmdCode, oDeviceIDLst, oBoardInfoMap);
        this.m_oColumnNames = columnNames;
        this.initGUI();
    }

    public CommonProgressDlg(int iCmdCode, List oDeviceIDLst) {
        this.setCommandCode(iCmdCode);
        this.setDeviceIds(oDeviceIDLst);
        this.initGUI();
    }

    private void initNeGUI(List<String[]> neList) {
        this.setSize(500, 250);
        this.m_cancelBtn.setEnabled(false);
        this.remove(this.m_progressBar);
        this.remove(this.m_cancelBtn);
        this.setM_bShowDetail(true);
        this.m_detailsBtn.setText(ResourceManager.getInstance().getResString("DETAILS_TEXT_OPEN"));
        this.m_detailsBtn.setBounds(274, 50, 100, 21);
        this.m_closeBtn.setEnabled(true);
        this.initInfoLabel();
        if (null != this.m_oColumnNames) {
            this.m_oDetailsTableModel = new DefaultTableModel(this.m_oColumnNames, 0){

                @Override
                public boolean isCellEditable(int row, int col) {
                    return false;
                }
            };
            if (null != neList) {
                for (int i = 0; i < neList.size(); ++i) {
                    this.m_oDetailsTableModel.addRow(neList.get(i));
                }
            }
            TableCellRender oTableCellRender = new TableCellRender();
            this.m_oResultTable.setModel(this.m_oDetailsTableModel);
            int iColCnt = this.m_oResultTable.getColumnCount();
            for (int i = 0; i < iColCnt; ++i) {
                TableColumn typeColumn = this.m_oResultTable.getColumnModel().getColumn(i);
                typeColumn.setCellRenderer(oTableCellRender);
            }
        }
        this.initQueryInfoButton();
    }

    private void initInfoLabel() {
        JLabel infoLabel = new JLabel(ResourceManager.getInstance().getResString("SUPPORT_NEINFO"));
        infoLabel.setBounds(12, 12, 470, 26);
        this.getContentPane().add((Component)infoLabel, null);
    }

    private void initGUI() {
        this.setSize(500, 250);
        this.m_cancelBtn.setEnabled(true);
        this.remove(this.m_progressBar);
        this.setM_bShowDetail(true);
        this.m_detailsBtn.setText(ResourceManager.getInstance().getResString("DETAILS_TEXT_OPEN"));
        this.initProgressLbl();
        this.m_closeBtn.setEnabled(false);
        if (null != this.m_oColumnNames) {
            this.m_oDetailsTableModel = new DefaultTableModel(this.m_oColumnNames, 0){

                @Override
                public boolean isCellEditable(int row, int col) {
                    return false;
                }
            };
            TableCellRender oTableCellRender = new TableCellRender();
            this.m_oResultTable.setModel(this.m_oDetailsTableModel);
            int iColCnt = this.m_oResultTable.getColumnCount();
            for (int i = 0; i < iColCnt; ++i) {
                TableColumn typeColumn = this.m_oResultTable.getColumnModel().getColumn(i);
                typeColumn.setCellRenderer(oTableCellRender);
            }
        }
        this.initQueryInfoButton();
    }

    private void initQueryInfoButton() {
        this.oShowQueryReasonButton = new JButton();
        this.oShowQueryReasonButton.setName("CommonProgressDlg_queryInfoButton");
        this.oShowQueryReasonButton.setBounds(40, 50, 130, 21);
        this.oShowQueryReasonButton.setFocusable(true);
        this.oShowQueryReasonButton.setText(ResourceManager.getInstance().getResString("SHOW_QUERY_INFORMATION"));
        this.oShowQueryReasonButton.setMnemonic('Q');
        this.oShowQueryReasonButton.setVisible(false);
        this.oShowQueryReasonButton.setToolTipText(ResourceManager.getInstance().getResString("SHOW_QUERY_INFORMATION"));
        this.oShowQueryReasonButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CommonProgressDlg.this.showQueryReasonButton_ActionPerformed();
            }
        });
        this.getContentPane().add(this.oShowQueryReasonButton);
    }

    public void setResultInfo() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CommonProgressDlg.this.initializeProgressBar();
                CommonProgressDlg.this.m_oCommonProgressBar.setValue(100);
                CommonProgressDlg.this.m_oCommonProgressBar.setIndeterminate(false);
                CommonProgressDlg.this.m_oCommonProgressBar.setString("100%");
                CommonProgressDlg.this.m_closeBtn.setEnabled(true);
                CommonProgressDlg.this.m_cancelBtn.setEnabled(false);
                CommonProgressDlg.this.replaceProgressBar();
                CommonProgressDlg.this.repaint();
            }
        });
    }

    private void replaceProgressBar() {
        this.m_oProgressLbl.setVisible(false);
        this.getContentPane().remove(this.m_oProgressLbl);
        this.getContentPane().add((Component)this.m_oCommonProgressBar, null);
        this.getContentPane().repaint();
        this.repaint();
    }

    private void initializeProgressBar() {
        this.m_oCommonProgressBar = new JProgressBar(0, 100);
        this.m_oCommonProgressBar.setName("Components_CommonProgressDlg_m_progressBar");
        this.m_oCommonProgressBar.setString(this.getProgBarInfo());
        this.m_oCommonProgressBar.setBounds(12, 12, 470, 21);
        this.m_oCommonProgressBar.setVisible(true);
        this.m_oCommonProgressBar.setBackground(this.getBackground());
        this.m_oCommonProgressBar.setForeground(new Color(0, 0, 116));
        this.m_progressBar.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, Color.gray));
        this.m_oCommonProgressBar.setStringPainted(true);
        this.m_oCommonProgressBar.setIndeterminate(true);
    }

    private void initProgressLbl() {
        ImageIcon progressIcon = ResourceManager.getInstance().getImage("commonProgress.gif");
        this.m_oProgressLbl = new JLabel(progressIcon);
        this.m_oProgressLbl.setBounds(12, 12, 470, 21);
        this.getContentPane().add((Component)this.m_oProgressLbl, null);
    }

    public void setProgress(int iDevID, String sDisplayName, String sOperationResult) {
        if (this.m_bCancelOpPerformed || null == this.m_oDeviceIds) {
            return;
        }
        if (this.m_oDeviceIds.contains(iDevID)) {
            this.m_oDeviceIds.remove((Object)iDevID);
        }
        Vector<String> rowDataVector = new Vector<String>(0);
        rowDataVector.add(sDisplayName);
        rowDataVector.add(sOperationResult);
        this.m_oDetailsTableModel.addRow(rowDataVector);
        if (null != this.m_oDeviceIds && this.m_oDeviceIds.size() == 0) {
            this.setResultInfo();
        }
    }

    public DefaultTableModel getTableModel() {
        return this.m_oDetailsTableModel;
    }

    public int getDataSize() {
        return this.m_oDetailsTableModel.getDataVector().size();
    }

    @Override
    protected void cancelButtonActionPerformed() {
        this.m_bCancelOpPerformed = true;
        AsnDCSyncCancelReq oAsnDCCancelOpr = new AsnDCSyncCancelReq();
        oAsnDCCancelOpr.oReqID = BigInteger.valueOf(this.m_iProgressdDlgId);
        try {
            if (-1 != this.m_iCommandCode) {
                this.sendCancelRequest(oAsnDCCancelOpr, 43852);
            }
            this.m_iProgressdDlgId = -1;
            if (null != this.m_oDeviceIds && 0 < this.m_oDeviceIds.size()) {
                this.updateDetailsTable();
            }
            this.setResultInfo();
        }
        catch (DCException e) {
            this.m_bCancelOpPerformed = false;
            DCDebugTracer.trace("DC::cancelButtonActionPerformed::throw exception::" + e.getMessage());
            this.dispose();
            return;
        }
        ToolTipManager.sharedInstance().setEnabled(true);
    }

    protected void sendCancelRequest(final AsnDCSyncCancelReq oAsnDCCancelOpr, final int iCmdCode) throws DCException {
        int iErrorCode;
        final BaseCommManager oCommManager = DCFrameWorkUtil.getCommManager();
        final AsnDCSyncRsp oAsnDCOpertionRsp = this.getAsnDCOperationRspInstance();
        SyncCommand syncCommand = new SyncCommand(){

            public Object call() throws Exception {
                int iErrorCode = oCommManager.sendSyncMsg(BaseCommManager.getMSGHead(iCmdCode), (FStruct)oAsnDCCancelOpr, (FStruct)oAsnDCOpertionRsp);
                return iErrorCode;
            }
        };
        syncCommand.startCall((Component)DCFrameWorkUtil.getMainFrame(), true);
        if (null != syncCommand.getResult() && 0 != (iErrorCode = ((Integer)syncCommand.getResult()).intValue())) {
            DCDebugTracer.trace("syncCommand getResult:" + iErrorCode);
            throw new DCException(iErrorCode, ResourceManager.getInstance().getResString("SEND_FAIL"));
        }
        int iErrCode = oAsnDCOpertionRsp.oErrorInfo.iErrorNo.intValue();
        if (0 != iErrCode) {
            DCDebugTracer.trace("oAsnDCOpertionRsp.oErrorInfo.iErrorNo:" + iErrCode);
            throw new DCException(iErrCode, ResourceManager.getInstance().getResString("CANCEL_REQUEST_FAILED"));
        }
    }

    public String getProgBarInfo() {
        return this.m_oProgBarInfo;
    }

    public List<AsnDCLoadTaskDeviceInfo> getDeviceInfoList() {
        return this.deviceInfoList;
    }

    public void setDeviceInfoList(List<AsnDCLoadTaskDeviceInfo> deviceInfoList) {
        this.deviceInfoList = deviceInfoList;
    }

    private void showQueryReasonButton_ActionPerformed() {
        this.dispose();
        final QueryFailedBoardInfoDlg oQueryDlg = new QueryFailedBoardInfoDlg(this.deviceInfoList);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                oQueryDlg.setVisible(true);
            }
        });
    }

    public JButton getShowQueryReasonButton() {
        return this.oShowQueryReasonButton;
    }
}

