/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.components.dialog;

import com.huawei.dc.common.ProgressManager;
import com.huawei.dc.common.asndatacenter.AsnDCSyncCancelReq;
import com.huawei.dc.common.asndatacenter.AsnDCSyncRsp;
import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.controller.BaseCommManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCOptionPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.math.BigInteger;
import javax.swing.BorderFactory;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import net.commustru.fstru.FStruct;

public class ASynProgressDlg
extends DCModalDialog
implements ProgressManager {
    private static final long serialVersionUID = 8579613930124633747L;
    private JProgressBar m_oProgressBar = null;
    private int exportRequestId;

    public ASynProgressDlg(int requestId, String strDialogTitle) {
        super(DCFrameWorkUtil.getMainFrame(), true);
        this.exportRequestId = requestId;
        this.jbInit();
        this.setTitle(strDialogTitle);
        this.setDefaultCloseOperation(2);
    }

    private void jbInit() {
        this.initDialog();
        this.initProgressbar();
        this.initCancelButton();
    }

    private void initDialog() {
        this.setSize(500, 120);
        this.setResizable(false);
        this.setLocationRelativeTo(DCFrameWorkUtil.getMainFrame());
        this.getContentPane().setLayout(null);
    }

    private void initProgressbar() {
        this.m_oProgressBar = new JProgressBar(0, 0, 100);
        this.m_oProgressBar.setName("DeviceManagement_AutoProgressDlg_m_oProgressBar");
        this.m_oProgressBar.setOpaque(true);
        this.m_oProgressBar.setBounds(10, 15, 470, 21);
        this.m_oProgressBar.setBackground(this.getBackground());
        this.m_oProgressBar.setForeground(new Color(0, 0, 116));
        this.m_oProgressBar.setValue(0);
        this.m_oProgressBar.setStringPainted(true);
        this.m_oProgressBar.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, Color.gray));
        this.getContentPane().add((Component)this.m_oProgressBar, null);
    }

    private void initCancelButton() {
        this.m_oOKBtn.setName("ASynProgressDlg_m_oOKBtn");
        this.m_oOKBtn.setBounds(new Rectangle(300, 55, 80, 21));
        this.m_oOKBtn.setText(ResourceManager.getInstance().getResString("OK_BTN"));
        this.m_oCancelBtn.setName("ASynProgressDlg_m_oCancelBtn");
        this.m_oCancelBtn.setBounds(new Rectangle(400, 55, 80, 21));
        this.m_oCancelBtn.setText(ResourceManager.getInstance().getResString("MDP_SETTING_CANCEL_BTN"));
        this.getContentPane().add((Component)this.m_oOKBtn, null);
        this.getContentPane().add((Component)this.m_oCancelBtn, null);
    }

    @Override
    protected void cancelButton_ActionPerformed() {
        BaseCommManager oCommManager = DCFrameWorkUtil.getCommManager();
        AsnDCSyncCancelReq oAsnCancelReq = new AsnDCSyncCancelReq();
        oAsnCancelReq.oReqID = BigInteger.valueOf(this.exportRequestId);
        AsnDCSyncRsp oAsnDCOpertionRsp = new AsnDCSyncRsp();
        int iErrorCode = oCommManager.sendSyncMsgWithSyncCommand(43852, (FStruct)oAsnCancelReq, (FStruct)oAsnDCOpertionRsp);
        if (0 != iErrorCode) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), BigInteger.valueOf(iErrorCode), DCFrameWorkUtil.getLocalizedString("ERROR"), 0);
            return;
        }
        if (0 != oAsnDCOpertionRsp.oErrorInfo.iErrorNo.intValue()) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), oAsnDCOpertionRsp.oErrorInfo.iErrorNo, DCFrameWorkUtil.getLocalizedString("ERROR"), 0);
            return;
        }
        this.closeDialog();
    }

    @Override
    public void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    @Override
    protected void oKButton_ActionPerformed() {
        this.closeDialog();
    }

    private void setProgress(final int iProgress) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ASynProgressDlg.this.m_oProgressBar.setValue(iProgress);
                ASynProgressDlg.this.m_oProgressBar.updateUI();
                ASynProgressDlg.this.getContentPane().validate();
                ASynProgressDlg.this.getContentPane().repaint();
            }
        });
    }

    @Override
    protected String getCurrentContext() {
        return "";
    }

    @Override
    public void updateProgress(int iProgress) {
        this.setProgress(iProgress);
    }

    @Override
    public void end() {
        this.closeDialog();
    }
}

