/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.components.devicetreepanel;

import com.huawei.dc.common.components.devicetreepanel.DeviceTreeButtonInfo;
import com.huawei.dc.common.components.devicetreepanel.DeviceTreeButtonListener;
import com.huawei.dc.common.components.devicetreepanel.DeviceTreePanel;
import com.huawei.dc.common.components.devicetreepanel.DeviceTreeToolBarModel;
import com.huawei.dc.common.components.tree.devicetree.DeviceTree;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.WindowStyleButton;
import com.huawei.dc.common.util.WindowStyleSpecialButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolBar;

public class DeviceTreeToolBarPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private ButtonGroup m_oButtonGroup;
    private static ResourceManager c_oResourceManager;
    private static DeviceTreeButtonListener c_oListener;
    private DeviceTreePanel m_oDeviceTreePanel;
    private JToolBar m_oToolBar;
    private DeviceTreeToolBarModel m_oToolBarModel;

    public DeviceTreeToolBarPanel(DeviceTreePanel oTreePanel, IDeviceInfoManager oDeviceInfoManager, DeviceTreeToolBarModel oToolBarModel) {
        this.m_oToolBarModel = oToolBarModel;
        this.m_oDeviceTreePanel = oTreePanel;
        this.initializeFields();
        this.createButtonListenerFromModel(oDeviceInfoManager);
        this.createComponentsFromModel();
        this.m_oToolBar.repaint();
        this.add((Component)this.m_oToolBar, "West");
        this.repaint();
    }

    private void initializeFields() {
        this.m_oButtonGroup = new ButtonGroup();
        this.m_oToolBar = new JToolBar();
        this.m_oToolBar.setFloatable(false);
        this.setLayout(new BorderLayout());
        this.initializeResourcemanager();
    }

    private void createComponentsFromModel() {
        if (null == this.m_oToolBarModel) {
            return;
        }
        for (Object oComponent : this.m_oToolBarModel.getComponentList()) {
            if (oComponent instanceof DeviceTreeButtonInfo) {
                this.createButton((DeviceTreeButtonInfo)oComponent);
                continue;
            }
            if (!(oComponent instanceof JComponent)) continue;
            this.addComponentToToolBar((JComponent)oComponent);
        }
    }

    private void createButtonListenerFromModel(IDeviceInfoManager oDeviceInfoManager) {
        c_oListener = this.m_oToolBarModel.getButtonListener();
        c_oListener.initializeListener(this.m_oDeviceTreePanel, oDeviceInfoManager, this);
    }

    private void createButton(DeviceTreeButtonInfo oButtonInfo) {
        int iButtonType = oButtonInfo.getButtonType();
        boolean bButtonEnabled = oButtonInfo.isButtonEnabled();
        switch (iButtonType) {
            case 0: {
                this.createDeviceVersionButton(bButtonEnabled);
                break;
            }
            case 1: {
                this.createSubMapButton(bButtonEnabled);
                break;
            }
            case 2: {
                this.createDeviceBoardButton(bButtonEnabled);
                break;
            }
            case 3: {
                this.createSubMapBoardButton(bButtonEnabled);
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                this.createFilterButton(bButtonEnabled);
                break;
            }
            case 6: {
                this.createImportButton(bButtonEnabled);
                break;
            }
            case 7: {
                this.createExportButton(bButtonEnabled);
                break;
            }
            case 8: {
                this.createExpandButton(bButtonEnabled);
                break;
            }
            case 9: {
                this.createCollapseButton(bButtonEnabled);
                break;
            }
        }
    }

    private void initializeResourcemanager() {
        c_oResourceManager = ResourceManager.getInstance();
    }

    private void addButtonToGroupAndToolBar(JButton oButton) {
        this.m_oButtonGroup.add(oButton);
        this.m_oToolBar.add(oButton);
        this.m_oToolBar.repaint();
        this.repaint();
    }

    private void createCollapseButton(boolean bButtonEnabled) {
        WindowStyleButton oImportBtn = new WindowStyleButton();
        this.initializeButtonToDefaultSettings(oImportBtn);
        this.initializeActionListenerForButton(oImportBtn);
        oImportBtn.setActionCommand("COLLAPSE_ACTION");
        oImportBtn.setIcon(c_oResourceManager.getImage("collapse_tasks.gif"));
        oImportBtn.setToolTipText(c_oResourceManager.getResString("COLLAPSE_TOOL_TIP"));
        oImportBtn.setVerifyInputWhenFocusTarget(true);
        oImportBtn.setEnabled(bButtonEnabled);
        this.addButtonToGroupAndToolBar(oImportBtn);
    }

    private void createExpandButton(boolean bButtonEnabled) {
        WindowStyleButton oImportBtn = new WindowStyleButton();
        this.initializeButtonToDefaultSettings(oImportBtn);
        this.initializeActionListenerForButton(oImportBtn);
        oImportBtn.setActionCommand("EXPAND_ACTION");
        oImportBtn.setIcon(c_oResourceManager.getImage("expand_tasks.gif"));
        oImportBtn.setToolTipText(c_oResourceManager.getResString("EXPAND_TOOL_TIP"));
        oImportBtn.setVerifyInputWhenFocusTarget(true);
        oImportBtn.setEnabled(bButtonEnabled);
        this.addButtonToGroupAndToolBar(oImportBtn);
    }

    public void createImportButton(boolean bButtonEnabled) {
        WindowStyleButton oImportBtn = new WindowStyleButton();
        oImportBtn.setName("DeviceTreePanel_DeviceTreeToolBarPanel_oImportBtn");
        this.initializeButtonToDefaultSettings(oImportBtn);
        this.initializeActionListenerForButton(oImportBtn);
        oImportBtn.setActionCommand("IMPORT_ACTION");
        oImportBtn.setIcon(ResourceManager.getInstance().getImage("import.gif"));
        oImportBtn.setToolTipText(c_oResourceManager.getResString("IMPORT_TOOL_TIP"));
        oImportBtn.setVerifyInputWhenFocusTarget(true);
        oImportBtn.setEnabled(bButtonEnabled);
        this.addButtonToGroupAndToolBar(oImportBtn);
    }

    public void createExportButton(boolean bButtonEnabled) {
        WindowStyleButton oExportBtn = new WindowStyleButton();
        oExportBtn.setName("DeviceTreePanel_DeviceTreeToolBarPanel_oExportBtn");
        this.initializeButtonToDefaultSettings(oExportBtn);
        this.initializeActionListenerForButton(oExportBtn);
        oExportBtn.setActionCommand("EXPORT_ACTION");
        oExportBtn.setToolTipText(c_oResourceManager.getResString("EXPORT_TOLL_TIP_TEXT"));
        oExportBtn.setIcon(ResourceManager.getInstance().getImage("export.gif"));
        oExportBtn.setEnabled(bButtonEnabled);
        this.addButtonToGroupAndToolBar(oExportBtn);
    }

    public void createDeviceVersionButton(boolean bButtonEnabled) {
        WindowStyleSpecialButton oDeviceVersionBtn = new WindowStyleSpecialButton();
        oDeviceVersionBtn.setName("DeviceTreePanel_DeviceTreeToolBarPanel_oDeviceVersionBtn");
        this.initializeButtonToDefaultSettings(oDeviceVersionBtn);
        this.initializeActionListenerForButton(oDeviceVersionBtn);
        oDeviceVersionBtn.setActionCommand("DEVICE_ACTION");
        oDeviceVersionBtn.setIcon(ResourceManager.getInstance().getImage("ic_device.gif"));
        oDeviceVersionBtn.setToolTipText(c_oResourceManager.getResString("DEVICE_VIEW"));
        oDeviceVersionBtn.setEnabled(bButtonEnabled);
        if (1 == this.getCurrentTreeDataType()) {
            this.setWindowStyleSpecialButtonPressed(oDeviceVersionBtn);
        }
        this.addButtonToGroupAndToolBar(oDeviceVersionBtn);
    }

    public void createSubMapButton(boolean bButtonEnabled) {
        WindowStyleSpecialButton oSubmapBtn = new WindowStyleSpecialButton();
        oSubmapBtn.setName("DeviceTreePanel_DeviceTreeToolBarPanel_oSubmapBoardBtn");
        this.initializeButtonToDefaultSettings(oSubmapBtn);
        this.initializeActionListenerForButton(oSubmapBtn);
        oSubmapBtn.setActionCommand("SUBMAP_ACTION");
        oSubmapBtn.setIcon(ResourceManager.getInstance().getImage("submap_1.gif"));
        oSubmapBtn.setToolTipText(c_oResourceManager.getResString("SUBMAP_VIEW"));
        oSubmapBtn.setEnabled(bButtonEnabled);
        if (3 == this.getCurrentTreeDataType()) {
            this.setWindowStyleSpecialButtonPressed(oSubmapBtn);
        }
        this.addButtonToGroupAndToolBar(oSubmapBtn);
    }

    public void createDeviceBoardButton(boolean bButtonEnabled) {
        WindowStyleSpecialButton oDeviceBoardBtn = new WindowStyleSpecialButton();
        oDeviceBoardBtn.setName("DeviceTreePanel_DeviceTreeToolBarPanel_oDeviceBoardBtn");
        this.initializeButtonToDefaultSettings(oDeviceBoardBtn);
        this.initializeActionListenerForButton(oDeviceBoardBtn);
        oDeviceBoardBtn.setActionCommand("DEVICE_BOARD_ACTION");
        oDeviceBoardBtn.setIcon(ResourceManager.getInstance().getImage("ic_slot.gif"));
        oDeviceBoardBtn.setToolTipText(c_oResourceManager.getResString("BOARD_VIEW"));
        oDeviceBoardBtn.setEnabled(bButtonEnabled);
        if (!DCFrameWorkUtil.getIsSingleClient()) {
            this.addButtonToGroupAndToolBar(oDeviceBoardBtn);
        }
        if (2 == this.getCurrentTreeDataType()) {
            this.setWindowStyleSpecialButtonPressed(oDeviceBoardBtn);
        }
    }

    public void createSubMapBoardButton(boolean bButtonEnabled) {
        WindowStyleSpecialButton oSubmapBoardBtn = new WindowStyleSpecialButton();
        oSubmapBoardBtn.setName("DeviceTreePanel_DeviceTreeToolBarPanel_oSubmapBoardBtn");
        this.initializeButtonToDefaultSettings(oSubmapBoardBtn);
        this.initializeActionListenerForButton(oSubmapBoardBtn);
        oSubmapBoardBtn.setActionCommand("SUBMAP_BOARD_ACTION");
        oSubmapBoardBtn.setIcon(ResourceManager.getInstance().getImage("submap_board.gif"));
        oSubmapBoardBtn.setToolTipText(c_oResourceManager.getResString("SUBMAP_BOARD_VIEW"));
        oSubmapBoardBtn.setEnabled(bButtonEnabled);
        if (!DCFrameWorkUtil.getIsSingleClient()) {
            this.addButtonToGroupAndToolBar(oSubmapBoardBtn);
        }
        if (4 == this.getCurrentTreeDataType()) {
            this.setWindowStyleSpecialButtonPressed(oSubmapBoardBtn);
        }
    }

    public void createFilterButton(boolean bButtonEnabled) {
        WindowStyleButton oFilterBtn = new WindowStyleButton();
        oFilterBtn.setName("DeviceTreePanel_DeviceTreeToolBarPanel_oFilterBtn");
        this.initializeButtonToDefaultSettings(oFilterBtn);
        this.initializeActionListenerForButton(oFilterBtn);
        oFilterBtn.setActionCommand("FILTER_ACTION");
        oFilterBtn.setIcon(ResourceManager.getInstance().getImage("filter.gif"));
        oFilterBtn.setToolTipText(c_oResourceManager.getResString("FILTER_BUTTON"));
        oFilterBtn.setEnabled(bButtonEnabled);
        this.addButtonToGroupAndToolBar(oFilterBtn);
    }

    public void createSearchButton(boolean bButtonEnabled) {
        WindowStyleButton oSearchBtn = new WindowStyleButton();
        oSearchBtn.setName("DeviceTreePanel_DeviceTreeToolBarPanel_oSearchBtn");
        this.initializeButtonToDefaultSettings(oSearchBtn);
        this.initializeActionListenerForButton(oSearchBtn);
        oSearchBtn.setActionCommand("SEARCH_ACTION");
        oSearchBtn.setIcon(ResourceManager.getInstance().getImage("search.gif"));
        oSearchBtn.setToolTipText(c_oResourceManager.getResString("SEARCH_BUTTON"));
        oSearchBtn.setEnabled(bButtonEnabled);
        this.addButtonToGroupAndToolBar(oSearchBtn);
    }

    private int getCurrentTreeDataType() {
        DeviceTree oTree = this.m_oDeviceTreePanel.getDeviceTree();
        return oTree.getTreeDescriptor().getViewType();
    }

    private void initializeButtonToDefaultSettings(JButton oButton) {
        Dimension oDefaultDimension = new Dimension(25, 25);
        oButton.setPreferredSize(oDefaultDimension);
        oButton.setMaximumSize(oDefaultDimension);
        oButton.setMinimumSize(oDefaultDimension);
        oButton.setBorder(null);
        oButton.repaint();
    }

    private void initializeActionListenerForButton(JButton oButton) {
        oButton.addActionListener(c_oListener);
    }

    public void updateButtonsForCurrentSelection(JButton oSelectedButton) {
        if (null == oSelectedButton || !(oSelectedButton instanceof WindowStyleSpecialButton)) {
            return;
        }
        this.setWindowStyleSpecialButtonPressed((WindowStyleSpecialButton)oSelectedButton);
        JButton oButton = null;
        String strSelectedAction = oSelectedButton.getActionCommand();
        if (null != this.m_oButtonGroup) {
            Enumeration<AbstractButton> oButtonList = this.m_oButtonGroup.getElements();
            while (oButtonList.hasMoreElements()) {
                oButton = (JButton)oButtonList.nextElement();
                if (null == oButton || oSelectedButton == oButton || !(oButton instanceof WindowStyleSpecialButton)) continue;
                this.resetWindowStyleSpecialButton((WindowStyleSpecialButton)oButton);
                String strCurrentAction = oButton.getActionCommand();
                if (!"FILTER_ACTION".equals(strCurrentAction)) continue;
                this.updateFilterButtonStatus(oButton, strSelectedAction);
            }
        }
    }

    private void updateFilterButtonStatus(JButton oFilterButton, String strSelectedAction) {
        if ("DEVICE_BOARD_ACTION".equals(strSelectedAction) || "SUBMAP_BOARD_ACTION".equals(strSelectedAction)) {
            oFilterButton.setEnabled(true);
        } else if ("DEVICE_ACTION".equals(strSelectedAction) || "SUBMAP_ACTION".equals(strSelectedAction)) {
            oFilterButton.setEnabled(false);
        }
        oFilterButton.repaint();
    }

    private void setWindowStyleSpecialButtonPressed(WindowStyleSpecialButton oSelectedButton) {
        oSelectedButton.getModel().setPressed(true);
        oSelectedButton.getModel().setRollover(true);
        oSelectedButton.setBorder(null);
        oSelectedButton.setBlPress(true);
        oSelectedButton.repaint();
    }

    private void resetWindowStyleSpecialButton(WindowStyleSpecialButton oWindowStyleBtn) {
        oWindowStyleBtn.removeActionListener(c_oListener);
        oWindowStyleBtn.getModel().setPressed(false);
        oWindowStyleBtn.setBorder(null);
        oWindowStyleBtn.setBlPress(false);
        oWindowStyleBtn.repaint();
        oWindowStyleBtn.addActionListener(c_oListener);
    }

    private void addComponentToToolBar(JComponent oComponent) {
        this.m_oToolBar.add(oComponent);
        this.m_oToolBar.repaint();
    }

    public DeviceTree getDeviceTree() {
        return this.m_oDeviceTreePanel.getDeviceTree();
    }

    public void disposePanel() {
        this.m_oButtonGroup = null;
        c_oResourceManager = null;
        this.m_oDeviceTreePanel = null;
        if (null != c_oListener) {
            c_oListener.dispose();
            c_oListener = null;
        }
        if (null != this.m_oToolBar) {
            this.m_oToolBar.removeAll();
            this.m_oToolBar = null;
        }
        if (null != this.m_oToolBarModel) {
            this.m_oToolBarModel.dispose();
            this.m_oToolBarModel = null;
        }
    }
}

