/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.components.devicetreepanel;

import com.huawei.dc.common.components.deviceselection.dropdown.DevBoardTypeEvent;
import com.huawei.dc.common.components.deviceselection.dropdown.DeviceDropDownChangeEvent;
import com.huawei.dc.common.components.deviceselection.dropdown.DeviceDropDownChangeListener;
import com.huawei.dc.common.components.deviceselection.table.DeviceSelectionCommTablePanel;
import com.huawei.dc.common.components.deviceselection.table.DeviceTableActionEvent;
import com.huawei.dc.common.components.deviceselection.table.DeviceTableActionListener;
import com.huawei.dc.common.components.devicetreepanel.DeviceTreePanel;
import com.huawei.dc.common.components.tree.devicetree.DeviceTree;
import com.huawei.dc.common.components.tree.devicetree.DeviceTreeUtil;
import com.huawei.dc.common.components.tree.devicetree.descriptor.DeviceTreeBaseDescriptor;
import com.huawei.dc.common.components.tree.devicetree.descriptor.DeviceTypeTreeDescriptor;
import com.huawei.dc.common.components.tree.devicetree.descriptor.DeviceVersionTreeDescriptor;
import com.huawei.dc.common.framework.interfaces.DCTreeEventListener;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.model.DeviceModelAdapter;
import com.huawei.dc.taskmgmt.controller.IUpgradeFeasibilityEventListener;
import com.huawei.dc.taskmgmt.controller.UpgradeFeasibilityNotifier;
import com.huawei.dc.taskmgmt.model.Resource;
import gnu.trove.THashSet;
import java.util.List;
import javax.swing.SwingUtilities;

public class DeviceTreePanelEventHandler
implements DeviceDropDownChangeListener,
DeviceTableActionListener,
IUpgradeFeasibilityEventListener {
    private DeviceTreePanel m_oDeviceTreePanel;
    private DeviceSelectionCommTablePanel m_oDeviceTablePanel;
    private DeviceTypeInfo m_oCurrentDeviceType;
    private String m_strCurrentVersion;

    public DeviceTreePanelEventHandler(DeviceTreePanel oTreePanel, DeviceSelectionCommTablePanel oTablePanel, boolean bSupportAllVersions) {
        this.m_oDeviceTreePanel = oTreePanel;
        this.m_oDeviceTablePanel = oTablePanel;
        UpgradeFeasibilityNotifier.getInstance().addUpgradeFeasibilityEventListener(this);
    }

    @Override
    public void onDropDownSelecton(DeviceDropDownChangeEvent oEvent) {
        int iSelectionType = oEvent.getSelectionType();
        if (1 == iSelectionType) {
            if (!(oEvent.getSource() instanceof DeviceTypeInfo)) {
                return;
            }
            this.m_oCurrentDeviceType = (DeviceTypeInfo)oEvent.getSource();
            this.m_strCurrentVersion = "";
            String sDevVersion = oEvent.getDeviceVersion();
            if (null != sDevVersion) {
                this.m_strCurrentVersion = sDevVersion;
            }
            this.m_oDeviceTablePanel.updateTableForDeviceDropDownChange(this.m_oCurrentDeviceType, this.m_strCurrentVersion);
            this.updateTreeForDeviceDropDownChange(null);
        } else if (4 == iSelectionType) {
            if (!(oEvent.getSource() instanceof DeviceTypeInfo)) {
                return;
            }
            this.m_oCurrentDeviceType = (DeviceTypeInfo)oEvent.getSource();
            this.m_strCurrentVersion = "";
        } else if (2 == iSelectionType) {
            this.m_strCurrentVersion = (String)oEvent.getSource();
            int allDevType = -1;
            if (-1 == this.m_oCurrentDeviceType.getDevTypeID()) {
                this.m_oDeviceTablePanel.updateTableForDeviceDropDownChange(this.m_oCurrentDeviceType, this.m_strCurrentVersion);
                return;
            }
            this.m_oDeviceTablePanel.updateTableForDeviceDropDownChange(this.m_oCurrentDeviceType, this.m_strCurrentVersion);
            this.updateTreeForDeviceDropDownChange(null);
        } else if (3 == iSelectionType) {
            DevBoardTypeEvent oDevBoardTypeEvent = (DevBoardTypeEvent)oEvent.getSource();
            this.m_strCurrentVersion = oDevBoardTypeEvent.getSelectedVersion();
            int allDevType = -1;
            if (-1 == this.m_oCurrentDeviceType.getDevTypeID()) {
                this.m_oDeviceTablePanel.updateTableForDeviceDropDownChange(this.m_oCurrentDeviceType, this.m_strCurrentVersion);
                return;
            }
            this.m_oDeviceTablePanel.updateTableForDeviceDropDownChange(this.m_oCurrentDeviceType, this.m_strCurrentVersion);
            this.updateTreeForDeviceDropDownChange(oDevBoardTypeEvent);
        }
    }

    private void updateTreeForDeviceDropDownChange(DevBoardTypeEvent oDevBoardTypeEvent) {
        DeviceTree oDeviceTree = this.m_oDeviceTreePanel.getDeviceTree();
        if (null == oDeviceTree) {
            return;
        }
        int iCurrentTreeDataType = oDeviceTree.getTreeDescriptor().getViewType();
        DeviceTreeBaseDescriptor oTreeDescriptor = this.createTreeDescriptor(iCurrentTreeDataType, oDevBoardTypeEvent);
        this.m_oDeviceTreePanel.updateDeviceTree(oTreeDescriptor);
        oDeviceTree = this.m_oDeviceTreePanel.getDeviceTree();
        THashSet<Resource> oCurrentResources = this.m_oDeviceTablePanel.getCurrentResources();
        if (oCurrentResources.size() != 0) {
            DeviceTreeUtil.setTreeNodeSelectionStateForResources(oDeviceTree, oCurrentResources, 0, false);
            oDeviceTree.updateUI();
        }
    }

    private DeviceTreeBaseDescriptor createTreeDescriptor(int iCurrentTreeDataType, DevBoardTypeEvent oDevBoardTypeEvent) {
        DeviceTreeBaseDescriptor oTreeDescriptor = null;
        oTreeDescriptor = null != this.m_strCurrentVersion && !"".equals(this.m_strCurrentVersion) ? (null == oDevBoardTypeEvent ? new DeviceVersionTreeDescriptor(iCurrentTreeDataType, this.m_strCurrentVersion, this.m_oCurrentDeviceType) : new DeviceVersionTreeDescriptor(iCurrentTreeDataType, oDevBoardTypeEvent.getSelectedVersion(), oDevBoardTypeEvent.getDevBoardType(), this.m_oCurrentDeviceType)) : (null == oDevBoardTypeEvent ? new DeviceTypeTreeDescriptor(iCurrentTreeDataType, this.m_oCurrentDeviceType.getDevTypeID(), this.m_oCurrentDeviceType.getDevTypeVersionId()) : new DeviceTypeTreeDescriptor(iCurrentTreeDataType, this.m_oCurrentDeviceType.getDevTypeID(), this.m_oCurrentDeviceType.getDevTypeVersionId(), oDevBoardTypeEvent.getDevBoardType()));
        oTreeDescriptor.setTreeSelectable(true);
        return oTreeDescriptor;
    }

    @Override
    public void onTableActionPerformed(DeviceTableActionEvent oEvent) {
        List oDeletedOLTDevVerLst;
        int iEventType = oEvent.getEventType();
        if (1 == iEventType) {
            THashSet oDeletedDevices = (THashSet)oEvent.getSource();
            if (null != oDeletedDevices && oDeletedDevices.size() != 0) {
                final DeviceTree oDeviceTree = this.m_oDeviceTreePanel.getDeviceTree();
                DeviceTreeUtil.setTreeNodeSelectionStateForResources(oDeviceTree, (THashSet<Resource>)oDeletedDevices, 2, false);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        oDeviceTree.treeDidChange();
                    }
                });
            }
        } else if (2 == iEventType && null != (oDeletedOLTDevVerLst = (List)oEvent.getSource()) && 0 != oDeletedOLTDevVerLst.size()) {
            final DeviceTree oDeviceTree = this.m_oDeviceTreePanel.getDeviceTree();
            DeviceTreeUtil.setTreeNodeSelectionStateForOLT(oDeviceTree, oDeletedOLTDevVerLst, 2);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    oDeviceTree.treeDidChange();
                }
            });
        }
    }

    public void registerForTreeSelectionEvent(DCTreeEventListener oEventListener) {
        this.m_oDeviceTreePanel.addDCEventListener(oEventListener);
    }

    @Override
    public void setCurrentEvent(DeviceDropDownChangeEvent oEvent) {
        if (oEvent.getSource() instanceof DeviceTypeInfo) {
            this.m_oCurrentDeviceType = (DeviceTypeInfo)oEvent.getSource();
            String sDeviceVersion = oEvent.getDeviceVersion();
            if (null != sDeviceVersion) {
                this.m_strCurrentVersion = sDeviceVersion;
            }
        } else if (oEvent.getSource() instanceof String) {
            this.m_strCurrentVersion = (String)oEvent.getSource();
        }
    }

    @Override
    public void onUpgradeFeasibilityEvent(List<Integer> oFailedDevList) {
        int iListSize = oFailedDevList.size();
        final DeviceTree oDeviceTree = this.m_oDeviceTreePanel.getDeviceTree();
        if (iListSize != 0) {
            THashSet oResList = new THashSet();
            Resource oResource = null;
            for (int i = 0; i < iListSize; ++i) {
                int iDevId = oFailedDevList.get(i);
                oResource = DeviceModelAdapter.populateResourceFromDeviceID(iDevId);
                oResList.add((Object)oResource);
            }
            DeviceTreeUtil.setTreeNodeSelectionStateForResources(oDeviceTree, (THashSet<Resource>)oResList, 2, false);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    oDeviceTree.treeDidChange();
                }
            });
        }
    }
}

