/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.components.devicetreepanel;

import com.huawei.dc.common.asndatacenter.AsnDCDeviceSubmapNtfnInfo;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceSubmapNtfnInfoLst;
import com.huawei.dc.common.components.devicetreepanel.DeviceTreeToolBarModel;
import com.huawei.dc.common.components.devicetreepanel.DeviceTreeToolBarPanel;
import com.huawei.dc.common.components.tree.devicetree.DeviceTree;
import com.huawei.dc.common.components.tree.devicetree.DeviceTreeFactory;
import com.huawei.dc.common.components.tree.devicetree.descriptor.DeviceTreeBaseDescriptor;
import com.huawei.dc.common.components.tree.devicetree.model.DeviceTreeModel;
import com.huawei.dc.common.components.tree.devicetree.model.DeviceTreeNode;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.interfaces.DCTreeEventListener;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.tree.TreeNodeInfo;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.deviceoperation.IDeviceOperationManager;
import com.huawei.dc.deviceoperation.deviceconfigchange.DeviceConfigEventReceiver;
import com.huawei.dc.deviceoperation.deviceconfigchange.IDeviceConfigChangeListener;
import com.huawei.dc.sam.model.ISAMFileInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DeviceTreePanel
extends JPanel
implements IDeviceConfigChangeListener {
    private static final long serialVersionUID = 1L;
    protected DeviceTree m_oDeviceTree;
    private JScrollPane m_oTreeScrollPane;
    protected IDeviceInfoManager c_oDeviceInfoMgr;
    protected IDeviceOperationManager c_oDeviceOperationManager;
    protected DeviceTreeBaseDescriptor m_oCurrentTreeDescriptor;
    private DeviceTreeToolBarPanel m_oToolBarPanel;
    private DeviceTreeToolBarModel m_oButtonModel;
    private ArrayList m_oDeviceTreeListeners;
    private static final int LISTENER_LIST_DEFAULT_SIZE = 1;
    public static final int DEVICE_NOTIFICATION_TYPE_ADD = 0;
    public static final int DEVICE_NOTIFICATION_TYPE_DELETE = 1;
    public static final int DEVICE_NOTIFICATION_TYPE_MODIFY = 2;
    public String rootName = "";
    private JTextField m_oSearchTextField;

    public JTextField getSearchTextField() {
        return this.m_oSearchTextField;
    }

    public void setSearchTextField(JTextField oSearchTextField) {
        this.m_oSearchTextField = oSearchTextField;
    }

    public DeviceTreePanel(DeviceTreeToolBarModel oButtonModel, DeviceTreeBaseDescriptor oTreeDescriptor, String strRootName) {
        this.initializeDeviceManagers();
        this.m_oCurrentTreeDescriptor = oTreeDescriptor;
        this.m_oButtonModel = oButtonModel;
        this.rootName = strRootName;
        this.jInit();
        this.registerForNotifications();
        this.initializeTreeListeners();
        this.m_oDeviceTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                DeviceTreePanel.this.generateMouseAdapterForTree(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                DeviceTreePanel.this.generateMouseAdapterForTree(e);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                DeviceTreePanel.this.generateMouseAdapterForTree(e);
            }
        });
    }

    private void generateMouseAdapterForTree(MouseEvent e) {
        if (null != DCFrameWorkUtil.getDeviceTablePanel()) {
            DCFrameWorkUtil.getDeviceTablePanel().refreshSelectedDevCountLabel();
        }
    }

    protected void initializeDeviceManagers() {
        this.c_oDeviceInfoMgr = DCFrameWorkUtil.getDeviceInfoManager();
        this.c_oDeviceOperationManager = DCFrameWorkUtil.getDeviceOperationManager();
    }

    private void jInit() {
        this.setLayout(new BorderLayout());
        this.createDeviceTree();
        if (null != this.m_oButtonModel && !this.m_oButtonModel.isEmpty()) {
            this.createToolBarWithButtons();
        }
        this.m_oTreeScrollPane = new JScrollPane();
        this.m_oTreeScrollPane.setViewportView(this.m_oDeviceTree);
        this.add((Component)this.m_oTreeScrollPane, "Center");
    }

    private void createToolBarWithButtons() {
        this.m_oToolBarPanel = new DeviceTreeToolBarPanel(this, this.c_oDeviceInfoMgr, this.m_oButtonModel);
        this.add((Component)this.m_oToolBarPanel, "North");
        this.m_oToolBarPanel.updateUI();
        this.updateUI();
    }

    protected void createDeviceTree() {
        this.m_oDeviceTree = DeviceTreeFactory.createDeviceTree(this.m_oCurrentTreeDescriptor, this.c_oDeviceInfoMgr, this.rootName);
        this.m_oDeviceTree.setName("DeviceTreePanel_DeviceTreePanel_m_oDeviceTree");
        this.expandTreeAtRoot();
    }

    private void expandTreeAtRoot() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TreePath rowTreePathNext;
                if (null == DeviceTreePanel.this.m_oDeviceTree) {
                    DCDebugTracer.trace("DC:: m_oDeviceTree is null!");
                    return;
                }
                TreePath rowTreePath = DeviceTreePanel.this.m_oDeviceTree.getPathForRow(0);
                if (DeviceTreePanel.this.m_oDeviceTree.isCollapsed(rowTreePath)) {
                    DeviceTreePanel.this.m_oDeviceTree.expandPath(rowTreePath);
                }
                if (DeviceTreePanel.this.m_oCurrentTreeDescriptor.getViewType() == 3 && DeviceTreePanel.this.m_oDeviceTree.isCollapsed(rowTreePathNext = DeviceTreePanel.this.m_oDeviceTree.getPathForRow(1))) {
                    DeviceTreePanel.this.m_oDeviceTree.expandPath(rowTreePathNext);
                }
                DeviceTreePanel.this.m_oDeviceTree.setModel(DeviceTreePanel.this.m_oDeviceTree.getModel());
                DeviceTreePanel.this.m_oDeviceTree.updateUI();
            }
        });
    }

    private void initializeTreeListeners() {
        this.m_oDeviceTreeListeners = new ArrayList(1);
    }

    private void registerForNotifications() {
        DeviceConfigEventReceiver.getInstance().resigterForConfigChangeEvent(this);
        if (null != this.c_oDeviceOperationManager) {
            this.c_oDeviceOperationManager.registerNotification(this);
        }
    }

    public void unrgisterForNotifications() {
        DeviceConfigEventReceiver.getInstance().unResigterForConfigChangeEvent(this);
        if (null != this.c_oDeviceOperationManager) {
            this.c_oDeviceOperationManager.unRegisterNotification(this);
        }
    }

    public synchronized void refreshDeviceTree(int iViewType) {
        DeviceTreeBaseDescriptor oDescriptor = null;
        oDescriptor = null != this.m_oDeviceTree ? this.m_oDeviceTree.getTreeDescriptor() : this.m_oCurrentTreeDescriptor;
        if (null == oDescriptor || oDescriptor.getTreeType() != iViewType) {
            return;
        }
        this.updateDeviceTree(oDescriptor);
    }

    public synchronized void refreshDeviceTree() {
        DeviceTreeBaseDescriptor oDescriptor = null;
        oDescriptor = null != this.m_oDeviceTree ? this.m_oDeviceTree.getTreeDescriptor() : this.m_oCurrentTreeDescriptor;
        this.updateDeviceTree(oDescriptor);
    }

    public void addDCEventListener(DCTreeEventListener oEventListener) {
        if (null != this.m_oDeviceTree) {
            this.m_oDeviceTree.registerForTreeSelectionEvent(oEventListener);
        }
        this.m_oDeviceTreeListeners.add(oEventListener);
    }

    private void removeAllDCEventListeners() {
        if (null != this.m_oDeviceTreeListeners) {
            int iSize = this.m_oDeviceTreeListeners.size();
            for (int i = iSize - 1; i >= 0; --i) {
                this.removeDCEventListener((DCTreeEventListener)this.m_oDeviceTreeListeners.get(i));
            }
        }
    }

    public void removeDCEventListener(DCTreeEventListener oEventListener) {
        if (null != this.m_oDeviceTree) {
            this.m_oDeviceTree.unregisterForTreeSelectionEvent(oEventListener);
        }
        if (null != this.m_oDeviceTreeListeners) {
            this.m_oDeviceTreeListeners.remove(oEventListener);
        }
    }

    public DeviceTree getDeviceTree() {
        return this.m_oDeviceTree;
    }

    public void setDeviceTreeNode(TreePath oPath) {
        int iRowIndex = -1;
        iRowIndex = this.m_oDeviceTree.getRowForPath(oPath);
        if (-1 != iRowIndex) {
            this.m_oDeviceTree.setSelectionPath(oPath);
        } else {
            this.m_oDeviceTree.setSelectionRow(0);
        }
    }

    public synchronized void updateDeviceTree(DeviceTreeBaseDescriptor oTreeDescriptor) {
        this.updateDeviceTree(oTreeDescriptor, true);
    }

    public void updateDeviceTree(DeviceTreeBaseDescriptor oTreeDescriptor, boolean bSendNotification) {
        if (null != this.m_oDeviceTree) {
            this.m_oTreeScrollPane.remove(this.m_oDeviceTree);
            this.m_oDeviceTree.disposeTree();
        }
        this.m_oDeviceTree = DeviceTreeFactory.createDeviceTree(oTreeDescriptor, this.c_oDeviceInfoMgr, this.rootName);
        if (null == this.m_oDeviceTree) {
            return;
        }
        this.m_oDeviceTree.setName("DeviceTreePanel_DeviceTreePanel_m_oDeviceTree");
        this.m_oCurrentTreeDescriptor = oTreeDescriptor;
        this.populateTreeListeners();
        if (bSendNotification && !oTreeDescriptor.isTreeSelectable()) {
            this.m_oDeviceTree.notifyNodeSelection(this.m_oDeviceTree.getRoot());
        }
        try {
            this.m_oTreeScrollPane.setViewportView(this.m_oDeviceTree);
        }
        catch (Exception e) {
            DCDebugTracer.trace("handle exception,not issue.");
        }
        this.expandTreeAtRoot();
    }

    public void updateDeviceTreeByFilter(DeviceTreeBaseDescriptor oTreeDescriptor, boolean bSendNotification, DeviceInfo[] deviceInfoList, String rootName) {
        if (null != this.m_oDeviceTree) {
            this.m_oTreeScrollPane.remove(this.m_oDeviceTree);
            this.m_oDeviceTree.disposeTree();
        }
        this.m_oDeviceTree = DeviceTreeFactory.createDeviceTreeByFilter(oTreeDescriptor, deviceInfoList, rootName);
        if (null == this.m_oDeviceTree) {
            return;
        }
        this.m_oDeviceTree.setName("DeviceTreePanel_DeviceTreePanel_m_oDeviceTree");
        this.m_oCurrentTreeDescriptor = oTreeDescriptor;
        this.populateTreeListeners();
        if (bSendNotification && !oTreeDescriptor.isTreeSelectable()) {
            this.m_oDeviceTree.notifyNodeSelection(this.m_oDeviceTree.getRoot());
        }
        try {
            this.m_oTreeScrollPane.setViewportView(this.m_oDeviceTree);
        }
        catch (Exception e) {
            DCDebugTracer.trace("handle exception,not issue.");
        }
        this.expandTreeAtRoot();
    }

    public void updateToolBar(DeviceTreeToolBarModel oToolBarModel) {
        if (null != this.m_oToolBarPanel) {
            this.remove(this.m_oToolBarPanel);
        }
        this.m_oButtonModel = oToolBarModel;
        this.createToolBarWithButtons();
    }

    private void populateTreeListeners() {
        int iListenerCount = this.m_oDeviceTreeListeners.size();
        for (int i = 0; i < iListenerCount; ++i) {
            this.m_oDeviceTree.registerForTreeSelectionEvent((DCTreeEventListener)this.m_oDeviceTreeListeners.get(i));
        }
    }

    public void disposePanel() {
        DeviceConfigEventReceiver.getInstance().unResigterForConfigChangeEvent(this);
        if (null != this.m_oDeviceTree) {
            this.m_oDeviceTree.removeAll();
            this.m_oDeviceTree.disposeTree();
            this.m_oDeviceTree = null;
        }
        if (null != this.m_oToolBarPanel) {
            this.m_oToolBarPanel.disposePanel();
            this.m_oToolBarPanel = null;
        }
        this.c_oDeviceInfoMgr = null;
        this.m_oTreeScrollPane = null;
        this.c_oDeviceOperationManager = null;
        this.m_oCurrentTreeDescriptor = null;
        this.m_oButtonModel = null;
        this.removeAllDCEventListeners();
        this.m_oDeviceTreeListeners = null;
        this.removeAll();
    }

    @Override
    public void handleDeviceConfigNotification(int iEventType, AsnDCDeviceSubmapNtfnInfoLst oDeviceInfoList) {
        if (this.rootName.equals(ResourceManager.getInstance().getResString("SAM_ROOT"))) {
            return;
        }
        AsnDCDeviceSubmapNtfnInfo oAsnDeviceInfo = null;
        for (int i = 0; i < oDeviceInfoList.size(); ++i) {
            oAsnDeviceInfo = (AsnDCDeviceSubmapNtfnInfo)oDeviceInfoList.get(i);
            if (null == this.m_oDeviceTree) continue;
            this.m_oDeviceTree.processEvent(iEventType, oAsnDeviceInfo);
        }
        if (null != this.m_oDeviceTree) {
            DCFrameWorkUtil.updateUI(this.m_oDeviceTree);
        }
        DCFrameWorkUtil.updateUI(this);
    }

    public DeviceTreeToolBarPanel getToolBarPanel() {
        return this.m_oToolBarPanel;
    }

    public List getSelectedResources() {
        return this.m_oDeviceTree.getSelectedResources();
    }

    public void updateSAMDeviceTreeNode(DeviceTypeInfo oDeviceTypeInfo, ISAMFileInfo oSAMFileInfo) {
        DefaultMutableTreeNode oRootNode = this.m_oDeviceTree.getRoot();
        String strDeviceVersion = oSAMFileInfo.getVersion();
        boolean bisDevVersionNodeExist = false;
        DefaultMutableTreeNode oDeviceTypeNode = this.getDeviceTypeNode(oRootNode, oDeviceTypeInfo.toString());
        if (null == oDeviceTypeNode) {
            TreeNodeInfo oTreeNodeInfo = new TreeNodeInfo(oDeviceTypeInfo);
            oDeviceTypeNode = new DefaultMutableTreeNode();
            oDeviceTypeNode.setUserObject(oTreeNodeInfo);
            oRootNode.add(oDeviceTypeNode);
        }
        if (!(bisDevVersionNodeExist = this.isDeviceVersionNodeExists(oDeviceTypeNode, oSAMFileInfo.getVersion()))) {
            DefaultMutableTreeNode oDeviceVersionNode = new DefaultMutableTreeNode();
            TreeNodeInfo oTreeNodeInfo = new TreeNodeInfo(strDeviceVersion, oDeviceTypeInfo);
            oDeviceVersionNode.setUserObject(oTreeNodeInfo);
            oDeviceTypeNode.add(oDeviceVersionNode);
            DCFrameWorkUtil.updateUI(this.m_oDeviceTree);
        }
    }

    public DefaultMutableTreeNode getDeviceTypeNode(DefaultMutableTreeNode oRootNode, String strDevType) {
        DefaultMutableTreeNode oDevTypeNode = null;
        boolean bNodePresent = false;
        int iDevTypeCount = oRootNode.getChildCount();
        for (int index = 0; index < iDevTypeCount; ++index) {
            oDevTypeNode = (DefaultMutableTreeNode)oRootNode.getChildAt(index);
            if (!oDevTypeNode.toString().equals(strDevType)) continue;
            bNodePresent = true;
            break;
        }
        if (!bNodePresent) {
            return null;
        }
        return oDevTypeNode;
    }

    private boolean isDeviceVersionNodeExists(DefaultMutableTreeNode oDeviceTypeNode, String strVersion) {
        DefaultMutableTreeNode oDevVersionNode = null;
        boolean isDevVersionExist = false;
        int iDevVersionCount = oDeviceTypeNode.getChildCount();
        for (int index = 0; index < iDevVersionCount; ++index) {
            oDevVersionNode = (DefaultMutableTreeNode)oDeviceTypeNode.getChildAt(index);
            if (!oDevVersionNode.toString().equals(strVersion)) continue;
            isDevVersionExist = true;
            break;
        }
        return isDevVersionExist;
    }

    public void setTreeNodeVisibleBySearchContent(String strContent) {
        DeviceTreeModel oDeviceTreeModel = (DeviceTreeModel)this.m_oDeviceTree.getModel();
        if (strContent.equals("")) {
            oDeviceTreeModel.activateFilter(false);
        } else {
            oDeviceTreeModel.activateFilter(true);
        }
        Enumeration<TreeNode> oChildEnum = this.m_oDeviceTree.getRoot().depthFirstEnumeration();
        while (oChildEnum.hasMoreElements()) {
            DeviceTreeNode oTreeNode = (DeviceTreeNode)oChildEnum.nextElement();
            TreeNodeInfo oNodeInfo = (TreeNodeInfo)oTreeNode.getUserObject();
            if (strContent.equals("")) {
                oTreeNode.setVisible(true);
                oNodeInfo.setVisible(true);
                continue;
            }
            if (4 != oNodeInfo.m_iNodeType) {
                if (oTreeNode.getChildCount(true) > 0) {
                    oTreeNode.setVisible(true);
                    oNodeInfo.setVisible(true);
                    continue;
                }
                oTreeNode.setVisible(false);
                oNodeInfo.setVisible(false);
                continue;
            }
            if (oNodeInfo.m_nodeName.toLowerCase().indexOf(strContent.toLowerCase()) >= 0) {
                oTreeNode.setVisible(true);
                oNodeInfo.setVisible(true);
                continue;
            }
            oTreeNode.setVisible(false);
            oNodeInfo.setVisible(false);
        }
        oChildEnum = null;
        oDeviceTreeModel.reload();
        this.expandAll(this.m_oDeviceTree, new TreePath(this.m_oDeviceTree.getRoot()), oDeviceTreeModel.isActivatedFilter());
    }

    private void expandAll(JTree tree, TreePath parent, boolean activateFilter) {
        try {
            DeviceTreeNode node = (DeviceTreeNode)parent.getLastPathComponent();
            if (node.getChildCount() >= 0) {
                Enumeration<TreeNode> e = node.children();
                while (e.hasMoreElements()) {
                    DeviceTreeNode n = (DeviceTreeNode)e.nextElement();
                    if (null == n) {
                        return;
                    }
                    if (!n.isVisible()) continue;
                    TreePath path = parent.pathByAddingChild(n);
                    this.expandAll(tree, path, activateFilter);
                }
                node = null;
            }
            tree.expandPath(parent);
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
    }
}

