/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.components.devicetreepanel;

import com.huawei.dc.common.components.devicetreepanel.DeviceImportExport;
import com.huawei.dc.common.components.devicetreepanel.DeviceTreePanel;
import com.huawei.dc.common.components.devicetreepanel.DeviceTreeToolBarPanel;
import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.components.tree.devicetree.DeviceTree;
import com.huawei.dc.common.components.tree.devicetree.descriptor.DeviceTreeBaseDescriptor;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.tree.TreeHelper;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.devicemanagement.deviceview.devicetable.devicesearch.DeviceFilterPanel;
import com.huawei.dc.devicemanagement.deviceview.devicetable.devicesearch.DeviceSearchDialog;
import com.huawei.dc.devicemanagement.deviceview.devicetable.devicesearch.DeviceSearchModel;
import com.huawei.dc.devicemanagement.deviceview.devicetable.devicesearch.DeviceSearchOnTreeManger;
import com.huawei.dc.taskmgmt.view.createtask.CreateTaskDeviceSelectionPanel;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.tree.TreePath;

public class DeviceTreeButtonListener
implements ActionListener {
    private DeviceTreePanel m_oDeviceTreePanel;
    private DeviceTreeToolBarPanel m_oDeviceTreeToolBarPanel;
    private DeviceImportExport m_oDeviceImportExport = new DeviceImportExport();

    public void initializeListener(DeviceTreePanel oDeviceTreePanel, IDeviceInfoManager oDeviceInfoManager, DeviceTreeToolBarPanel oToolBarPanel) {
        this.m_oDeviceTreePanel = oDeviceTreePanel;
        this.m_oDeviceTreeToolBarPanel = oToolBarPanel;
    }

    @Override
    public void actionPerformed(ActionEvent oActionEvent) {
        String oActionCommand = oActionEvent.getActionCommand();
        JButton oButton = (JButton)oActionEvent.getSource();
        if (null == oActionCommand) {
            return;
        }
        if (null == this.m_oDeviceTreePanel) {
            DCDebugTracer.trace("DeviceTreeButtonListener#actionPerformed=>m_oDeviceTreePanel is null, oActionCommand = " + oActionCommand);
            return;
        }
        this.processActionCommand(oActionCommand, oButton);
    }

    private void processActionCommand(String oActionCommand, JButton oButton) {
        if ("DEVICE_ACTION".equalsIgnoreCase(oActionCommand)) {
            this.deviceButtonActionPerformed();
            this.m_oDeviceTreeToolBarPanel.updateButtonsForCurrentSelection(oButton);
        } else if ("SUBMAP_ACTION".equalsIgnoreCase(oActionCommand)) {
            this.submapButtonActionPerformed();
            this.m_oDeviceTreeToolBarPanel.updateButtonsForCurrentSelection(oButton);
        } else if ("DEVICE_BOARD_ACTION".equalsIgnoreCase(oActionCommand)) {
            this.deviceBoardButtonActionPerformed();
            this.m_oDeviceTreeToolBarPanel.updateButtonsForCurrentSelection(oButton);
        } else if ("SUBMAP_BOARD_ACTION".equalsIgnoreCase(oActionCommand)) {
            this.submapBoardButtonActionPerformed();
            this.m_oDeviceTreeToolBarPanel.updateButtonsForCurrentSelection(oButton);
        } else if ("IMPORT_ACTION".equalsIgnoreCase(oActionCommand)) {
            this.importButtonActionPerformed();
            this.m_oDeviceTreePanel.updateUI();
        } else if ("EXPORT_ACTION".equalsIgnoreCase(oActionCommand)) {
            this.exportButtonActionPerformed();
        } else if ("SEARCH_ACTION".equalsIgnoreCase(oActionCommand)) {
            this.searchButtonActionPerformed();
        } else if ("FILTER_ACTION".equalsIgnoreCase(oActionCommand)) {
            this.filterButtonActionPerformed();
        } else if ("EXPAND_ACTION".equalsIgnoreCase(oActionCommand)) {
            this.expandButtonActionPerformed();
        } else if ("COLLAPSE_ACTION".equalsIgnoreCase(oActionCommand)) {
            this.collapseButtonActionPerformed();
        }
    }

    protected void collapseButtonActionPerformed() {
        DeviceTree tree = this.m_oDeviceTreePanel.getDeviceTree();
        TreePath trePath = new TreePath(tree.getRoot());
        TreeHelper.expandAll(tree, trePath, false);
    }

    protected void expandButtonActionPerformed() {
        DeviceTree tree = this.m_oDeviceTreePanel.getDeviceTree();
        TreePath trePath = new TreePath(tree.getRoot());
        TreeHelper.expandAll(tree, trePath, true);
    }

    protected void importButtonActionPerformed() {
        this.m_oDeviceImportExport.importButtonActionPerformed(this.m_oDeviceTreePanel.getDeviceTree(), this.m_oDeviceTreePanel);
    }

    protected void exportButtonActionPerformed() {
        this.m_oDeviceImportExport.exportButtonActionPerformed(this.m_oDeviceTreePanel.getDeviceTree());
    }

    protected void deviceButtonActionPerformed() {
        this.createTreeForDataType(1);
    }

    protected void submapButtonActionPerformed() {
        this.createTreeForDataType(3);
    }

    protected void deviceBoardButtonActionPerformed() {
        this.createTreeForDataType(2);
    }

    protected void submapBoardButtonActionPerformed() {
        this.createTreeForDataType(4);
    }

    private void createTreeForDataType(int iDeviceTreeDataType) {
        DeviceTree oDeviceTree;
        if (null != this.m_oDeviceTreePanel.getSearchTextField()) {
            this.m_oDeviceTreePanel.getSearchTextField().setText("");
        }
        if (null == (oDeviceTree = this.m_oDeviceTreePanel.getDeviceTree())) {
            return;
        }
        DeviceTreeBaseDescriptor oDeviceTreeDescriptor = oDeviceTree.getTreeDescriptor();
        if (null != oDeviceTreeDescriptor && iDeviceTreeDataType != oDeviceTreeDescriptor.getViewType()) {
            oDeviceTreeDescriptor.setViewType(iDeviceTreeDataType);
            this.m_oDeviceTreePanel.updateDeviceTree(oDeviceTreeDescriptor);
            this.m_oDeviceTreePanel.getDeviceTree().notifyTreeInit();
        }
    }

    protected void filterButtonActionPerformed() {
    }

    protected void searchButtonActionPerformed() {
        DeviceSearchDialog oDialog = null;
        DeviceFilterPanel oFilterDialog = null;
        DeviceSearchModel oSearchModel = this.createSearchModel();
        DeviceSearchOnTreeManger oManager = new DeviceSearchOnTreeManger(this.m_oDeviceTreePanel);
        Container parentDlgObj = this.m_oDeviceTreePanel.getParent().getParent().getParent();
        if (DCFrameWorkUtil.getIsSingleClient()) {
            if (parentDlgObj instanceof CreateTaskDeviceSelectionPanel) {
                DCModalDialog parentDlg = ((CreateTaskDeviceSelectionPanel)parentDlgObj).getCreateTaskDlg();
                oFilterDialog = new DeviceFilterPanel(oSearchModel, oManager, this.m_oDeviceTreePanel, true, parentDlg);
            } else {
                oFilterDialog = new DeviceFilterPanel(oSearchModel, oManager, this.m_oDeviceTreePanel, true);
            }
        } else if (parentDlgObj instanceof CreateTaskDeviceSelectionPanel) {
            DCModalDialog parentDlg = ((CreateTaskDeviceSelectionPanel)parentDlgObj).getCreateTaskDlg();
            oDialog = new DeviceSearchDialog(oSearchModel, oManager, this.m_oDeviceTreePanel, true, parentDlg);
        } else {
            oDialog = new DeviceSearchDialog(oSearchModel, oManager, this.m_oDeviceTreePanel, true);
        }
        if (null != oDialog) {
            oDialog.setVisible(true);
        } else if (null != oFilterDialog) {
            oFilterDialog.setVisible(true);
        }
    }

    public void dispose() {
        this.m_oDeviceImportExport = null;
        this.m_oDeviceTreePanel = null;
        this.m_oDeviceTreeToolBarPanel = null;
    }

    private DeviceSearchModel createSearchModel() {
        DeviceSearchModel oModel = new DeviceSearchModel();
        oModel.setDeviceTypeList(this.getDeviceTypeList());
        oModel.setSearchModeList(this.getSearchModeList());
        return oModel;
    }

    private Vector getDeviceTypeList() {
        ResourceManager oResManager = ResourceManager.getInstance();
        Vector<String> oTypeList = new Vector<String>(2);
        oTypeList.add(oResManager.getResString("SEARCH_RESOURCE_TYPE_DEVICE"));
        return oTypeList;
    }

    private Vector getSearchModeList() {
        ResourceManager oResManager = ResourceManager.getInstance();
        Vector<String> oModeList = new Vector<String>(2);
        oModeList.add(oResManager.getResString("SEARCH_DEVICE_MODE_NAME_OPTION"));
        oModeList.add(oResManager.getResString("SEARCH_DEVICE_MODE_IP_OPTION"));
        return oModeList;
    }
}

