/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.components.devicetreepanel;

import com.huawei.dc.common.ProgressDlgForImport;
import com.huawei.dc.common.components.devicetreepanel.DeviceTreePanel;
import com.huawei.dc.common.components.tree.devicetree.BoardTree;
import com.huawei.dc.common.components.tree.devicetree.DeviceTree;
import com.huawei.dc.common.components.tree.devicetree.DeviceTreeUtil;
import com.huawei.dc.common.components.tree.devicetree.listener.DeviceTreeListener;
import com.huawei.dc.common.components.tree.devicetree.model.DeviceTreeModel;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.tree.TreeNodeInfo;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCFileChooser;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.DCSaveFileChooser;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.taskmgmt.model.Resource;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;

public class DeviceImportExport {
    private boolean bStopImporting = false;
    private DeviceTreePanel m_oDevTreePanel;

    protected void importButtonActionPerformed(DeviceTree oTree, DeviceTreePanel oDeviceTreePanel) {
        this.m_oDevTreePanel = oDeviceTreePanel;
        String strFilename = this.getFileName();
        if (null != strFilename) {
            try {
                this.selectImportedDevices(oTree, DeviceImportExport.getDeviceContentFromFile(strFilename));
            }
            catch (Exception e) {
                DCDebugTracer.trace("DC::importButton_ActionPerformed::throw exception::" + e.getMessage());
            }
        }
    }

    private void selectImportedDevices(final DeviceTree m_oTree, final ArrayList deviceContentArrLst) {
        final ProgressDlgForImport oProgressDlg = new ProgressDlgForImport(this, ResourceManager.getInstance().getResString("IMPORTING"));
        this.bStopImporting = false;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                oProgressDlg.setVisible(true);
            }
        });
        this.m_oDevTreePanel.update(this.m_oDevTreePanel.getGraphics());
        Thread oGetImportedDevThread = new Thread(new Runnable(){

            @Override
            public void run() {
                DeviceImportExport.this.updateSelectedDevices(m_oTree, deviceContentArrLst, oProgressDlg);
            }
        });
        oGetImportedDevThread.start();
    }

    public void setImportingStopped() {
        this.bStopImporting = true;
    }

    private void updateSelectedDevices(DeviceTree m_oTree, ArrayList deviceContentArrLst, ProgressDlgForImport oProgressDlgForImport) {
        DeviceTreeListener oListener = m_oTree.getTreeListener();
        ArrayList<Integer> oSelectDevices = new ArrayList<Integer>(2);
        boolean bIsBoardTree = false;
        if (m_oTree instanceof BoardTree) {
            bIsBoardTree = true;
        }
        int iSizeOfLst = deviceContentArrLst.size();
        for (int i = 0; i < iSizeOfLst; ++i) {
            this.checkIfOperationCancelled(bIsBoardTree, m_oTree, oListener, oSelectDevices);
            if (bIsBoardTree) {
                this.handleDeviceBoardImport(deviceContentArrLst, i, oProgressDlgForImport, m_oTree, oSelectDevices);
                continue;
            }
            this.handleDeviceImport(deviceContentArrLst, i, oProgressDlgForImport, m_oTree);
        }
        if (!bIsBoardTree) {
            DefaultMutableTreeNode oTreeRootNode = m_oTree.getRoot();
            DeviceTreeUtil.updateSelecForParentRecursively(oTreeRootNode);
        }
        oListener.sendSelectionNotificationsToListeners();
        m_oTree.treeDidChange();
    }

    private void handleDeviceBoardImport(ArrayList oIpAddressesArrLst, int iIndex, ProgressDlgForImport oProgressDlgForImport, DeviceTree oTree, List<Integer> oSelectDevices) {
        List<DeviceInfo> oDevInfoLst = null;
        TreeNodeInfo oTempTreeNode = null;
        DefaultMutableTreeNode oTreeNodeObject = null;
        String strIPAddress = (String)oIpAddressesArrLst.get(iIndex);
        int iSizeOfLst = oIpAddressesArrLst.size();
        if (null != strIPAddress && 0 != strIPAddress.length()) {
            oDevInfoLst = DCFrameWorkUtil.getDeviceInfoManager().getDevsInfoByIP(strIPAddress);
            if (null == oDevInfoLst || 0 == oDevInfoLst.size()) {
                oProgressDlgForImport.setProgress(strIPAddress, ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(989855751L)), (iIndex + 1) * 100 / iSizeOfLst);
                return;
            }
            int iNosDevs = oDevInfoLst.size();
            DeviceInfo oDevInfo = null;
            for (int j = 0; j < iNosDevs; ++j) {
                oDevInfo = oDevInfoLst.get(j);
                int iDevID = oDevInfo.getDevId();
                oTreeNodeObject = this.searchNodeInTree(oTree, iDevID);
                if (null == oTreeNodeObject) {
                    oProgressDlgForImport.setProgress(strIPAddress, ResourceManager.getInstance().getResString("DEVICE_NOT_IN_TREE"), (iIndex + 1) * 100 / iSizeOfLst);
                    continue;
                }
                oTempTreeNode = (TreeNodeInfo)oTreeNodeObject.getUserObject();
                if (4 == oTempTreeNode.m_iNodeType) {
                    iDevID = oTempTreeNode.m_oDevInfo.m_iDeviceID;
                } else if (8 == oTempTreeNode.m_iNodeType) {
                    iDevID = oTempTreeNode.m_oDeviceInfo.getDeviceId();
                }
                oProgressDlgForImport.setProgress(oTempTreeNode.toString(), ResourceManager.getInstance().getResString("OPERTION_SUCCESS"), (iIndex + 1) * 100 / iSizeOfLst);
                oSelectDevices.add(iDevID);
            }
        }
        if (0 != oSelectDevices.size()) {
            this.selectDevices(oTree, oSelectDevices);
        }
    }

    private void handleDeviceImport(ArrayList deviceContentArrLst, int iIndex, ProgressDlgForImport oProgressDlgForImport, DeviceTree m_oTree) {
        List<DeviceInfo> oDevInfoLst = null;
        TreeNodeInfo oTempTreeNode = null;
        DefaultMutableTreeNode oTreeNodeObject = null;
        String strDevContent = (String)deviceContentArrLst.get(iIndex);
        int iSizeOfLst = deviceContentArrLst.size();
        if (null != strDevContent && 0 != strDevContent.length()) {
            DeviceTreeModel oTreeModel;
            if (StringUtils.isIPV4(strDevContent)) {
                oDevInfoLst = DCFrameWorkUtil.getDeviceInfoManager().getDevsInfoByIP(strDevContent);
                String[] devInfo = strDevContent.split("[|]");
                strDevContent = devInfo[0];
            } else {
                oDevInfoLst = DCFrameWorkUtil.getDeviceInfoManager().getDevsInfoByDeviceName(strDevContent);
            }
            if (null == oDevInfoLst || 0 == oDevInfoLst.size()) {
                oProgressDlgForImport.setProgress(strDevContent, ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(989855751L)), (iIndex + 1) * 100 / iSizeOfLst);
                return;
            }
            int iNosDevs = oDevInfoLst.size();
            if (iNosDevs > 0 && (oTreeModel = (DeviceTreeModel)m_oTree.getModel()).isActivatedFilter()) {
                this.m_oDevTreePanel.getSearchTextField().setText("");
            }
            DeviceInfo oDevInfo = null;
            for (int j = 0; j < iNosDevs; ++j) {
                oDevInfo = oDevInfoLst.get(j);
                int iDevID = oDevInfo.getDevId();
                oTreeNodeObject = this.searchNodeInTree(m_oTree, iDevID);
                if (null == oTreeNodeObject) {
                    oProgressDlgForImport.setProgress(strDevContent, ResourceManager.getInstance().getResString("DEVICE_NOT_IN_TREE"), (iIndex + 1) * 100 / iSizeOfLst);
                    continue;
                }
                oTempTreeNode = (TreeNodeInfo)oTreeNodeObject.getUserObject();
                oTempTreeNode.setSelected(0);
                oProgressDlgForImport.setProgress(oTempTreeNode.toString(), ResourceManager.getInstance().getResString("OPERTION_SUCCESS"), (iIndex + 1) * 100 / iSizeOfLst);
            }
        }
    }

    private void checkIfOperationCancelled(boolean isBoardTree, DeviceTree oTree, DeviceTreeListener olistener, List<Integer> oSelectDevices) {
        if (this.bStopImporting) {
            if (0 != oSelectDevices.size() && isBoardTree) {
                this.selectDevices(oTree, oSelectDevices);
            } else {
                DeviceTreeUtil.updateSelectionForParent(oTree);
            }
            olistener.sendSelectionNotificationsToListeners();
            return;
        }
    }

    public boolean isDevicePresent(DeviceTree m_oTree, int iDevId) {
        boolean isDevicePresent = true;
        DefaultMutableTreeNode oTreeNode = DeviceTreeUtil.findNodeForDevice(m_oTree, iDevId);
        if (null == oTreeNode) {
            isDevicePresent = false;
        }
        return isDevicePresent;
    }

    public void selectDevices(DeviceTree m_oTree, List<Integer> oSelectDevLst) {
        if (m_oTree instanceof BoardTree) {
            if (null == oSelectDevLst) {
                return;
            }
            ArrayList<Integer> oDevicesToGetBoards = new ArrayList<Integer>(0);
            for (int i = 0; i < oSelectDevLst.size(); ++i) {
                DefaultMutableTreeNode oDeviceNode = DeviceTreeUtil.findNodeForDevice(m_oTree, oSelectDevLst.get(i));
                if (null != oDeviceNode && !oDeviceNode.isLeaf()) continue;
                oDevicesToGetBoards.add(oSelectDevLst.get(i));
            }
            ((BoardTree)m_oTree).populateBoardsForDevices(oDevicesToGetBoards, false);
            int iResourceCount = oSelectDevLst.size();
            for (int i = 0; i < iResourceCount; ++i) {
                DefaultMutableTreeNode oTreeNode = DeviceTreeUtil.findNodeForDevice(m_oTree, oSelectDevLst.get(i));
                if (null == oTreeNode) continue;
                ((TreeNodeInfo)oTreeNode.getUserObject()).setSelected(0);
                DeviceTreeUtil.propogateSelectionToParentNode(oTreeNode, 0);
            }
        } else {
            DeviceTreeUtil.setTreeNodeSelectionStateForDevices(m_oTree, oSelectDevLst, 0);
        }
    }

    public DefaultMutableTreeNode searchNodeInTree(DeviceTree m_oTree, int iDeviceId) {
        return DeviceTreeUtil.findNodeForDevice(m_oTree, iDeviceId);
    }

    private String getFileName() {
        String strFileName = null;
        String strApproveButton = ResourceManager.getInstance().getResString("IMPORT_BUTTON_TEXT");
        String strToolTip = ResourceManager.getInstance().getResString("IMPORT_TOOL_TIP");
        String strTitle = ResourceManager.getInstance().getResString("IMPORT_DEVICE_INFO");
        DCFileChooser oFileChooser = new DCFileChooser();
        oFileChooser.setTitle(strTitle);
        oFileChooser.setFileFilter(1);
        oFileChooser.setApproveButtonToolTipText(strToolTip);
        oFileChooser.setAcceptAllFileFilterUsed(false);
        int iReturnVal = -1;
        iReturnVal = oFileChooser.showDialog(DCFrameWorkUtil.getMainFrame(), strApproveButton);
        if (iReturnVal == 0) {
            try {
                if (null == oFileChooser.getSelectedFile()) {
                    DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("PRINT_FILENAME_ERROR"), ResourceManager.getInstance().getResString("ERROR"), 0);
                    return null;
                }
                strFileName = oFileChooser.getSelectedFile().getAbsolutePath();
            }
            catch (Exception e) {
                DCDebugTracer.trace(e);
            }
        }
        return strFileName;
    }

    protected void exportButtonActionPerformed(DeviceTree oTree) {
        HashSet<Resource> oSelectedResSet = new HashSet<Resource>(4);
        oSelectedResSet = new HashSet(oTree.getSelectedResources());
        if (0 == oSelectedResSet.size()) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("NO_DEVICE_SELECTED"), ResourceManager.getInstance().getResString("ERROR"), 0);
            return;
        }
        String strTitle = ResourceManager.getInstance().getResString("EXPORT_DEVICE_INFO");
        DCSaveFileChooser oSaveFileChooser = new DCSaveFileChooser();
        oSaveFileChooser.setFileFilter(1);
        oSaveFileChooser.setAcceptAllFileFilterUsed(false);
        oSaveFileChooser.setEncodingEnabled(true);
        oSaveFileChooser.setTitle(strTitle);
        DCHelpManager.getInstance().enableF1HelpKey((Component)((Object)oSaveFileChooser), "HELP_TOPIC_NE_EXPORT");
        int iReturnVal = -1;
        iReturnVal = oSaveFileChooser.showSaveDialog(DCFrameWorkUtil.getMainFrame());
        try {
            if (iReturnVal == 0) {
                if (null == oSaveFileChooser.getSelectedFile()) {
                    DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("SELECT_FILES"), ResourceManager.getInstance().getResString("ERROR"), 0);
                    return;
                }
                String strFileName = oSaveFileChooser.getFullFileName();
                this.exportSelectedDevices(strFileName, oSelectedResSet);
            }
        }
        catch (Exception e) {
            DCDebugTracer.trace("DC::exportButton_ActionPerformed::throw exception::" + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportSelectedDevices(String strFileName, HashSet<Resource> oSelectedResources) {
        FileWriter oFileWriter = null;
        BufferedWriter oBufferedWriter = null;
        try {
            oFileWriter = new FileWriter(strFileName);
            oBufferedWriter = new BufferedWriter(oFileWriter);
            StringBuffer strUniqueID = new StringBuffer(32);
            String strLineSeperator = System.getProperty("line.separator");
            Iterator<Resource> oIterate = oSelectedResources.iterator();
            IDeviceInfoManager devInfoManger = DeviceInfoManagerImpl.getInstance();
            DeviceInfo devInfo = null;
            String exportContent = null;
            while (oIterate.hasNext()) {
                exportContent = null;
                Resource oResource = oIterate.next();
                devInfo = devInfoManger.getDevice(oResource.getDeviceID());
                exportContent = devInfo.getDeviceTypeInfo().getDevDomain() == 4 ? oResource.getDeviceName() : oResource.getDeviceIP();
                strUniqueID.append(exportContent);
                strUniqueID.append(strLineSeperator);
            }
            oBufferedWriter.write(strUniqueID.toString());
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("OPERATION_SUCCESSFUL"), ResourceManager.getInstance().getResString("INFO"), 1);
        }
        catch (Exception e) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("PRINT_ERROR_HALT"), ResourceManager.getInstance().getResString("ERROR"), 0);
        }
        finally {
            try {
                if (null != oBufferedWriter) {
                    oBufferedWriter.close();
                }
            }
            catch (IOException e) {
                DCDebugTracer.trace(e);
            }
            try {
                if (null != oFileWriter) {
                    oFileWriter.close();
                }
            }
            catch (IOException e) {
                DCDebugTracer.trace(e);
            }
        }
    }

    private static ArrayList getDeviceContentFromFile(String strFileName) throws Exception {
        ArrayList<String> devContentLst = new ArrayList<String>(6);
        HashSet<String> oHashSet = new HashSet<String>(8);
        BufferedReader oInput = null;
        FileReader oFileReader = null;
        try {
            oFileReader = new FileReader(strFileName);
            oInput = new BufferedReader(oFileReader);
            String strLineContent = null;
            strLineContent = oInput.readLine();
            while (null != strLineContent) {
                if (null != strLineContent && !"".equals(strLineContent.trim()) && !oHashSet.contains(strLineContent = strLineContent.trim())) {
                    oHashSet.add(strLineContent);
                    devContentLst.add(strLineContent);
                }
                strLineContent = oInput.readLine();
            }
            if (0 == devContentLst.size()) {
                oFileReader.close();
                oInput.close();
                throw new Exception(ResourceManager.getInstance().getResString("FILE_INVALID_FORMAT"));
            }
        }
        catch (Exception e) {
            if (null != oFileReader) {
                oFileReader.close();
            }
            throw new Exception(ResourceManager.getInstance().getResString("NOT_EXIST_FILE"));
        }
        finally {
            try {
                if (null != oInput) {
                    oInput.close();
                }
            }
            catch (IOException e) {
                DCDebugTracer.trace(e);
            }
            try {
                if (null != oFileReader) {
                    oFileReader.close();
                }
            }
            catch (IOException e) {
                DCDebugTracer.trace(e);
            }
        }
        return devContentLst;
    }
}

