/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.components.deviceselection.table;

import com.huawei.dc.adapter.swimap.iview.templates.extendedtable.DCExtendedTable;
import com.huawei.dc.common.components.deviceselection.table.DCDefaultTableRenderer;
import com.huawei.dc.common.components.deviceselection.table.DeviceSelectionCommTablePanel;
import com.huawei.dc.common.components.deviceselection.table.DeviceSelectionTableEventHandler;
import com.huawei.dc.common.components.deviceselection.table.DeviceSelectionTableModel;
import com.huawei.dc.common.components.deviceselection.table.DeviceTableActionEvent;
import com.huawei.dc.common.components.deviceselection.table.OLTDeviceSelectionTableModel;
import com.huawei.dc.common.components.tree.devicetree.DeviceTreeUtil;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.tree.TreeNodeInfo;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.devicemanagement.model.deviceinfo.OLTDevVerInfo;
import com.huawei.dc.devicemanagement.model.deviceinfo.SubMapInfo;
import com.huawei.dc.taskmgmt.model.Resource;
import com.swimap.iview.templates.extendedtable.SortableTableModel;
import gnu.trove.THashSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.table.JTableHeader;

public class OLTDeviceSelectionTablePanel
extends DeviceSelectionCommTablePanel {
    private static final long serialVersionUID = 1L;
    private OLTDeviceSelectionTableModel m_oDeviceTableModel = null;

    public OLTDeviceSelectionTablePanel() {
        this.initializeDeviceInfoManager();
        this.initializeEventHandler();
        this.createOLTDeviceSelectionTable();
        this.createToolBar();
        this.addFieldsToPanel();
        this.initTableActionListener();
    }

    private void initializeEventHandler() {
        this.m_oEventHandler = new DeviceSelectionTableEventHandler(this);
    }

    protected void createOLTDeviceSelectionTable() {
        this.m_oDeviceTableModel = new OLTDeviceSelectionTableModel();
        this.m_oDeviceSelectionTable = new DCExtendedTable((SortableTableModel)this.m_oDeviceTableModel);
        this.initializeTable();
    }

    protected void initializeTable() {
        this.initializeTableHeader();
        this.m_oDeviceSelectionTable.setFocusable(true);
        this.m_oDeviceSelectionTable.setRowSelectionAllowed(true);
        this.m_oDeviceSelectionTable.getColumnModel().getColumn(0).setPreferredWidth(107);
        this.m_oDeviceSelectionTable.getColumnModel().getColumn(1).setPreferredWidth(80);
        this.m_oDeviceSelectionTable.getColumnModel().getColumn(2).setPreferredWidth(80);
        this.m_oDeviceSelectionTable.setRowHeight(21);
        this.initializeTableCellRenderer();
        ActionListener escKeyHandler = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OLTDeviceSelectionTablePanel.this.deleteButtonActionPerformed();
            }
        };
        KeyStroke keyStroke = KeyStroke.getKeyStroke(127, 0);
        this.m_oDeviceSelectionTable.registerKeyboardAction(escKeyHandler, keyStroke, 2);
    }

    private void addFieldsToPanel() {
        this.setLayout(new BorderLayout());
        this.m_oScrollPane = new JScrollPane((Component)this.m_oDeviceSelectionTable);
        JPanel oToolBarPanel = new JPanel(new BorderLayout());
        oToolBarPanel.add((Component)this.m_oToolBar, "North");
        this.add((Component)this.m_oScrollPane, "Center");
        this.add((Component)oToolBarPanel, "East");
    }

    private void initializeTableHeader() {
        JTableHeader oTableHeader = this.m_oDeviceSelectionTable.getTableHeader();
        oTableHeader.setReorderingAllowed(false);
        oTableHeader.setPreferredSize(new Dimension(this.m_oDeviceSelectionTable.getSize().width, 21));
        this.m_oDeviceSelectionTable.getTableHeader().addMouseMotionListener(this.getToolTipRendererForHeader());
    }

    private MouseMotionAdapter getToolTipRendererForHeader() {
        return new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int oColNum = OLTDeviceSelectionTablePanel.this.m_oDeviceSelectionTable.getColumnModel().getColumnIndexAtX(e.getX());
                if (oColNum > -1) {
                    OLTDeviceSelectionTablePanel.this.m_oDeviceSelectionTable.getTableHeader().setToolTipText(OLTDeviceSelectionTablePanel.this.m_oDeviceSelectionTable.getColumnName(oColNum));
                }
            }
        };
    }

    private void initializeTableCellRenderer() {
        DCDefaultTableRenderer oRenderer = new DCDefaultTableRenderer();
        for (int i = 0; i < DeviceSelectionTableModel.getIColumnCount(); ++i) {
            this.m_oDeviceSelectionTable.getColumnModel().getColumn(i).setCellRenderer(oRenderer);
        }
    }

    @Override
    protected void deleteButtonActionPerformed() {
        int[] arrSelectedRows = this.m_oDeviceSelectionTable.getSelectedRows();
        int iSelectedRowCount = arrSelectedRows.length;
        if (0 == iSelectedRowCount) {
            return;
        }
        int iFirstSelectedRow = arrSelectedRows[0];
        THashSet oSelectedResources = new THashSet();
        for (int iIndex = 0; iIndex < iSelectedRowCount; ++iIndex) {
            int iSelectedRow = arrSelectedRows[iIndex] - iIndex;
            oSelectedResources.add((Object)this.m_oDeviceTableModel.getResourceAtRow(iSelectedRow));
            this.m_oDeviceTableModel.removeRow(iSelectedRow);
        }
        int iRowCount = this.m_oDeviceTableModel.getRowCount();
        if (0 == iRowCount) {
            this.m_oDeleteBtn.setEnabled(false);
        } else {
            this.resetTableSelection(iFirstSelectedRow, iRowCount);
        }
        if (0 != iSelectedRowCount) {
            this.sendNotificationForEvent((THashSet<Object>)oSelectedResources);
        }
    }

    @Override
    public void sendNotificationForEvent(THashSet<Object> oResources) {
        if (null == oResources) {
            return;
        }
        DeviceTableActionEvent oEvent = new DeviceTableActionEvent(oResources, 2);
        this.m_oEventHandler.notifyEvent(oEvent);
    }

    @Override
    public DeviceType getCurrentDeviceDataModel() {
        DeviceType oTypeModel = this.createDeviceTypeModel();
        return oTypeModel;
    }

    private DeviceType createDeviceTypeModel() {
        DeviceType oTypeModel = new DeviceType();
        oTypeModel.setDeviceTypeID(this.m_oCurrentDeviceTypeInfo.getDevTypeID());
        oTypeModel.setDeviceTypeName(this.m_oCurrentDeviceTypeInfo.getDevTypeName());
        oTypeModel.setDeviceTypeVersionID(this.m_oCurrentDeviceTypeInfo.getDevTypeVersionId());
        oTypeModel.setDeviceTypeVersionName(this.m_oCurrentDeviceTypeInfo.getDevTypeVersionName());
        oTypeModel.setResources(this.getCurrentResources());
        return oTypeModel;
    }

    @Override
    public Resource[] getCurrentDevices() {
        int iResourceCount = this.m_oDeviceTableModel.getResourceCount();
        IDeviceInfoManager c_oDeviceInfoMgr = DCFrameWorkUtil.getDeviceInfoManager();
        Resource[] arrDevices = null;
        Vector<Resource> resourceVct = new Vector<Resource>();
        Resource tmpResource = null;
        OLTDevVerInfo oLTDevVerInfo = null;
        DeviceInfo[] devInfoLst = null;
        DeviceInfo devInfo = null;
        int devLstSize = 0;
        ArrayList devIdLst = null;
        for (int i = 0; i < iResourceCount; ++i) {
            oLTDevVerInfo = this.m_oDeviceTableModel.getResourceAtRow(i);
            devIdLst = oLTDevVerInfo.getDevIDLst();
            devInfoLst = c_oDeviceInfoMgr.getDevices(this.transeLst2Array(devIdLst));
            if (null == devInfoLst) continue;
            devLstSize = devInfoLst.length;
            for (int j = 0; j < devLstSize; ++j) {
                tmpResource = new Resource();
                devInfo = devInfoLst[j];
                if (null == devInfo) continue;
                tmpResource.setDeviceID(devInfo.getDevId());
                tmpResource.setDeviceName(devInfo.getDevName());
                tmpResource.setDeviceIP(devInfo.getDevIPAddress());
                tmpResource.setParentDevId(oLTDevVerInfo.getOltDevID());
                tmpResource.setRoleType(2);
                if (null != devInfo.getDevVersion()) {
                    tmpResource.setDeviceVersion(devInfo.getDevVersion().getDevVersion());
                }
                resourceVct.add(tmpResource);
            }
        }
        arrDevices = resourceVct.toArray(new Resource[0]);
        return arrDevices;
    }

    @Override
    public THashSet<Resource> getCurrentResources() {
        int iResourceCount = this.m_oDeviceTableModel.getResourceCount();
        IDeviceInfoManager c_oDeviceInfoMgr = DCFrameWorkUtil.getDeviceInfoManager();
        Object arrDevices = null;
        THashSet oResHs = new THashSet();
        Resource tmpResource = null;
        OLTDevVerInfo oLTDevVerInfo = null;
        DeviceInfo[] devInfoLst = null;
        DeviceInfo devInfo = null;
        int devLstSize = 0;
        ArrayList devIdLst = null;
        for (int i = 0; i < iResourceCount; ++i) {
            oLTDevVerInfo = this.m_oDeviceTableModel.getResourceAtRow(i);
            devIdLst = oLTDevVerInfo.getDevIDLst();
            devInfoLst = c_oDeviceInfoMgr.getDevices(this.transeLst2Array(devIdLst));
            if (null == devInfoLst) continue;
            devLstSize = devInfoLst.length;
            for (int j = 0; j < devLstSize; ++j) {
                tmpResource = new Resource();
                devInfo = devInfoLst[j];
                if (null == devInfo) continue;
                tmpResource.setDeviceID(devInfo.getDevId());
                tmpResource.setDeviceName(devInfo.getDevName());
                tmpResource.setDeviceIP(devInfo.getDevIPAddress());
                tmpResource.setParentDevId(oLTDevVerInfo.getOltDevID());
                tmpResource.setRoleType(2);
                tmpResource.setDeviceVersion(devInfo.getDevVersion().getDevVersion());
                oResHs.add((Object)tmpResource);
            }
        }
        return oResHs;
    }

    @Override
    public void updateResourcesInTableModel(THashSet<Resource> resourceList, boolean isNodeSelected) {
        if (null == resourceList || 0 == resourceList.size()) {
            return;
        }
        OLTDevVerInfo[] oLTVerInfoLst = DeviceTreeUtil.getOLTVerInfoLst(resourceList);
        if (null == oLTVerInfoLst) {
            return;
        }
        OLTDevVerInfo oLTDevVerInfo2 = null;
        for (OLTDevVerInfo oLTDevVerInfo2 : oLTVerInfoLst) {
            if (isNodeSelected) {
                this.m_oDeviceTableModel.addResourceToModel(oLTDevVerInfo2);
                continue;
            }
            this.m_oDeviceTableModel.removeResourceFromModel(oLTDevVerInfo2);
        }
        this.m_oDeviceSelectionTable.updateUI();
        this.updateDeleteButtonStatus();
    }

    @Override
    public void addResourcesInTableModelForInit(THashSet<Resource> oResourceList) {
        if (null == oResourceList || 0 == oResourceList.size()) {
            return;
        }
        OLTDevVerInfo[] oOLTDevVerInfoLst = DeviceTreeUtil.getOLTVerInfoLst(oResourceList);
        if (null != oOLTDevVerInfoLst && oOLTDevVerInfoLst.length > 0) {
            this.m_oDeviceTableModel.addResourceToModel(oOLTDevVerInfoLst[0]);
        }
        if (this.m_oDeviceTableModel.getResourceCount() > 0) {
            this.m_oDeviceSelectionTable.addRowSelectionInterval(0, 0);
        }
        this.m_oDeviceSelectionTable.updateUI();
        this.updateDeleteButtonStatus();
    }

    @Override
    public void updateDeleteButtonStatus() {
        if (0 == this.m_oDeviceTableModel.getRowCount()) {
            this.m_oDeleteBtn.setEnabled(false);
        } else {
            this.m_oDeleteBtn.setEnabled(true);
        }
    }

    @Override
    public void updateTableForDeviceDropDownChange(DeviceTypeInfo deviceTypeInfo, String strVersion) {
        this.m_oCurrentDeviceTypeInfo = deviceTypeInfo;
        this.m_strCurrentDeviceVersion = strVersion;
        this.clearAllResourcesFromTable();
    }

    @Override
    public void updateTableModelForEvent() {
        if (null == this.m_oDeviceTreeSelectionEvent) {
            return;
        }
        Object source = this.m_oDeviceTreeSelectionEvent.getSource();
        int operType = this.m_oDeviceTreeSelectionEvent.getEventType();
        if (source instanceof TreeNodeInfo) {
            this.addResourcesToTableModel((TreeNodeInfo)source);
        } else if (source instanceof OLTDevVerInfo || source instanceof SubMapInfo) {
            int oldDataCount = this.m_oDeviceTableModel.getDataVector().size();
            this.m_oDeviceTableModel.updateResourceInModel(source, operType);
            int newDataCount = this.m_oDeviceTableModel.getDataVector().size();
            if (oldDataCount > newDataCount && 1 == operType) {
                THashSet sourceLst = new THashSet();
                sourceLst.add(source);
                this.sendNotificationForEvent((THashSet<Object>)sourceLst);
                int rowCount = this.m_oDeviceTableModel.getRowCount();
                if (rowCount > 0) {
                    this.resetTableSelection(0, rowCount);
                }
            }
            this.updateDeleteButtonStatus();
            this.m_oDeviceSelectionTable.repaint();
        }
    }

    @Override
    public void clearAllResourcesFromTable() {
        if (0 != this.m_oDeviceTableModel.getRowCount()) {
            this.m_oDeviceTableModel.getDataVector().removeAllElements();
            this.m_oDeviceSelectionTable.updateUI();
            this.m_oDeleteBtn.setEnabled(false);
        }
    }

    private void addResourcesToTableModel(TreeNodeInfo oTreeNodeInfo) {
        OLTDevVerInfo[] oLTDevVerInfoLst = null;
        int iNodeSelectionState = oTreeNodeInfo.getSelectedState();
        if (0 == iNodeSelectionState || 2 == iNodeSelectionState) {
            oLTDevVerInfoLst = DeviceTreeUtil.getOLTVerInfoLst(oTreeNodeInfo);
        }
        oLTDevVerInfoLst = this.filterDevVerInfoLstByDevType(oTreeNodeInfo, oLTDevVerInfoLst);
        boolean bIsNodeSelected = false;
        if (0 == iNodeSelectionState || 1 == iNodeSelectionState) {
            bIsNodeSelected = true;
        }
        this.updateResourceInTableModel(oLTDevVerInfoLst, bIsNodeSelected);
    }

    private OLTDevVerInfo[] filterDevVerInfoLstByDevType(TreeNodeInfo oTreeNodeInfo, OLTDevVerInfo[] devVerInfoLst) {
        if (null == devVerInfoLst) {
            return null;
        }
        int devTypeId = this.m_oCurrentDeviceTypeInfo.getDevTypeID();
        int devTypeVerId = this.m_oCurrentDeviceTypeInfo.getDevTypeVersionId();
        Vector<OLTDevVerInfo> devVerInfoVector = new Vector<OLTDevVerInfo>();
        OLTDevVerInfo oltDevVerInfo = null;
        for (int i = 0; i < devVerInfoLst.length; ++i) {
            oltDevVerInfo = devVerInfoLst[i];
            if (-1 == devTypeId && -1 == devTypeVerId) {
                devVerInfoVector.add(oltDevVerInfo);
                continue;
            }
            if (oltDevVerInfo.getIDevTypeID() != devTypeId || oltDevVerInfo.getIDevVerID() != devTypeVerId) continue;
            devVerInfoVector.add(oltDevVerInfo);
        }
        OLTDevVerInfo[] oltDevVerInfos = new OLTDevVerInfo[devVerInfoVector.size()];
        oltDevVerInfos = devVerInfoVector.toArray(new OLTDevVerInfo[0]);
        return oltDevVerInfos;
    }

    private void updateResourceInTableModel(OLTDevVerInfo[] devVerInfoLst, boolean isNodeSelected) {
        if (null == devVerInfoLst || 0 == devVerInfoLst.length) {
            return;
        }
        OLTDevVerInfo oLTDevVerInfo2 = null;
        for (OLTDevVerInfo oLTDevVerInfo2 : devVerInfoLst) {
            if (isNodeSelected) {
                this.addResourceToTable(oLTDevVerInfo2);
                continue;
            }
            this.removeResourceTable(oLTDevVerInfo2);
        }
        this.updateDeleteButtonStatus();
        this.m_oDeviceSelectionTable.updateUI();
    }

    private void removeResourceTable(OLTDevVerInfo devVerInfo) {
        this.m_oDeviceTableModel.removeResourceFromModel(devVerInfo);
    }

    private void addResourceToTable(OLTDevVerInfo devVerInfo) {
        this.m_oDeviceSelectionTable.getSelectionModel().setSelectionInterval(0, 0);
        this.m_oDeviceTableModel.addResourceToModel(devVerInfo);
    }

    private int[] transeLst2Array(ArrayList devIDLst) {
        int devCount = devIDLst.size();
        int[] devIDArrays = new int[devCount];
        for (int i = 0; i <= devCount - 1; ++i) {
            devIDArrays[i] = Integer.parseInt(devIDLst.get(i).toString());
        }
        return devIDArrays;
    }

    @Override
    public void deleteDeviceFromTable(DeviceInfo deviceInfo) {
    }
}

