/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.components.deviceselection.table;

import com.huawei.dc.common.components.deviceselection.table.DeviceSelectionCommTableModel;
import com.huawei.dc.devicemanagement.model.deviceinfo.OLTDevVerInfo;
import com.huawei.dc.devicemanagement.model.deviceinfo.SubMapInfo;

public class OLTDeviceSelectionTableModel
extends DeviceSelectionCommTableModel {
    public static final int OLT_VERSION_TABLE_VERSION_COLUMN = 0;
    public static final int OLT_VERSION_TABLE_OLTDEVICE_COLUMN = 1;
    public static final int OLT_VERSION_TABLE_MXUMOUT_COLUMN = 2;
    private static final String[] OLT_DEVICE_TABLE_HEAD_NAMES = new String[]{c_oResourceManager.getResString("DEVICE_OLT_TABLE_COLUMN_VERSION"), c_oResourceManager.getResString("DEVICE_OLT_TABLE_COLUMN_SUBMAPNAME"), c_oResourceManager.getResString("DEVICE_OLT_TABLE_COLUMN_AMOUNT")};
    private static final long serialVersionUID = 1L;

    public OLTDeviceSelectionTableModel() {
        super(OLT_DEVICE_TABLE_HEAD_NAMES);
    }

    @Override
    public Object getValueAt(int row, int column) {
        Object oRowData = this.dataVector.elementAt(row);
        if (null == oRowData || !(oRowData instanceof OLTDevVerInfo)) {
            return "";
        }
        OLTDevVerInfo oLTDevVerInfo = (OLTDevVerInfo)oRowData;
        switch (column) {
            case 0: {
                return oLTDevVerInfo.getStrDevVer();
            }
            case 1: {
                return oLTDevVerInfo.getOltDevName() + "(" + oLTDevVerInfo.getOltDevIP() + ")";
            }
            case 2: {
                return oLTDevVerInfo.getIMxuMount();
            }
        }
        return "";
    }

    public OLTDevVerInfo getResourceAtRow(int iRowIndex) {
        if (0 <= iRowIndex && iRowIndex < this.dataVector.size()) {
            return (OLTDevVerInfo)this.dataVector.get(iRowIndex);
        }
        return null;
    }

    public int getResourceCount() {
        return this.dataVector.size();
    }

    public void addResourceToModel(OLTDevVerInfo oLTDevVerInfo) {
        if (null == oLTDevVerInfo || null == oLTDevVerInfo.getStrDevVer()) {
            return;
        }
        if (this.isContainsResource(oLTDevVerInfo)) {
            this.modifydata(oLTDevVerInfo, 4);
            return;
        }
        this.dataVector.addElement(oLTDevVerInfo);
    }

    public void updateResourceInModel(Object resource, int cmd) {
        if (null == resource) {
            return;
        }
        if (resource instanceof OLTDevVerInfo) {
            boolean isExist = this.isContainsResource((OLTDevVerInfo)resource);
            if (isExist) {
                this.modifydata((OLTDevVerInfo)resource, cmd);
            } else if (!isExist && 0 == cmd && !((OLTDevVerInfo)resource).getStrDevVer().equals("")) {
                this.dataVector.add((OLTDevVerInfo)resource);
            }
        } else if (resource instanceof SubMapInfo) {
            this.updateSubmapInfo((SubMapInfo)resource, cmd);
        }
    }

    private boolean isContainsResource(OLTDevVerInfo oLTDevVerInfo) {
        boolean isExist = false;
        if (null == oLTDevVerInfo || null == this.dataVector) {
            return isExist;
        }
        OLTDevVerInfo existVerInfo = null;
        for (int i = 0; i < this.dataVector.size(); ++i) {
            existVerInfo = (OLTDevVerInfo)this.dataVector.get(i);
            if (existVerInfo.getIDevTypeID() != oLTDevVerInfo.getIDevTypeID() || existVerInfo.getIDevVerID() != oLTDevVerInfo.getIDevVerID() || !existVerInfo.getStrDevVer().equals(oLTDevVerInfo.getStrDevVer()) || existVerInfo.getOltDevID() != oLTDevVerInfo.getOltDevID()) continue;
            isExist = true;
            break;
        }
        return isExist;
    }

    public void removeResourceFromModel(OLTDevVerInfo oLTDevVerInfo) {
        if (null == oLTDevVerInfo || null == this.dataVector) {
            return;
        }
        OLTDevVerInfo existVerInfo = null;
        int size = this.dataVector.size();
        for (int i = size - 1; i >= 0; --i) {
            existVerInfo = (OLTDevVerInfo)this.dataVector.get(i);
            if (existVerInfo.getOltDevID() != oLTDevVerInfo.getOltDevID() || !existVerInfo.getStrDevVer().equalsIgnoreCase(oLTDevVerInfo.getStrDevVer())) continue;
            if (oLTDevVerInfo.getDevIDLst().size() == existVerInfo.getDevIDLst().size()) {
                this.dataVector.remove(i);
                break;
            }
            existVerInfo.getDevIDLst().removeAll(oLTDevVerInfo.getDevIDLst());
            existVerInfo.setIMxuMount(existVerInfo.getIMxuMount() - oLTDevVerInfo.getDevIDLst().size());
            break;
        }
    }

    private void modifydata(OLTDevVerInfo oltDevVerInfo, int cmd) {
        if (null == this.dataVector) {
            return;
        }
        OLTDevVerInfo tmpoltDevVerInfo = null;
        for (int i = this.dataVector.size() - 1; i >= 0; --i) {
            tmpoltDevVerInfo = (OLTDevVerInfo)this.dataVector.get(i);
            if (tmpoltDevVerInfo.getOltDevID() != oltDevVerInfo.getOltDevID() || !tmpoltDevVerInfo.getStrDevVer().equals(oltDevVerInfo.getStrDevVer())) continue;
            if (0 == cmd) {
                tmpoltDevVerInfo.addMxuMount();
                tmpoltDevVerInfo.addDevIDLst(oltDevVerInfo.getDevIDLst());
                break;
            }
            if (1 == cmd) {
                tmpoltDevVerInfo.moveMxuMout();
                tmpoltDevVerInfo.getDevIDLst().removeAll(oltDevVerInfo.getDevIDLst());
                if (tmpoltDevVerInfo.getIMxuMount() >= 1) break;
                this.dataVector.remove(i);
                break;
            }
            if (4 != cmd) break;
            for (int k = 0; k < oltDevVerInfo.getDevIDLst().size(); ++k) {
                int devID = (Integer)oltDevVerInfo.getDevIDLst().get(k);
                if (tmpoltDevVerInfo.getDevIDLst().contains(devID)) continue;
                tmpoltDevVerInfo.getDevIDLst().add(devID);
                tmpoltDevVerInfo.addMxuMount();
            }
            break;
        }
    }

    private void updateSubmapInfo(SubMapInfo submapInfo, int cmd) {
        if (null == this.dataVector || this.dataVector.size() < 1) {
            return;
        }
        OLTDevVerInfo devVerInfo = null;
        for (int i = this.dataVector.size() - 1; i >= 0; --i) {
            devVerInfo = (OLTDevVerInfo)this.dataVector.get(i);
            if (!devVerInfo.getStrParentSubMapID().equals(submapInfo.m_strSubMapID)) continue;
            if (2 == cmd) {
                devVerInfo.setStrParentSubMapName(submapInfo.m_strSubMapName);
                continue;
            }
            if (3 != cmd) continue;
            this.dataVector.remove(i);
        }
    }
}

