/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.components.deviceselection.table;

import com.huawei.dc.adapter.swimap.iview.templates.extendedtable.DCExtendedTable;
import com.huawei.dc.common.components.deviceselection.DeviceSelectionPanel;
import com.huawei.dc.common.components.deviceselection.table.DCDefaultTableRenderer;
import com.huawei.dc.common.components.deviceselection.table.DeviceSelectionCommTablePanel;
import com.huawei.dc.common.components.deviceselection.table.DeviceSelectionTableEventHandler;
import com.huawei.dc.common.components.deviceselection.table.DeviceSelectionTableModel;
import com.huawei.dc.common.components.deviceselection.table.DeviceTableActionEvent;
import com.huawei.dc.common.components.tree.devicetree.BoardTree;
import com.huawei.dc.common.components.tree.devicetree.BoardTreeUtil;
import com.huawei.dc.common.components.tree.devicetree.descriptor.DeviceTreeBaseDescriptor;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.tree.TreeNodeInfo;
import com.huawei.dc.common.util.DCCommonUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.DeviceInfoUtil;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.view.createtask.CreateTaskDeviceSelectionPanel;
import com.swimap.iview.templates.extendedtable.SortableTableModel;
import gnu.trove.THashSet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;

public class DeviceSelectionTablePanel
extends DeviceSelectionCommTablePanel {
    private static final long serialVersionUID = 1L;
    private DeviceSelectionTableModel m_oDeviceTableModel;
    private HashSet<Resource> m_oResourceInfoSet = new HashSet(8);
    private int m_iTaskTypeID = -1;

    public int getTaskTypeID() {
        return this.m_iTaskTypeID;
    }

    public DeviceSelectionTablePanel(int taskType) {
        this.m_iTaskTypeID = taskType;
        this.initializeDeviceInfoManager();
        this.initializeEventHandler();
        this.createDeviceSelectionTable();
        this.createToolBar();
        this.addFieldsToPanel();
        this.initTableActionListener();
    }

    private void initializeEventHandler() {
        this.m_oEventHandler = new DeviceSelectionTableEventHandler(this);
    }

    private void createDeviceSelectionTable() {
        this.m_oDeviceTableModel = new DeviceSelectionTableModel();
        this.m_oDeviceSelectionTable = new DCExtendedTable((SortableTableModel)this.m_oDeviceTableModel);
        this.m_oDeviceSelectionTable.setColumnSortable(new int[]{1, 2, 3, 4, 5}, true);
        this.m_oDeviceSelectionTable.setSortableClickCount(1);
        if (this.m_iTaskTypeID != 5 && this.m_iTaskTypeID != 4 && this.m_iTaskTypeID != 13) {
            int PKG_STATE_COLUMN = 2;
            this.m_oDeviceSelectionTable.getColumnModel().getColumn(PKG_STATE_COLUMN).setMaxWidth(0);
            this.m_oDeviceSelectionTable.getColumnModel().getColumn(PKG_STATE_COLUMN).setMinWidth(0);
            this.m_oDeviceSelectionTable.getColumnModel().getColumn(PKG_STATE_COLUMN).setPreferredWidth(0);
            this.m_oDeviceSelectionTable.getColumnModel().getColumn(PKG_STATE_COLUMN).setResizable(false);
        }
        this.m_oDeviceSelectionTable.setName("DeviceSelection_DeviceSelectionTablePanel_m_oDeviceSelectionTable");
        this.initializeTable();
        this.updateTableHeader(this.m_iTaskTypeID, -2);
    }

    private void initializeTable() {
        this.initializeTableHeader();
        this.m_oDeviceSelectionTable.setFocusable(true);
        this.m_oDeviceSelectionTable.setRowSelectionAllowed(true);
        this.m_oDeviceSelectionTable.getColumnModel().getColumn(0).setMaxWidth(40);
        this.m_oDeviceSelectionTable.getColumnModel().getColumn(0).setMinWidth(40);
        this.m_oDeviceSelectionTable.getColumnModel().getColumn(0).setPreferredWidth(40);
        this.m_oDeviceSelectionTable.getColumnModel().getColumn(1).setPreferredWidth(107);
        this.m_oDeviceSelectionTable.getColumnModel().getColumn(3).setPreferredWidth(80);
        this.m_oDeviceSelectionTable.getColumnModel().getColumn(3).setPreferredWidth(80);
        this.m_oDeviceSelectionTable.setRowHeight(21);
        this.initializeTableCellRenderer();
        ActionListener escKeyHandler = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DeviceSelectionTablePanel.this.deleteButtonActionPerformed();
            }
        };
        KeyStroke keyStroke = KeyStroke.getKeyStroke(127, 0);
        this.m_oDeviceSelectionTable.registerKeyboardAction(escKeyHandler, keyStroke, 2);
    }

    private void initializeTableCellRenderer() {
        DCDefaultTableRenderer oRenderer = new DCDefaultTableRenderer();
        for (int i = 0; i < DeviceSelectionTableModel.getIColumnCount(); ++i) {
            this.m_oDeviceSelectionTable.getColumnModel().getColumn(i).setCellRenderer(oRenderer);
        }
    }

    private void initializeTableHeader() {
        JTableHeader oTableHeader = this.m_oDeviceSelectionTable.getTableHeader();
        oTableHeader.setReorderingAllowed(false);
        oTableHeader.setPreferredSize(new Dimension(this.m_oDeviceSelectionTable.getSize().width, 21));
        this.m_oDeviceSelectionTable.getTableHeader().addMouseMotionListener(this.getToolTipRendererForHeader());
    }

    private MouseMotionAdapter getToolTipRendererForHeader() {
        return new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int oColNum = DeviceSelectionTablePanel.this.m_oDeviceSelectionTable.getColumnModel().getColumnIndexAtX(e.getX());
                if (oColNum > -1) {
                    DeviceSelectionTablePanel.this.m_oDeviceSelectionTable.getTableHeader().setToolTipText(DeviceSelectionTablePanel.this.m_oDeviceSelectionTable.getColumnName(oColNum));
                }
            }
        };
    }

    private void addFieldsToPanel() {
        this.setLayout(new BorderLayout());
        this.m_oScrollPane = new JScrollPane((Component)this.m_oDeviceSelectionTable);
        JPanel oToolBarPanel = new JPanel(new BorderLayout());
        oToolBarPanel.add((Component)this.m_oToolBar, "North");
        this.add((Component)this.m_oScrollPane, "Center");
        this.add((Component)oToolBarPanel, "East");
    }

    @Override
    public void updateDeleteButtonStatus() {
        if (0 == this.m_oDeviceTableModel.getRowCount() || this.m_oDeviceSelectionTable.getSelectedRowCount() < 1) {
            this.m_oDeleteBtn.setEnabled(false);
        } else {
            this.m_oDeleteBtn.setEnabled(true);
        }
        this.updateOffLineTaskCheckBox();
    }

    @Override
    protected void deleteButtonActionPerformed() {
        int[] arrSelectedRows = this.m_oDeviceSelectionTable.getSelectedRows();
        int iSelectedRowCount = arrSelectedRows.length;
        if (0 == iSelectedRowCount) {
            this.displayErrorMessageForNoSelectedDevices();
            return;
        }
        int iFirstSelectedRow = arrSelectedRows[0];
        THashSet oSelectedResources = new THashSet();
        for (int iIndex = iSelectedRowCount - 1; iIndex >= 0; --iIndex) {
            Resource oResource = this.m_oDeviceTableModel.getResourceAtRow(arrSelectedRows[iIndex]);
            oSelectedResources.add((Object)oResource);
            this.m_oResourceInfoSet.remove(oResource);
            this.m_oDeviceTableModel.removeRow(arrSelectedRows[iIndex]);
        }
        int iRowCount = this.m_oDeviceTableModel.getRowCount();
        if (0 == iRowCount) {
            this.m_oDeleteBtn.setEnabled(false);
        } else {
            this.resetTableSelection(iFirstSelectedRow, iRowCount);
        }
        if (0 != iSelectedRowCount) {
            this.sendNotificationForEvent((THashSet<Object>)oSelectedResources);
        }
        this.updateOffLineTaskCheckBox();
    }

    private void displayErrorMessageForNoSelectedDevices() {
        ResourceManager oResManager = ResourceManager.getInstance();
        DCOptionPane.showMessageDialog((Component)this, oResManager.getResString(oResManager.getResString("DEVICE_TABLE_NO_DEVICE_SELECTED")), oResManager.getResString("SYSTEM_INFO_ERROR"), 0);
    }

    @Override
    public void sendNotificationForEvent(THashSet<Object> oResources) {
        if (null == oResources) {
            return;
        }
        DeviceTableActionEvent oEvent = new DeviceTableActionEvent(oResources, 1);
        this.m_oEventHandler.notifyEvent(oEvent);
    }

    @Override
    public void updateTableModelForEvent() {
        if (null == this.m_oDeviceTreeSelectionEvent) {
            return;
        }
        Object oSourceObj = this.m_oDeviceTreeSelectionEvent.getSource();
        if (oSourceObj instanceof TreeNodeInfo) {
            this.updateTable((TreeNodeInfo)oSourceObj);
        } else if (oSourceObj instanceof List) {
            List oLstOfTreeNodeInfo = (List)oSourceObj;
            int iNodeCount = oLstOfTreeNodeInfo.size();
            for (int i = 0; i < iNodeCount; ++i) {
                TreeNodeInfo oTreeNodeInfo = (TreeNodeInfo)oLstOfTreeNodeInfo.get(i);
                this.updateTable(oTreeNodeInfo);
            }
        }
        this.updateTable();
    }

    public void updateTable() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DeviceSelectionTablePanel.this.m_oDeviceSelectionTable.updateUI();
            }
        });
    }

    private void updateTable(TreeNodeInfo oTreeNodeInfo) {
        if (oTreeNodeInfo.isBoardTreeNode()) {
            BoardTree oTree = (BoardTree)this.m_oDeviceTreeSelectionEvent.getDeviceTree();
            this.addResourcesToTableModel(oTreeNodeInfo, oTree);
        } else {
            this.addDevicesToTableModel(oTreeNodeInfo, oTreeNodeInfo.m_iNodeType);
        }
    }

    private void addDevicesToTableModel(TreeNodeInfo oTreeNodeInfo, int iNodeType) {
        DeviceSelectionPanel parentComponent;
        DeviceInfo[] oDeviceList = null;
        int iNodeSelectionState = oTreeNodeInfo.getSelectedState();
        if ((0 == iNodeSelectionState || 2 == iNodeSelectionState && !this.isShowImportBtn()) && null != (parentComponent = (DeviceSelectionPanel)this.getParent()) && null != parentComponent.getDeviceTree()) {
            oDeviceList = 2 == iNodeSelectionState ? parentComponent.getDeviceTree().getDeSelectedDevInfoArr() : parentComponent.getDeviceTree().getSelectedDevInfoArr();
        }
        boolean bIsNodeSelected = false;
        if (0 == iNodeSelectionState || 1 == iNodeSelectionState) {
            bIsNodeSelected = true;
        }
        if (this.isShowImportBtn() && bIsNodeSelected) {
            DeviceSelectionPanel parentComponent2 = (DeviceSelectionPanel)this.getParent();
            int iResCountOnTree = parentComponent2.getDeviceTree().getSelectedResources().size();
            int iResCountInTable = this.m_oDeviceTableModel.getResourceCount();
            DCDebugTracer.trace("DeviceSelectionTablePanel#addDevicesToTableModel::iResCountOnTree" + iResCountOnTree);
            DCDebugTracer.trace("DeviceSelectionTablePanel#addDevicesToTableModel::iResCountOnTree" + iResCountInTable);
            if (this.judgeToSetRedColor(parentComponent2, this.m_oDeviceTableModel) && bIsNodeSelected) {
                parentComponent2.setImportButtonColor(Color.RED);
            } else {
                parentComponent2.setImportButtonColor(parentComponent2.getBackground());
            }
            return;
        }
        if (!bIsNodeSelected && this.isShowImportBtn()) {
            DeviceSelectionPanel parentComponent3 = (DeviceSelectionPanel)this.getParent();
            parentComponent3.setImportButtonColor(Color.white);
        }
        this.updateDevicesInTableModel(oDeviceList, bIsNodeSelected, iNodeType);
    }

    private boolean judgeToSetRedColor(DeviceSelectionPanel deviceSelectionPane, DeviceSelectionTableModel deviceSelectionModel) {
        List resources = deviceSelectionPane.getDeviceTree().getSelectedResources();
        Vector destResources = deviceSelectionModel.getDataVector();
        if (null == destResources || destResources.size() == 0) {
            return true;
        }
        for (Resource resource : resources) {
            if (destResources.contains(resource)) continue;
            return true;
        }
        return false;
    }

    private void addResourcesToTableModel(TreeNodeInfo oTreeNodeInfo, BoardTree oTree) {
        THashSet<Resource> oResourceList = new THashSet<Resource>();
        int iNodeSelectionState = oTreeNodeInfo.getSelectedState();
        if (0 == iNodeSelectionState || 2 == iNodeSelectionState) {
            oResourceList = BoardTreeUtil.getResourcesFromNodeInfo(oTreeNodeInfo, oTree);
        }
        boolean bIsNodeSelected = false;
        if (0 == iNodeSelectionState || 1 == iNodeSelectionState) {
            bIsNodeSelected = true;
        }
        this.updateResourcesInTableModel(oResourceList, bIsNodeSelected);
    }

    public void updateDevicesInTableModel(DeviceInfo[] oDeviceList, boolean bIsNodeSelected, int iNodeType) {
        int iResCountInTable;
        DeviceSelectionPanel parentComponent;
        int iResCountOnTree;
        if (null == oDeviceList || 0 == oDeviceList.length) {
            return;
        }
        DeviceInfo oDeviceInfo = null;
        for (int i = 0; i < oDeviceList.length; ++i) {
            oDeviceInfo = oDeviceList[i];
            if (3 == oDeviceInfo.getRoleType() && 3 == iNodeType) continue;
            if (bIsNodeSelected) {
                this.addDeviceToTableModel(oDeviceInfo);
                continue;
            }
            this.deleteDeviceFromTable(oDeviceInfo);
        }
        if (this.isShowImportBtn() && (iResCountOnTree = (parentComponent = (DeviceSelectionPanel)this.getParent()).getDeviceTree().getSelectedResources().size()) == (iResCountInTable = this.m_oDeviceTableModel.getResourceCount())) {
            parentComponent.setImportButtonColor(parentComponent.getBackground());
        }
        int iEvenType = bIsNodeSelected ? 4 : 3;
        DeviceTableActionEvent oEvent = new DeviceTableActionEvent(oDeviceList, iEvenType);
        this.m_oEventHandler.notifyEvent(oEvent);
        this.updateDeleteButtonStatus();
    }

    @Override
    public void updateResourcesInTableModel(THashSet<Resource> oResourceList, boolean bIsNodeSelected) {
        if (null == oResourceList || 0 == oResourceList.size()) {
            return;
        }
        Resource oResource2 = null;
        for (Resource oResource2 : oResourceList) {
            if (3 == oResource2.getRoleType() && -1 != oResource2.getStackId()) continue;
            if (bIsNodeSelected) {
                this.m_oDeviceTableModel.addResourceToModel(oResource2);
                this.m_oResourceInfoSet.add(oResource2);
                continue;
            }
            this.m_oDeviceTableModel.removeResourceFromModel(oResource2);
            this.m_oResourceInfoSet.remove(oResource2);
        }
        if (this.m_oDeviceTableModel.getResourceCount() > 0) {
            this.m_oDeviceSelectionTable.addRowSelectionInterval(0, 0);
        }
        this.m_oDeviceSelectionTable.updateUI();
        this.updateDeleteButtonStatus();
    }

    @Override
    public void addResourcesInTableModelForInit(THashSet<Resource> oResourceList) {
        if (null == oResourceList || 0 == oResourceList.size()) {
            return;
        }
        this.m_oDeviceTableModel.addResourceToModelByBatch(oResourceList);
        this.m_oResourceInfoSet.addAll((Collection<Resource>)oResourceList);
        if (this.m_oDeviceTableModel.getResourceCount() > 0) {
            this.m_oDeviceSelectionTable.addRowSelectionInterval(0, 0);
        }
        this.m_oDeviceSelectionTable.updateUI();
        this.updateDeleteButtonStatus();
    }

    private void addDeviceToTableModel(DeviceInfo oDeviceInfo) {
        int[] arrSelectedRows = this.m_oDeviceSelectionTable.getSelectedRows();
        int iSelectedRowCount = arrSelectedRows.length;
        if (iSelectedRowCount >= 0) {
            this.m_oDeviceSelectionTable.getSelectionModel().setSelectionInterval(0, 0);
        }
        Resource oResource = new Resource();
        oResource.setDeviceID(oDeviceInfo.getDevId());
        oResource.setDeviceIP(oDeviceInfo.getDevIPAddress());
        oResource.setDeviceName(oDeviceInfo.getDevName());
        oResource.setRoleType(oDeviceInfo.getRoleType());
        oResource.setUpgradeMode(oDeviceInfo.getUpgradeMode());
        oResource.setUpgradeModeConfig(oDeviceInfo.getUpgradeModeConfig());
        if (null == oDeviceInfo.getDevVersion()) {
            oResource.setDeviceVersion("");
        } else {
            oResource.setDeviceVersion(oDeviceInfo.getDevVersion().getDevVersion());
        }
        if (oResource.getDeviceVersion().trim().equals(ResourceManager.getInstance().getResString("UNKNOWN_VERSION"))) {
            oResource.setDeviceVersion("");
        }
        if (this.m_oResourceInfoSet.contains(oResource)) {
            return;
        }
        this.m_oDeviceTableModel.addDeviceToModel(oResource);
        this.m_oResourceInfoSet.add(oResource);
    }

    @Override
    public void deleteDeviceFromTable(DeviceInfo oDeviceInfo) {
        Resource oDeletedResource = this.m_oDeviceTableModel.removeDeviceFromModel(oDeviceInfo);
        if (null != oDeletedResource) {
            this.m_oResourceInfoSet.remove(oDeletedResource);
        }
    }

    @Override
    public Resource[] getCurrentDevices() {
        int iResourceCount = this.m_oDeviceTableModel.getResourceCount();
        Resource[] arrDevices = new Resource[iResourceCount];
        for (int i = 0; i < iResourceCount; ++i) {
            arrDevices[i] = this.m_oDeviceTableModel.getResourceAtRow(i);
        }
        return arrDevices;
    }

    public int getCurrentResourceList() {
        if (null != this.m_oDeviceTreeSelectionEvent.getDeviceTree()) {
            return this.m_oDeviceTreeSelectionEvent.getDeviceTree().getSelectedResources().size();
        }
        int iResourceCount = this.m_oDeviceTableModel.getResourceCount();
        THashSet oCurrentResourceList = new THashSet();
        for (int i = 0; i < iResourceCount; ++i) {
            oCurrentResourceList.add((Object)this.m_oDeviceTableModel.getResourceAtRow(i));
        }
        return oCurrentResourceList.size();
    }

    @Override
    public THashSet<Resource> getCurrentResources() {
        int iResourceCount = this.m_oDeviceTableModel.getResourceCount();
        THashSet oResHs = new THashSet();
        for (int i = 0; i < iResourceCount; ++i) {
            oResHs.add((Object)this.m_oDeviceTableModel.getResourceAtRow(i));
        }
        return oResHs;
    }

    @Override
    public void updateTableForDeviceDropDownChange(DeviceTypeInfo oDeviceTypeInfo, String strVersion) {
        this.m_oCurrentDeviceTypeInfo = oDeviceTypeInfo;
        this.m_strCurrentDeviceVersion = strVersion;
        if (-2 == this.m_iTaskTypeID) {
            this.clearAllResourcesFromTable();
        }
    }

    @Override
    public void clearAllResourcesFromTable() {
        if (0 != this.m_oDeviceTableModel.getRowCount()) {
            this.m_oDeviceTableModel.getDataVector().removeAllElements();
            this.m_oResourceInfoSet.clear();
            this.m_oDeviceSelectionTable.updateUI();
            this.m_oDeleteBtn.setEnabled(false);
        }
    }

    @Override
    public DeviceType getCurrentDeviceDataModel() {
        DeviceType oTypeModel = this.createDeviceTypeModel();
        return oTypeModel;
    }

    private DeviceType createDeviceTypeModel() {
        DeviceType oTypeModel = new DeviceType();
        oTypeModel.setDeviceTypeID(this.m_oCurrentDeviceTypeInfo.getDevTypeID());
        oTypeModel.setDeviceTypeName(this.m_oCurrentDeviceTypeInfo.getDevTypeName());
        oTypeModel.setDeviceTypeVersionID(this.m_oCurrentDeviceTypeInfo.getDevTypeVersionId());
        oTypeModel.setDeviceTypeVersionName(this.m_oCurrentDeviceTypeInfo.getDevTypeVersionName());
        oTypeModel.setResources(this.getCurrentResources());
        return oTypeModel;
    }

    public DeviceTreeBaseDescriptor getDeviceTreeDescriptor() {
        return this.m_oDeviceTreeDescriptor;
    }

    private void updateOffLineTaskCheckBox() {
        THashSet<Resource> oResLst = this.getCurrentResources();
        if (!DCFrameWorkUtil.getIsSingleClient()) {
            return;
        }
        for (Resource oResource : oResLst) {
            DeviceInfo oDeviceInfo = DCFrameWorkUtil.getDeviceInfoManager().getDevice(oResource.getDeviceID());
            DeviceTypeInfo oDevType = oDeviceInfo.getDeviceTypeInfo();
            if (null == oDevType || oDevType.isDMSDomain()) continue;
            return;
        }
        boolean isContainsClusterDevice = DeviceInfoUtil.isContainsClusterDevice(oResLst);
        CreateTaskDeviceSelectionPanel oCreateTaskDeviceSelectionPanel = DCFrameWorkUtil.getCreateTaskDeviceSelectionPanel();
        if (null != oCreateTaskDeviceSelectionPanel && isContainsClusterDevice) {
            oCreateTaskDeviceSelectionPanel.enableOfflineCheckBox(!isContainsClusterDevice);
        }
    }

    private boolean isShowImportBtn() {
        int iDevTypeId = this.m_oCurrentDeviceTypeInfo.getDevTypeID();
        return DCCommonUtil.isShowQueryBtnForTask(this.m_iTaskTypeID, iDevTypeId);
    }

    @Override
    public void disposePanel() {
        super.disposePanel();
        this.m_oResourceInfoSet.clear();
        this.m_oDeviceTableModel.getDataVector().clear();
        this.m_oDeviceTableModel = null;
        this.removeAll();
    }
}

