/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.components.deviceselection.table;

import com.huawei.dc.common.components.deviceselection.table.DeviceSelectionCommTableModel;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.taskmgmt.model.Resource;
import gnu.trove.THashSet;
import java.util.Collections;
import java.util.Comparator;

public class DeviceSelectionTableModel
extends DeviceSelectionCommTableModel {
    private static final long serialVersionUID = 1L;
    public static final int RESOURCE_TABLE_SL_NO_COLUMN = 0;
    public static final int RESOURCE_TABLE_NAME_COLUMN = 1;
    public static final int RESOURCE_TABLE_PACKAGE_STATE_COLUMN = 2;
    public static final int RESOURCE_TABLE_IP_COLUMN = 3;
    public static final int RESOURCE_TABLE_VERSION_COLUMN = 4;
    public static final int RESOURCE_TABLE_BOARD_TYPE = 5;
    public static final int INVALID_INDEX = -1;
    private int m_iTaskType = -1;
    private static final String[] DEVICE_TABLE_HEADER_NAMES = new String[]{c_oResourceManager.getResString("DEVICE_TABLE_COLUMN_SERIAL_NUMBER"), c_oResourceManager.getResString("DEVICE_TABLE_COLUMN_DEVICE_NAME"), c_oResourceManager.getResString("DEVICE_TABLE_COLUMN_PACKAGE_STATE"), c_oResourceManager.getResString("DEVICE_TABLE_COLUMN_DEVICE_IP"), c_oResourceManager.getResString("DEVICE_TABLE_COLUMN_DEVICE_VERSION"), c_oResourceManager.getResString("DEVICE_TABLE_COLUMN_MASTER_OR_STANDBY")};

    public DeviceSelectionTableModel() {
        super(DEVICE_TABLE_HEADER_NAMES);
    }

    @Override
    public Object getValueAt(int iRow, int iColumn) {
        Object oRowData = this.dataVector.elementAt(iRow);
        if (null == oRowData || !(oRowData instanceof Resource)) {
            return "";
        }
        Resource oResource = (Resource)oRowData;
        switch (iColumn) {
            case 0: {
                return iRow + 1;
            }
            case 1: {
                return oResource.getDeviceName();
            }
            case 2: {
                return oResource.getProgressInfo().getSWDLStatus();
            }
            case 3: {
                return oResource.getDeviceIP();
            }
            case 4: {
                return oResource.getDeviceVersion();
            }
            case 5: {
                return oResource.getStrMainBoardNum();
            }
        }
        return "";
    }

    public void addDeviceToModel(Resource oResource) {
        this.dataVector.addElement(oResource);
    }

    public void addResourceToModel(Resource oResource) {
        if (null != oResource && !this.dataVector.contains(oResource)) {
            this.dataVector.addElement(oResource);
        }
    }

    public void removeResourceFromModel(Resource oResource) {
        if (null != oResource && this.dataVector.contains(oResource)) {
            this.dataVector.removeElement(oResource);
        }
    }

    public void addResourceToModelByBatch(THashSet<Resource> oResourceList) {
        boolean addAll = false;
        if (null != oResourceList && 0 != oResourceList.size() && !(addAll = this.dataVector.addAll(oResourceList))) {
            DCDebugTracer.trace("DeviceSelectionTableModel#addResourceToModelByBatch:add got error.");
        }
    }

    public Resource removeDeviceFromModel(DeviceInfo oDevice) {
        int iDeviceID = oDevice.getDevId();
        for (Object oRow : this.dataVector) {
            Resource oResource;
            if (null == oRow || !(oRow instanceof Resource) || iDeviceID != (oResource = (Resource)oRow).getDeviceID()) continue;
            this.dataVector.removeElement(oRow);
            return oResource;
        }
        return null;
    }

    public Resource getResourceAtRow(int iRowIndex) {
        if (0 <= iRowIndex && iRowIndex < this.dataVector.size()) {
            return (Resource)this.dataVector.get(iRowIndex);
        }
        return null;
    }

    public int getIndexForDevice(int iDeviceID) {
        int iRowCount = this.getRowCount();
        Resource oDeviceInfo = null;
        for (int i = 0; i < iRowCount; ++i) {
            oDeviceInfo = this.getResourceAtRow(i);
            if (null == oDeviceInfo || iDeviceID != oDeviceInfo.getDeviceID()) continue;
            return i;
        }
        return -1;
    }

    public int getResourceCount() {
        return this.dataVector.size();
    }

    public void sortByColumn(int column, boolean isDesc) {
        if (-1 == column) {
            return;
        }
        ResourceSortComparator oComparator = new ResourceSortComparator(column, isDesc);
        if (null == this.dataVector || this.dataVector.isEmpty()) {
            return;
        }
        Collections.sort(this.dataVector, oComparator);
    }

    class ResourceSortComparator
    implements Comparator {
        private boolean isDesc = true;
        private int sortedColumn = -1;

        public ResourceSortComparator(int sortedColumn, boolean isDesc) {
            this.sortedColumn = sortedColumn;
            this.isDesc = !isDesc;
        }

        public int compare(Object o1, Object o2) {
            int result = 0;
            if (o1 instanceof Resource && o2 instanceof Resource) {
                Resource oRes1 = (Resource)o1;
                Resource oRes2 = (Resource)o2;
                String str1 = "";
                String str2 = "";
                switch (this.sortedColumn) {
                    case 1: {
                        str1 = oRes1.getDeviceName();
                        str2 = oRes2.getDeviceName();
                        break;
                    }
                    case 2: {
                        str1 = oRes1.getProgressInfo().getSWDLStatus();
                        str2 = oRes2.getProgressInfo().getSWDLStatus();
                        break;
                    }
                    case 3: {
                        long lDevIP1 = oRes1.getLDevIP();
                        long lDevIP2 = oRes2.getLDevIP();
                        result = (int)(lDevIP1 - lDevIP2);
                        if (!this.isDesc) {
                            result = -result;
                        }
                        return result;
                    }
                    case 4: {
                        str1 = oRes1.getDeviceVersion();
                        str2 = oRes2.getDeviceVersion();
                        break;
                    }
                    case 5: {
                        str1 = oRes1.getStrMainBoardNum();
                        str2 = oRes2.getStrMainBoardNum();
                        break;
                    }
                }
                result = str1.compareTo(str2);
                if (!this.isDesc) {
                    result = -result;
                }
            }
            return result;
        }
    }
}

