/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.components.deviceselection.table;

import com.huawei.dc.common.components.deviceselection.table.DeviceSelectionCommTablePanel;
import com.huawei.dc.common.components.deviceselection.table.DeviceSelectionTablePanel;
import com.huawei.dc.common.components.deviceselection.table.DeviceTableActionEvent;
import com.huawei.dc.common.components.deviceselection.table.DeviceTableActionListener;
import com.huawei.dc.common.components.deviceselection.table.DeviceTableActionNotifier;
import com.huawei.dc.common.components.tree.devicetree.descriptor.DeviceTreeBaseDescriptor;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.framework.event.DCDeviceTreeNodeSelectionEventObject;
import com.huawei.dc.common.framework.event.DCEventObject;
import com.huawei.dc.common.framework.event.DCTreeInitEvent;
import com.huawei.dc.common.framework.interfaces.DCTreeEventListener;
import com.huawei.dc.common.tree.TreeNodeInfo;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.devicemanagement.model.deviceinfo.OLTDevVerInfo;
import com.huawei.dc.devicemanagement.model.deviceinfo.SubMapInfo;
import com.huawei.dc.taskmgmt.controller.IUpgradeFeasibilityEventListener;
import com.huawei.dc.taskmgmt.controller.UpgradeFeasibilityNotifier;
import java.util.ArrayList;
import java.util.List;

public class DeviceSelectionTableEventHandler
implements DCTreeEventListener,
DeviceTableActionNotifier,
IUpgradeFeasibilityEventListener {
    private DeviceSelectionCommTablePanel m_oTablePanel;
    private ArrayList m_oTableListenerList;
    private static final int LISTENER_LIST_DEFAULT_SIZE = 1;

    public DeviceSelectionTableEventHandler(DeviceSelectionCommTablePanel oPanel) {
        this.m_oTablePanel = oPanel;
        this.m_oTableListenerList = new ArrayList(1);
        UpgradeFeasibilityNotifier.getInstance().addUpgradeFeasibilityEventListener(this);
    }

    @Override
    public void onTreeNodeSelection(DCEventObject oEventObject) {
        if (null == oEventObject || !(oEventObject instanceof DCDeviceTreeNodeSelectionEventObject)) {
            return;
        }
        if (oEventObject.getSource() instanceof TreeNodeInfo || oEventObject.getSource() instanceof OLTDevVerInfo || oEventObject.getSource() instanceof SubMapInfo) {
            DCDeviceTreeNodeSelectionEventObject oDeviceTreeSelectionEvent = (DCDeviceTreeNodeSelectionEventObject)oEventObject;
            this.m_oTablePanel.setTreeSelectionEvent(oDeviceTreeSelectionEvent);
            this.m_oTablePanel.updateTableModelForEvent();
        }
    }

    @Override
    public void addDeviceTableActionListener(DeviceTableActionListener oEventListener) {
        if (null != oEventListener && !this.m_oTableListenerList.contains(oEventListener)) {
            this.m_oTableListenerList.add(oEventListener);
        }
    }

    @Override
    public void notifyEvent(DeviceTableActionEvent oEventObject) {
        int iCount = this.m_oTableListenerList.size();
        for (int index = 0; index < iCount; ++index) {
            DeviceTableActionListener oEventListener = (DeviceTableActionListener)this.m_oTableListenerList.get(index);
            oEventListener.onTableActionPerformed(oEventObject);
        }
    }

    @Override
    public void removeDeviceTableActionListener(DeviceTableActionListener oEventListener) {
        if (null != oEventListener && this.m_oTableListenerList.contains(oEventListener)) {
            this.m_oTableListenerList.remove(oEventListener);
        }
    }

    @Override
    public void onTreeInit(DCEventObject oEventObject) {
        Object oEventSrc;
        if (null == oEventObject || !(oEventObject instanceof DCTreeInitEvent)) {
            return;
        }
        if (this.m_oTablePanel instanceof DeviceSelectionTablePanel && ((DeviceSelectionTablePanel)this.m_oTablePanel).getTaskTypeID() == -2) {
            this.m_oTablePanel.clearAllResourcesFromTable();
        }
        if (null != (oEventSrc = oEventObject.getSource()) && oEventSrc instanceof DeviceTreeBaseDescriptor) {
            this.m_oTablePanel.setDeviceTreeDescriptor((DeviceTreeBaseDescriptor)oEventSrc);
        }
    }

    @Override
    public void onUpgradeFeasibilityEvent(List<Integer> oFailedDevList) {
        int iListSize = oFailedDevList.size();
        DeviceInfo oDeviceInfo = null;
        for (int i = 0; i < iListSize; ++i) {
            int iDevId = oFailedDevList.get(i);
            oDeviceInfo = DeviceInfoManagerImpl.getInstance().getDevice(iDevId);
            this.m_oTablePanel.deleteDeviceFromTable(oDeviceInfo);
        }
    }

    public void doCleanUp() {
        if (null != this.m_oTablePanel) {
            this.m_oTablePanel.clearAllResourcesFromTable();
            this.m_oTablePanel = null;
        }
        if (null != this.m_oTableListenerList) {
            this.m_oTableListenerList.clear();
            this.m_oTableListenerList = null;
        }
    }
}

