/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.components.deviceselection.table;

import com.huawei.dc.adapter.swimap.iview.templates.extendedtable.DCExtendedTable;
import com.huawei.dc.common.components.deviceselection.table.DeviceSelectionTableEventHandler;
import com.huawei.dc.common.components.tree.devicetree.descriptor.DeviceTreeBaseDescriptor;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.event.DCDeviceTreeNodeSelectionEventObject;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCCommonUtil;
import com.huawei.dc.common.util.WindowStyleSpecialButton;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.taskmgmt.model.Resource;
import gnu.trove.THashSet;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.table.TableColumn;

public abstract class DeviceSelectionCommTablePanel
extends JPanel {
    private static final long serialVersionUID = -7288652133315966234L;
    protected static final String DELETE_BUTTON_ICON = "delete.gif";
    protected static final String DELETE_BUTTON_TOOLTIP_TEXT = "DELETE_BUTTON";
    protected DCExtendedTable m_oDeviceSelectionTable;
    protected JScrollPane m_oScrollPane;
    protected WindowStyleSpecialButton m_oDeleteBtn;
    protected DCDeviceTreeNodeSelectionEventObject m_oDeviceTreeSelectionEvent;
    protected IDeviceInfoManager c_oDeviceInfoManager;
    protected JToolBar m_oToolBar;
    protected DeviceSelectionTableEventHandler m_oEventHandler;
    protected String m_strCurrentDeviceVersion = "";
    protected DeviceTypeInfo m_oCurrentDeviceTypeInfo;
    protected DeviceTreeBaseDescriptor m_oDeviceTreeDescriptor;
    private TableColumn m_oBoardTypeTablecColumn;

    protected void initializeDeviceInfoManager() {
        this.c_oDeviceInfoManager = DCFrameWorkUtil.getDeviceInfoManager();
    }

    public DeviceSelectionTableEventHandler getEventHandler() {
        return this.m_oEventHandler;
    }

    public void setTreeSelectionEvent(DCDeviceTreeNodeSelectionEventObject oEvent) {
        this.m_oDeviceTreeSelectionEvent = oEvent;
    }

    public abstract void updateTableForDeviceDropDownChange(DeviceTypeInfo var1, String var2);

    public abstract THashSet<Resource> getCurrentResources();

    protected abstract void deleteButtonActionPerformed();

    public abstract void updateDeleteButtonStatus();

    public abstract void deleteDeviceFromTable(DeviceInfo var1);

    public abstract void sendNotificationForEvent(THashSet<Object> var1);

    public abstract DeviceType getCurrentDeviceDataModel();

    public DeviceTypeInfo getCurrentDeviceTypeInfo() {
        return this.m_oCurrentDeviceTypeInfo;
    }

    public String getCurrentDeviceVersion() {
        return this.m_strCurrentDeviceVersion;
    }

    protected void resetTableSelection(int iFirstSelectedRow, int iTotalRowCount) {
        if (iFirstSelectedRow + 1 <= iTotalRowCount) {
            this.m_oDeviceSelectionTable.setRowSelectionInterval(iFirstSelectedRow, iFirstSelectedRow);
        } else {
            this.m_oDeviceSelectionTable.setRowSelectionInterval(0, 0);
        }
    }

    public void setDeviceTreeDescriptor(DeviceTreeBaseDescriptor oTreeDescriptor) {
        this.m_oDeviceTreeDescriptor = oTreeDescriptor;
    }

    public abstract Resource[] getCurrentDevices();

    public abstract void updateResourcesInTableModel(THashSet<Resource> var1, boolean var2);

    public abstract void addResourcesInTableModelForInit(THashSet<Resource> var1);

    public abstract void updateTableModelForEvent();

    public abstract void clearAllResourcesFromTable();

    protected void createToolBar() {
        this.m_oToolBar = new JToolBar();
        this.m_oToolBar.setFloatable(false);
        this.createDeleteButton();
        this.m_oToolBar.add(this.m_oDeleteBtn);
    }

    void createDeleteButton() {
        this.m_oDeleteBtn = new WindowStyleSpecialButton();
        this.m_oDeleteBtn.setName("DeviceSelection_DeviceSelectionCommTable_m_oDeleteBtn");
        ImageIcon oDeviceDeleteIcon = ResourceManager.getInstance().getImage(DELETE_BUTTON_ICON);
        this.m_oDeleteBtn.setIcon(oDeviceDeleteIcon);
        this.m_oDeleteBtn.setToolTipText(ResourceManager.getInstance().getResString(DELETE_BUTTON_TOOLTIP_TEXT));
        this.m_oDeleteBtn.setMnemonic('D');
        this.initializeDeleteButton();
        this.updateDeleteButtonStatus();
    }

    private void initializeDeleteButton() {
        this.m_oDeleteBtn.setPreferredSize(new Dimension(25, 25));
        this.m_oDeleteBtn.setMaximumSize(new Dimension(25, 25));
        this.m_oDeleteBtn.setMinimumSize(new Dimension(25, 25));
        this.m_oDeleteBtn.getModel().setPressed(true);
        this.m_oDeleteBtn.getModel().setRollover(true);
        this.m_oDeleteBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent oEvent) {
                DeviceSelectionCommTablePanel.this.deleteButtonActionPerformed();
            }
        });
    }

    public JTable getDeviceSelectionTable() {
        return this.m_oDeviceSelectionTable;
    }

    protected void initTableActionListener() {
        this.m_oDeviceSelectionTable.addMouseListener((MouseListener)this.generateMouseAdapterForTable());
    }

    private MouseAdapter generateMouseAdapterForTable() {
        return new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent oMouseEvent) {
                DeviceSelectionCommTablePanel.this.updateDeleteButtonStatus();
            }

            @Override
            public void mouseClicked(MouseEvent oMouseEvent) {
                DeviceSelectionCommTablePanel.this.updateDeleteButtonStatus();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                Cursor cur = new Cursor(0);
                DCFrameWorkUtil.setCursor(DeviceSelectionCommTablePanel.this.getParent(), cur);
            }
        };
    }

    public void updateTableHeader(int iTaskTypeId, int iSelectedDevTypeId) {
        DCExtendedTable oTable = this.m_oDeviceSelectionTable;
        int iColumnCount = oTable.getColumnModel().getColumnCount();
        boolean isContainBoardTypeTablecColumn = false;
        if (6 == iColumnCount) {
            isContainBoardTypeTablecColumn = true;
            if (null == this.m_oBoardTypeTablecColumn) {
                this.m_oBoardTypeTablecColumn = oTable.getColumnModel().getColumn(5);
            }
        }
        if (DCCommonUtil.isShowQueryBtnForTask(iTaskTypeId, iSelectedDevTypeId) && 0 == iTaskTypeId || 1 == iTaskTypeId) {
            if (!isContainBoardTypeTablecColumn) {
                oTable.getColumnModel().addColumn(this.m_oBoardTypeTablecColumn);
            }
        } else if (isContainBoardTypeTablecColumn) {
            oTable.getColumnModel().removeColumn(this.m_oBoardTypeTablecColumn);
        }
    }

    public void disposePanel() {
        if (null != this.m_oDeviceSelectionTable) {
            this.m_oDeviceSelectionTable.removeAll();
            this.m_oDeviceSelectionTable = null;
        }
        if (null != this.m_oScrollPane) {
            this.m_oScrollPane.removeAll();
            this.m_oScrollPane = null;
        }
        if (null != this.m_oToolBar) {
            this.m_oToolBar.removeAll();
            this.m_oToolBar = null;
        }
        if (null != this.m_oDeviceTreeSelectionEvent) {
            this.m_oDeviceTreeSelectionEvent.clearUpObject();
            this.m_oDeviceTreeSelectionEvent = null;
        }
        this.c_oDeviceInfoManager = null;
        this.m_oEventHandler = null;
        this.m_oCurrentDeviceTypeInfo = null;
        this.m_oDeviceTreeDescriptor = null;
        this.m_oBoardTypeTablecColumn = null;
        this.removeAll();
    }
}

