/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.components.deviceselection.table;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.TableCellRenderer;

public class DCDefaultTableRenderer
extends JTextArea
implements TableCellRenderer {
    private boolean isDialog = false;
    private static final long serialVersionUID = 1L;

    public DCDefaultTableRenderer() {
    }

    public DCDefaultTableRenderer(boolean isDialog) {
        this.isDialog = isDialog;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setOpaque(true);
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
        this.setColorForComponent(table, isSelected, this);
        if (null != value && !"".equals(value.toString().trim())) {
            if (this.isDialog) {
                int maxPreferredHeight = 0;
                for (int i = 0; i < table.getColumnCount(); ++i) {
                    this.setText("" + table.getValueAt(row, i));
                    this.setSize(table.getColumnModel().getColumn(column).getWidth(), 0);
                    maxPreferredHeight = Math.max(maxPreferredHeight, this.getPreferredSize().height);
                }
                if (table.getRowHeight(row) != maxPreferredHeight && maxPreferredHeight > 0) {
                    table.setRowHeight(row, maxPreferredHeight);
                }
            }
            this.setText(value.toString());
            this.setToolTipText(value.toString());
        } else {
            this.setText("");
            this.setToolTipText("");
        }
        return this;
    }

    protected void setColorForComponent(JTable table, boolean isSelected, Component oComponent) {
        if (isSelected) {
            oComponent.setBackground(table.getSelectionBackground());
            oComponent.setForeground(Color.white);
        } else {
            oComponent.setBackground(table.getBackground());
            oComponent.setForeground(table.getForeground());
        }
    }
}

