/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.components.deviceselection.dropdown;

import com.huawei.dc.common.DCConstants;
import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceSubmapNtfnInfo;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceSubmapNtfnInfoLst;
import com.huawei.dc.common.components.deviceselection.dropdown.DeviceDropDownChangeEvent;
import com.huawei.dc.common.components.deviceselection.dropdown.DeviceDropDownEventHandler;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.ComboBoxWithToolTip;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.deviceoperation.IOperation;
import com.huawei.dc.devicemanagement.deviceoperation.IOperationPara;
import com.huawei.dc.devicemanagement.deviceoperation.IParaList;
import com.huawei.dc.devicemanagement.model.xmlconfig.DeviceXMLConfigModel;
import com.huawei.dc.devicemanagement.model.xmlconfig.IDeviceTypeConfigModel;
import com.huawei.dc.devicemanagement.model.xmlconfig.TaskTypeConfiguration;
import com.huawei.dc.deviceoperation.deviceconfigchange.DeviceConfigEventReceiver;
import com.huawei.dc.deviceoperation.deviceconfigchange.IDeviceConfigChangeListener;
import com.huawei.dc.taskmgmt.model.TaskModelUtil;
import com.huawei.dc.taskmgmt.view.createtask.IDeviceVersionChangeListener;
import com.huawei.dc.taskmgmt.view.createtask.IDeviceVersionEventregisterInterface;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DeviceSelectionDropDownPanel
extends JPanel
implements IDeviceConfigChangeListener,
IDeviceVersionEventregisterInterface {
    private static final long serialVersionUID = 1L;
    private JLabel m_oDeviceTypeLabel;
    private JLabel m_oDeviceBoardTypeLabel;
    private JLabel m_oDeviceVersionLabel;
    private JLabel m_oKeyLabel;
    private JTextField m_oSearchTextField;
    private DefaultComboBoxModel m_oDeviceTypeModel;
    private DefaultComboBoxModel m_oDeviceVersionModel;
    private ComboBoxWithToolTip m_oDeviceTypeComboBox;
    private ComboBoxWithToolTip m_oDeviceVersionComboBox;
    private DefaultComboBoxModel m_oDeviceBoardTypeModel;
    private ComboBoxWithToolTip m_oDeviceBoardTypeComboBox;
    private IDeviceInfoManager c_oDeviceInfoManager;
    private DeviceDropDownEventHandler m_oEventHandler;
    private boolean bSupportAllVersions;
    private boolean bSupportAllDevType;
    private boolean bIsAllDevType;
    private ArrayList m_oDeviceVersionListenerlist;
    private int taskTypeId = -1;
    private String m_strLastDeviceVersion;
    private DeviceTypeInfo m_oLastDeviceTypeInfo;
    private DeviceTypeInfo m_oLastDeviceTypeInfoForRe;
    private boolean bManualEvent = false;
    private transient ItemListener m_oVersionItemListener = null;
    private ActionListener m_oVersionActionListener = null;
    private transient ItemListener m_oBoardActionListener = null;
    private static final String All_VERSIONS = ResourceManager.getInstance().getResString("DEVICE_VERSION_ALL");
    private static final String DEVICE_BOARD_TYPE_ALL = ResourceManager.getInstance().getResString("DEVICE_BOARD_TYPE_ALL");

    public DeviceSelectionDropDownPanel(boolean bSupportAllVersions) throws DCException {
        this.bSupportAllVersions = bSupportAllVersions;
        this.m_oDeviceVersionListenerlist = new ArrayList(0);
        this.initializeDeviceInfoManager();
        this.initializeEventHandler();
        this.createComponents();
        this.alignComponents();
        this.addComponents();
        this.updateBoardCombox(this.getSelectedDeviceType());
        this.registerForServerNotifications();
    }

    public DeviceSelectionDropDownPanel(boolean bSupportAllVersions, int taskTypeId, boolean bSupportAllTypes) throws DCException {
        this.taskTypeId = taskTypeId;
        this.bSupportAllVersions = bSupportAllVersions;
        this.bSupportAllDevType = bSupportAllTypes;
        this.m_oDeviceVersionListenerlist = new ArrayList(0);
        GridBagLayout thisLayout = new GridBagLayout();
        this.setLayout(thisLayout);
        this.initializeDeviceInfoManager();
        this.initializeEventHandler();
        this.createComponents();
        this.alignComponents();
        this.addComponents();
        this.updateBoardCombox(this.getSelectedDeviceType());
        this.registerForServerNotifications();
    }

    public void updateBoardCombox(DeviceTypeInfo oDeviceType) {
        if (null == oDeviceType) {
            return;
        }
        if (!this.isMainBoardTypeTask()) {
            this.removeBoardTypeCom();
            return;
        }
        if (oDeviceType.isBMSDomain()) {
            if (this.isRequireMainBoardType(oDeviceType)) {
                this.reInitBoardCombox();
            } else {
                this.removeBoardTypeCom();
            }
        } else if (oDeviceType.isALLType()) {
            boolean isBMS = true;
            boolean isAllRequireMainBoard = true;
            boolean isHaveRequireMainBoard = false;
            int size = this.m_oDeviceTypeModel.getSize();
            for (int i = 0; i < size; ++i) {
                DeviceTypeInfo oDevType = (DeviceTypeInfo)this.m_oDeviceTypeModel.getElementAt(i);
                if (oDevType.isALLType()) continue;
                if (!oDevType.isBMSDomain()) {
                    isBMS = false;
                    break;
                }
                if (!this.isRequireMainBoardType(oDevType)) {
                    isAllRequireMainBoard = false;
                    break;
                }
                isHaveRequireMainBoard = true;
            }
            if (!isBMS) {
                this.removeBoardTypeCom();
                return;
            }
            if (isAllRequireMainBoard) {
                this.reInitBoardCombox();
            } else if (isHaveRequireMainBoard) {
                this.reInitBoardCombox();
            } else {
                this.removeBoardTypeCom();
            }
        } else {
            this.removeBoardTypeCom();
        }
    }

    private void removeBoardTypeCom() {
        this.remove(this.m_oDeviceBoardTypeLabel);
        this.remove(this.m_oDeviceBoardTypeComboBox);
    }

    private void reInitBoardCombox() {
        this.removeBoardTypeCom();
        this.add((Component)this.m_oDeviceBoardTypeLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 12, 0, 0), 0, 0));
        this.add((Component)this.m_oDeviceBoardTypeComboBox, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(12, 0, 0, 12), 0, 0));
        this.m_oDeviceBoardTypeComboBox.removeItemListener(this.m_oBoardActionListener);
        this.m_oDeviceBoardTypeModel.removeAllElements();
        this.populateDevBoardTypeDropDown();
        this.m_oDeviceBoardTypeComboBox.addItemListener(this.m_oBoardActionListener);
    }

    private boolean isMainBoardTypeTask() {
        return 2 == this.taskTypeId || 7 == this.taskTypeId || 0 == this.taskTypeId || 1 == this.taskTypeId;
    }

    private boolean isRequireMainBoardType(DeviceTypeInfo oDeviceType) {
        IDeviceTypeConfigModel deviceTypeConfigModel = DeviceXMLConfigModel.getInstance().getDeviceTypeConfigModel(oDeviceType, null);
        if (null == deviceTypeConfigModel) {
            return false;
        }
        IOperation oGetBoardOperationObj = deviceTypeConfigModel.getOperationObj(5, 46);
        if (null == oGetBoardOperationObj) {
            return false;
        }
        IParaList paraList = oGetBoardOperationObj.getoPerationParaList();
        if (null == paraList) {
            return false;
        }
        IOperationPara operationPara = paraList.getParameter("GetMainBoardType");
        if (null == operationPara) {
            return false;
        }
        return operationPara.isRequired();
    }

    private void registerForServerNotifications() {
        DeviceConfigEventReceiver.getInstance().resigterForConfigChangeEvent(this);
    }

    public void unRegisterForServerodifications() {
        DeviceConfigEventReceiver.getInstance().unResigterForConfigChangeEvent(this);
    }

    public void enableDeviceDropDowns(boolean bFlag) {
        this.m_oDeviceTypeComboBox.setEnabled(bFlag);
    }

    protected void initializeDeviceInfoManager() {
        this.c_oDeviceInfoManager = DCFrameWorkUtil.getDeviceInfoManager();
    }

    private void initializeEventHandler() {
        this.m_oEventHandler = new DeviceDropDownEventHandler(this);
    }

    private void createComponents() throws DCException {
        ResourceManager oResourceManager = ResourceManager.getInstance();
        this.m_oDeviceTypeLabel = new JLabel(oResourceManager.getResString("DEVICE_TYPE_DROPDOWN_LABEL"));
        this.m_oDeviceVersionLabel = new JLabel(oResourceManager.getResString("DEVICE_VERSION_DROPDOWN_LABEL"));
        this.m_oDeviceBoardTypeLabel = new JLabel(oResourceManager.getResString("DEVICE_BOARD_TYPE_DROPDOWN_LABEL"));
        this.m_oKeyLabel = new JLabel(ResourceManager.getInstance().getResString("KEY_WORD"));
        this.createDeviceTypeDropDown();
        this.createDeviceVersionDropDown();
        this.createDeviceBoardTypeDropDown();
        this.createDeviceSearchField();
        this.addComponentActionListener();
    }

    private void createDeviceBoardTypeDropDown() {
        this.m_oDeviceBoardTypeModel = new DefaultComboBoxModel();
        this.m_oDeviceBoardTypeComboBox = new ComboBoxWithToolTip((ComboBoxModel)this.m_oDeviceBoardTypeModel);
        this.m_oDeviceBoardTypeComboBox.setName("DeviceSelection_DeviceSelectionDropDownpanel_m_oDeviceBoardTypeComboBox");
        this.populateDevBoardTypeDropDown();
    }

    private void populateDevBoardTypeDropDown() {
        if (0 == this.m_oDeviceVersionModel.getSize() || 0 == this.m_oDeviceTypeModel.getSize()) {
            return;
        }
        DeviceTypeInfo oSelectedDeviceType = this.getSelectedDeviceType();
        int oSelectedDeviceTypeID = oSelectedDeviceType.getDevTypeID();
        int oSelectedDeviceTypeVersionID = oSelectedDeviceType.getDevTypeVersionId();
        int allDevTypeId = -1;
        int allDevTypeVersionId = -1;
        DeviceInfo[] deviceInfoArray = null;
        if (-1 == oSelectedDeviceTypeID && -1 == oSelectedDeviceTypeVersionID) {
            this.m_oDeviceBoardTypeComboBox.setEnabled(false);
            return;
        }
        deviceInfoArray = All_VERSIONS.equals((String)this.m_oDeviceVersionModel.getSelectedItem()) ? this.c_oDeviceInfoManager.getDevicesByType(oSelectedDeviceTypeID) : this.c_oDeviceInfoManager.getDevicesForVersion((String)this.m_oDeviceVersionModel.getSelectedItem(), oSelectedDeviceType);
        ArrayList<String> oDevBoardTypeLst = new ArrayList<String>();
        String devBoadType = "";
        for (DeviceInfo deviceInfo : deviceInfoArray) {
            devBoadType = deviceInfo.getDevBoardType();
            if (StringUtils.isNullOrEmptyStr(devBoadType) || oDevBoardTypeLst.contains(devBoadType)) continue;
            oDevBoardTypeLst.add(devBoadType);
        }
        for (String oDevTypeBoard : oDevBoardTypeLst) {
            this.m_oDeviceBoardTypeModel.addElement(oDevTypeBoard);
        }
        this.m_oDeviceBoardTypeModel.insertElementAt(DEVICE_BOARD_TYPE_ALL, 0);
        this.m_oDeviceBoardTypeComboBox.setSelectedIndex(0);
    }

    public void setSelectedBoardType(String boardType) {
        if (null != boardType && this.m_oDeviceBoardTypeComboBox.isEnabled()) {
            this.m_oDeviceBoardTypeComboBox.setSelectedItem(boardType);
        }
    }

    private void alignComponents() {
        this.setLayout(new GridBagLayout());
        this.m_oDeviceTypeLabel.setPreferredSize(new Dimension(100, 20));
        this.m_oDeviceTypeLabel.setMinimumSize(new Dimension(100, 20));
        this.m_oDeviceVersionLabel.setPreferredSize(new Dimension(97, 20));
        this.m_oDeviceVersionLabel.setMinimumSize(new Dimension(97, 20));
        this.m_oDeviceBoardTypeLabel.setPreferredSize(new Dimension(110, 20));
        this.m_oDeviceBoardTypeLabel.setMinimumSize(new Dimension(110, 20));
        this.m_oKeyLabel.setPreferredSize(new Dimension(110, 20));
        this.m_oKeyLabel.setMinimumSize(new Dimension(110, 20));
        this.m_oDeviceTypeComboBox.setPreferredSize(new Dimension(186, 20));
        this.m_oDeviceTypeComboBox.setMinimumSize(new Dimension(186, 20));
        this.m_oDeviceVersionComboBox.setPreferredSize(new Dimension(186, 20));
        this.m_oDeviceVersionComboBox.setMinimumSize(new Dimension(186, 20));
        this.m_oDeviceBoardTypeComboBox.setPreferredSize(new Dimension(186, 20));
        this.m_oDeviceBoardTypeComboBox.setMinimumSize(new Dimension(186, 20));
        this.m_oSearchTextField.setPreferredSize(new Dimension(186, 20));
        this.m_oSearchTextField.setMinimumSize(new Dimension(186, 20));
    }

    private void addComponents() {
        this.add((Component)this.m_oDeviceTypeLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 12, 0, 0), 0, 0));
        this.add((Component)this.m_oDeviceVersionLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 12, 0, 0), 0, 0));
        this.add((Component)this.m_oDeviceBoardTypeLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 12, 0, 0), 0, 0));
        this.add((Component)this.m_oKeyLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 12, 0, 0), 0, 0));
        this.add((Component)this.m_oDeviceTypeComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 12), 0, 0));
        this.add((Component)this.m_oDeviceVersionComboBox, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 12), 0, 0));
        this.add((Component)this.m_oDeviceBoardTypeComboBox, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 12), 0, 0));
        this.add((Component)this.m_oSearchTextField, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 12), 0, 0));
    }

    private void createDeviceTypeDropDown() throws DCException {
        DCDebugTracer.trace("DC::[Olt] createDeviceTypeDropDown start");
        Object[] arrDeviceTypes = DCFrameWorkUtil.getIsSingleClient() ? this.c_oDeviceInfoManager.getAddedDeviceTypes() : this.c_oDeviceInfoManager.getExistDeviceTypes();
        int devTypeNum = arrDeviceTypes.length;
        ResourceManager oResManager = ResourceManager.getInstance();
        if (0 == devTypeNum) {
            DCDebugTracer.trace("DC::[Olt] Device type is null.");
            DCDebugTracer.trace("DC::[Olt] createDeviceTypeDropDown end..");
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), oResManager.getResString("DEVICES_NOT_ADDED"), oResManager.getResString("ERROR"), 0);
            return;
        }
        if (this.taskTypeId != -1) {
            int[] iDeviceIdLst = this.c_oDeviceInfoManager.getAddedDeviceIdLst();
            Vector deviceTypeList = this.filtrationDevTypeSpportTaskTye(this.taskTypeId, (DeviceTypeInfo[])arrDeviceTypes, iDeviceIdLst);
            arrDeviceTypes = deviceTypeList.toArray(new DeviceTypeInfo[0]);
            boolean validateForOlt = this.validateOLTDev(this.taskTypeId, (DeviceTypeInfo[])arrDeviceTypes);
            if (0 == arrDeviceTypes.length || !validateForOlt) {
                DCDebugTracer.trace("DC::[Olt] arrDeviceTypes.length : " + arrDeviceTypes.length);
                DCDebugTracer.trace("DC::[Olt] validateForOlt : " + validateForOlt);
                DCDebugTracer.trace("DC::[Olt] createDeviceTypeDropDown end..");
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), oResManager.getResString("COMPATIBLE_DEVICES_NOT_ADDED"), oResManager.getResString("ERROR"), 0);
                return;
            }
        }
        Arrays.sort(arrDeviceTypes);
        this.m_oDeviceTypeModel = new DefaultComboBoxModel<Object>(arrDeviceTypes);
        this.m_oDeviceTypeComboBox = new ComboBoxWithToolTip((ComboBoxModel)this.m_oDeviceTypeModel);
        this.m_oDeviceTypeComboBox.setName("DeviceSelection_DeviceSelectionDropDownpanel_m_oDeviceTypeComboBox");
        this.m_oDeviceTypeComboBox.setSelectedItem(0);
        DCDebugTracer.trace("DC::[Olt] createDeviceTypeDropDown end..");
    }

    private boolean validateOLTDev(int taskTypeId, DeviceTypeInfo[] arrDeviceTypes) {
        boolean isPresentMXU = false;
        if (null == arrDeviceTypes || arrDeviceTypes.length < 1) {
            return isPresentMXU;
        }
        if (7 != taskTypeId) {
            return true;
        }
        DeviceTypeInfo devTypeInfo = null;
        for (int i = 0; i < arrDeviceTypes.length && !(isPresentMXU = (devTypeInfo = arrDeviceTypes[i]).getIsMXUDevice()); ++i) {
        }
        return isPresentMXU;
    }

    private Vector filtrationDevTypeSpportTaskTye(int taskTypeId, DeviceTypeInfo[] arrDeviceTypes, int[] iDeviceIdLst) {
        DCDebugTracer.trace("DC::[Olt] filtrationDevTypeSpportTaskTye start");
        IDeviceTypeConfigModel oDevTypeConfigModel = null;
        Vector<DeviceTypeInfo> deviceTypeList = new Vector<DeviceTypeInfo>();
        DeviceTypeInfo deviceType = null;
        for (int i = 0; i < arrDeviceTypes.length; ++i) {
            deviceType = arrDeviceTypes[i];
            int[] m_iDeviceIdLst = TaskModelUtil.getDevTypeInfoFromDevID(iDeviceIdLst, deviceType);
            if (m_iDeviceIdLst[0] == -1000) continue;
            oDevTypeConfigModel = DeviceXMLConfigModel.getInstance().getDeviceTypeConfigModel(deviceType, m_iDeviceIdLst);
            DCDebugTracer.trace("taskTypeId :" + taskTypeId);
            if (oDevTypeConfigModel == null) continue;
            TaskTypeConfiguration taskTypeConf = (TaskTypeConfiguration)oDevTypeConfigModel.getTaskTaskTypeConfiguration();
            if (-2 == taskTypeId) {
                deviceTypeList.add(deviceType);
                continue;
            }
            IParaList oParalist = taskTypeConf.getParaList(taskTypeId);
            if (oParalist == null) continue;
            if (7 == taskTypeId) {
                DeviceInfo[] deviceInfoArray;
                boolean isMXUDeviceExist = false;
                for (DeviceInfo deviceInfo : deviceInfoArray = this.c_oDeviceInfoManager.getDevicesByType(deviceType.getDevTypeID())) {
                    if (deviceInfo.getRoleType() != 2 || !deviceInfo.getDeviceTypeInfo().isBMSDomain()) continue;
                    isMXUDeviceExist = true;
                    break;
                }
                if (!isMXUDeviceExist) continue;
            }
            deviceTypeList.add(deviceType);
        }
        DCDebugTracer.trace("deviceTypeList.size():" + deviceTypeList.size());
        if (deviceTypeList.size() > 0) {
            int allDevTypeId = -1;
            int allDevTypeVersionId = -1;
            deviceType = new DeviceTypeInfo();
            deviceType.setDevTypeName(DCConstants.ALL_TYPE);
            deviceType.setDevTypeVersionName(DCConstants.ALL_TYPE_VERSION);
            deviceType.setDevTypeID(-1);
            deviceType.setDevTypeVersionId(-1);
            this.c_oDeviceInfoManager.setDevTypeListByDiffusionTask(deviceTypeList);
            deviceTypeList.add(deviceType);
        }
        DCDebugTracer.trace("DC::[Olt] filtrationDevTypeSpportTaskTye end..");
        return deviceTypeList;
    }

    private boolean doesDeviceTypeSupportCurrentTask(DeviceTypeInfo oDeviceType, int[] iDeviceIdLst) {
        TaskTypeConfiguration taskTypeConf;
        IParaList oParalist;
        IDeviceTypeConfigModel oDevTypeConfigModel = DeviceXMLConfigModel.getInstance().getDeviceTypeConfigModel(oDeviceType, iDeviceIdLst);
        return oDevTypeConfigModel != null && (oParalist = (taskTypeConf = (TaskTypeConfiguration)oDevTypeConfigModel.getTaskTaskTypeConfiguration()).getParaList(this.taskTypeId)) != null;
    }

    private void createDeviceVersionDropDown() {
        this.m_oDeviceVersionModel = new DefaultComboBoxModel();
        this.m_oDeviceVersionComboBox = new ComboBoxWithToolTip((ComboBoxModel)this.m_oDeviceVersionModel);
        this.m_oDeviceVersionComboBox.setName("DeviceSelection_DeviceSelectionDropDownpanel_m_oDeviceVersionComboBox");
        this.populateVersionDropDown();
    }

    private void addComponentActionListener() {
        this.m_oDeviceTypeComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent oEvent) {
                if (2 == oEvent.getStateChange()) {
                    return;
                }
                DeviceSelectionDropDownPanel.this.m_oDeviceVersionComboBox.removeItemListener(DeviceSelectionDropDownPanel.this.m_oVersionItemListener);
                DeviceSelectionDropDownPanel.this.m_oDeviceVersionComboBox.removeActionListener(DeviceSelectionDropDownPanel.this.m_oVersionActionListener);
                DeviceSelectionDropDownPanel.this.m_oDeviceVersionModel.removeAllElements();
                DeviceSelectionDropDownPanel.this.populateVersionDropDown();
                DeviceSelectionDropDownPanel.this.sendNotificationForTypeChange();
                DeviceSelectionDropDownPanel.this.m_oDeviceVersionComboBox.addItemListener(DeviceSelectionDropDownPanel.this.m_oVersionItemListener);
                DeviceSelectionDropDownPanel.this.m_oDeviceVersionComboBox.addActionListener(DeviceSelectionDropDownPanel.this.m_oVersionActionListener);
                DeviceSelectionDropDownPanel.this.updateBoardCombox(DeviceSelectionDropDownPanel.this.getSelectedDeviceType());
                DeviceSelectionDropDownPanel.this.m_oSearchTextField.setText("");
            }
        });
        this.m_oVersionItemListener = null;
        this.m_oVersionItemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (2 == e.getStateChange()) {
                    return;
                }
                int iMinVersionCount = 0;
                if (DeviceSelectionDropDownPanel.this.bSupportAllVersions) {
                    iMinVersionCount = 1;
                }
                if (iMinVersionCount < DeviceSelectionDropDownPanel.this.m_oDeviceVersionModel.getSize()) {
                    DeviceSelectionDropDownPanel.this.sendNotificationForVersionChange();
                }
                DeviceSelectionDropDownPanel.this.m_oSearchTextField.setText("");
            }
        };
        this.m_oDeviceVersionComboBox.addItemListener(this.m_oVersionItemListener);
        this.m_oVersionActionListener = null;
        this.m_oVersionActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent oEvent) {
                DeviceSelectionDropDownPanel.this.onDeviceVersionChange();
                DeviceSelectionDropDownPanel.this.m_oDeviceBoardTypeComboBox.removeItemListener(DeviceSelectionDropDownPanel.this.m_oBoardActionListener);
                DeviceSelectionDropDownPanel.this.m_oDeviceBoardTypeModel.removeAllElements();
                DeviceSelectionDropDownPanel.this.populateDevBoardTypeDropDown();
                DeviceSelectionDropDownPanel.this.m_oDeviceBoardTypeComboBox.addItemListener(DeviceSelectionDropDownPanel.this.m_oBoardActionListener);
            }
        };
        this.m_oDeviceVersionComboBox.addActionListener(this.m_oVersionActionListener);
        this.m_oBoardActionListener = null;
        this.m_oBoardActionListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (2 == e.getStateChange()) {
                    return;
                }
                DeviceSelectionDropDownPanel.this.sendNotieForDevBoardChange();
            }
        };
        this.m_oDeviceBoardTypeComboBox.addItemListener(this.m_oBoardActionListener);
    }

    private void populateVersionDropDown() {
        if (null == this.m_oDeviceTypeModel || 0 == this.m_oDeviceTypeModel.getSize()) {
            return;
        }
        this.populateVersionModelFromSelectedType();
        if (0 != this.m_oDeviceVersionModel.getSize()) {
            if (this.bSupportAllVersions) {
                this.m_oDeviceVersionModel.insertElementAt(All_VERSIONS, 0);
            }
            this.m_oDeviceVersionComboBox.setEnabled(true);
            if (this.m_oDeviceVersionModel.getSize() > 0) {
                this.m_oDeviceVersionComboBox.setSelectedIndex(0);
            }
            if (null != this.m_oDeviceBoardTypeComboBox) {
                this.m_oDeviceBoardTypeComboBox.setEnabled(true);
                if (this.m_oDeviceBoardTypeModel.getSize() > 0) {
                    this.m_oDeviceBoardTypeComboBox.setSelectedIndex(0);
                }
            }
        } else {
            if (this.bIsAllDevType) {
                this.m_oDeviceVersionModel.insertElementAt(All_VERSIONS, 0);
            }
            this.m_oDeviceVersionComboBox.setEnabled(false);
            if (null != this.m_oDeviceBoardTypeComboBox) {
                this.m_oDeviceBoardTypeComboBox.removeAllItems();
                this.m_oDeviceBoardTypeComboBox.setEnabled(false);
            }
        }
    }

    private void populateVersionModelFromSelectedType() {
        DeviceTypeInfo oSelectedDeviceType = this.getSelectedDeviceType();
        int oSelectedDeviceTypeID = oSelectedDeviceType.getDevTypeID();
        int oSelectedDeviceTypeVersionID = oSelectedDeviceType.getDevTypeVersionId();
        int allDevTypeId = -1;
        int allDevTypeVersionId = -1;
        if (-1 == oSelectedDeviceTypeID && -1 == oSelectedDeviceTypeVersionID) {
            this.bIsAllDevType = true;
        } else {
            this.bIsAllDevType = false;
            HashMap oVersionMap = this.c_oDeviceInfoManager.getDeviceVersionMapByDeviceTypeAndVersion(oSelectedDeviceTypeID, oSelectedDeviceTypeVersionID);
            if (null == oVersionMap) {
                return;
            }
            Iterator oVersionIterator = oVersionMap.keySet().iterator();
            String strVersion = null;
            while (oVersionIterator.hasNext()) {
                strVersion = (String)oVersionIterator.next();
                if (this.taskTypeId == 7 && ("".equals(strVersion) || ResourceManager.getInstance().getResString("UNKNOWN_VERSION").equals(strVersion))) continue;
                this.m_oDeviceVersionModel.addElement(strVersion);
            }
        }
    }

    public DeviceTypeInfo getSelectedDeviceType() {
        DeviceTypeInfo oSelectedType = (DeviceTypeInfo)this.m_oDeviceTypeComboBox.getSelectedItem();
        return oSelectedType;
    }

    public String getSelectedDeviceVersion() {
        String strVersion = (String)this.m_oDeviceVersionComboBox.getSelectedItem();
        if (All_VERSIONS.equals(strVersion)) {
            strVersion = "";
        }
        return strVersion;
    }

    public String getSelectedDevBoard() {
        String strBoardType = (String)this.m_oDeviceBoardTypeComboBox.getSelectedItem();
        if (DEVICE_BOARD_TYPE_ALL.equals(strBoardType)) {
            return null;
        }
        return strBoardType;
    }

    public DeviceDropDownEventHandler getEventHandler() {
        return this.m_oEventHandler;
    }

    public void initializeDropDowns() {
        if (0 != this.m_oDeviceTypeModel.getSize()) {
            if (0 < this.m_oDeviceVersionModel.getSize()) {
                this.m_oEventHandler.sendNotificationForTypeChange(this.getSelectedDeviceType(), null, true);
                this.m_oEventHandler.sendNotificationForVersionChange(this.getSelectedDeviceVersion(), false);
            } else {
                this.m_oEventHandler.sendNotificationForTypeChange(this.getSelectedDeviceType(), null, false);
            }
        }
    }

    public void setSelectedDeviceType(DeviceTypeInfo oDeviceType) {
        if (null == oDeviceType || 0 == this.m_oDeviceTypeModel.getSize()) {
            return;
        }
        int iIndex = this.m_oDeviceTypeModel.getIndexOf(oDeviceType);
        if (-1 == iIndex) {
            iIndex = 0;
        }
        this.bManualEvent = true;
        this.m_oDeviceTypeComboBox.setSelectedIndex(iIndex);
        this.bManualEvent = false;
        DeviceDropDownChangeEvent oTypeEvent = new DeviceDropDownChangeEvent(this.getSelectedDeviceType(), 1);
        this.m_oEventHandler.notifyEvent(oTypeEvent, this.bManualEvent);
        this.updateBoardCombox(oDeviceType);
    }

    public void setSelectedDeviceTypeByFilter(DeviceTypeInfo oDeviceType) {
        if (null == oDeviceType || 0 == this.m_oDeviceTypeModel.getSize()) {
            return;
        }
        int iIndex = this.m_oDeviceTypeModel.getIndexOf(oDeviceType);
        if (-1 == iIndex) {
            iIndex = 0;
        }
        this.bManualEvent = true;
        this.m_oDeviceTypeComboBox.setSelectedIndex(iIndex);
        this.bManualEvent = false;
        DeviceDropDownChangeEvent oTypeEvent = new DeviceDropDownChangeEvent(this.getSelectedDeviceType(), 4);
        this.m_oEventHandler.notifyEvent(oTypeEvent, this.bManualEvent);
    }

    public void setSelectedDeviceVersion(String oDeviceVersion) {
        if (null == oDeviceVersion || 0 == this.m_oDeviceVersionModel.getSize()) {
            return;
        }
        int iIndex = this.m_oDeviceVersionModel.getIndexOf(oDeviceVersion);
        if (-1 == iIndex) {
            iIndex = 0;
        }
        this.bManualEvent = true;
        this.m_oDeviceVersionComboBox.setSelectedIndex(iIndex);
        this.bManualEvent = false;
    }

    private void sendNotificationForTypeChange() {
        DeviceTypeInfo oSelectedType = this.getSelectedDeviceType();
        if (this.m_oLastDeviceTypeInfo != null && this.m_oLastDeviceTypeInfo.equals(oSelectedType)) {
            return;
        }
        this.m_oLastDeviceTypeInfoForRe = this.m_oLastDeviceTypeInfo;
        this.m_oLastDeviceTypeInfo = oSelectedType;
        this.m_strLastDeviceVersion = this.getSelectedDeviceVersion();
        this.m_oEventHandler.sendNotificationForTypeChange(this.m_oLastDeviceTypeInfo, this.m_strLastDeviceVersion, this.bManualEvent);
    }

    private void sendNotificationForVersionChange() {
        String strSelectedVersion;
        this.m_strLastDeviceVersion = strSelectedVersion = this.getSelectedDeviceVersion();
        if (null == this.m_oEventHandler) {
            this.initializeEventHandler();
        }
        this.m_oEventHandler.sendNotificationForVersionChange(strSelectedVersion, this.bManualEvent);
    }

    private void sendNotieForDevBoardChange() {
        String strSelectedVersion;
        this.m_strLastDeviceVersion = strSelectedVersion = this.getSelectedDeviceVersion();
        if (null == this.m_oEventHandler) {
            this.initializeEventHandler();
        }
        this.m_oEventHandler.sendNotificationForVersionChange(strSelectedVersion, this.getSelectedDevBoard(), this.bManualEvent);
    }

    private int getInsertIndex(DeviceTypeInfo oNewDevTypeInfo) {
        int iSize = this.m_oDeviceTypeModel.getSize();
        for (int i = 0; i < iSize; ++i) {
            if (0 <= oNewDevTypeInfo.compareTo(this.m_oDeviceTypeModel.getElementAt(i))) continue;
            return i;
        }
        return 0;
    }

    private void handleDeviceAddNotification(AsnDCDeviceSubmapNtfnInfoLst oDeviceInfoList) {
        AsnDCDeviceSubmapNtfnInfo oAsnDeviceInfo = null;
        int iDeviceCount = oDeviceInfoList.size();
        for (int i = 0; i < iDeviceCount; ++i) {
            boolean isVersionExist;
            oAsnDeviceInfo = (AsnDCDeviceSubmapNtfnInfo)oDeviceInfoList.get(i);
            DeviceInfo oDeviceInfo = this.c_oDeviceInfoManager.getDeviceFromAsn(oAsnDeviceInfo.oDeviceInfo);
            int[] iDeviceIdLst = new int[]{oDeviceInfo.getDevId()};
            if (null == oDeviceInfo.getDeviceTypeInfo() || !this.doesDeviceTypeSupportCurrentTask(oDeviceInfo.getDeviceTypeInfo(), iDeviceIdLst) || null == oDeviceInfo.getDevVersion()) continue;
            DeviceTypeInfo oNewDevType = oDeviceInfo.getDeviceTypeInfo();
            if (-1 == this.m_oDeviceTypeModel.getIndexOf(oNewDevType)) {
                this.m_oDeviceTypeModel.insertElementAt(oNewDevType, this.getInsertIndex(oNewDevType));
                this.m_oDeviceTypeComboBox.repaint();
                continue;
            }
            if (!this.getSelectedDeviceType().equals(oNewDevType) || -1 != this.m_oDeviceVersionModel.getIndexOf(oDeviceInfo.getDevVersion().getDevVersion())) continue;
            String strNewVersion = oDeviceInfo.getDevVersion().getDevVersion();
            if (null == strNewVersion || "".equals(strNewVersion)) {
                strNewVersion = ResourceManager.getInstance().getResString("UNKNOWN_VERSION");
            }
            if (!(isVersionExist = this.isVersionExist(strNewVersion))) {
                this.m_oDeviceVersionModel.addElement(strNewVersion);
            }
            if (1 == this.m_oDeviceVersionModel.getSize()) {
                this.m_oDeviceVersionComboBox.setEnabled(true);
                if (this.bSupportAllVersions) {
                    String strAllVersions = ResourceManager.getInstance().getResString("DEVICE_VERSION_ALL");
                    this.m_oDeviceVersionModel.insertElementAt(strAllVersions, 0);
                }
            }
            this.m_oDeviceVersionComboBox.repaint();
        }
    }

    private void handleDeviceDeleteNotification(AsnDCDeviceSubmapNtfnInfoLst oDeviceInfoList) {
        AsnDCDeviceSubmapNtfnInfo oAsnDeviceInfo = null;
        int iDeviceCount = oDeviceInfoList.size();
        for (int i = 0; i < iDeviceCount; ++i) {
            DeviceInfo[] arrRemainingDevices;
            String strDelVersion;
            oAsnDeviceInfo = (AsnDCDeviceSubmapNtfnInfo)oDeviceInfoList.get(i);
            int iDeviceCountForVersion = 1;
            DeviceInfo oDeviceInfo = this.c_oDeviceInfoManager.getDevice(oAsnDeviceInfo.oDeviceInfo.iDevId.intValue());
            if (null == oDeviceInfo) {
                oDeviceInfo = this.c_oDeviceInfoManager.getDeviceFromAsn(oAsnDeviceInfo.oDeviceInfo);
                iDeviceCountForVersion = 0;
            }
            if (null == oDeviceInfo.getDeviceTypeInfo() || -1 == this.m_oDeviceTypeModel.getIndexOf(oDeviceInfo.getDeviceTypeInfo()) || null == oDeviceInfo.getDevVersion()) {
                return;
            }
            DeviceTypeInfo oDeletedDevType = oDeviceInfo.getDeviceTypeInfo();
            boolean bDeleteType = false;
            DeviceInfo[] arrDevices = this.c_oDeviceInfoManager.getDevicesByTypeAndVersion(oDeletedDevType.getDevTypeID(), oDeletedDevType.getDevTypeVersionId());
            if (null == arrDevices || 0 >= arrDevices.length || 1 == arrDevices.length && arrDevices[0].getDevId() == oDeviceInfo.getDevId()) {
                bDeleteType = true;
            }
            if (bDeleteType && !this.getSelectedDeviceType().equals(oDeletedDevType)) {
                this.m_oDeviceTypeModel.removeElement(oDeletedDevType);
                this.m_oDeviceTypeComboBox.repaint();
                continue;
            }
            if (bDeleteType && 1 < this.m_oDeviceTypeModel.getSize()) {
                this.m_oDeviceTypeModel.removeElement(oDeletedDevType);
                this.m_oDeviceTypeComboBox.repaint();
            }
            if (null == (strDelVersion = oDeviceInfo.getDevVersion().getDevVersion()) || "".equals(strDelVersion)) {
                strDelVersion = ResourceManager.getInstance().getResString("UNKNOWN_VERSION");
            }
            if (-1 == this.m_oDeviceVersionModel.getIndexOf(strDelVersion) || iDeviceCountForVersion != (arrRemainingDevices = this.c_oDeviceInfoManager.getDevicesForVersion(oDeviceInfo.getDevVersion().getDevVersion(), oDeviceInfo.getDeviceTypeInfo())).length) continue;
            this.m_oDeviceVersionModel.removeElement(oDeviceInfo.getDevVersion().getDevVersion());
            if (this.bSupportAllVersions && 1 == this.m_oDeviceVersionModel.getSize()) {
                String strAllVersions = ResourceManager.getInstance().getResString("DEVICE_VERSION_ALL");
                this.m_oDeviceVersionModel.removeElement(strAllVersions);
            }
            if (0 != this.m_oDeviceVersionModel.getSize()) continue;
            this.m_oDeviceVersionComboBox.setEnabled(false);
        }
        this.m_oDeviceVersionComboBox.repaint();
    }

    public void disposePanel() {
        DeviceConfigEventReceiver.getInstance().unResigterForConfigChangeEvent(this);
        if (null != this.m_oEventHandler) {
            this.m_oEventHandler.doCleanUp();
            this.m_oEventHandler = null;
        }
        this.m_oVersionItemListener = null;
        this.m_oVersionActionListener = null;
    }

    private void onDeviceVersionChange() {
        int iListenerCount = this.m_oDeviceVersionListenerlist.size();
        String strDeviceVersion = "";
        if (null != this.m_oDeviceVersionComboBox.getSelectedItem()) {
            strDeviceVersion = this.m_oDeviceVersionComboBox.getSelectedItem().toString();
        }
        if (0 == iListenerCount || 0 == this.m_oDeviceVersionComboBox.getItemCount() || 0 == strDeviceVersion.length()) {
            return;
        }
        for (int index = 0; index < iListenerCount; ++index) {
            IDeviceVersionChangeListener oDeviceVersionChangeListener = (IDeviceVersionChangeListener)this.m_oDeviceVersionListenerlist.get(index);
            oDeviceVersionChangeListener.deviceVersionChangeNotification(strDeviceVersion);
        }
    }

    @Override
    public void addDeviceVersionChangelistener(IDeviceVersionChangeListener oDeviceVersionChangeListener) {
        this.m_oDeviceVersionListenerlist.add(oDeviceVersionChangeListener);
    }

    @Override
    public void removeDeviceVersionChangelistener(IDeviceVersionChangeListener oDeviceVersionChangeListener) {
        this.m_oDeviceVersionListenerlist.remove(oDeviceVersionChangeListener);
    }

    @Override
    public void handleDeviceConfigNotification(int iEventType, AsnDCDeviceSubmapNtfnInfoLst oDeviceInfoList) {
        switch (iEventType) {
            case 0: {
                this.handleDeviceAddNotification(oDeviceInfoList);
                break;
            }
            case 1: {
                this.handleDeviceDeleteNotification(oDeviceInfoList);
                break;
            }
        }
    }

    private boolean isVersionExist(String sVersion) {
        int iVersionIndex = this.m_oDeviceVersionModel.getIndexOf(sVersion);
        return iVersionIndex >= 0;
    }

    public boolean isBIsAllDevType() {
        return this.bIsAllDevType;
    }

    public void setBIsAllDevType(boolean isAllDevType) {
        this.bIsAllDevType = isAllDevType;
    }

    private void createDeviceSearchField() {
        this.m_oSearchTextField = new JTextField();
        this.m_oSearchTextField.setPreferredSize(new Dimension(186, 20));
        this.m_oSearchTextField.setMinimumSize(new Dimension(186, 20));
        this.m_oSearchTextField.setToolTipText(ResourceManager.getInstance().getResString("KEY_WORD_FIELD_TOOLTIP"));
    }

    public JTextField getSearchTextField() {
        return this.m_oSearchTextField;
    }

    public DeviceTypeInfo getLastDeviceTypeInfo() {
        return this.m_oLastDeviceTypeInfoForRe;
    }

    public boolean isManualEvent() {
        return this.bManualEvent;
    }
}

