/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.components.deviceselection.dropdown;

import com.huawei.dc.common.components.deviceselection.dropdown.DevBoardTypeEvent;
import com.huawei.dc.common.components.deviceselection.dropdown.DeviceDropDownChangeEvent;
import com.huawei.dc.common.components.deviceselection.dropdown.DeviceDropDownChangeListener;
import com.huawei.dc.common.components.deviceselection.dropdown.DeviceDropDownChangeNotifier;
import com.huawei.dc.common.components.deviceselection.dropdown.DeviceSelectionDropDownPanel;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import java.util.ArrayList;

public class DeviceDropDownEventHandler
implements DeviceDropDownChangeNotifier {
    private ArrayList m_oEventListenerList = new ArrayList(1);
    private static final int LISTENER_LIST_DEFAULT_SIZE = 1;

    public DeviceDropDownEventHandler(DeviceSelectionDropDownPanel oPanel) {
    }

    public void sendNotificationForTypeChange(DeviceTypeInfo oSelectedType, String sDeviceVesion, boolean bManualEvent) {
        DeviceDropDownChangeEvent oEvent = new DeviceDropDownChangeEvent(oSelectedType, 1);
        oEvent.setDeviceVersion(sDeviceVesion);
        this.notifyEvent(oEvent, bManualEvent);
    }

    public void sendNotificationForVersionChange(String strSelectedVersion, boolean bManualEvent) {
        if (null == strSelectedVersion) {
            strSelectedVersion = "";
        }
        DeviceDropDownChangeEvent oEvent = new DeviceDropDownChangeEvent(strSelectedVersion, 2);
        this.notifyEvent(oEvent, bManualEvent);
    }

    public void sendNotificationForVersionChange(String strSelectedVersion, String boardType, boolean bManualEvent) {
        if (null == strSelectedVersion) {
            strSelectedVersion = "";
        }
        if (null == boardType) {
            DeviceDropDownChangeEvent oEvent = new DeviceDropDownChangeEvent(strSelectedVersion, 2);
            this.notifyEvent(oEvent, bManualEvent);
            return;
        }
        DevBoardTypeEvent devBoard = new DevBoardTypeEvent(boardType, strSelectedVersion);
        DeviceDropDownChangeEvent oEvent = new DeviceDropDownChangeEvent(devBoard, 3);
        this.notifyEvent(oEvent, bManualEvent);
    }

    @Override
    public void addDropDownChangeListener(DeviceDropDownChangeListener oEventListener) {
        if (null != oEventListener && !this.m_oEventListenerList.contains(oEventListener)) {
            this.m_oEventListenerList.add(oEventListener);
        }
    }

    @Override
    public void notifyEvent(DeviceDropDownChangeEvent oEventObject, boolean bManualEvent) {
        int iCount = this.m_oEventListenerList.size();
        for (int index = 0; index < iCount; ++index) {
            DeviceDropDownChangeListener oEventListener = (DeviceDropDownChangeListener)this.m_oEventListenerList.get(index);
            if (bManualEvent) {
                oEventListener.setCurrentEvent(oEventObject);
                continue;
            }
            oEventListener.onDropDownSelecton(oEventObject);
        }
    }

    @Override
    public void removeDeviceDropDownChangeListener(DeviceDropDownChangeListener oEventListener) {
        if (null != oEventListener && this.m_oEventListenerList.contains(oEventListener)) {
            this.m_oEventListenerList.remove(oEventListener);
        }
    }

    public void doCleanUp() {
        if (null != this.m_oEventListenerList) {
            this.m_oEventListenerList.clear();
            this.m_oEventListenerList = null;
        }
    }
}

