/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.components.deviceselection;

import com.huawei.dc.common.DCConstants;
import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnDCMainBoardNumEnum;
import com.huawei.dc.common.asndatacenter.AsnDCMainBoardNumReq;
import com.huawei.dc.common.asndatacenter.AsnDCSWDLStatusNotify;
import com.huawei.dc.common.components.deviceselection.dropdown.DeviceDropDownChangeListener;
import com.huawei.dc.common.components.deviceselection.dropdown.DeviceDropDownEventHandler;
import com.huawei.dc.common.components.deviceselection.dropdown.DeviceSelectionDropDownPanel;
import com.huawei.dc.common.components.deviceselection.table.DeviceSelectionCommTablePanel;
import com.huawei.dc.common.components.deviceselection.table.DeviceSelectionTableEventHandler;
import com.huawei.dc.common.components.deviceselection.table.DeviceSelectionTablePanel;
import com.huawei.dc.common.components.deviceselection.table.OLTDeviceSelectionTablePanel;
import com.huawei.dc.common.components.devicetreepanel.DeviceTreeButtonInfo;
import com.huawei.dc.common.components.devicetreepanel.DeviceTreePanel;
import com.huawei.dc.common.components.devicetreepanel.DeviceTreePanelEventHandler;
import com.huawei.dc.common.components.devicetreepanel.DeviceTreeToolBarModel;
import com.huawei.dc.common.components.dialog.CommonProgressDlg;
import com.huawei.dc.common.components.tree.devicetree.DeviceTree;
import com.huawei.dc.common.components.tree.devicetree.DeviceTreeUtil;
import com.huawei.dc.common.components.tree.devicetree.descriptor.DeviceVersionTreeDescriptor;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCCommonUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.taskmgmt.controller.TaskAsynCommController;
import com.huawei.dc.taskmgmt.controller.TaskAsynCommControllerProxy;
import com.huawei.dc.taskmgmt.controller.TaskCommUtil;
import com.huawei.dc.taskmgmt.controller.UpgradeFeasibilityNotifier;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.view.createtask.CreateTaskDeviceSelectionPanel;
import gnu.trove.THashSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class DeviceSelectionPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Color PANEL_BORDER_COLOR = new Color(148, 145, 140);
    protected DeviceSelectionDropDownPanel m_oDeviceDropDownPanel;
    protected DeviceSelectionCommTablePanel m_oDeviceTablePanel;
    protected DeviceTreePanel m_oDeviceTreePanel;
    protected JSeparator oSeparator;
    private DeviceTreePanelEventHandler m_oDeviceTreeEventListener;
    private DeviceDropDownEventHandler m_oDeviceDropDownEventHandler;
    private DeviceSelectionTableEventHandler m_oDeviceTableEventHandler;
    protected IDeviceInfoManager c_oDeviceInfoManager;
    protected JPanel oLeftPanel;
    private int m_iTaskTypeId = -1;
    private JPanel importButtonPanel;
    private JButton importButton;
    private CreateTaskDeviceSelectionPanel m_oFirstStepPanel;
    private boolean m_isOfflineTask = false;
    private JTextField m_oSearchTextField;
    private int deviceCount = 0;
    private THashSet<Resource> oResources = new THashSet();
    private DeviceTypeInfo m_oCurrentSelectedDevTypeInfo = null;
    public String rootName = "";

    public DeviceSelectionPanel(CreateTaskDeviceSelectionPanel oPanel) {
        this.m_oFirstStepPanel = oPanel;
    }

    public DeviceSelectionPanel(boolean isOfflineTask) {
        this.m_isOfflineTask = isOfflineTask;
    }

    public void setMainBoardNumInfo(int iDevId, AsnDCMainBoardNumEnum oMainBoardNum) {
        Resource oRes = this.getResourceById(iDevId);
        if (null != oRes) {
            oRes.setMainBoardNum(oMainBoardNum.value);
            this.oResources.add((Object)oRes);
        }
        if (this.deviceCount != 0 && this.deviceCount == this.oResources.size()) {
            this.m_oDeviceTablePanel.updateResourcesInTableModel(this.oResources, true);
        }
        this.setImportButtonColor(this.m_oDeviceTablePanel.getBackground());
    }

    private Resource getResourceById(int iDevId) {
        List selectedResources = this.m_oDeviceTreePanel.getSelectedResources();
        for (int i = 0; i < selectedResources.size(); ++i) {
            Resource oRes = (Resource)selectedResources.get(i);
            if (oRes.getDeviceID() != iDevId) continue;
            return oRes;
        }
        return null;
    }

    public DeviceSelectionPanel(DeviceTreeToolBarModel oButtonModel, boolean bSupportAllVersions, int iTreeViewType, boolean bSupportAllTypes, String strRootName, int taskTypeId) throws DCException {
        this.m_iTaskTypeId = taskTypeId;
        this.rootName = strRootName;
        this.initDeviceSelection(oButtonModel, bSupportAllVersions, bSupportAllTypes, iTreeViewType, taskTypeId);
        this.initDeviceInfoManager();
        this.refreshViewForCurrentDeviceSelection();
    }

    public void onDropDownSelecton(DeviceTypeInfo oSelectedDevType) {
        this.m_oCurrentSelectedDevTypeInfo = oSelectedDevType;
        int iDevTypeId = oSelectedDevType.getDevTypeID();
        if (-1 == iDevTypeId && this.isShowImportBtn(iDevTypeId)) {
            this.createImportButtonPanel();
            this.m_oDeviceTreePanel.getToolBarPanel().add((Component)this.importButtonPanel, "Center");
            this.updateUI();
        }
        this.setImportButtonColor(this.m_oDeviceTablePanel.getBackground());
        this.m_oDeviceTablePanel.updateTableHeader(this.m_iTaskTypeId, this.getSelectDevTypeId());
    }

    private boolean isShowImportBtn(int iDevTypeId) {
        return DCCommonUtil.isShowQueryBtnForTask(this.m_iTaskTypeId, iDevTypeId);
    }

    public DeviceSelectionPanel(boolean bSupportAllVersions, int iTreeViewType, String strRootName) throws DCException {
        this(DeviceSelectionPanel.generateDefaultToolBarModel(), bSupportAllVersions, iTreeViewType, false, strRootName, -1);
    }

    private void initDeviceSelection(DeviceTreeToolBarModel oButtonModel, boolean bSupportAllVersions, boolean bSupportAllTypes, int iTreeViewType, int taskTypeId) throws DCException {
        this.createSubPanels(oButtonModel, bSupportAllVersions, bSupportAllTypes, iTreeViewType, taskTypeId);
        this.initializeEventListeners(bSupportAllVersions);
        this.registerPanelsForEvents();
        this.alignMainPanel();
    }

    public void initDeviceSelectionPanel(DeviceTreeToolBarModel oButtonModel, boolean bSupportAllVersions, boolean bSupportAllTypes, int iTreeViewType, int taskTypeId, DeviceDropDownChangeListener oTaskDeviceTypeChangeListener) throws DCException {
        this.m_iTaskTypeId = taskTypeId;
        this.initDeviceSelection(oButtonModel, bSupportAllVersions, bSupportAllTypes, iTreeViewType, taskTypeId);
        this.initDeviceInfoManager();
        this.m_oDeviceDropDownEventHandler.addDropDownChangeListener(oTaskDeviceTypeChangeListener);
    }

    public void refreshViewForCurrentDeviceSelection() {
        this.m_oDeviceDropDownPanel.initializeDropDowns();
    }

    protected void initDeviceInfoManager() {
        this.c_oDeviceInfoManager = DCFrameWorkUtil.getDeviceInfoManager();
    }

    private void createSubPanels(DeviceTreeToolBarModel oButtonModel, boolean bSupportAllVersions, boolean bSupportAllTypes, int iTreeViewType, int taskTypeId) throws DCException {
        this.m_oDeviceDropDownPanel = this.createDeviceDropDownPanel(bSupportAllVersions, bSupportAllTypes, taskTypeId);
        this.m_oDeviceDropDownPanel.setName("TaskMgmt_DeviceSelectionPanel_m_oDeviceDropDownPanel");
        if (iTreeViewType == 5) {
            this.m_oDeviceTablePanel = new OLTDeviceSelectionTablePanel();
            this.m_oDeviceTablePanel.setName("TaskMgmt_DeviceSelectionPanel_m_oDeviceTablePanel");
        } else {
            this.m_oDeviceTablePanel = new DeviceSelectionTablePanel(this.m_iTaskTypeId);
            this.m_oDeviceTablePanel.setName("TaskMgmt_DeviceSelectionPanel_m_oDeviceTablePanel");
        }
        this.m_oDeviceTreePanel = this.createDeviceTreePanel(oButtonModel, iTreeViewType);
        this.m_oDeviceTreePanel.setName("TaskMgmt_DeviceSelectionPanel_m_oDeviceTreePanel");
        this.m_oDeviceTreePanel.setSearchTextField(this.m_oSearchTextField);
        GridBagLayout thisLayout = new GridBagLayout();
        this.setLayout(thisLayout);
        this.createLeftPanel();
        this.createRightPanel();
    }

    public void enableDeviceDropDowns(boolean bFlag) {
        this.m_oDeviceDropDownPanel.enableDeviceDropDowns(bFlag);
    }

    private void createLeftPanel() {
        GridBagLayout oLeftPanelLayout = new GridBagLayout();
        this.oLeftPanel = new JPanel(null);
        this.oLeftPanel.setName("TaskMgmt_DeviceSelectionPanel_oLeftPanel");
        this.oLeftPanel.setLayout(oLeftPanelLayout);
        this.m_oDeviceDropDownPanel.setPreferredSize(new Dimension(257, 72));
        this.m_oDeviceDropDownPanel.setMaximumSize(new Dimension(257, 72));
        this.oLeftPanel.add((Component)this.m_oDeviceDropDownPanel, new GridBagConstraints(0, 0, 2, 2, 0.0, 0.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.m_oDeviceTreePanel.setPreferredSize(new Dimension(350, 210));
        this.m_oDeviceTreePanel.setMinimumSize(new Dimension(350, 210));
        this.oLeftPanel.add((Component)this.m_oDeviceTreePanel, new GridBagConstraints(0, 2, 2, 5, 1.0, 1.0, 10, 1, new Insets(5, 12, 0, 12), 0, 0));
        this.oSeparator = new JSeparator(0);
        this.oSeparator.setPreferredSize(new Dimension(254, 210));
        this.oLeftPanel.add((Component)this.oSeparator, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(12, 12, 0, 0), 0, 0));
        this.oLeftPanel.setPreferredSize(new Dimension(400, 310));
        this.oLeftPanel.setMinimumSize(new Dimension(400, 310));
        this.add((Component)this.oLeftPanel, new GridBagConstraints(0, 0, 2, 7, 1.0, 1.0, 10, 1, new Insets(12, 0, 0, 0), 0, 0));
        TitledBorder oBorder = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, PANEL_BORDER_COLOR), ResourceManager.getInstance().getResString("DEVICE_TREE"));
        this.oLeftPanel.setBorder(oBorder);
    }

    private void createRightPanel() {
        this.m_oDeviceTablePanel.setPreferredSize(new Dimension(420, 311));
        this.m_oDeviceTablePanel.setMinimumSize(new Dimension(420, 311));
        this.add((Component)this.m_oDeviceTablePanel, new GridBagConstraints(2, 0, 3, 7, 1.0, 1.0, 10, 1, new Insets(12, 10, 0, 0), 0, 0));
        TitledBorder oBorder = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, PANEL_BORDER_COLOR), ResourceManager.getInstance().getResString("DEVICE_TABLE"));
        this.m_oDeviceTablePanel.setBorder(oBorder);
    }

    private void initializeEventListeners(boolean bSupportAllVersions) {
        this.m_oDeviceTreeEventListener = new DeviceTreePanelEventHandler(this.m_oDeviceTreePanel, this.m_oDeviceTablePanel, bSupportAllVersions);
        this.m_oDeviceDropDownEventHandler = this.m_oDeviceDropDownPanel.getEventHandler();
        this.m_oDeviceTableEventHandler = this.m_oDeviceTablePanel.getEventHandler();
    }

    private void registerPanelsForEvents() {
        this.m_oDeviceDropDownEventHandler.addDropDownChangeListener(this.m_oDeviceTreeEventListener);
        this.m_oDeviceTreeEventListener.registerForTreeSelectionEvent(this.m_oDeviceTableEventHandler);
        this.m_oDeviceTableEventHandler.addDeviceTableActionListener(this.m_oDeviceTreeEventListener);
    }

    private void alignMainPanel() {
        this.setPreferredSize(new Dimension(680, 325));
        this.setMinimumSize(new Dimension(680, 325));
    }

    private DeviceSelectionDropDownPanel createDeviceDropDownPanel(boolean bSupportAllVersions, boolean bSupportAllTypes, int iTaskTypeId) throws DCException {
        this.m_iTaskTypeId = iTaskTypeId;
        DeviceSelectionDropDownPanel oDropDownPanel = new DeviceSelectionDropDownPanel(bSupportAllVersions, iTaskTypeId, bSupportAllTypes);
        this.m_oSearchTextField = oDropDownPanel.getSearchTextField();
        this.m_oSearchTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                DeviceSelectionPanel.this.m_oDeviceTreePanel.setTreeNodeVisibleBySearchContent(DeviceSelectionPanel.this.m_oSearchTextField.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                DeviceSelectionPanel.this.m_oDeviceTreePanel.setTreeNodeVisibleBySearchContent(DeviceSelectionPanel.this.m_oSearchTextField.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        return oDropDownPanel;
    }

    private DeviceTreePanel createDeviceTreePanel(DeviceTreeToolBarModel oButtonModel, int iTreeViewType) {
        DeviceVersionTreeDescriptor oDescriptor = null;
        if (this.m_oDeviceDropDownPanel.isBIsAllDevType()) {
            int allDevTypeId = -1;
            int allDevTypeVersionId = -1;
            DeviceTypeInfo devTypeInfo = new DeviceTypeInfo();
            devTypeInfo.setDevTypeName(DCConstants.ALL_TYPE);
            devTypeInfo.setDevTypeVersionName(DCConstants.ALL_TYPE);
            devTypeInfo.setDevTypeID(-1);
            devTypeInfo.setDevTypeVersionId(-1);
            oDescriptor = new DeviceVersionTreeDescriptor(iTreeViewType, "", devTypeInfo);
            oDescriptor.setTreeSelectable(true);
        } else {
            oDescriptor = this.generateTreeDescriptor(iTreeViewType);
        }
        DeviceTreePanel m_oDeviceTreePanel = new DeviceTreePanel(oButtonModel, oDescriptor, this.rootName);
        return m_oDeviceTreePanel;
    }

    private static DeviceTreeToolBarModel generateDefaultToolBarModel() {
        DeviceTreeToolBarModel oButtonModel = new DeviceTreeToolBarModel();
        DeviceTreeButtonInfo oDeviceButton = new DeviceTreeButtonInfo(0);
        oButtonModel.addButton(oDeviceButton);
        if (!DCFrameWorkUtil.getIsSingleClient() || DCFrameWorkUtil.isShowSubMap()) {
            DeviceTreeButtonInfo oSubmapButton = new DeviceTreeButtonInfo(1);
            oButtonModel.addButton(oSubmapButton);
        }
        oButtonModel.addVerticalSeperator();
        DeviceTreeButtonInfo oImportButton = new DeviceTreeButtonInfo(6);
        oButtonModel.addButton(oImportButton);
        DeviceTreeButtonInfo oExportButton = new DeviceTreeButtonInfo(7);
        oButtonModel.addButton(oExportButton);
        return oButtonModel;
    }

    private DeviceVersionTreeDescriptor generateTreeDescriptor(int iTreeViewType) {
        DeviceVersionTreeDescriptor oTreeDescriptor = new DeviceVersionTreeDescriptor(iTreeViewType, "");
        oTreeDescriptor.setTreeSelectable(true);
        return oTreeDescriptor;
    }

    public DeviceType getCurrentDeviceDataModelFromTable() {
        return this.m_oDeviceTablePanel.getCurrentDeviceDataModel();
    }

    public DeviceTypeInfo getCurrentDeviceTypeInfo() {
        return this.m_oDeviceTablePanel.getCurrentDeviceTypeInfo();
    }

    public String getCurrentDeviceVersion() {
        return this.m_oDeviceTablePanel.getCurrentDeviceVersion();
    }

    public Resource[] getCurrentDevices() {
        return this.m_oDeviceTablePanel.getCurrentDevices();
    }

    public DeviceTree getDeviceTree() {
        return this.m_oDeviceTreePanel.getDeviceTree();
    }

    public void initializePanelForDeviceType(DeviceType oDeviceType, int iTaskType, int isCreateTask) {
        if (null == oDeviceType) {
            return;
        }
        THashSet<Resource> oResources = oDeviceType.getResources();
        DeviceTypeInfo oDeviceTypeInfo = this.getTypeToBeSelected(oResources);
        this.m_oDeviceDropDownPanel.setSelectedDeviceType(oDeviceTypeInfo);
        String strVersion = this.getVersionToBeSelected(oResources);
        this.m_oDeviceDropDownPanel.setSelectedDeviceVersion(strVersion);
        this.refreshViewForCurrentDeviceSelection();
        if (this.isShowImportBtn(oDeviceTypeInfo.getDevTypeID())) {
            this.createImportButtonPanel();
            this.m_oDeviceTreePanel.getToolBarPanel().add((Component)this.importButtonPanel, "Center");
            if (isCreateTask != 0) {
                this.m_oDeviceTablePanel.updateResourcesInTableModel(oResources, true);
            }
        } else {
            this.m_oDeviceTablePanel.addResourcesInTableModelForInit(oResources);
        }
        DeviceTree oDeviceTree = this.m_oDeviceTreePanel.getDeviceTree();
        if (null != oResources && 0 != oResources.size()) {
            DeviceTreeUtil.setTreeNodeSelectionStateForResources(oDeviceTree, oResources, 0, true);
            oDeviceTree.treeDidChange();
        }
        this.refreshPanels();
    }

    public DeviceSelectionDropDownPanel getDeviceSelectionDropDownPanel() {
        return this.m_oDeviceDropDownPanel;
    }

    private void refreshPanels() {
        this.m_oDeviceDropDownPanel.updateUI();
        this.m_oDeviceTreePanel.updateUI();
        this.m_oDeviceTablePanel.updateUI();
        this.updateUI();
    }

    private DeviceTypeInfo getTypeToBeSelected(THashSet<Resource> oResources) {
        DeviceTypeInfo m_oDeviceTypeInfo = new DeviceTypeInfo();
        if (null == oResources || 0 == oResources.size()) {
            return m_oDeviceTypeInfo;
        }
        Iterator oResItor = oResources.iterator();
        Resource oResource = null;
        int i = 0;
        while (oResItor.hasNext()) {
            oResource = (Resource)oResItor.next();
            if (i == 0) {
                m_oDeviceTypeInfo = this.c_oDeviceInfoManager.getDevice(oResource.getDeviceID()).getDeviceTypeInfo();
                ++i;
                continue;
            }
            if (3 == oResource.getRoleType() && -1 != oResource.getStackId()) continue;
            DeviceTypeInfo oDeviceTypeInfo = this.c_oDeviceInfoManager.getDevice(oResource.getDeviceID()).getDeviceTypeInfo();
            if (m_oDeviceTypeInfo.getDevTypeID() == oDeviceTypeInfo.getDevTypeID() && m_oDeviceTypeInfo.getDevTypeVersionId() == oDeviceTypeInfo.getDevTypeVersionId()) continue;
            m_oDeviceTypeInfo = new DeviceTypeInfo();
            int allDevTypeId = -1;
            int allDevTypeVersionId = -1;
            m_oDeviceTypeInfo.setDevTypeName(DCConstants.ALL_TYPE);
            m_oDeviceTypeInfo.setDevTypeVersionName(DCConstants.ALL_TYPE_VERSION);
            m_oDeviceTypeInfo.setDevTypeID(-1);
            m_oDeviceTypeInfo.setDevTypeVersionId(-1);
            break;
        }
        return m_oDeviceTypeInfo;
    }

    private String getVersionToBeSelected(THashSet<Resource> oResources) {
        if (null == oResources || 0 == oResources.size()) {
            return "";
        }
        Iterator oResItor = oResources.iterator();
        Resource oResource = null;
        String strVersion = "";
        int i = 0;
        while (oResItor.hasNext()) {
            oResource = (Resource)oResItor.next();
            if (i == 0) {
                strVersion = oResource.getDeviceVersion();
                ++i;
                continue;
            }
            if (strVersion.equals(oResource.getDeviceVersion())) continue;
            return ResourceManager.getInstance().getResString("DEVICE_VERSION_ALL");
        }
        return strVersion;
    }

    public void disposePanel() {
        if (null != this.m_oDeviceDropDownPanel) {
            this.m_oDeviceDropDownPanel.disposePanel();
        }
        if (null != this.m_oDeviceTreePanel) {
            this.m_oDeviceTreePanel.disposePanel();
        }
        if (null != this.m_oDeviceTablePanel) {
            this.m_oDeviceTablePanel.disposePanel();
        }
        UpgradeFeasibilityNotifier.getInstance().removeUpgradeFeasibilityEventListener(this.m_oDeviceTreeEventListener);
        this.m_oDeviceTreeEventListener = null;
        this.m_oDeviceDropDownEventHandler = null;
        this.m_oDeviceTableEventHandler = null;
    }

    public void updateToolBarPanel(DeviceTreeToolBarModel oUpdatedToolBarModel) {
        this.m_oDeviceTreePanel.updateToolBar(oUpdatedToolBarModel);
        int iDevTypeId = -1;
        if (null != this.m_oCurrentSelectedDevTypeInfo) {
            iDevTypeId = this.m_oCurrentSelectedDevTypeInfo.getDevTypeID();
        }
        if (this.isShowImportBtn(iDevTypeId)) {
            this.createImportButtonPanel();
            this.m_oDeviceTreePanel.getToolBarPanel().add((Component)this.importButtonPanel, "Center");
        }
        this.updateUI();
    }

    public DeviceSelectionCommTablePanel getDeviceTablePanel() {
        return this.m_oDeviceTablePanel;
    }

    public DeviceTreePanel getDevcieTreePanel() {
        return this.m_oDeviceTreePanel;
    }

    private void createImportButtonPanel() {
        if (null == this.importButtonPanel) {
            this.importButtonPanel = new JPanel();
            this.importButtonPanel.setLayout(new FlowLayout(2));
            this.importButton = new JButton(ResourceManager.getInstance().getResString("BUTTON_QUERY_BOARDINFO") + " >>");
            this.importButton.setName("TaskMgmt_DeviceSelectionPanel_queryButton");
            this.importButton.setPreferredSize(new Dimension(80, 20));
            if (this.m_iTaskTypeId == 5 || this.m_iTaskTypeId == 4 || this.m_iTaskTypeId == 13) {
                this.importButton.setToolTipText(ResourceManager.getInstance().getResString("QUERY_SWDL_DLG_PROGRESS_TITLE"));
            } else if (this.m_iTaskTypeId == 0 || this.m_iTaskTypeId == 1) {
                this.importButton.setToolTipText(ResourceManager.getInstance().getResString("QUERY_MAIN_BOARD_NUM_TITLE"));
            }
            this.importButtonPanel.add(this.importButton);
            this.importButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent oEvent) {
                    DeviceSelectionPanel.this.importButton_actionPerformed();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importButton_actionPerformed() {
        this.oResources = new THashSet();
        List selectedResources = this.m_oDeviceTreePanel.getSelectedResources();
        if (selectedResources.size() == 0) {
            DCOptionPane.showMessageDialog((Component)this, ResourceManager.getInstance().getResString("NO_DEVICES_SELECTED"), ResourceManager.getInstance().getResString("ERROR"), 0);
            return;
        }
        THashSet<Resource> currentResourceList = this.m_oDeviceTablePanel.getCurrentResources();
        ArrayList<Integer> devicesIDList = new ArrayList<Integer>();
        for (Object resource : selectedResources) {
            if (currentResourceList.contains(resource)) continue;
            devicesIDList.add(((Resource)resource).getDeviceID());
        }
        if (devicesIDList.size() == 0) {
            this.setImportButtonColor(this.getBackground());
            return;
        }
        if (this.m_isOfflineTask || null != this.m_oFirstStepPanel && this.m_oFirstStepPanel.isSelectOffline()) {
            int iSize = selectedResources.size();
            THashSet oResourceslst = new THashSet();
            AsnDCSWDLStatusNotify asnDCSWDLStatusNotify = new AsnDCSWDLStatusNotify();
            asnDCSWDLStatusNotify.oSWDLStatus.value = 0;
            for (int i = 0; i < iSize; ++i) {
                Resource oResource = (Resource)selectedResources.get(i);
                oResource.getProgressInfo().setSWDLStatus(TaskCommUtil.getSWDLStatusRes(asnDCSWDLStatusNotify.oSWDLStatus.value));
                oResourceslst.add((Object)oResource);
            }
            this.m_oDeviceTablePanel.updateResourcesInTableModel((THashSet<Resource>)oResourceslst, true);
            this.importButton.setBackground(this.m_oDeviceTablePanel.getBackground());
            return;
        }
        Object object = DCFrameWorkUtil.getTaskTablePanel().getSynObject();
        synchronized (object) {
            if (this.m_iTaskTypeId == 5 || this.m_iTaskTypeId == 4 || this.m_iTaskTypeId == 13) {
                this.updateSWDLStatus(devicesIDList);
            } else if (this.m_iTaskTypeId == 0 || this.m_iTaskTypeId == 1) {
                this.queryMainBoardNumInfo(devicesIDList);
            } else {
                DCDebugTracer.trace("do not need handle it, m_iTaskTypeId " + this.m_iTaskTypeId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSWDLStatus(List<Integer> devicesIDList) {
        if (this.m_isOfflineTask || null != this.m_oFirstStepPanel && this.m_oFirstStepPanel.isSelectOffline()) {
            int iSize = devicesIDList.size();
            AsnDCSWDLStatusNotify asnDCSWDLStatusNotify = new AsnDCSWDLStatusNotify();
            asnDCSWDLStatusNotify.oSWDLStatus.value = 0;
            for (int i = 0; i < iSize; ++i) {
                int iDevId = devicesIDList.get(i);
                asnDCSWDLStatusNotify.iDevID = BigInteger.valueOf(iDevId);
                this.setResourceSWDLStatus(asnDCSWDLStatusNotify);
            }
            return;
        }
        Object object = DCFrameWorkUtil.getTaskTablePanel().getSynObject();
        synchronized (object) {
            String[] columnNames = new String[]{ResourceManager.getInstance().getResString("DEVICE_NAME"), ResourceManager.getInstance().getResString("TBL_COLUMN_NAME_STATUS")};
            final CommonProgressDlg commonFileCheckResultDlg = new CommonProgressDlg(43981, devicesIDList, columnNames);
            int iReqId = DCFrameWorkUtil.generateRequestId();
            commonFileCheckResultDlg.setProgressDlgId(iReqId);
            commonFileCheckResultDlg.setTitle(ResourceManager.getInstance().getResString("QUERY_SWDL_DLG_PROGRESS_TITLE"));
            DCFrameWorkUtil.getTaskTablePanel().setResultDlg(commonFileCheckResultDlg);
            DCFrameWorkUtil.getTaskTablePanel().setDeviceSelectionPanel(this);
            try {
                TaskAsynCommController.getInstance().refreshSWDLStatus(iReqId, -1, devicesIDList);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        commonFileCheckResultDlg.setVisible(true);
                    }
                });
            }
            catch (DCException e) {
                DCDebugTracer.trace(e);
                commonFileCheckResultDlg.dispose();
                DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), e.getErrorCode());
                return;
            }
        }
    }

    private void queryMainBoardNumInfo(List<Integer> devicesIDList) {
        AsnDCMainBoardNumReq oReq = new AsnDCMainBoardNumReq();
        try {
            int iReqId = DCFrameWorkUtil.generateRequestId();
            DCDebugTracer.trace("queryMainBoardNumInfo(the request id is " + iReqId + ")");
            oReq.oReqID = BigInteger.valueOf(iReqId);
            IDeviceInfoManager oDevInfoMgr = DeviceInfoManagerImpl.getInstance();
            boolean isQueryMainBoardNum = false;
            AsnDCMainBoardNumEnum oNotSupport = new AsnDCMainBoardNumEnum(0);
            AsnDCMainBoardNumEnum oUnknown = new AsnDCMainBoardNumEnum(1);
            ArrayList<Integer> oTmpDevIdLst = new ArrayList<Integer>();
            this.deviceCount = devicesIDList.size();
            for (int iDevId : devicesIDList) {
                DeviceInfo oDevInfo = oDevInfoMgr.getDevice(iDevId);
                int iDevTypeId = 0;
                if (null != oDevInfo) {
                    iDevTypeId = oDevInfo.getDeviceTypeInfo().getDevTypeID();
                }
                if (DCCommonUtil.isCheckMainAndStandbyBoard(iDevTypeId)) {
                    if (this.m_isOfflineTask) {
                        this.setMainBoardNumInfo(iDevId, oUnknown);
                        continue;
                    }
                    isQueryMainBoardNum = true;
                    oReq.iDeviceIdLst.add((Object)BigInteger.valueOf(iDevId));
                    continue;
                }
                oTmpDevIdLst.add(iDevId);
                this.setMainBoardNumInfo(iDevId, oNotSupport);
            }
            if (!isQueryMainBoardNum) {
                return;
            }
            DCDebugTracer.trace("queryMainBoardNumInfo(the devices are : " + oReq.iDeviceIdLst.toString() + ")");
            String[] columnNames = new String[]{ResourceManager.getInstance().getResString("DEVICE_NAME"), ResourceManager.getInstance().getResString("OPERATION_RESULT")};
            final CommonProgressDlg commonFileCheckResultDlg = new CommonProgressDlg(44084, devicesIDList, columnNames);
            commonFileCheckResultDlg.setProgressDlgId(iReqId);
            commonFileCheckResultDlg.setTitle(ResourceManager.getInstance().getResString("QUERY_MAIN_BOARD_NUM_TITLE"));
            String strOprResult = ResourceManager.getInstance().getResString("NOT_NEED_TO_QUERY_MAIN_BOARD_NUM");
            Iterator i$ = oTmpDevIdLst.iterator();
            while (i$.hasNext()) {
                int iDevId = (Integer)i$.next();
                this.refreshProgressDlg(iDevId, strOprResult, commonFileCheckResultDlg);
            }
            DCFrameWorkUtil.getTaskTablePanel().setResultDlg(commonFileCheckResultDlg);
            DCFrameWorkUtil.getTaskTablePanel().setDeviceSelectionPanel(this);
            TaskAsynCommControllerProxy.queryMainBoardNum(oReq);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    commonFileCheckResultDlg.setVisible(true);
                }
            });
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
            DCOptionPane.showMessageDialog((Component)this, e.getMessage(), ResourceManager.getInstance().getResString("ERROR"), 0);
        }
        if (this.getDeviceTree() == null) {
            DCDebugTracer.trace("queryMainBoardNumInfo getdevicetree is null");
        }
    }

    public void setImportButtonColor(Color color) {
        if (this.importButton != null) {
            this.importButton.setBackground(color);
        }
    }

    private void refreshProgressDlg(int devID, String sOperationName, CommonProgressDlg oDlg) {
        DeviceInfo devInfo = DeviceInfoManagerImpl.getInstance().getDevice(devID);
        if (null == devInfo) {
            oDlg.setProgress(devID, String.valueOf(devID), ResourceManager.getInstance().getResString("DEVICE_INFORMATION_EMPTY"));
            DCDebugTracer.trace("devInfo :null!");
            return;
        }
        int iDevID = devInfo.getDevId();
        String devName = devInfo.getDevName();
        String devIP = devInfo.getDevIPAddress();
        String sDisplayName = devName + "(" + devIP + ")";
        oDlg.setProgress(iDevID, sDisplayName, sOperationName);
    }

    public Color getImportButtonColor() {
        if (null == this.importButton) {
            return null;
        }
        return this.importButton.getBackground();
    }

    public void setResourceSWDLStatus(AsnDCSWDLStatusNotify asnDCSWDLStatusNotify) {
        List selectedResources = this.m_oDeviceTreePanel.getSelectedResources();
        THashSet oResources = new THashSet();
        for (int i = 0; i < selectedResources.size(); ++i) {
            Resource res = (Resource)selectedResources.get(i);
            if (res.getDeviceID() != asnDCSWDLStatusNotify.iDevID.intValue()) continue;
            res.getProgressInfo().setSWDLStatus(TaskCommUtil.getSWDLStatusRes(asnDCSWDLStatusNotify.oSWDLStatus.value));
            res.getProgressInfo().setIntSWDLStatus(asnDCSWDLStatusNotify.oSWDLStatus.value);
            oResources.add((Object)res);
            break;
        }
        this.m_oDeviceTablePanel.updateResourcesInTableModel((THashSet<Resource>)oResources, true);
        this.importButton.setBackground(this.m_oDeviceTablePanel.getBackground());
    }

    private int getSelectDevTypeId() {
        int iDevTypeId = -1;
        if (null != this.m_oCurrentSelectedDevTypeInfo) {
            DeviceTypeInfo devType = this.m_oDeviceDropDownPanel.getSelectedDeviceType();
            iDevTypeId = !devType.equals(this.m_oCurrentSelectedDevTypeInfo) ? devType.getDevTypeID() : this.m_oCurrentSelectedDevTypeInfo.getDevTypeID();
        }
        return iDevTypeId;
    }

    public void refreshDevTree() {
        this.m_oDeviceTreePanel.getDeviceTree().updateUI();
    }
}

