/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.comparefiles;

import com.huawei.dc.common.util.DCDebugTracer;
import java.io.File;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class StringHelper {
    private static final String RegxFree = "\\(((\\d,*)+)+ *kb *free.*\\)";
    private static final String RegxFree_MA5200 = "(((\\d,*)+)+ *kb *remain *)";
    private static final String RegxFreeSize = "(\\d,*)+";

    private StringHelper() {
    }

    public static String getNewFileName(String filePath, String fileName) {
        if (null == filePath) {
            return fileName;
        }
        if (filePath.endsWith("/") || filePath.endsWith("\\")) {
            return filePath + fileName;
        }
        return filePath + "/" + fileName;
    }

    public static String getFileName(String str) {
        if (null == str || str.trim().equals("")) {
            return str;
        }
        int begin = (str = str.replaceAll("\\\\", "/")).lastIndexOf("/");
        if (0 > begin) {
            return str.toLowerCase();
        }
        return str.substring(begin + 1, str.length()).toLowerCase();
    }

    public static String getOriginalFileName(String str) {
        if (null == str || str.trim().equals("")) {
            return str;
        }
        int begin = (str = str.replaceAll("\\\\", "/")).lastIndexOf("/");
        if (0 > begin) {
            return str;
        }
        return str.substring(begin + 1, str.length());
    }

    public static String getMatchingLinesStr(String data, String regx) {
        String result = "";
        if (null == data || null == regx) {
            return result;
        }
        try {
            Pattern p = Pattern.compile(regx, 1);
            Matcher m = p.matcher(data);
            while (m.find()) {
                if (null == m.group()) continue;
                result = m.group();
            }
        }
        catch (PatternSyntaxException e) {
            DCDebugTracer.trace(e);
        }
        return result;
    }

    public static String getMatchingNocaseStr(String data, String regx) {
        String result = "";
        if (null == data || null == regx) {
            return result;
        }
        try {
            Pattern p = Pattern.compile(regx, 2);
            Matcher m = p.matcher(data);
            while (m.find()) {
                if (null == m.group()) continue;
                result = m.group();
            }
        }
        catch (PatternSyntaxException e) {
            DCDebugTracer.trace(e);
        }
        return result;
    }

    public static String getMatchingNocaseStr(String data, String regx, int index) {
        String result = "";
        if (null == data || null == regx) {
            return result;
        }
        try {
            Pattern p = Pattern.compile(regx, 2);
            Matcher m = p.matcher(data);
            while (m.find()) {
                if (null == m.group()) continue;
                result = m.group(index);
            }
        }
        catch (PatternSyntaxException e) {
            DCDebugTracer.trace(e);
        }
        return result;
    }

    public static String getMatchingTotalStr(String data, String regx) {
        String result = "";
        if (null == data || null == regx) {
            return result;
        }
        try {
            Pattern p = Pattern.compile(regx, 32);
            Matcher m = p.matcher(data);
            while (m.find()) {
                if (null == m.group()) continue;
                result = m.group();
            }
        }
        catch (PatternSyntaxException e) {
            DCDebugTracer.trace(e);
        }
        return result;
    }

    public static String getTray(String file) {
        if (null == file || 0 > file.indexOf(":")) {
            return file;
        }
        return file.substring(0, file.indexOf(":")).toLowerCase().trim();
    }

    public static String clipString(String data) {
        if (null == data) {
            return data;
        }
        int last = data.lastIndexOf("\n");
        if (0 > last) {
            return data;
        }
        while (0 < last) {
            last = (data = data.substring(0, last)).endsWith(">") || data.endsWith("]") ? data.lastIndexOf("\n") : -1;
        }
        return data;
    }

    public static String removeStartStrLines(String data, String start) {
        if (null == data || null == start) {
            return data;
        }
        try {
            Pattern p;
            Matcher m;
            while ((m = (p = Pattern.compile(start, 1)).matcher(data)).find()) {
                int appearStartIndex = m.start();
                int appearEndIndex = m.end();
                StringBuffer sb = new StringBuffer(data);
                data = String.valueOf(sb.delete(appearStartIndex, appearEndIndex + 1));
            }
        }
        catch (PatternSyntaxException e) {
            DCDebugTracer.trace(e);
        }
        return data;
    }

    public static String removeLine(String data, int line) {
        if (1 > line || null == data) {
            return data;
        }
        try {
            Pattern p = Pattern.compile("\n", 1);
            Matcher m = p.matcher(data);
            int post = 0;
            int pre = 0;
            int count = 0;
            while (m.find()) {
                pre = post;
                post = m.start();
                if (++count != line) continue;
            }
            if (line <= count) {
                StringBuffer sb = new StringBuffer(data);
                data = String.valueOf(sb.delete(pre, post));
            }
            if (!data.endsWith("\n") && line == count + 1) {
                data = data.substring(0, post);
            }
        }
        catch (PatternSyntaxException e) {
            DCDebugTracer.trace(e);
        }
        return data;
    }

    public static String[] splitRegulation(String reg) {
        if (null == reg) {
            return null;
        }
        String[] tempReg = reg.split("\\|");
        int leftParenthesisCounts = 0;
        int rightParenthesisCounts = 0;
        int leftMiddleParenthesesCounts = 0;
        int rightMiddleParenthesesCounts = 0;
        int leftBigParenthesesCounts = 0;
        int rightBigParenthesesCounts = 0;
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < tempReg.length; ++i) {
            while (true) {
                sb.append(tempReg[i]);
                if ((leftParenthesisCounts += StringHelper.count(tempReg[i], "\\(")) == (rightParenthesisCounts += StringHelper.count(tempReg[i], "\\)")) && (leftMiddleParenthesesCounts += StringHelper.count(tempReg[i], "\\[")) == (rightMiddleParenthesesCounts += StringHelper.count(tempReg[i], "\\]")) && (leftBigParenthesesCounts += StringHelper.count(tempReg[i], "\\{")) == (rightBigParenthesesCounts += StringHelper.count(tempReg[i], "\\}"))) break;
                ++i;
                sb.append("|");
            }
            leftParenthesisCounts = 0;
            rightParenthesisCounts = 0;
            leftMiddleParenthesesCounts = 0;
            rightMiddleParenthesesCounts = 0;
            leftBigParenthesesCounts = 0;
            rightBigParenthesesCounts = 0;
            if (i >= tempReg.length) continue;
            sb.append("@@@@");
        }
        return sb.toString().split("@@@@");
    }

    public static int count(String data, String reg) {
        int count = 0;
        try {
            Pattern pattern = Pattern.compile(reg, 32);
            Matcher matcher = pattern.matcher(data);
            while (matcher.find()) {
                ++count;
            }
        }
        catch (PatternSyntaxException e) {
            DCDebugTracer.trace(e);
        }
        return count;
    }

    public static String getLine(String data, int line) {
        if (1 > line || null == data) {
            return null;
        }
        try {
            Pattern p = Pattern.compile("\n", 1);
            Matcher m = p.matcher(data);
            int post = 0;
            int pre = 0;
            int count = 0;
            while (m.find()) {
                pre = post;
                post = m.start();
                if (++count != line) continue;
            }
            if (line <= count) {
                data = data.substring(pre + 1, post);
            }
            if (!data.endsWith("\n") && line == count + 1) {
                data = data.substring(post + 1);
            }
        }
        catch (PatternSyntaxException e) {
            DCDebugTracer.trace(e);
        }
        return data;
    }

    public static int[] getSplitCoordinate(String data, int column) {
        if (null == data || 1 > column) {
            return null;
        }
        int[] array = new int[column];
        String[] rowData = data.split("\n");
        int maxColunm = 0;
        int splitSign = 0;
        int tempMaxEndColumn = 0;
        int tempMinNextCoumn = 0;
        for (int m = 0; m < column - 1; ++m) {
            int i;
            if (0 == m) {
                for (i = 0; i < rowData.length; ++i) {
                    int temp = StringHelper.appearIndex(rowData[i], "\\S", splitSign);
                    splitSign = splitSign > temp ? splitSign : temp;
                }
            }
            for (i = 0; i < rowData.length; ++i) {
                tempMaxEndColumn = StringHelper.appearIndex(rowData[i], "\\S\\s", splitSign);
                tempMinNextCoumn = StringHelper.appearIndex(rowData[i], "\\s\\S", splitSign);
                if (i == 0) {
                    splitSign = tempMinNextCoumn;
                    maxColunm = tempMaxEndColumn;
                }
                maxColunm = tempMaxEndColumn > maxColunm ? tempMaxEndColumn : maxColunm;
                splitSign = maxColunm < tempMinNextCoumn && splitSign > tempMinNextCoumn ? tempMinNextCoumn : splitSign;
            }
            array[m + 1] = array[m] + splitSign + 1;
        }
        return array;
    }

    public static void parseMatrix(String data, int column) {
        if (null == data || 1 > column) {
            return;
        }
        String[] rowData = data.split("\n");
        int[] coordinate = StringHelper.getSplitCoordinate(data, column);
        for (int i = 0; i < rowData.length; ++i) {
            for (int m = 0; m < coordinate.length - 1; ++m) {
                DCDebugTracer.trace("@@" + rowData[i].substring(coordinate[m], coordinate[m + 1]) + "@@");
            }
            DCDebugTracer.trace(rowData[i].substring(coordinate[coordinate.length - 1]) + "@@");
        }
    }

    public static int appearIndex(String data, String reg, int beginIndex) {
        int appearStartIndex = -1;
        if (null == data || null == reg || 0 > beginIndex) {
            return appearStartIndex;
        }
        try {
            Pattern p = Pattern.compile(reg, 32);
            Matcher m = p.matcher(data);
            m.find(beginIndex);
            appearStartIndex = m.start();
        }
        catch (PatternSyntaxException e) {
            DCDebugTracer.trace(e);
        }
        catch (IndexOutOfBoundsException ie) {
            DCDebugTracer.trace(ie);
        }
        catch (IllegalStateException ise) {
            DCDebugTracer.trace(ise);
        }
        return appearStartIndex;
    }

    public static boolean haveRegStr(String data, String reg) {
        if (data == null || data.equals("")) {
            return false;
        }
        if (reg == null || reg.equals("")) {
            return false;
        }
        boolean bRtv = false;
        try {
            Pattern p = Pattern.compile(reg, 2);
            Matcher m = p.matcher(data);
            if (m.find()) {
                bRtv = true;
            }
        }
        catch (PatternSyntaxException e) {
            DCDebugTracer.trace(e);
        }
        return bRtv;
    }

    public static String replace(String data, Object[] obj) {
        if (null == data || null == obj || obj.length == 0) {
            return data;
        }
        return MessageFormat.format(data, obj);
    }

    public static String replace(String data, Object obj) {
        if (null == data || null == obj) {
            return data;
        }
        return MessageFormat.format(data, obj);
    }

    public static String getFilePath(String path) {
        if (null == path) {
            return "";
        }
        int tempInt = path.replaceAll("\\\\", "/").lastIndexOf("/");
        if (tempInt > -1) {
            path = path.substring(0, tempInt + 1);
        }
        return path;
    }

    public static String removeMatchReg(String data, String regx) {
        if (null == data || null == regx) {
            return data;
        }
        StringBuffer sb = new StringBuffer(data);
        try {
            Pattern p = Pattern.compile(regx, 2);
            Matcher m = p.matcher(data);
            while (m.find()) {
                if (null == m.group()) continue;
                int start = m.start();
                int end = m.end();
                sb = sb.delete(start, end + 1);
            }
        }
        catch (PatternSyntaxException e) {
            DCDebugTracer.trace(e);
        }
        return sb.toString();
    }

    public static HashSet<String> getMatchSet(String data, String regx) {
        HashSet<String> set = new HashSet<String>();
        if (null == data || null == regx) {
            return set;
        }
        try {
            Pattern p = Pattern.compile(regx, 1);
            Matcher m = p.matcher(data);
            while (m.find()) {
                if (null == m.group()) continue;
                set.add(m.group());
            }
        }
        catch (PatternSyntaxException e) {
            DCDebugTracer.trace(e);
        }
        return set;
    }

    public static boolean isContained(String small, String big) {
        if (0 == small.compareToIgnoreCase(big)) {
            return true;
        }
        return (big + ";").contains(small + ";");
    }

    public static String convertNullStr(String str) {
        if (str == null) {
            return "";
        }
        return str.trim();
    }

    public static boolean isEmpty(String str) {
        return str == null || str.trim().equals("");
    }

    public static boolean isDirName(String path) {
        if (null == path) {
            return false;
        }
        return path.trim().replaceAll("\\\\", "/").endsWith("/");
    }

    public static boolean hasDirPartition(String path) {
        if (null == path) {
            return false;
        }
        return path.lastIndexOf("\\") > -1 || path.lastIndexOf("/") > -1;
    }

    public static long getFreeWorkPlaceSize(String data) {
        long freeSize = -1L;
        if (null == data || data.endsWith("")) {
            return freeSize;
        }
        String regmatche = StringHelper.getMatchingNocaseStr(data, RegxFree);
        String remain = StringHelper.getMatchingNocaseStr(regmatche, RegxFree_MA5200);
        if (remain != null && !remain.trim().equals("")) {
            regmatche = remain;
        } else {
            String freeSpace = StringHelper.getMatchingNocaseStr(regmatche, "((\\d,*)+)+ *kb *free");
            if (null != freeSpace && !"".equals(freeSpace.trim())) {
                regmatche = freeSpace;
            }
        }
        String dirFreeSize = StringHelper.getMatchingNocaseStr(regmatche, RegxFreeSize);
        if (!dirFreeSize.equals("")) {
            try {
                freeSize = Long.parseLong(dirFreeSize.replaceAll(",", ""));
            }
            catch (NumberFormatException nfe) {
                return freeSize * 1024L;
            }
        }
        return freeSize * 1024L;
    }

    public static long getLocalFileSize(String localFilename) {
        long size = -1L;
        if (null == localFilename) {
            return size;
        }
        File file = new File(localFilename);
        if (file.exists()) {
            size = file.length();
        }
        return size;
    }

    public static String replaceSpecalChar(String data) {
        if (null == data) {
            data = "";
        } else {
            data = data.replace("(", "\\(");
            data = data.replace(")", "\\)");
            data = data.replace("{", "\\{");
            data = data.replace("}", "\\}");
            data = data.replace("[", "\\[");
            data = data.replace("]", "\\]");
            data = data.replace("+", "\\+");
            data = data.replace(".", "\\.");
        }
        return data;
    }

    public static boolean haveMatchingNocaseStr(String data, String regx) {
        boolean match = false;
        if (null == data || null == regx) {
            return match;
        }
        try {
            Pattern p = Pattern.compile(regx, 2);
            Matcher m = p.matcher(data);
            match = m.find();
        }
        catch (PatternSyntaxException e) {
            DCDebugTracer.trace(e);
        }
        return match;
    }
}

