/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.comparefiles;

import com.huawei.dc.common.util.DCDebugTracer;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class CompareRouting {
    private static final int lenght = 21;
    private static final String regx = "(\\d{1,3}(\\.)\\d{1,3}(\\.)\\d{1,3}(\\.)\\d{1,3})/\\d{1,2}";
    private static final String ipRegx = "\\d{1,3}(\\.)\\d{1,3}(\\.)\\d{1,3}(\\.)\\d{1,3}";

    public static void execute(String leftFile, String rightFile, Vector<String> leftVec, Vector<String> rightVec) {
        if (null == leftFile || null == rightFile || null == leftVec || null == rightVec) {
            return;
        }
        CompareRouting.readFile(leftFile, leftVec);
        CompareRouting.readFile(rightFile, rightVec);
        if (leftVec.size() != 0 && rightVec.size() != 0) {
            CompareRouting.compare(leftVec, rightVec);
        }
    }

    private static void compare(Vector<String> leftVec, Vector<String> rightVec) {
        Vector retainSet = (Vector)leftVec.clone();
        retainSet.retainAll(rightVec);
        leftVec.removeAll(retainSet);
        rightVec.removeAll(retainSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readFile(String strFile, Vector<String> contentVec) {
        String line = null;
        BufferedReader oReader = null;
        try {
            oReader = new BufferedReader(new FileReader(strFile));
            line = oReader.readLine();
            while (line != null) {
                String data = CompareRouting.getMatchStr(line);
                if (!data.equals("")) {
                    contentVec.add(data);
                }
                line = oReader.readLine();
            }
        }
        catch (IOException e) {
            DCDebugTracer.trace(e);
        }
        finally {
            if (null != oReader) {
                try {
                    oReader.close();
                }
                catch (IOException e) {
                    DCDebugTracer.trace(e);
                }
            }
        }
    }

    private static String getMatchStr(String data) {
        StringBuffer result = new StringBuffer();
        if (null == data) {
            return result.toString();
        }
        int index = 0;
        try {
            Pattern p = Pattern.compile(regx, 2);
            Matcher m = p.matcher(data);
            while (m.find()) {
                if (null == m.group()) continue;
                index = m.end();
                result.append(m.group());
            }
            Pattern ipPattern = Pattern.compile(ipRegx, 2);
            Matcher ipMatcher = ipPattern.matcher(data);
            while (ipMatcher.find(index)) {
                if (null == ipMatcher.group()) continue;
                index = ipMatcher.end();
                result.append(CompareRouting.getSpace(result.toString()));
                result.append(ipMatcher.group());
            }
        }
        catch (PatternSyntaxException e) {
            DCDebugTracer.trace(e);
        }
        return result.toString().trim();
    }

    private static String getSpace(String data) {
        StringBuffer sb = new StringBuffer(20);
        for (int tempLenght = 21 - data.length(); tempLenght > 0; --tempLenght) {
            sb.append(" ");
        }
        return sb.toString();
    }
}

