/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.comparefiles;

import com.huawei.dc.common.comparefiles.CompareRouting;
import com.huawei.dc.common.comparefiles.StringHelper;
import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.components.dialog.ReportSaveFileFilter;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.framework.utility.print.PrintSupportor;
import com.huawei.dc.common.util.DCFileChooser;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.framework.ObjectStore;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class CompareRautingFileDialog
extends DCModalDialog {
    private static final long serialVersionUID = -4495922560065227108L;
    static String leftFilePath = "";
    static String rightFilePath = "";
    private JScrollPane scpnl_left;
    private JScrollPane scpnl_right;
    private JTextArea leftTextArea = null;
    private JTextArea rightTextArea = null;
    private JTextField leftFileText = null;
    private String m_leftFilePath = null;
    private JTextField rightFileText = null;
    private String m_rightFilePath = null;
    private JButton leftbutton = null;
    private JButton rightbutton = null;
    private JButton comparebutton = null;
    private JButton closeBtn = null;
    private ResourceManager resource = ResourceManager.getInstance();
    private Thread thread = null;

    public CompareRautingFileDialog(JFrame mainFrame) {
        super(mainFrame);
        this.setSize(600, 500);
        this.setResizable(true);
        this.init();
        this.setLocationRelativeTo(mainFrame);
    }

    private void init() {
        Border oBorder = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        JPanel oMainPanel = new JPanel();
        oMainPanel.setLayout(new BorderLayout(5, 5));
        oMainPanel.setBorder(oBorder);
        this.setContentPane(oMainPanel);
        GridBagConstraints gridBagConst = new GridBagConstraints();
        gridBagConst.insets = new Insets(5, 5, 0, 0);
        JPanel oLeftTextPanel = new JPanel();
        oLeftTextPanel.setLayout(new BorderLayout(5, 0));
        this.leftFileText = new JTextField();
        this.leftFileText.setName("com.huawei.dc.common.comparefiles.CompareRautingFileDialog.leftFileText");
        this.leftFileText.setEditable(false);
        this.leftFileText.setPreferredSize(new Dimension(100, 21));
        oLeftTextPanel.add((Component)this.leftFileText, "Center");
        this.leftbutton = new JButton();
        this.leftbutton.setName("com.huawei.dc.common.comparefiles.CompareRautingFileDialog.leftbutton");
        this.leftbutton.setText(this.resource.getResString("CHOOSEFILE"));
        this.setBtnSize(this.leftbutton);
        oLeftTextPanel.add((Component)this.leftbutton, "East");
        JPanel oRightTextPanel = new JPanel();
        oRightTextPanel.setLayout(new BorderLayout());
        this.rightFileText = new JTextField();
        this.rightFileText.setName("com.huawei.dc.common.comparefiles.CompareRautingFileDialog.rightFileText");
        this.rightFileText.setEditable(false);
        oRightTextPanel.add((Component)this.rightFileText, "Center");
        JPanel oRightBtnPanel = new JPanel();
        oRightBtnPanel.setLayout(new FlowLayout(2, 0, 0));
        oRightBtnPanel.add(Box.createHorizontalStrut(5));
        this.rightbutton = new JButton();
        this.rightbutton.setName("com.huawei.dc.common.comparefiles.CompareRautingFileDialog.rightbutton");
        this.rightbutton.setText(this.resource.getResString("CHOOSEFILE"));
        this.setBtnSize(this.rightbutton);
        oRightBtnPanel.add(this.rightbutton);
        oRightBtnPanel.add(Box.createHorizontalStrut(5));
        this.comparebutton = new JButton();
        this.comparebutton.setName("com.huawei.dc.common.comparefiles.CompareRautingFileDialog.comparebutton");
        this.comparebutton.setText(this.resource.getResString("COMPARE"));
        this.setBtnSize(this.comparebutton);
        oRightBtnPanel.add(this.comparebutton);
        oRightTextPanel.add((Component)oRightBtnPanel, "East");
        JPanel oTextPanel = new JPanel();
        oTextPanel.setLayout(new GridLayout(1, 2, 5, 5));
        oTextPanel.add(oLeftTextPanel);
        oTextPanel.add(oRightTextPanel);
        oMainPanel.add((Component)oTextPanel, "North");
        JPanel oContentPanel = new JPanel();
        oContentPanel.setLayout(new GridLayout(1, 2, 5, 5));
        this.leftTextArea = new JTextArea();
        this.leftTextArea.setName("com.huawei.dc.common.comparefiles.CompareRautingFileDialog.leftTextArea");
        this.leftTextArea.setEditable(false);
        this.scpnl_left = new JScrollPane(this.leftTextArea);
        oContentPanel.add(this.scpnl_left);
        this.rightTextArea = new JTextArea();
        this.rightTextArea.setName("com.huawei.dc.common.comparefiles.CompareRautingFileDialog.rightTextArea");
        this.rightTextArea.setEditable(false);
        this.scpnl_right = new JScrollPane(this.rightTextArea);
        oContentPanel.add(this.scpnl_right);
        oMainPanel.add((Component)oContentPanel, "Center");
        this.closeBtn = new JButton();
        this.closeBtn.setName("com.huawei.dc.common.comparefiles.CompareConfigFileDialog.closeBtn");
        this.closeBtn.setText(this.resource.getResString("SYSTEM_INFO_CANCEL_BTN"));
        this.setBtnSize(this.closeBtn);
        JPanel oBtnPanel = new JPanel();
        oBtnPanel.setLayout(new FlowLayout(2, 0, 0));
        oBtnPanel.add(this.closeBtn);
        oMainPanel.add((Component)oBtnPanel, "South");
        this.setCompareButtonEnable();
        this.addListener();
        DCHelpManager.getInstance().enableF1HelpKey(this.getContentPane(), this.getCurrentContext());
    }

    private void setBtnSize(JButton oBtn) {
        Dimension oPreferredBtnSize = new Dimension(80, 21);
        oBtn.setMinimumSize(oPreferredBtnSize);
        oBtn.setPreferredSize(oPreferredBtnSize);
        oBtn.setMaximumSize(oPreferredBtnSize);
    }

    private void addListener() {
        this.rightbutton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int returnValue;
                File dirSave;
                DCFileChooser oFileRightChooserDialog = CompareRautingFileDialog.this.getFileChooserDlg();
                String strDefPath = (String)ObjectStore.getInstance().getObjectInstance("COMPARE_RAUTING_FILE_DIALOG_LEFT");
                if (null != strDefPath && (dirSave = new File(strDefPath)).exists()) {
                    oFileRightChooserDialog.setSelectedFile(dirSave);
                }
                if (0 != (returnValue = oFileRightChooserDialog.showDialog((Component)((Object)CompareRautingFileDialog.this), ResourceManager.getInstance().getResString("OK")))) {
                    CompareRautingFileDialog.this.setCompareButtonEnable();
                    return;
                }
                CompareRautingFileDialog.this.rightFileText.setText(oFileRightChooserDialog.getSelectedFile().getAbsolutePath());
                CompareRautingFileDialog.this.rightFileText.setToolTipText(oFileRightChooserDialog.getSelectedFile().getAbsolutePath());
                CompareRautingFileDialog.this.m_rightFilePath = oFileRightChooserDialog.getSelectedFile().getAbsolutePath();
                ObjectStore.getInstance().putObjectInstance("COMPARE_RAUTING_FILE_DIALOG_LEFT", CompareRautingFileDialog.this.rightFileText.getText());
                CompareRautingFileDialog.this.setCompareButtonEnable();
            }
        });
        this.leftbutton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int returnValue;
                File dirSave;
                DCFileChooser oFileLightChooserDialog = CompareRautingFileDialog.this.getFileChooserDlg();
                String strDefPath = (String)ObjectStore.getInstance().getObjectInstance("COMPARE_RAUTING_FILE_DIALOG");
                if (null != strDefPath && (dirSave = new File(strDefPath)).exists()) {
                    oFileLightChooserDialog.setSelectedFile(dirSave);
                }
                if (0 != (returnValue = oFileLightChooserDialog.showDialog((Component)((Object)CompareRautingFileDialog.this), ResourceManager.getInstance().getResString("OK")))) {
                    CompareRautingFileDialog.this.setCompareButtonEnable();
                    return;
                }
                CompareRautingFileDialog.this.leftFileText.setText(oFileLightChooserDialog.getSelectedFile().getAbsolutePath());
                CompareRautingFileDialog.this.leftFileText.setToolTipText(oFileLightChooserDialog.getSelectedFile().getAbsolutePath());
                CompareRautingFileDialog.this.m_leftFilePath = oFileLightChooserDialog.getSelectedFile().getAbsolutePath();
                ObjectStore.getInstance().putObjectInstance("COMPARE_RAUTING_FILE_DIALOG", CompareRautingFileDialog.this.leftFileText.getText());
                CompareRautingFileDialog.this.setCompareButtonEnable();
            }
        });
        this.comparebutton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (null != CompareRautingFileDialog.this.m_leftFilePath || "".equals(CompareRautingFileDialog.this.m_leftFilePath)) {
                    int iErrCode = CompareRautingFileDialog.this.promptForDeleteFile(CompareRautingFileDialog.this.m_leftFilePath);
                    if (0 == iErrCode) {
                        iErrCode = CompareRautingFileDialog.this.promptForDeleteFile(CompareRautingFileDialog.this.m_rightFilePath);
                    }
                    if (0 == iErrCode) {
                        CompareRautingFileDialog.this.startThread(CompareRautingFileDialog.this.m_leftFilePath, CompareRautingFileDialog.this.m_rightFilePath);
                    }
                    CompareRautingFileDialog.this.setCompareButtonEnable();
                }
            }
        });
        this.closeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CompareRautingFileDialog.this.dispose();
            }
        });
    }

    private int promptForDeleteFile(String strFilePath) {
        File oFile = new File(strFilePath);
        if (!oFile.exists()) {
            String strErrMsg = this.resource.getResString("SELECT_FILE_ALREADY_BE_DELETED");
            strErrMsg = MessageFormat.format(strErrMsg, strFilePath);
            DCOptionPane.showMessageDialog((Component)((Object)this), strErrMsg, this.resource.getResString("ERROR"), 0);
            return -1;
        }
        return 0;
    }

    private DCFileChooser getFileChooserDlg() {
        PrintSupportor.setIsFileSelection(true);
        DCFileChooser oFileChooserDialog = new DCFileChooser();
        oFileChooserDialog.setTitle(this.resource.getResString("FILECHOOSETITLE"));
        oFileChooserDialog.setApproveButtonText(this.resource.getResString("SAVE_DIALOG_OPEN_BUTTON"));
        oFileChooserDialog.setFileSelectionMode(2);
        oFileChooserDialog.setApproveButtonMnemonic('O');
        oFileChooserDialog.setControlButtonsAreShown(true);
        oFileChooserDialog.setAcceptAllFileFilterUsed(false);
        ReportSaveFileFilter txtOFileFilter = new ReportSaveFileFilter(new String[]{"txt"}, "*.txt");
        ReportSaveFileFilter logOFileFilter = new ReportSaveFileFilter(new String[]{"log"}, "*.log");
        ReportSaveFileFilter cfgOFileFilter = new ReportSaveFileFilter(new String[]{"cfg"}, "*.cfg");
        oFileChooserDialog.setFileFilter(cfgOFileFilter);
        oFileChooserDialog.setFileFilter(logOFileFilter);
        oFileChooserDialog.setFileFilter(txtOFileFilter);
        return oFileChooserDialog;
    }

    private void setCompareButtonEnable() {
        String leftFilename = this.leftFileText.getText();
        String rightFilename = this.rightFileText.getText();
        if (leftFilename != null && !leftFilename.equals("") && rightFilename != null && !rightFilename.equals("")) {
            this.comparebutton.setEnabled(true);
        } else {
            this.comparebutton.setEnabled(false);
        }
    }

    public void startThread(final String leftFilePath, final String rightFilePath) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                int i;
                Vector<String> leftVec = new Vector<String>();
                Vector<String> rightVec = new Vector<String>();
                CompareRouting.execute(leftFilePath, rightFilePath, leftVec, rightVec);
                StringBuffer leftsb = new StringBuffer();
                StringBuffer rightsb = new StringBuffer();
                String totalRouting = CompareRautingFileDialog.this.resource.getResString("totalrouting");
                String routingTitle = CompareRautingFileDialog.this.resource.getResString("routingtitle");
                int leftSize = leftVec.size();
                int rightSize = rightVec.size();
                String str = StringHelper.replace(totalRouting, leftSize) + "\n";
                leftsb.append(str);
                if (leftSize > 0) {
                    String str1 = routingTitle + "\n";
                    leftsb.append(str1);
                }
                String str2 = StringHelper.replace(totalRouting, rightSize) + "\n";
                rightsb.append(str2);
                if (rightSize > 0) {
                    String str3 = routingTitle + "\n";
                    rightsb.append(str3);
                }
                for (i = 0; i < leftSize; ++i) {
                    String str4 = leftVec.get(i) + "\n";
                    leftsb.append(str4);
                }
                for (i = 0; i < rightSize; ++i) {
                    String str5 = rightVec.get(i) + "\n";
                    rightsb.append(str5);
                }
                CompareRautingFileDialog.this.leftTextArea.setText(leftsb.toString());
                CompareRautingFileDialog.this.rightTextArea.setText(rightsb.toString());
                CompareRautingFileDialog.this.scpnl_left.getVerticalScrollBar().setValue(0);
                CompareRautingFileDialog.this.scpnl_right.getVerticalScrollBar().setValue(0);
                CompareRautingFileDialog.this.comparebutton.setEnabled(true);
            }
        };
        this.thread = new Thread(runnable);
        this.thread.start();
    }

    @Override
    protected String getCurrentContext() {
        return "HELP_TOPIC_NE_COMPARE_ROUTE_FILE";
    }
}

