/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.comparefiles;

import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.components.dialog.ReportSaveFileFilter;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.framework.utility.print.PrintSupportor;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCFileChooser;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.compare.CmpListRender;
import com.huawei.dc.compare.common.LCSStrWrapper;
import com.huawei.dc.compare.common.UIConstants;
import com.huawei.dc.compare.datasource.ConfigFileControl;
import com.huawei.dc.framework.ObjectStore;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.metal.MetalScrollBarUI;

public class CompareConfigFileDialog
extends DCModalDialog {
    private static final long serialVersionUID = -780380979587437534L;
    private static final int ZERO = 0;
    private static final int ONE = 1;
    private static final int TWO = 2;
    private static final int THREE = 3;
    private static final int FIVE = 5;
    private static final int NEGATIVE_ONE = -1;
    static String leftFilePath = "";
    static String rightFilePath = "";
    private JButton comparebutton = null;
    private JScrollPane scpnl_left;
    private JScrollPane scpnl_right;
    private boolean hasSetLeftModel;
    private boolean hasSetRightModel;
    private ArrayList diffListDatas;
    private int[] m_iDiffLines;
    private int[] m_iDiffYCoordinates;
    private Rectangle m_trackBounds;
    private int m_iFirstDiffIndex = -1;
    private int m_iLastDiffIndex = -1;
    private JList leftList = new JList();
    private JList rightList = new JList();
    private JTextField leftFileText = null;
    private String m_leftFilePath = null;
    private JTextField rightFileText = null;
    private String m_rightFilePath = null;
    private JTextField leftSelectText = null;
    private JTextField rightSelectText = null;
    private JButton leftbutton = null;
    private JButton rightbutton = null;
    private JButton nextBtn = null;
    private JButton preBtn = null;
    private JButton closeBtn = null;
    private boolean m_isFirst = true;
    private ResourceManager resource = ResourceManager.getInstance();
    private DCFileChooser oFileRightChooserDialog = null;
    private DCFileChooser oFileLeftChooserDialog = null;

    public CompareConfigFileDialog(JFrame mainFrame) {
        super(mainFrame);
        this.setSize(600, 500);
        this.setResizable(true);
        this.init();
        this.setLocationRelativeTo(mainFrame);
    }

    private void init() {
        Border oBorder = BorderFactory.createEmptyBorder(5, 5, 5, 8);
        JPanel oMainPanel = new JPanel();
        oMainPanel.setLayout(new GridBagLayout());
        oMainPanel.setBorder(oBorder);
        this.setContentPane(oMainPanel);
        GridBagConstraints gridBagConst = new GridBagConstraints();
        gridBagConst.insets = new Insets(5, 5, 0, 0);
        gridBagConst.fill = 1;
        gridBagConst.weightx = 0.5;
        gridBagConst.gridx = 0;
        gridBagConst.gridy = 0;
        gridBagConst.gridwidth = 4;
        this.leftFileText = new JTextField();
        this.leftFileText.setName("com.huawei.dc.common.comparefiles.CompareConfigFileDialog.leftFileText");
        this.leftFileText.setEditable(false);
        oMainPanel.add((Component)this.leftFileText, gridBagConst);
        gridBagConst.weightx = 0.0;
        gridBagConst.gridx = 4;
        gridBagConst.gridy = 0;
        gridBagConst.gridwidth = 1;
        gridBagConst.fill = 0;
        this.leftbutton = new JButton();
        this.leftbutton.setName("com.huawei.dc.common.comparefiles.CompareConfigFileDialog.leftbutton");
        this.leftbutton.setText(this.resource.getResString("CHOOSEFILE"));
        this.setBtnSize(this.leftbutton);
        oMainPanel.add((Component)this.leftbutton, gridBagConst);
        gridBagConst.fill = 1;
        gridBagConst.weightx = 0.5;
        gridBagConst.gridx = 5;
        gridBagConst.gridy = 0;
        gridBagConst.gridwidth = 3;
        this.rightFileText = new JTextField();
        this.rightFileText.setName("com.huawei.dc.common.comparefiles.CompareConfigFileDialog.rightFileText");
        this.rightFileText.setEditable(false);
        oMainPanel.add((Component)this.rightFileText, gridBagConst);
        gridBagConst.fill = 0;
        gridBagConst.weightx = 0.0;
        gridBagConst.gridx = 8;
        gridBagConst.gridy = 0;
        gridBagConst.gridwidth = 1;
        this.rightbutton = new JButton();
        this.rightbutton.setName("com.huawei.dc.common.comparefiles.CompareConfigFileDialog.rightbutton");
        this.rightbutton.setText(this.resource.getResString("CHOOSEFILE"));
        this.setBtnSize(this.rightbutton);
        oMainPanel.add((Component)this.rightbutton, gridBagConst);
        gridBagConst.gridx = 9;
        gridBagConst.gridy = 0;
        gridBagConst.gridwidth = 1;
        this.comparebutton = new JButton();
        this.comparebutton.setName("com.huawei.dc.common.comparefiles.CompareConfigFileDialog.comparebutton");
        this.comparebutton.setText(this.resource.getResString("COMPARE"));
        this.setBtnSize(this.comparebutton);
        oMainPanel.add((Component)this.comparebutton, gridBagConst);
        gridBagConst.fill = 0;
        gridBagConst.gridx = 0;
        gridBagConst.gridy = 1;
        gridBagConst.gridwidth = 1;
        ImageIcon downicon = new ImageIcon(((Object)((Object)this)).getClass().getResource("/com/huawei/dc/compare/res/image/down.gif"));
        this.nextBtn = new JButton(downicon);
        this.nextBtn.setName("com.huawei.dc.common.comparefiles.CompareConfigFileDialog.nextBtn");
        this.nextBtn.setToolTipText(this.resource.getResString("button.next.tooltip"));
        this.nextBtn.setMinimumSize(new Dimension(21, 21));
        this.nextBtn.setPreferredSize(new Dimension(21, 21));
        this.nextBtn.setMaximumSize(new Dimension(21, 21));
        oMainPanel.add((Component)this.nextBtn, gridBagConst);
        gridBagConst.gridx = 1;
        gridBagConst.gridy = 1;
        gridBagConst.gridwidth = 1;
        ImageIcon upicon = new ImageIcon(((Object)((Object)this)).getClass().getResource("/com/huawei/dc/compare/res/image/up.gif"));
        this.preBtn = new JButton(upicon);
        this.preBtn.setName("com.huawei.dc.common.comparefiles.CompareConfigFileDialog.preBtn");
        this.preBtn.setToolTipText(this.resource.getResString("button.previous.tooltip"));
        this.preBtn.setMinimumSize(new Dimension(21, 21));
        this.preBtn.setPreferredSize(new Dimension(21, 21));
        this.preBtn.setMaximumSize(new Dimension(21, 21));
        oMainPanel.add((Component)this.preBtn, gridBagConst);
        gridBagConst.fill = 1;
        gridBagConst.gridheight = 5;
        gridBagConst.weighty = 1.0;
        gridBagConst.gridx = 0;
        gridBagConst.gridy = 2;
        gridBagConst.gridwidth = 5;
        this.leftList.setFixedCellHeight(21);
        this.leftList.setCellRenderer(new CmpListRender());
        this.leftList.setSelectionModel(this.rightList.getSelectionModel());
        this.leftList.setSelectionMode(0);
        this.scpnl_left = new JScrollPane(this.leftList);
        oMainPanel.add((Component)this.scpnl_left, gridBagConst);
        gridBagConst.gridx = 5;
        gridBagConst.gridy = 2;
        gridBagConst.gridwidth = 5;
        this.rightList.setFixedCellHeight(21);
        this.rightList.setCellRenderer(new CmpListRender());
        this.rightList.setSelectionMode(0);
        this.scpnl_right = new JScrollPane(this.rightList);
        this.scpnl_right.getVerticalScrollBar().setUI(new VScrollBarUI());
        oMainPanel.add((Component)this.scpnl_right, gridBagConst);
        this.scpnl_left.getVerticalScrollBar().setUI(new VScrollBarUI());
        this.scpnl_left.getVerticalScrollBar().setModel(this.scpnl_right.getVerticalScrollBar().getModel());
        this.scpnl_left.getHorizontalScrollBar().setModel(this.scpnl_right.getHorizontalScrollBar().getModel());
        this.scpnl_left.getVerticalScrollBar().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int index = CompareConfigFileDialog.this.getSelectedIndex(e.getY());
                CompareConfigFileDialog.this.leftList.setSelectedIndex(index);
                CompareConfigFileDialog.this.leftList.ensureIndexIsVisible(index);
            }
        });
        this.scpnl_right.getVerticalScrollBar().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int index = CompareConfigFileDialog.this.getSelectedIndex(e.getY());
                CompareConfigFileDialog.this.leftList.setSelectedIndex(index);
                CompareConfigFileDialog.this.leftList.ensureIndexIsVisible(index);
            }
        });
        JPanel oSelectTextPanel = new JPanel();
        oSelectTextPanel.setLayout(new BorderLayout());
        gridBagConst.weighty = 0.0;
        gridBagConst.gridheight = 1;
        gridBagConst.gridx = 0;
        gridBagConst.gridy = 7;
        gridBagConst.gridwidth = 10;
        this.leftSelectText = new JTextField();
        this.leftSelectText.setName("com.huawei.dc.common.comparefiles.CompareConfigFileDialog.leftSelectText");
        this.leftSelectText.setEditable(false);
        oMainPanel.add((Component)this.leftSelectText, gridBagConst);
        gridBagConst.gridx = 0;
        gridBagConst.gridy = 8;
        gridBagConst.gridwidth = 10;
        this.rightSelectText = new JTextField();
        this.rightSelectText.setName("com.huawei.dc.common.comparefiles.CompareConfigFileDialog.rightSelectText");
        this.rightSelectText.setEditable(false);
        oMainPanel.add((Component)this.rightSelectText, gridBagConst);
        gridBagConst.fill = 0;
        gridBagConst.gridx = 9;
        gridBagConst.gridy = 9;
        gridBagConst.gridwidth = 1;
        this.closeBtn = new JButton();
        this.closeBtn.setName("com.huawei.dc.common.comparefiles.CompareConfigFileDialog.closeBtn");
        this.closeBtn.setText(this.resource.getResString("SYSTEM_INFO_CANCEL_BTN"));
        this.setBtnSize(this.closeBtn);
        oMainPanel.add((Component)this.closeBtn, gridBagConst);
        this.setCompareButtonEnable();
        this.addListener();
        DCHelpManager.getInstance().enableF1HelpKey(this.getContentPane(), this.getCurrentContext());
    }

    private void setBtnSize(JButton oBtn) {
        Dimension oPreferredBtnSize = new Dimension(80, 21);
        oBtn.setMinimumSize(oPreferredBtnSize);
        oBtn.setPreferredSize(oPreferredBtnSize);
        oBtn.setMaximumSize(oPreferredBtnSize);
    }

    private void addListener() {
        this.rightbutton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int returnValue;
                File dirSave;
                CompareConfigFileDialog.this.oFileRightChooserDialog = CompareConfigFileDialog.this.getFileChooserDlg();
                String strDefPath = (String)ObjectStore.getInstance().getObjectInstance("COMPARE_CONFIG_FILE_DIALOG");
                if (null != strDefPath && (dirSave = new File(strDefPath)).exists()) {
                    CompareConfigFileDialog.this.oFileRightChooserDialog.setSelectedFile(dirSave);
                }
                if (0 != (returnValue = CompareConfigFileDialog.this.oFileRightChooserDialog.showDialog((Component)((Object)CompareConfigFileDialog.this), ResourceManager.getInstance().getResString("OK")))) {
                    CompareConfigFileDialog.this.setCompareButtonEnable();
                    return;
                }
                CompareConfigFileDialog.this.rightFileText.setText(CompareConfigFileDialog.this.oFileRightChooserDialog.getSelectedFile().getAbsolutePath());
                CompareConfigFileDialog.this.rightFileText.setToolTipText(CompareConfigFileDialog.this.oFileRightChooserDialog.getSelectedFile().getAbsolutePath());
                CompareConfigFileDialog.this.m_rightFilePath = CompareConfigFileDialog.this.oFileRightChooserDialog.getSelectedFile().getAbsolutePath();
                ObjectStore.getInstance().putObjectInstance("COMPARE_CONFIG_FILE_DIALOG", CompareConfigFileDialog.this.rightFileText.getText());
                CompareConfigFileDialog.this.setCompareButtonEnable();
            }
        });
        this.leftbutton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int returnValue;
                File dirSave;
                CompareConfigFileDialog.this.oFileLeftChooserDialog = CompareConfigFileDialog.this.getFileChooserDlg();
                String strDefPath = (String)ObjectStore.getInstance().getObjectInstance("COMPARE_CONFIG_FILE_DIALOG_LEFT");
                if (null != strDefPath && (dirSave = new File(strDefPath)).exists()) {
                    CompareConfigFileDialog.this.oFileLeftChooserDialog.setSelectedFile(dirSave);
                }
                if (0 != (returnValue = CompareConfigFileDialog.this.oFileLeftChooserDialog.showDialog((Component)((Object)CompareConfigFileDialog.this), ResourceManager.getInstance().getResString("OK")))) {
                    CompareConfigFileDialog.this.setCompareButtonEnable();
                    return;
                }
                CompareConfigFileDialog.this.leftFileText.setText(CompareConfigFileDialog.this.oFileLeftChooserDialog.getSelectedFile().getAbsolutePath());
                CompareConfigFileDialog.this.m_leftFilePath = CompareConfigFileDialog.this.oFileLeftChooserDialog.getSelectedFile().getAbsolutePath();
                CompareConfigFileDialog.this.leftFileText.setToolTipText(CompareConfigFileDialog.this.oFileLeftChooserDialog.getSelectedFile().getAbsolutePath());
                ObjectStore.getInstance().putObjectInstance("COMPARE_CONFIG_FILE_DIALOG_LEFT", CompareConfigFileDialog.this.leftFileText.getText());
                CompareConfigFileDialog.this.setCompareButtonEnable();
            }
        });
        this.comparebutton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (null != CompareConfigFileDialog.this.m_leftFilePath || "".equals(CompareConfigFileDialog.this.m_leftFilePath)) {
                    CompareConfigFileDialog.this.setFilePath(CompareConfigFileDialog.this.m_leftFilePath, CompareConfigFileDialog.this.m_rightFilePath);
                    CompareConfigFileDialog.this.setCompareButtonEnable();
                }
            }
        });
        this.nextBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selIndex = CompareConfigFileDialog.this.leftList.getSelectedIndex();
                if (selIndex < 0) {
                    int index = ((DiffDatas)((CompareConfigFileDialog)CompareConfigFileDialog.this).diffListDatas.get((int)0)).index;
                    CompareConfigFileDialog.this.leftList.setSelectedIndex(index);
                    CompareConfigFileDialog.this.leftList.ensureIndexIsVisible(index);
                    return;
                }
                for (DiffDatas element : CompareConfigFileDialog.this.diffListDatas) {
                    if (selIndex >= element.index) continue;
                    CompareConfigFileDialog.this.leftList.setSelectedIndex(element.index);
                    CompareConfigFileDialog.this.leftList.ensureIndexIsVisible(element.index);
                    return;
                }
            }
        });
        this.preBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selIndex = CompareConfigFileDialog.this.leftList.getSelectedIndex();
                if (selIndex < 0) {
                    int index = ((DiffDatas)((CompareConfigFileDialog)CompareConfigFileDialog.this).diffListDatas.get((int)(((CompareConfigFileDialog)CompareConfigFileDialog.this).diffListDatas.size() - 1))).index;
                    CompareConfigFileDialog.this.leftList.setSelectedIndex(index);
                    CompareConfigFileDialog.this.leftList.ensureIndexIsVisible(index);
                    return;
                }
                for (int i = CompareConfigFileDialog.this.diffListDatas.size() - 1; i >= 0; --i) {
                    DiffDatas element = (DiffDatas)CompareConfigFileDialog.this.diffListDatas.get(i);
                    if (selIndex <= element.index) continue;
                    CompareConfigFileDialog.this.leftList.setSelectedIndex(element.index);
                    CompareConfigFileDialog.this.leftList.ensureIndexIsVisible(element.index);
                    return;
                }
            }
        });
        this.closeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CompareConfigFileDialog.this.dispose();
            }
        });
        this.leftList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (CompareConfigFileDialog.this.leftList.getModel().getSize() != 0) {
                    int iSelectedIndex = CompareConfigFileDialog.this.leftList.getSelectedIndex();
                    CompareConfigFileDialog.this.rightList.setSelectedIndex(iSelectedIndex);
                    CompareConfigFileDialog.this.leftSelectText.setText(((LCSStrWrapper)CompareConfigFileDialog.this.leftList.getSelectedValue()).toString());
                    CompareConfigFileDialog.this.rightSelectText.setText(((LCSStrWrapper)CompareConfigFileDialog.this.rightList.getSelectedValue()).toString());
                }
            }
        });
    }

    private DCFileChooser getFileChooserDlg() {
        PrintSupportor.setIsFileSelection(true);
        DCFileChooser oFileChooserDialog = new DCFileChooser();
        oFileChooserDialog.setTitle(this.resource.getResString("FILECHOOSETITLE"));
        oFileChooserDialog.setApproveButtonText(this.resource.getResString("SAVE_DIALOG_OPEN_BUTTON"));
        oFileChooserDialog.setFileSelectionMode(2);
        oFileChooserDialog.setApproveButtonMnemonic('O');
        oFileChooserDialog.setControlButtonsAreShown(true);
        oFileChooserDialog.setAcceptAllFileFilterUsed(false);
        ReportSaveFileFilter txtOFileFilter = new ReportSaveFileFilter(new String[]{"txt"}, "*.txt");
        ReportSaveFileFilter logOFileFilter = new ReportSaveFileFilter(new String[]{"log"}, "*.log");
        ReportSaveFileFilter cfgOFileFilter = new ReportSaveFileFilter(new String[]{"cfg"}, "*.cfg");
        oFileChooserDialog.setFileFilter(txtOFileFilter);
        oFileChooserDialog.setFileFilter(logOFileFilter);
        oFileChooserDialog.setFileFilter(cfgOFileFilter);
        return oFileChooserDialog;
    }

    private void setCompareButtonEnable() {
        String leftFilename = this.leftFileText.getText();
        String rightFilename = this.rightFileText.getText();
        if (leftFilename != null && !leftFilename.equals("") && rightFilename != null && !rightFilename.equals("")) {
            this.comparebutton.setEnabled(true);
        } else {
            this.comparebutton.setEnabled(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setFilePath(String strLeftFilePath, String strRightFilePath) {
        if (null == strLeftFilePath || "".equals(strLeftFilePath) || null == strRightFilePath || "".equals(strRightFilePath)) {
            return -1;
        }
        ArrayList<String> leftFileInfoList = new ArrayList<String>();
        BufferedReader leftBuffer = null;
        try {
            int iErrCode = this.promptForDeleteFile(strLeftFilePath);
            if (0 != iErrCode) {
                int n = iErrCode;
                return n;
            }
            leftBuffer = new BufferedReader(new FileReader(strLeftFilePath));
            String line = leftBuffer.readLine();
            while (line != null) {
                leftFileInfoList.add(line);
                line = leftBuffer.readLine();
            }
        }
        catch (IOException e) {
            DCOptionPane.showMessageDialog((Component)((Object)this), this.resource.getResString("FAIL_TO_READ_FILE"), this.resource.getResString("ERROR"), 0);
            int line = -1;
            return line;
        }
        finally {
            if (leftBuffer != null) {
                try {
                    leftBuffer.close();
                }
                catch (IOException e) {
                    DCDebugTracer.trace(e);
                }
            }
        }
        ArrayList<String> rightFileInfoList = new ArrayList<String>();
        BufferedReader rightBuffer = null;
        try {
            int iErrCode = this.promptForDeleteFile(strRightFilePath);
            if (0 != iErrCode) {
                int n = iErrCode;
                return n;
            }
            rightBuffer = new BufferedReader(new FileReader(strRightFilePath));
            String line = rightBuffer.readLine();
            while (line != null) {
                rightFileInfoList.add(line);
                line = rightBuffer.readLine();
            }
        }
        catch (IOException e) {
            DCOptionPane.showMessageDialog((Component)((Object)this), this.resource.getResString("FAIL_TO_READ_FILE"), this.resource.getResString("ERROR"), 0);
            int n = -1;
            return n;
        }
        finally {
            if (rightBuffer != null) {
                try {
                    rightBuffer.close();
                }
                catch (IOException e) {
                    DCDebugTracer.trace(e);
                }
            }
        }
        ConfigFileControl.getInstance().compareBetweenFile(leftFileInfoList, rightFileInfoList);
        this.setLeftModel(ConfigFileControl.getInstance().getCompareFileLeftModel());
        this.setRightModel(ConfigFileControl.getInstance().getCompareFileRightModel());
        return 0;
    }

    private int promptForDeleteFile(String strFilePath) {
        File oFile = new File(strFilePath);
        if (!oFile.exists()) {
            String strErrMsg = this.resource.getResString("SELECT_FILE_ALREADY_BE_DELETED");
            strErrMsg = MessageFormat.format(strErrMsg, strFilePath);
            DCOptionPane.showMessageDialog((Component)((Object)this), strErrMsg, this.resource.getResString("ERROR"), 0);
            return -1;
        }
        return 0;
    }

    public void setRightFileInfoDirect(String fileStringLeft, String fileStringRight) {
        if (fileStringLeft == null) {
            return;
        }
        this.leftFileText.setText(fileStringLeft);
        this.m_leftFilePath = fileStringLeft;
        if (fileStringRight == null) {
            return;
        }
        this.rightFileText.setText(fileStringRight);
        this.m_rightFilePath = fileStringRight;
    }

    public void setRightFileDesc(String description) {
        this.rightFileText.setText(description);
        this.m_rightFilePath = description;
    }

    public void setLeftModel(DefaultComboBoxModel leftModel) {
        this.leftList.setModel(leftModel);
        int size = leftModel.getSize();
        if (null == this.diffListDatas || this.diffListDatas.size() != size) {
            this.diffListDatas = new ArrayList();
            for (int i = 0; i < size; ++i) {
                LCSStrWrapper sw = (LCSStrWrapper)leftModel.getElementAt(i);
                int type = sw.type;
                if (type == 0) continue;
                this.diffListDatas.add(new DiffDatas(i, sw.type));
                this.setDiffIndex(i);
            }
        }
        if (this.hasSetRightModel) {
            this.refresh();
        }
        this.hasSetLeftModel = true;
    }

    public void setRightModel(DefaultComboBoxModel rightModel) {
        this.rightList.setModel(rightModel);
        int size = rightModel.getSize();
        if (null == this.diffListDatas || this.diffListDatas.size() != size) {
            this.diffListDatas = new ArrayList();
            for (int i = 0; i < size; ++i) {
                LCSStrWrapper sw = (LCSStrWrapper)rightModel.getElementAt(i);
                int type = sw.type;
                if (type == 0) continue;
                this.diffListDatas.add(new DiffDatas(i, sw.type));
                this.setDiffIndex(i);
            }
        }
        if (this.hasSetLeftModel) {
            this.refresh();
        }
        this.hasSetRightModel = true;
    }

    private void refresh() {
        int pbW = this.leftList.getPreferredScrollableViewportSize().width;
        int pcW = this.rightList.getPreferredScrollableViewportSize().width;
        int mW = Math.max(pbW, pcW);
        if (pbW != mW) {
            this.leftList.setFixedCellWidth(mW);
        }
        if (pcW != mW) {
            this.rightList.setFixedCellWidth(mW);
        }
    }

    private int getSelectedIndex(int y) {
        if (null == this.m_iDiffLines || null == this.m_iDiffYCoordinates) {
            return -1;
        }
        int iDiffLineCount = this.m_iDiffLines.length;
        int index = -1;
        int minV = 5;
        int iPos = -1;
        for (int i = 0; i < iDiffLineCount; ++i) {
            int tmpV = Math.abs(this.m_iDiffYCoordinates[i] - y);
            if (0 == tmpV) {
                iPos = i;
                break;
            }
            if (minV <= tmpV) continue;
            minV = tmpV;
            iPos = i;
        }
        index = iPos >= 0 ? this.m_iDiffLines[iPos] : (y - this.m_trackBounds.y) * this.leftList.getModel().getSize() / this.m_trackBounds.height;
        return index;
    }

    private void setDiffIndex(int index) {
        if (this.m_iFirstDiffIndex == -1) {
            this.m_iFirstDiffIndex = index;
        }
        if (this.m_iLastDiffIndex == -1) {
            this.m_iLastDiffIndex = index;
        }
        if (this.m_iFirstDiffIndex > index) {
            this.m_iFirstDiffIndex = index;
        }
        if (this.m_iLastDiffIndex < index) {
            this.m_iLastDiffIndex = index;
        }
    }

    @Override
    protected String getCurrentContext() {
        return "HELP_TOPIC_NE_COMPARE_CONFIG_FILE";
    }

    static /* synthetic */ int[] access$1502(CompareConfigFileDialog x0, int[] x1) {
        x0.m_iDiffLines = x1;
        return x1;
    }

    static /* synthetic */ int[] access$1602(CompareConfigFileDialog x0, int[] x1) {
        x0.m_iDiffYCoordinates = x1;
        return x1;
    }

    private static final class DiffDatas {
        int index;
        Color color;

        public DiffDatas(int index, int type) {
            this.index = index;
            if (type == 1) {
                this.color = UIConstants.ADD_COLOR;
            } else if (type == 2) {
                this.color = UIConstants.DELETE_COLOR;
            } else if (type == 3) {
                this.color = UIConstants.MODIFY_COLOR;
            }
        }
    }

    public class VScrollBarUI
    extends MetalScrollBarUI {
        private Color thumbColor;
        private Color thumbShadow;
        private Color thumbHighlightColor;
        private int iScrollBarHeight = 0;

        @Override
        protected void configureScrollBarColors() {
            super.configureScrollBarColors();
            this.thumbColor = UIManager.getColor("ScrollBar.thumb");
            this.thumbShadow = UIManager.getColor("ScrollBar.thumbShadow");
            this.thumbHighlightColor = UIManager.getColor("ScrollBar.thumbHighlight");
        }

        @Override
        protected void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
            super.paintTrack(g, c, trackBounds);
            if (this.iScrollBarHeight != trackBounds.height) {
                CompareConfigFileDialog.this.m_isFirst = true;
                this.iScrollBarHeight = trackBounds.height;
            }
            Vector<Integer> tmpLineVec = null;
            Vector<Integer> tmpYCoordinateVec = null;
            if (CompareConfigFileDialog.this.m_isFirst) {
                tmpLineVec = new Vector<Integer>();
                tmpYCoordinateVec = new Vector<Integer>();
            }
            for (DiffDatas element : CompareConfigFileDialog.this.diffListDatas) {
                g.setColor(element.color);
                int cd = trackBounds.y + element.index * trackBounds.height / CompareConfigFileDialog.this.leftList.getModel().getSize();
                cd = cd == 0 ? 1 : cd;
                g.drawLine(trackBounds.x, cd, trackBounds.width, cd);
                if (!CompareConfigFileDialog.this.m_isFirst) continue;
                tmpYCoordinateVec.add(cd);
                tmpLineVec.add(element.index);
            }
            if (CompareConfigFileDialog.this.m_isFirst && null != tmpLineVec) {
                int iDiffLineCount = tmpLineVec.size();
                CompareConfigFileDialog.access$1502(CompareConfigFileDialog.this, new int[iDiffLineCount]);
                CompareConfigFileDialog.access$1602(CompareConfigFileDialog.this, new int[iDiffLineCount]);
                for (int i = 0; i < iDiffLineCount; ++i) {
                    ((CompareConfigFileDialog)CompareConfigFileDialog.this).m_iDiffYCoordinates[i] = (Integer)tmpYCoordinateVec.get(i);
                    ((CompareConfigFileDialog)CompareConfigFileDialog.this).m_iDiffLines[i] = (Integer)tmpLineVec.get(i);
                }
                CompareConfigFileDialog.this.m_isFirst = false;
                tmpLineVec = null;
                tmpYCoordinateVec = null;
            }
            CompareConfigFileDialog.this.m_trackBounds = this.getTrackBounds();
        }

        @Override
        protected void paintThumb(Graphics pictorial, JComponent assembly, Rectangle border) {
            if (!assembly.isEnabled()) {
                return;
            }
            boolean isLToR = assembly.getComponentOrientation().isLeftToRight();
            pictorial.translate(border.x, border.y);
            if (this.scrollbar.getOrientation() == 1) {
                if (!this.isFreeStanding) {
                    if (!isLToR) {
                        ++border.width;
                        pictorial.translate(-1, 0);
                    } else {
                        border.width += 2;
                    }
                }
                pictorial.setColor(this.thumbColor);
                pictorial.fillRect(border.width - 5, 0, border.width - 3, border.height - 1);
                pictorial.fillRect(1, 0, 3, border.height - 1);
                pictorial.setColor(this.thumbShadow);
                pictorial.drawRect(0, 0, border.width - 2, border.height - 1);
                pictorial.setColor(this.thumbHighlightColor);
                pictorial.drawLine(1, 1, border.width - 3, 1);
                pictorial.drawLine(1, 1, 1, border.height - 1);
                pictorial.drawLine(border.width - 3, 1, border.width - 3, border.height - 1);
                if (!this.isFreeStanding) {
                    if (!isLToR) {
                        --border.width;
                        pictorial.translate(1, 0);
                    } else {
                        border.width -= 2;
                    }
                }
            }
            pictorial.translate(-border.x, -border.y);
        }
    }
}

