/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class RebootConfirmationDlg
extends DCModalDialog {
    private static final long serialVersionUID = -2635124288592258526L;
    private static RebootConfirmationDlg m_oInstance = null;
    private static boolean m_bConfirmationRequired = true;
    private static boolean m_bResult = true;
    private JButton m_oOkBtn = null;
    private JCheckBox m_oRebootCbx = null;
    private JLabel m_oMsgLabel = null;
    private JPanel m_oMainPanel = null;
    private JLabel m_oImageLabel = null;

    private RebootConfirmationDlg() {
        super(DCFrameWorkUtil.getMainFrame(), true);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            DCDebugTracer.trace(ex);
        }
    }

    public static boolean confirmReboot() {
        m_bResult = true;
        if (m_bConfirmationRequired) {
            if (null == m_oInstance) {
                m_oInstance = new RebootConfirmationDlg();
            }
            m_oInstance.setSize(320, 160);
            m_oInstance.setLocationRelativeTo(DCFrameWorkUtil.getMainFrame());
            m_oInstance.setResizable(false);
            m_oInstance.setVisible(true);
        }
        return m_bResult;
    }

    private void jbInit() throws DCException {
        ResourceManager resManager = ResourceManager.getInstance();
        this.setTitle(resManager.getResString("REBOOT_CONFIRM_TITLE"));
        this.setModal(true);
        TitledBorder border1 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), "");
        this.m_oMainPanel = new JPanel();
        this.m_oMainPanel.setBorder(border1);
        this.m_oOkBtn = new JButton();
        this.m_oRebootCbx = new JCheckBox();
        this.m_oMsgLabel = new JLabel();
        this.m_oMainPanel.setLayout(null);
        ImageIcon confirmIcon = ResourceManager.getInstance().getImage("confirmImage.gif");
        this.m_oImageLabel = new JLabel("", confirmIcon, 0);
        this.m_oImageLabel.setBounds(15, 20, 30, 30);
        this.m_oImageLabel.setOpaque(true);
        this.m_oMsgLabel.setBounds(50, 13, 400, 42);
        this.m_oMsgLabel.setOpaque(false);
        this.m_oMsgLabel.setText(resManager.getResString("REBOOT_CONFIRM_MSG"));
        this.m_oRebootCbx.setText(resManager.getResString("REBOOT_CONFIRM_REQ"));
        this.m_oRebootCbx.setBounds(40, 60, 250, 25);
        this.m_oRebootCbx.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                m_bConfirmationRequired = !RebootConfirmationDlg.this.m_oRebootCbx.isSelected();
            }
        });
        this.m_oOkBtn.setBounds(53, 95, 80, 20);
        this.m_oOkBtn.setText(resManager.getResString("REBOOT_CONFIRM_YES_BTN"));
        this.m_oOkBtn.setMnemonic('Y');
        this.m_oOkBtn.setHorizontalAlignment(0);
        this.m_oOkBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RebootConfirmationDlg.this.okButtonActionPerformed();
            }
        });
        this.m_oCancelBtn.setBounds(180, 95, 80, 20);
        this.m_oCancelBtn.setText(resManager.getResString("REBOOT_CONFIRM_NO_BTN"));
        this.m_oCancelBtn.setMnemonic('N');
        this.m_oMainPanel.add((Component)this.m_oOkBtn, null);
        this.m_oMainPanel.add((Component)this.m_oCancelBtn, null);
        this.m_oMainPanel.add((Component)this.m_oImageLabel, null);
        this.m_oMainPanel.add((Component)this.m_oMsgLabel, null);
        this.m_oMainPanel.add((Component)this.m_oRebootCbx, null);
        this.getContentPane().add((Component)this.m_oMainPanel, null);
    }

    @Override
    protected void cancelButton_ActionPerformed() {
        m_bResult = false;
        m_bConfirmationRequired = true;
        this.m_oRebootCbx.setSelected(false);
        m_oInstance.dispose();
    }

    protected void okButtonActionPerformed() {
        m_bResult = true;
        m_oInstance.dispose();
    }

    public static void setM_bConfirmationRequired(boolean confirmationRequired) {
        m_bConfirmationRequired = confirmationRequired;
        if (null != m_oInstance) {
            RebootConfirmationDlg.m_oInstance.m_oRebootCbx.setSelected(!m_bConfirmationRequired);
        }
    }

    @Override
    protected String getCurrentContext() {
        return null;
    }
}

